--Reeds & Cactus able to plant v1.0 by Vu Phan

local GROUND = GLOBAL.GROUND
local GetGroundTypeAtPosition = GLOBAL.GetGroundTypeAtPosition
local distsq = GLOBAL.distsq
local Vector3 = GLOBAL.Vector3
local SpawnPrefab = GLOBAL.SpawnPrefab
local dig_cactus = GetModConfigData("dig_cactus")
local dig_cactus = GetModConfigData("dig_reeds")

local defaultTileSet = {GROUND.ROCKY, GROUND.ROAD, GROUND.IMPASSABLE, GROUND.UNDERROCK, GROUND.WOODFLOOR, GROUND.CARPET, GROUND.CHECKER, GROUND.DESERT_DIRT, GROUND.DIRT, GROUND.SAVANNA, GROUND.GRASS, GROUND.FOREST, GROUND.MARSH, GROUND.CAVE, GROUND.FUNGUS, GROUND.FUNGUSRED, GROUND.FUNGUSGREEN, GROUND.SINKHOLE, GROUND.SINKHOLE, GROUND.UNDERROCK, GROUND.MUD, GROUND.DECIDUOUS}

plantables = {}
i = 1

if GetModConfigData("plantcutreeds") then
plantables[i] =

	{plant = "cutreeds", spawn = "reeds", validTurf = {GROUND.MARSH}, sounds = {"dontstarve/wilson/pickup_reeds"},
		deployExtras = function(inst, pt, deployer, flower)
			flower.components.pickable:OnTransplant()
		end}

i = i + 1
end


if GetModConfigData("plantcactus") then
plantables[i] =

	{plant = "cactus_meat", spawn = "cactus", validTurf = {GROUND.DESERT_DIRT}, sounds = {"dontstarve/wilson/pickup_reeds"},
		deployExtras = function(inst, pt, deployer, flower)
			flower.components.pickable:OnTransplant()
		end}

i = i + 1
end

if GetModConfigData("plantflower_cave") then
plantables[i] =

	{plant = "lightbulb", spawn = "flower_cave", validTurf = {GROUND.CAVE}, sounds = {"dontstarve/wilson/pickup_reeds"},
		deployExtras = function(inst, pt, deployer, flower)
			flower.components.pickable:OnTransplant()
		end}

i = i + 1
end

for i,v in ipairs(plantables) do
	AddPrefabPostInit(v.plant, function(inst)
		local function test_turf(inst, tiletype)
			if v.validTurf then
				for i,turf in ipairs(v.validTurf) do
					if tiletype == turf then
						return true
					end
				end
				return false
			end
			if v.invalidTurf then
				for i,turf in ipairs(v.invalidTurf) do
					if tiletype == turf then
						return false
					end
				end
				return true
			end
			return true
		end

		local function test_ground(inst, pt)
			if v.turfExtras then
				if not v.turfExtras() then
					return false
				end
			end

			local tiletype = GetGroundTypeAtPosition(pt)
			local ground_OK = test_turf(inst, tiletype) and tiletype < GROUND.UNDERGROUND
			
			if ground_OK then
				local notags = {'NOBLOCK', 'player', 'FX'}
			    local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, nil, notags) -- or we could include a flag to the search?
				local min_spacing = inst.components.deployable.min_spacing or 2

			    for k, v in pairs(ents) do
					if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
						if distsq( Vector3(v.Transform:GetWorldPosition()), pt) < min_spacing*min_spacing then
							return false
						end
					end
				end
				
				return true

			end
			return false
		end

		local function CanDeploy(inst) return true end
		local function OnDeploy(inst, pt, deployer) 
			local flower = SpawnPrefab(v.spawn or v.altSpawn())
			if flower then
				flower.Transform:SetPosition(pt.x, pt.y, pt.z)
				inst.components.stackable:Get():Remove()
				if v.deployExtras then
					v.deployExtras(inst, pt, deployer, flower)
				end
				if v.sounds then
					if not flower.SoundEmitter then
						flower.entity:AddSoundEmitter()
					end
					for i,sound in ipairs(v.sounds) do
						flower.SoundEmitter:PlaySound(sound)
					end
				end
			end
		end

		inst:AddComponent("deployable")
		inst.components.deployable.ondeploy = OnDeploy
		inst.components.deployable.test = test_ground
		if v.spacing then 
			inst.components.deployable.min_spacing = v.spacing
		end
	end)
end


function PostInitCactus(inst)
	local function ontransplantfn(inst)
		inst.components.pickable:MakeEmpty()
	end
	inst.components.pickable.ontransplantfn = ontransplantfn
	
	if dig_cactus then
		local function dig_up(inst, chopper)
			if inst.components.pickable and inst.components.pickable:CanBePicked() then
				inst.components.lootdropper:SpawnLootPrefab("cactus_meat")
			end
			inst:Remove()
		end

		inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(GLOBAL.ACTIONS.DIG)
		inst.components.workable:SetOnFinishCallback(dig_up)
		inst.components.workable:SetWorkLeft(1)
	end
end

AddPrefabPostInit("cactus", PostInitCactus)

function PostInitReeds(inst)
	local function ontransplantfn(inst)
		inst.components.pickable:MakeEmpty()
	end
	inst.components.pickable.ontransplantfn = ontransplantfn
	
	if dig_cactus then
		local function dig_up(inst, chopper)
			if inst.components.pickable and inst.components.pickable:CanBePicked() then
				inst.components.lootdropper:SpawnLootPrefab("cutreeds")
			end
			inst:Remove()
		end

		inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(GLOBAL.ACTIONS.DIG)
		inst.components.workable:SetOnFinishCallback(dig_up)
		inst.components.workable:SetWorkLeft(1)
	end
end

AddPrefabPostInit("reeds", PostInitReeds)