PrefabFiles = {
	"cac",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/cac.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/cac.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/cac.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/cac.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/cac_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/cac_silho.xml" ),

    Asset( "IMAGE", "bigportraits/cac.tex" ),
    Asset( "ATLAS", "bigportraits/cac.xml" ),
	
	Asset( "ATLAS", "images/weston.xml" ),
	Asset( "IMAGE", "images/weston.tex" ),

}

local require = GLOBAL.require
GLOBAL.STRINGS.CHARACTERS.CAC = require "speech_cac"

-- The character select screen lines
-- note: these are lower-case character name
GLOBAL.STRINGS.CHARACTER_TITLES.cac = "The Wandering Cactus"
GLOBAL.STRINGS.CHARACTER_NAMES.cac = "Weston"  -- Note! This line is especially important as some parts of the game require
                                            -- the character to have a valid name.
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.cac = "*Is covered in sharp spines\n*Loves hot weather\n*Has a flower that attracts bugs"
GLOBAL.STRINGS.CHARACTER_QUOTES.cac = "\"I've got to look sharp!\""

-- Let the game know cac is a male, for proper pronouns during the end-game sequence.
-- Possible genders here are MALE, FEMALE, or ROBOT
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "cac")

if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then
    local HeatOver = GLOBAL.require "widgets/heatover"
 
    local HeatOver_OnHeatChange_base = HeatOver.OnHeatChange or function() end
    function HeatOver:OnHeatChange()
        if self.owner.prefab ~= "cac" then
            HeatOver_OnHeatChange_base(self)
        end
    end
end

local forbidden_foodset = {
	cactus_meat = true,
	cactus_meat_cooked = true,
	cactus_flower = true,
	guacamole = true,
	flowersalad = true,
}
 
function pickyeater(inst)
    if inst.prefab == "cac" then
        inst.components.eater:SetCanEatTestFn(function(inst, food)
            return not food.prefab or not forbidden_foodset[food.prefab]
        end)
    end
end

AddSimPostInit(pickyeater)

AddMinimapAtlas("images/weston.xml")


AddModCharacter("cac")

