local stat_scale = const.Scale.Stat
local birth_comfort_cap = 150 * stat_scale
local daily_birth_checks = 6

local CheckFertility = function(c, min_comfort_birth)
  local traits = c.traits
  if min_comfort_birth < c.stat_comfort and not c:IsDying() and not traits.Child and not traits.Android and (not traits.Senior or g_SeniorsCanWork) and not traits.OtherGender then
    return true
  end
end

local CalcFertility = function(c)
  local comfort = c.stat_comfort
  return comfort + Min(birth_comfort_cap, c.birth_comfort_modifier), comfort
end

local GetFreeNurseriesSlots = function(dome)
  local free_slots_in_nurseries = 0
  for _, home in ipairs(dome.labels.Residence or empty_table) do
    if not home.destroyed and home.ui_working then
      local is_nursery = home.children_only
      if is_nursery then
        local nursery_open_slots = home.capacity - #home.colonists - #home.reserved - (home.closed or 0)
        free_slots_in_nurseries = free_slots_in_nurseries + nursery_open_slots
      end
    end
  end
  return free_slots_in_nurseries
end

function NewCalcBirth(dome)
  local min_comfort_birth = dome:GetMinComfortBirth()
  local males = dome.labels.Male or empty_table
  local females = dome.labels.Female or empty_table
  local num_male_fertile = 0
  local fertile_male = {}
  for _, colonist in ipairs(males) do
    if CheckFertility(colonist, min_comfort_birth) then
      fertile_male[#fertile_male + 1] = colonist
    end
  end
  local num_female_fertile = 0
  local fertile_female = {}
  for _, colonist in ipairs(females) do
    if CheckFertility(colonist, min_comfort_birth) then
      fertile_female[#fertile_female + 1] = colonist
    end
  end
  dome.fertile_male = #fertile_male
  dome.fertile_female = #fertile_female
  local couples_count = Min(#fertile_male, #fertile_female)
  if couples_count == 0 then
    dome.daily_birth_progress = 0
    RebuildInfopanel(dome)
    return false
  end
  if #fertile_male < #fertile_female then
    table.sortby_field_descending(fertile_female, "stat_comfort")
  else
    table.sortby_field_descending(fertile_male, "stat_comfort")
  end
  local total_fertility, total_comfort, dreamers = 0, 0, 0
  local add_group = function(group)
    for i = 1, couples_count do
      local colonist = group[i]
      local fertility, comfort = CalcFertility(colonist)
      total_fertility = total_fertility + fertility
      total_comfort = total_comfort + comfort
      local traits = colonist.traits
      if traits.Dreamer or traits.DreamerPostMystery then
        dreamers = dreamers + 1
      end
    end
  end
  add_group(fertile_male)
  add_group(fertile_female)
  local avg_comfort = total_comfort / (2 * couples_count)
  local avg_fertility = total_fertility / (2 * couples_count)
  local birth_progress = Max(0, couples_count * (avg_fertility - 30 * stat_scale))
  birth_progress = MulDivRound(birth_progress, 100 - dome:GetHomelessBirthRatePenalty(), 100)
  dome.daily_birth_progress = birth_progress
  dome.birth_progress = dome.birth_progress + birth_progress / daily_birth_checks
  while dome.birth_progress >= g_Consts.BirthThreshold do
    dome.birth_progress = dome.birth_progress - g_Consts.BirthThreshold
    
    -- BREEDING DOME CHOICE
    local birth_dome
    if GetFreeNurseriesSlots(dome) > 0 then
      birth_dome = dome
    else
      for _, i_dome in ipairs(UICity.labels.Dome or empty_table) do
        -- Fail-safe
        if i_dome.is_birth_dome == nil then i_dome.is_birth_dome = false end
    
        if i_dome.is_birth_dome and GetFreeNurseriesSlots(i_dome) > 0 then
          birth_dome = i_dome
        end
      end
    end
    --
    
    if birth_dome then
      CreateGameTimeThread(function(birth_dome)
        Sleep(1000 + birth_dome:Random(birth_dome.building_update_time - 1000))
        if not IsValid(birth_dome) then
          return
        end
        if GetFreeNurseriesSlots(birth_dome) <= 0 then
          return
        end
        birth_dome:SpawnChild(dreamers * 100 / (2 * couples_count))
      end, birth_dome)
    end
  end
  RebuildInfopanel(dome)
end

VanillaCalcBirth = Dome.CalcBirth
Dome.CalcBirth = function(dome)
  NewCalcBirth(dome)
  
  if false then
  -- DEBUG  
    -- BREEDING DOME CHOICE
    local birth_dome
    if GetFreeNurseriesSlots(dome) > 0 then
      birth_dome = dome
    else
      for i, i_dome in ipairs(UICity.labels.Dome or empty_table) do
        -- Fail-safe
		if i_dome.is_birth_dome == nil then i_dome.is_birth_dome = false end
		
        if i_dome.is_birth_dome and GetFreeNurseriesSlots(i_dome) > 0 then
          birth_dome = i_dome
        end
      end
    end
    --
    
    if birth_dome then
      CreateGameTimeThread(function(birth_dome)
        Sleep(1000 + birth_dome:Random(birth_dome.building_update_time - 1000))
        if not IsValid(birth_dome) then
          return
        end
        if GetFreeNurseriesSlots(birth_dome) <= 0 then
          return
        end
        birth_dome:SpawnChild(0)
      end, birth_dome)
    end
	--
	end
end