/*==============================================
 * 小兵客服2.1依赖jQuery1.7以上
 * by WangHao
 * Copyright 2016 xb, Inc. Author WANGHAO 
 * Licensed under the MIT license
 * role="kefu"
 *  $('#kefu').kefutu({
     service:'on',//是否打开服务 on off
      skin:'blue',//自定义风格.yourclass
      horizontal:'right',//水平 left， rihgt
      offset:'middle',//垂直偏移量,middle：垂直居中
      targetCell:'',//基于目标对象定位
      durationTime: 300,//缓动时间
    });
 */
;(function($) {

    "use strict";
    var KEFUTU = (function(){
        //客服兔构造函数
        function KEFUTU(element,options){
            
            this.settings = $.extend(true,$.fn.KEFUTU.defaults, options||{});//获取参数
            this.element = element;//保存对象
            this.init();
            //console.log(this.settings);
        }
        KEFUTU.prototype = {
            //初始化插件
            init:function(){
                var me = this;
                // 参数
                me.service = me.settings.service;
                me.skin = me.settings.skin;
                me.horizontal = me.settings.horizontal;
                me.targetCell = me.settings.targetCell;
                me.offset = me.settings.offset;
                me.durationTime = me.settings.durationTime;
                me.items = me.settings.items;
                me.zindex = me.settings.zindex;
                // 是否打开服务
                if('on'== me.service){

                    me.render();

                }else if('off' == me.service){
                    me.element.remove();
                }

            },
            /*渲染*/
            render:function(){
                var me = this;
                var html = '';
                /*增加风格*/
                me.element.show().addClass(me.skin).css({'z-index':me.zindex});
                
                /*偏移量*/
                switch(me.offset)
                {
                case 'middle':
                  //垂直居中
                  var offt = me.element.height()/2;

                  me.element.animate({top:'50%','margin-top':-offt},me.durationTime);
                 
                  break;

                default:
                  me.element.animate({top:me.offset});
                }

                // alert(me.offset)

                if(me.targetCell===''){
                    /*水平位置*/ 
                    switch(me.horizontal)
                    {
                    case 'left':

                      me.element.css({left:0});
                      break;

                    case 'right':
                      
                      me.element.css({right:0});
                      break;

                    default:
                      me.element.css({right:0});
                    }

                }else{

                    //目标定位
                    if($(me.targetCell).length){
                        var targetO = $(me.targetCell);
                        var targetO_x = targetO.offset().left;
                        switch(me.horizontal)
                        {
                        case 'left':

                          me.element.css({left:targetO_x-me.element.width()});
   
                          break;

                        case 'right':
                            me.element.css({left:targetO_x+targetO.outerWidth()});
                          break;
                        }

                    }

                }
                
                
                me._initEvent();
            },
            /*说明：绑定事件*/
            _initEvent:function(){
                var me = this;
                var arrow = me.element.find('.kefutu-arrow');//箭头
                var gotop = me.element.find('.item-gotop');
                //鼠标事件
                me.element.find('.kefutu-item').hover(function(){
                    var _self = $(this);
                    var h = _self.height();//自身高度
                    var pt = _self.position().top;//相对Y坐标

                    _self.addClass('on');
                    arrow.stop(true,true).fadeIn().animate({'top':pt+h/2},me.durationTime); //设定位置
                    _self.find('.kefutu-item-content').stop(true,true).fadeIn(me.durationTime);

                },function(){
                    var _self = $(this);
                    _self.removeClass('on');
                    arrow.fadeOut()
                    _self.find('.kefutu-item-content').stop(true,true).fadeOut(me.durationTime);
                })

                /*返回顶部*/
                $(window).scroll(function() { 
                    var st = $(window).scrollTop()
                    st > 100 ? gotop.stop(true,true).fadeIn(me.durationTime) : gotop.stop(true,true).fadeOut(me.durationTime);  
      
                });  
                
                gotop.click(function(){
                    $("html,body").stop().animate({scrollTop: 0},me.durationTime);
                }) 

                // 验证码
                me.element.find('.kefu-vcode input').on('focus',function(){
                    
                    var vcodeO = $(this).siblings('.kefu-vcode-imgbox');
                    vcodeO.show();
                    var vcodeSrc = vcodeO.find('img').attr('_src');
                    vcodeO.find('img').attr('src',vcodeSrc+'?'+Math.random())
                })

                me.element.find('.kefu-vcode input').on('blur',function(){
                    $(this).siblings('.kefu-vcode-imgbox').hide();
                })
                
            }
        }
        return KEFUTU;   //必须返回值
    })();

    //把客服注册到jquery原型上
    $.fn.KEFUTU = function(options){
        //为了链式调用
        return this.each(function(){
            var me = $(this);
            //初始化实例
            var instance = me.attr('role');
            if(instance === 'kefu'){
       
               instance = new KEFUTU(me,options);
            }
        })
    }

    //默认参数配置
    $.fn.KEFUTU.defaults={
          service:'on',//是否打开  off
          skin:'blue',//风格
          horizontal:'right',//居右
          targetCell:'',//基于目标定位
          offset:'50%',//垂直偏移量
          durationTime: 600,//缓动,
          items:'',
          zindex:'9999'
    }


})(jQuery);