local FutaraDragonHPHUD = Class(function(self, inst)
    self.inst = inst
    self.deadstatus = 0
    self.alertsound = 0
    self.alertsounddef = 100
    self.hpreader = 0
    self.nearleader = 0
    self.futaradragon = nil
end)

function FutaraDragonHPHUD:RunHUD()
	self.inst.components.perishable:SetPerishTime(1)
	self.inst.components.perishable:SetPercent(0)
	self.inst.components.perishable:Dilute(0,0)
	self.inst.components.finiteuses.current = 0
	self.inst.components.finiteuses.total = 100
    self.inst.components.finiteuses:SetUses(self.inst.components.finiteuses.current)
end

function FutaraDragonHPHUD:StartUpdating()
	if not self.loop then
        self.loop = {}
    end
    self.loop.amount = 0
    self.loop.period = 0.1
    if not self.loop.task then
        self.loop.task = self.inst:DoPeriodicTask(self.loop.period, function() self:Update() end)
    end
end

function FutaraDragonHPHUD:Update()
	self.futaradragon = TheSim:FindFirstEntityWithTag("futdg")
	if self.futaradragon ~= nil then
	    self.inst.components.perishable:SetPerishTime(1)
		self.inst.components.perishable:SetPercent(self.futaradragon.components.health:GetPercent())
		self.inst.components.perishable:Dilute(0,0)
		self.inst.components.finiteuses.current = self.futaradragon.components.mana:GetMana()
	    self.inst.components.finiteuses.total = self.futaradragon.components.mana:GetMaxMana()
	    self.inst.components.finiteuses:SetUses(self.inst.components.finiteuses.current)
		if self.alertsound > 0 then
			self.alertsound = self.alertsound - 1
		else
			if self.hpreader > self.futaradragon.components.health.currenthealth and not self.futaradragon.components.follower:IsNearLeader(self.nearleader) then
				PlayCreatureSound(self.inst, "hurt")
				self.alertsound = self.alertsounddef
			end
		end
		if self.hpreader > self.futaradragon.components.health.currenthealth then
			self.hpreader = self.futaradragon.components.health.currenthealth
		else
			self.hpreader = self.futaradragon.components.health.currenthealth
		end
		if self.deadstatus == 0 and self.futaradragon.components.health.currenthealth <= 0 and not self.futaradragon.components.follower:IsNearLeader(self.nearleader) then
			PlayCreatureSound(self.inst, "death")
			self.deadstatus = 1
		end
		if self.futaradragon.components.health.currenthealth <= 0 then
			TUNING.FUTARADRAGON_ALIVE = 0
		end
	else
		self.inst.components.perishable:SetPerishTime(1)
		self.inst.components.perishable:SetPercent(0)
		self.inst.components.perishable:Dilute(0,0)
		if self.inst.components.finiteuses.current ~= TUNING.FUTARADRAGON_CHARGE then
			self.inst.components.finiteuses.current = TUNING.FUTARADRAGON_CHARGE
			if self.inst.components.finiteuses.total ~= TUNING.FUTARADRAGON_CHARGEMAX then
			    self.inst.components.finiteuses.total = TUNING.FUTARADRAGON_CHARGEMAX
			end
		    self.inst.components.finiteuses:SetUses(self.inst.components.finiteuses.current)
		end
	end
end

return FutaraDragonHPHUD
