local Mana = Class(function(self, inst)
    self.inst = inst
    self.maxmana = 100
    self.currentmana = self.maxmana
    self.invincible = false
    
	self.nofadeout = false
	self.penalty = 0
    self.absorb = 0
	
end)

function Mana:OnSave()    
    return 
    {
		mana = self.currentmana,
		penalty = self.penalty > 0 and self.penalty or nil
	}
end


function Mana:RecalculatePenalty()
	self.penalty = 0

	for k,v in pairs(Ents) do
		if v.components.resurrector and v.components.resurrector.penalty then
			self.penalty = self.penalty + v.components.resurrector.penalty
		end
	end

	self:DoDelta(0)

end

function Mana:OnLoad(data)
    self.penalty = data.penalty or self.penalty
    if data.mana then
        self:SetVal(data.mana, "loading")
        self:DoDelta(0)
	elseif data.percent then
		self:SetPercent(data.percent, "loading")
        self:DoDelta(0)
    end
end

function Mana:DoRegen()
    if not self:IsDead() then
        self:DoDelta(self.regen.amount, true, "regen")
    else
    end
end

function Mana:StartRegen(amount, period)
    if not self.regen then
        self.regen = {}
    end
    self.regen.amount = amount
    self.regen.period = period

    if not self.regen.task then
        self.regen.task = self.inst:DoPeriodicTask(self.regen.period, function() self:DoRegen() end)
    end
end

function Mana:StopRegen()
    if self.regen then
        if self.regen.task then
            self.regen.task:Cancel()
        end
        self.regen = nil
    end
end

function Mana:GetPenaltyPercent()
	return (self.penalty*TUNING.EFFIGY_HEALTH_PENALTY)/ self.maxmana
end


function Mana:GetPercent()
    return self.currentmana / self.maxmana
end

function Mana:SetMaxMana(amount)
    self.maxmana = amount
    self.currentmana = amount
end

function Mana:SetPercent(percent, cause)
    self:SetVal(self.maxmana*percent, cause)
end

function Mana:UseMana(amount)
    self.currentmana = self.currentmana - amount
end

function Mana:GetMana()
    return self.currentmana
end

function Mana:GetMaxMana()
    return self.maxmana
end

function Mana:OnProgress()
	self.penalty = 0
end

function Mana:SetVal(val, cause)

    local old_percent = self:GetPercent()

    self.currentmana = val
    if self.currentmana > self.maxmana - self.penalty*TUNING.EFFIGY_HEALTH_PENALTY then
        self.currentmana = self.maxmana - self.penalty*TUNING.EFFIGY_HEALTH_PENALTY
    end

    if self.currentmana < 0 then
        self.currentmana = 0
    end

    local new_percent = self:GetPercent()
    
    if old_percent > 0 and new_percent <= 0 then
        self.inst:PushEvent("death", {cause=cause})

		if not self.nofadeout then
			self.inst:AddTag("NOCLICK")
			self.inst.persists = false
			self.inst:DoTaskInTime(2, destroy)
		end
    end
end

function Mana:Respawn(mana)
	
	self:DoDelta( mana or 10 )
    self.inst:PushEvent( "respawn", {} )
end

function Mana:CollectInventoryActions(doer, actions)
    table.insert(actions, ACTIONS.MURDER)
end

function Mana:DoDelta(amount, overtime, cause)

    if self.invincible or self.inst.is_teleporting == true then
        return
    end
    
    amount = amount - (amount * self.absorb)

    local old_percent = self:GetPercent()
    self:SetVal(self.currentmana + amount, cause)
    local new_percent = self:GetPercent()

    self.inst:PushEvent("healthdelta", {oldpercent = old_percent, newpercent = self:GetPercent(), overtime=overtime, cause=cause})
    if self.ondelta then
        self.ondelta(self.inst, old_percent, self:GetPercent())
    end
end

function Mana:IsDead()
    return self.inst.components.health.currenthealth <= 0
end

return Mana
