require "prefabutil"
require "fonthelper"

local assets = TUNING.FUTARADRAGON_ASSET

local prefabs = TUNING.FUTARADRAGON_PREFABS

local FONTS = {
    { filename = TUNING.FUTARADRAGON_FONT, alias = DIALOGFONT },
}

AddFontAssets( assets, FONTS )

local SPAWN_DIST = 5

local function InitSkillFX()
    if TUNING.FUTARADRAGON_SHADERED == 0 then
        if EnvelopeManager then
            local SDCS,SDCE,SDCD = TUNING.FUTARADRAGON_SHADER_CMAX,1,-1
            for F = SDCS,SDCE,SDCD do
                EnvelopeManager:AddColourEnvelope(TUNING.FUTARADRAGON_SHADER_C[F][1],TUNING.FUTARADRAGON_SHADER_C[F][2])
            end
            local SDSS,SDSE,SDSD = TUNING.FUTARADRAGON_SHADER_SMAX,1,-1
            for D = SDSS,SDSE,SDSD do
                EnvelopeManager:AddVector2Envelope(TUNING.FUTARADRAGON_SHADER_S[D][1],TUNING.FUTARADRAGON_SHADER_S[D][2])
            end
            TUNING.FUTARADRAGON_SHADERED = 1
        end
    end
end

local function Say(inst,script)
    inst.components.talker:Say(script,TUNING.FUTARADRAGON_CHATTIME)
end

local function Talk(inst,say,max)
    if TUNING.FUTARADRAGON_CRIS == 1 then
        Say(inst,say[math.random(1,max)])
    else
        Say(inst,TUNING.FUTARADRAGON_SAYUNKNOW[math.random(1,TUNING.FUTARADRAGON_SAYUNKNOWMAX)])
    end
    inst.saydelay = TUNING.FUTARADRAGON_SAYDELAY*math.random(500,1000)
end

local function ChangeLight(inst,update)
    inst.Light:SetRadius(update)
end

local function GetNormalScale()
    return TUNING.FUTARADRAGON_SCALE
end

local function ChangeScale(inst,update)
    inst.Transform:SetScale(update, update, update)
end

local function ChangeManaFX(number)
    TUNING.FUTARADRAGON_SKILLFX = number
end

local function GetTrueDelay(inst)
    return inst.delay <= 0
end

local function GetTrueDelayNotMax(inst)
    return inst.delay ~= TUNING.FUTARADRAGON_DELAY
end

local function ResetDelay(inst)
    inst.delay = TUNING.FUTARADRAGON_DELAY
end

local function UpdateDelay(inst)
    inst.delay = inst.delay - 1
end

local function GetTrueSkillDelay(inst)
    return inst.skilldelay <= 0
end

local function GetTrueSkillDelayNotMax(inst)
    return inst.skilldelay ~= TUNING.FUTARADRAGON_SKILLDELAY
end

local function ResetSkillDelay(inst)
    inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
end

local function UpdateSkillDelay(inst)
    inst.skilldelay = inst.skilldelay - 1
end

local function GetSkillDelay(inst)
    return inst.skilldelay
end

local function ResetLongRangeDelay(inst)
    inst.longrangedelay = TUNING.FUTARADRAGON_ATK_LONGRANGEDELAY
end

local function OnTalk(inst)
    PlayCreatureSound(inst, "laugh")
end

local function GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = SPAWN_DIST
    local offset = FindWalkableOffset(pt, theta, radius, 12, true)
    if offset then
        return pt+offset
    end
end

local function ReWarpFutaraDragon(inst)
    if GetPlayer() then
        local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
        local spawn_pt = GetSpawnPoint(pt)
        if spawn_pt then
            inst.Physics:Teleport(spawn_pt:Get())
            inst:FacePoint(pt)
        else
        end
    end
end

local function GetPoint(pt)
    return pt
end

local function SwapPlayer(inst)
    if GetPlayer() then
        local PYP = Vector3(GetPlayer().Transform:GetWorldPosition())
        local FDP = Vector3(inst.Transform:GetWorldPosition())
        local PYPP = GetPoint(PYP)
        local FDPP = GetPoint(FDP)
        if PYPP and FDPP then
            GetPlayer().Physics:Teleport(FDPP:Get())
            inst.Physics:Teleport(PYPP:Get())
            if inst.components.combat.target ~= nil then
                inst.components.combat:SetTarget(nil)
                inst.components.combat.retargettask = nil
                inst.components.combat.target = nil
            end
        end
    end
end

local function SetParticleFX(inst,LT,VX,VXM,VXL,VY,VYM,VYL,VZ,VZM,VZL,TX,PC,PS,SW,SH,SZ,BM)
    inst.ParticleLT = LT
    inst.ParticleVX = VX
    inst.ParticleVXM = VXM
    inst.ParticleVXL = VXL
    inst.ParticleVY = VY
    inst.ParticleVYM = VYM
    inst.ParticleVYL = VYL
    inst.ParticleVZ = VZ
    inst.ParticleVZM = VZM
    inst.ParticleVZL = VZL
    inst.ParticleEmitter:SetRenderResources(TUNING.FDFNDM.."fx/"..TX..".tex", TUNING.FUTARADRAGON_SHADER[1])
    inst.ParticleEmitter:SetBlendMode(BM)
    inst.ParticleEmitter:SetMaxLifetime(inst.ParticleLT)
    inst.ParticleEmitter:SetColourEnvelope(PC)
    inst.ParticleEmitter:SetScaleEnvelope(PS);
    inst.ParticleEmitter:SetUVFrameSize(SW,SH)
    inst.ParticleSize = CreateSphereEmitter(SZ)
end

local function SetParticleSet(inst,setting,slot)
    local FX = setting[slot]
    SetParticleFX(inst,FX[1],FX[2],FX[3],FX[4],FX[5],FX[6],FX[7],FX[8],FX[9],FX[10],FX[11],FX[12],FX[13],FX[14],FX[15],FX[16],FX[17])
end

local function ReLeader(inst)
    inst.components.follower:SetLeader(GetPlayer())
end

local function AddLeader(inst,target)
    target.components.follower:SetLeader(inst)
end

local function ResetAllStatus(inst)
    inst.delay = 0
    inst.saydelay = TUNING.FUTARADRAGON_SAYDELAY*math.random(500,1000)
    inst.longrangedelay = TUNING.FUTARADRAGON_ATK_LONGRANGEDELAY
    inst.longrangeaction = 0
    inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK)
    inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_PERIOD)
    inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_RANGE)
    inst.components.inventory:DropEverything(true)
    inst.skillfx = 0
    inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
    inst.skillsound = 1
    inst.skilltime = 0
    inst.skilltalk = 0
    inst.skilldanger = 0
    inst.atktype = true
    inst.scale = 0.1
    inst.light = 0
    inst.iconstatus = TUNING.FUTARADRAGON_STATUSGLOBAL[1]
    inst.statusalert = 0
    if inst.darksidermode == 1 then
        inst:RemoveTag("ghost")
        inst.Physics:ClearMotorVelOverride()
    end
    inst.darksidermode = 0
    inst.darksiderrush = 0
    inst.darksiderrushdelay = 0
    inst.darksiderdarkfield = 0
    inst.darksiderdarkfielddelay = 0
    TUNING.FUTARADRAGON_ACTION = 0
    inst.Transform:SetScale(inst.scale, inst.scale, inst.scale)
    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,1)
    inst.components.mana:StopRegen()
    inst.components.mana:StartRegen(TUNING.FUTARADRAGON_MNRE, TUNING.FUTARADRAGON_MNPI)
    inst.components.health:StopRegen()
    inst.components.health:StartRegen(TUNING.FUTARADRAGON_HPRE, TUNING.FUTARADRAGON_HPPI)
    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[3])
    ChangeLight(inst,0)
    ChangeManaFX(0)
    inst.AnimState:SetBuild("futaradga")
    inst.followmin = TUNING.FUTARADRAGON_MINFOLLOW
    inst.followtarget = TUNING.FUTARADRAGON_TARGETFOLLOW
    inst.followmax = TUNING.FUTARADRAGON_MAXFOLLOW
    inst.Light:SetColour(255/255,255/255,255/255)
    TUNING.FUTARADRAGON_USING = 0
    inst.components.sleeper:WakeUp()
    ReLeader(inst)
    if inst.components.combat.target ~= nil then
        inst.components.combat:SetTarget(nil)
        inst.components.combat.retargettask = nil
        inst.components.combat.target = nil
    end
end

function GetIconStatus(inst)
    return inst.iconstatus
end

local function SetIconStatus(inst,data)
    inst.iconstatus = data
end

local function SetHPDmg(inst,target,damage)
    if target.components.health and target.components.combat then
        inst:PushEvent("onareaattackother", {target = target})
        target.components.combat:GetAttacked(inst, damage, nil)
    end
end

local function CHKUnAtk(inst,target)
    if not target 
       or not target.components.combat
       or not target.entity:IsValid()
       or not target.entity:IsVisible()
       or not target.components.health
       or target == inst
       or target.components.health:IsDead() then
        return false
    else
        return true
    end
end

local function SetBurnArea(inst,range,damage)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, range)
    for i,ent in ipairs(ents) do
        if ent ~= GetPlayer() and ent ~= inst and not ent.components.combat and ent.components.propagator and ent.components.propagator.acceptsheat then
            ent.components.propagator:AddHeat(0.25)
        end
        if ent ~= GetPlayer() and CHKUnAtk(inst,ent) then
            if ent.components.combat and not ent.components.combat:IsAlly(GetPlayer()) and not ent.components.combat:IsAlly(inst) then
                if ent.components.burnable and not ent.components.burnable:IsBurning() then
                    if ent.components.freezable and ent.components.freezable:IsFrozen() then           
                        ent.components.freezable:Unfreeze()            
                    else            
                        ent.components.burnable:Ignite()
                    end   
                end
                SetHPDmg(inst,ent,damage)
            end
        end
        if ent.components.health and ent.components.combat then
            if ent == GetPlayer() or ent == inst or ent.components.combat:IsAlly(GetPlayer()) or ent.components.combat:IsAlly(inst) then
                if ent.components.burnable and ent.components.burnable:IsBurning() then
                    ent.components.burnable:Extinguish()
                end
                if ent.components.freezable and ent.components.freezable:IsFrozen() then           
                    ent.components.freezable:Unfreeze()            
                end
            end
        end
    end
end

local function SetHeal(target,heal)
    if target.components.health then
        target.components.health:DoDelta(heal)
    end
end

local function SetHealArea(inst,range,heal)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, range)
    for i,ent in ipairs(ents) do
        if ent.components.health and ent.components.combat then
            if ent == GetPlayer() or ent == inst or ent.components.combat:IsAlly(GetPlayer()) then
                SetHeal(ent,heal)
            end
        end
    end
end

local function GetPoint(pt)
    return pt
end

local function SetDarkArea(inst)
    local DarkField = nil
    local pt = Vector3(inst.Transform:GetWorldPosition())
    local spawn_pt = GetPoint(pt)
    if spawn_pt then
        DarkField = SpawnPrefab("futaradragondarkfield")
        if DarkField then
            DarkField.Physics:Teleport(spawn_pt:Get())
            DarkField:FacePoint(pt)
        end
    end
end

local function RemoveDropped(inst)
    inst:Remove()
end

local function BreathFireAdd(inst)
    if inst.components.inventory then
        local BreathFire = CreateEntity()
        BreathFire.entity:AddTransform()
        MakeInventoryPhysics(BreathFire)
        BreathFire:AddComponent("weapon")
        BreathFire.components.weapon:SetDamage(TUNING.FUTARADRAGON_ATK_LONGRANGEATK)
        BreathFire.components.weapon:SetRange(TUNING.FUTARADRAGON_ATK_LONGRANGE, TUNING.FUTARADRAGON_ATK_LONGRANGEHIT)
        BreathFire.components.weapon:SetProjectile(TUNING.FUTARADRAGON_ATK_LONGRANGEPRJ[1])
        BreathFire:AddComponent("inventoryitem")
        BreathFire.persists = false
        BreathFire.components.inventoryitem:SetOnDroppedFn(function() RemoveDropped(BreathFire) end)
        BreathFire:AddComponent("equippable")
        inst.BreathFire = BreathFire
        inst.components.inventory:Equip(inst.BreathFire)
    end
end

local function SummonGuardian(inst,slot)
    local Guardian = nil
    local pt = Vector3(inst.Transform:GetWorldPosition())
    local spawn_pt = GetSpawnPoint(pt)
    if spawn_pt then
        Guardian = SpawnPrefab("futaradragonsg"..slot)
        if Guardian then
            AddLeader(inst,Guardian)
            Guardian.Physics:Teleport(spawn_pt:Get())
            Guardian:FacePoint(pt)
        end
    end
end

local function CHKSummon()
    local CHK = false
    for F = 1,4,1 do
        if TUNING.FUTARADRAGON_SUMMON[F] == 0 then
            CHK = true
            break
        end
    end
    return CHK
end

local function AIAutoHelpFriend(inst)
    if inst.components.combat.target == nil then
        local pos = Vector3(inst.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 30)
        for i,ent in ipairs(ents) do
            if not inst.components.combat:IsAlly(ent) then
                if GetPlayer().components.combat.target == ent
                or ent.components.combat.target == GetPlayer()
                or ent.components.combat.target == inst.components.follower.leader 
                or ent.components.combat.target == inst  
                then
                    if ent ~= GetPlayer() and ent ~= inst.components.follower.leader then
                        if ent.components.follower and ent.components.follower.leader ~= inst.components.follower.leader and ent.components.follower.leader ~= GetPlayer and ent.components.follower.leader ~= inst then
                            inst.components.combat:SetTarget(ent)
                            inst.components.combat.target = ent
                            inst.components.combat:ShareTarget(ent, 30,function(dude) return (dude:HasTag("futdg") or dude:HasTag("futdgs") or dude:HasTag("companion")) and not dude.components.health:IsDead() end, 5)
                        elseif ent.components.follower and ent.components.follower.leader == inst.components.follower.leader then
                        
                        else
                            inst.components.combat:SetTarget(ent)
                            inst.components.combat.target = ent
                            inst.components.combat:ShareTarget(ent, 30,function(dude) return (dude:HasTag("futdg") or dude:HasTag("futdgs") or dude:HasTag("companion")) and not dude.components.health:IsDead() end, 5)
                        end
                    end
                end
            end
        end
    else
        if inst.components.combat.target.components.health then
            if inst.components.combat.target.components.combat and inst.components.combat.target.components.health:IsDead() or not inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST) then
                inst.components.combat:SetTarget(nil)
                inst.components.combat.retargettask = nil
                inst.components.combat.target = nil
            elseif inst.components.combat.target.components.combat and (inst.components.combat:IsAlly(inst.components.combat.target) or inst.components.combat.target.components.combat:IsAlly(inst) or inst.components.combat.target.components.combat:IsAlly(inst.components.follower.leader) or inst.components.combat.target == GetPlayer()) then
                inst.components.combat:SetTarget(nil)
                inst.components.combat.retargettask = nil
                inst.components.combat.target = nil
            end
        end
    end
end

local function SummonGPCHK(inst,ID)
    local IDnum = ID
    local CHKSummon = TheSim:FindFirstEntityWithTag(TUNING.FUTARADRAGON_SUMMONID[IDnum])
    if not CHKSummon and inst.components.mana:GetMana() >= TUNING.FUTARADRAGON_SKILLMANA[TUNING.FUTARADRAGON_SKILLUSING] then
        SummonGuardian(inst,ID)
        inst.components.mana:UseMana(TUNING.FUTARADRAGON_SKILLMANA[TUNING.FUTARADRAGON_SKILLUSING])
    end
    IDnum = IDnum + 1
    return IDnum
end

local function Update(inst)
    AIAutoHelpFriend(inst)
    if inst.components.health.currenthealth <= 0 and inst.death == 0 then
        TUNING.FUTARADRAGON_ACTION = -1
        TUNING.FUTARADRAGON_USING = 0
        if inst.darksidermode == 1 then
            inst.AnimState:SetBuild("futaradga")
            inst.components.mana:StartRegen(TUNING.FUTARADRAGON_MNRE, TUNING.FUTARADRAGON_MNPI)
            inst.components.mana.currentmana = 0
            inst.components.health:StartRegen(TUNING.FUTARADRAGON_HPRE, TUNING.FUTARADRAGON_HPPI)
            inst:RemoveTag("ghost")
            inst.Light:SetColour(255/255,255/255,255/255)
            inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[3])
            inst.darksidermode = 0
            inst.atktype = true
        end
        ChangeLight(inst,0.0)
        ChangeManaFX(0)
        inst.sg:GoToState("death")
        inst.death = 1
    end
    if inst.components.follower and inst.components.follower.leader ~= GetPlayer() then
        ReLeader(inst)
    end
    if inst.death ~= 1 and inst.components.follower.leader == GetPlayer() and not inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_WARPDIST) then
        ResetAllStatus(inst)
        ReWarpFutaraDragon(inst)
    end
    if inst.darksidermode == 0 then
        if inst.longrangedelay > 0 then
            if inst.longrangeaction == 1 then
                inst.atktype = true
                inst.components.inventory:DropEverything(true)
                inst.longrangeaction = 0
            end
            inst.longrangedelay = inst.longrangedelay - 1
        else
            if inst.longrangeaction == 0 then
                inst.atktype = true
                BreathFireAdd(inst)
                inst.longrangeaction = 1
            end
        end
    elseif inst.darksidermode == 1 then
        if inst.longrangeaction == 0 then
            inst.atktype = true
            BreathFireAdd(inst)
            inst.longrangeaction = 1
        end
    end
    if inst.atktype then
        if inst.darksidermode == 0 then
            if inst.longrangeaction == 0 then
                inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK)
                inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_PERIOD)
                inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_RANGE)
                if inst.skilllight == 1 then
                    inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK)
                    inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_PERIOD*2)
                    inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_RANGE)
                end
            elseif inst.longrangeaction == 1 then
                inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK_LONGRANGEATK)
                inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_LONGRANGEPERIOD)
                inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_LONGRANGE, TUNING.FUTARADRAGON_ATK_LONGRANGEHIT)
                if inst.skilllight == 1 then
                    inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK_LONGRANGEATK)
                    inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_LONGRANGEPERIOD*2)
                    inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_LONGRANGE, TUNING.FUTARADRAGON_ATK_LONGRANGEHIT)
                end
            end
        elseif inst.darksidermode == 1 then
            inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK/2)
            inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_PERIOD-TUNING.FUTARADRAGON_ATK_PERIOD)
            inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_LONGRANGE/1.5)
            inst.longrangeaction = 1
        end
        inst.atktype = false
    end
    if TUNING.FUTARADRAGON_ACTION == 0 then
        if GetTrueSkillDelay(inst) then
            TUNING.FUTARADRAGON_ACTION = 1
        else
            if inst.skillsound == 1 then
                OnTalk(inst)
                Talk(inst,TUNING.FUTARADRAGON_SAYALIVE,TUNING.FUTARADRAGON_SAYALIVEMAX)
                inst.sg:GoToState("charge")
                inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_raise")
                inst.skillsound = 0
            end
            if inst.skilldelay > TUNING.FUTARADRAGON_SKILLDELAY then
               inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
            end
            ChangeScale(inst,((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))/TUNING.FUTARADRAGON_SKILLDELAY)*GetNormalScale())
            ChangeLight(inst,((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))/TUNING.FUTARADRAGON_SKILLDELAY)*TUNING.FUTARADRAGON_LIGHT)
            ChangeManaFX((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))*4)
            UpdateSkillDelay(inst)
        end
        if GetTrueDelayNotMax(inst) then
            ResetDelay(inst)
        end
    elseif TUNING.FUTARADRAGON_ACTION == 1 then
        if GetTrueDelay(inst) then
            if TUNING.FUTARADRAGON_CRIS == 1 then
                if TUNING.FUTARADRAGON_SKILLUSING ~= TUNING.FUTARADRAGON_SKILL then
                    TUNING.FUTARADRAGON_SKILLUSING = TUNING.FUTARADRAGON_SKILL
                    STRINGS.ACTIONS.FUTARADRAGONAC1 = "Call FutaraDragon Use Skill "..TUNING.FUTARADRAGON_SKILLNAME[TUNING.FUTARADRAGON_SKILLUSING]
                    STRINGS.ACTIONS.FUTARADRAGONAC2 = "Call FutaraDragon Cancel Skill "..TUNING.FUTARADRAGON_SKILLNAME[TUNING.FUTARADRAGON_SKILLUSING]
                end
            else
                STRINGS.ACTIONS.FUTARADRAGONAC1 = "Can't Call FutaraDragon"
                STRINGS.ACTIONS.FUTARADRAGONAC2 = "Can't Call FutaraDragon"
            end
            if GetTrueSkillDelayNotMax(inst) then
                ChangeLight(inst,(inst.delay/TUNING.FUTARADRAGON_DELAY)*TUNING.FUTARADRAGON_LIGHT)
                ChangeManaFX((inst.delay)*8)
                ResetSkillDelay(inst)
            end
            if inst.components.sleeper:IsAsleep() then
                if inst.light < TUNING.FUTARADRAGON_DELAY then
                    inst.light = inst.light + 0.2
                    ChangeLight(inst,(inst.light/TUNING.FUTARADRAGON_DELAY)*TUNING.FUTARADRAGON_LIGHT)
                end
            else
                if inst.light > 0 then
                    inst.light = inst.light - 0.2
                    ChangeLight(inst,(inst.light/TUNING.FUTARADRAGON_DELAY)*TUNING.FUTARADRAGON_LIGHT)
                end
            end
            if inst.statusalert <= 0 and not inst.components.sleeper:IsAsleep() then
                if GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSGLOBAL[1] then
                    SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSGLOBAL[1])
                    inst.skilldanger = 0
                end
            elseif inst.components.sleeper:IsAsleep() then
                if GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSGLOBAL[4] then
                    SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSGLOBAL[4])
                    inst.skilldanger = 0
                end
            else
                inst.statusalert = inst.statusalert - 1
            end
            if inst.skilldanger == 1 and inst.light <= 0 and not inst.components.sleeper:IsAsleep() then
                local RandomSkill = math.random(1,TUNING.FUTARADRAGON_SKILLAUTOMAX)
                if inst.components.mana:GetMana() >= 10 then
                    inst.components.mana:UseMana(10)
                    inst.skilltime = 50
                    Talk(inst,TUNING.FUTARADRAGON_SAYHELP,TUNING.FUTARADRAGON_SAYHELPMAX)
                    TUNING.FUTARADRAGON_SKILLUSING = -1
                    TUNING.FUTARADRAGON_USING = 1
                    TUNING.FUTARADRAGON_ACTION = 2
                    inst.skilldanger = 0
                else
                    inst.skilldanger = 0
                end
            elseif TUNING.FUTARADRAGON_USING == 1 and inst.light <= 0 and not inst.components.sleeper:IsAsleep() then
                if inst.components.mana:GetMana() >= TUNING.FUTARADRAGON_SKILLMANA[TUNING.FUTARADRAGON_SKILLUSING] then
                    if TUNING.FUTARADRAGON_SKILLUSING == 6 then
                        if CHKSummon() then
                            inst.skilltime = TUNING.FUTARADRAGON_SKILLTIMER[TUNING.FUTARADRAGON_SKILLUSING]
                            Talk(inst,TUNING.FUTARADRAGON_SAYCHARGE,TUNING.FUTARADRAGON_SAYCHARGEMAX)
                            TUNING.FUTARADRAGON_ACTION = 2
                            inst.skilldanger = 0
                        else
                            Talk(inst,TUNING.FUTARADRAGON_SAYSUMMONFULL,TUNING.FUTARADRAGON_SAYSUMMONFULLMAX)
                            TUNING.FUTARADRAGON_USING = 0
                        end
                    else
                        inst.components.mana:UseMana(TUNING.FUTARADRAGON_SKILLMANA[TUNING.FUTARADRAGON_SKILLUSING])
                        inst.skilltime = TUNING.FUTARADRAGON_SKILLTIMER[TUNING.FUTARADRAGON_SKILLUSING]
                        Talk(inst,TUNING.FUTARADRAGON_SAYCHARGE,TUNING.FUTARADRAGON_SAYCHARGEMAX)
                        TUNING.FUTARADRAGON_ACTION = 2
                        inst.skilldanger = 0
                    end
                else
                    Talk(inst,TUNING.FUTARADRAGON_SAYNOMP,TUNING.FUTARADRAGON_SAYNOMPMAX)
                    TUNING.FUTARADRAGON_USING = 0
                end
            elseif inst.components.sleeper:IsAsleep() then
            else
                if inst.saydelay > 0 then
                    inst.saydelay = inst.saydelay - 1
                else
                    Talk(inst,TUNING.FUTARADRAGON_SAY,TUNING.FUTARADRAGON_SAYMAX)
                    inst.saydelay = TUNING.FUTARADRAGON_SAYDELAY*math.random(500,1000)
                end
            end
        else
            if inst.delay > TUNING.FUTARADRAGON_DELAY then
               inst.delay = TUNING.FUTARADRAGON_DELAY
            end
            UpdateDelay(inst)
            ChangeLight(inst,(inst.delay/TUNING.FUTARADRAGON_DELAY)*TUNING.FUTARADRAGON_LIGHT)
            ChangeManaFX((inst.delay)*8)
            inst.light = 0
            if inst.skillsound == 1 then
                inst.sg:GoToState("charge")
                inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_raise")
                inst.skillsound = 0
            end
            if inst.skillfx == 1 then
                inst.skillfx = 0
            end
            if inst.skilltalk == 1 then
                inst.skilltalk = 0
            end
            if GetTrueDelay(inst) then
                inst.sg:GoToState("idle")
            end
        end
    elseif TUNING.FUTARADRAGON_ACTION == 2 then
        if GetTrueDelayNotMax(inst) then
            ResetDelay(inst)
        end
        if GetTrueSkillDelay(inst) then
            if inst.skilltime > 0 and TUNING.FUTARADRAGON_USING == 1 then
                inst.skilltime = inst.skilltime - 1
                if TUNING.FUTARADRAGON_SKILLUSING == -1 then

                elseif TUNING.FUTARADRAGON_SKILLUSING == 1 then
                    SetHealArea(inst,6,0.1)
                elseif TUNING.FUTARADRAGON_SKILLUSING == 2 then
                    if inst.components.sanityaura.aura ~= 10 then
                        inst.components.sanityaura.aura = 10
                    end
                elseif TUNING.FUTARADRAGON_SKILLUSING == 3 then
                    SetBurnArea(inst,6,10)
                elseif TUNING.FUTARADRAGON_SKILLUSING == 4 then
                elseif TUNING.FUTARADRAGON_SKILLUSING == 5 then
                elseif TUNING.FUTARADRAGON_SKILLUSING == 6 then
                end
                if inst.skilltalk == 0 then
                    Talk(inst,TUNING.FUTARADRAGON_SKILLSAY[TUNING.FUTARADRAGON_SKILLUSING],TUNING.FUTARADRAGON_SKILLSAYMAX)
                    inst.skilltalk = 1
                end
            elseif inst.skilltime == -1 and TUNING.FUTARADRAGON_USING == 1 then
                if TUNING.FUTARADRAGON_SKILLUSING == 5 then
                    if inst.light < TUNING.FUTARADRAGON_LIGHT+2 then
                        inst.light = inst.light + 0.05
                        if inst.light > TUNING.FUTARADRAGON_LIGHT+2 then
                            inst.light = TUNING.FUTARADRAGON_LIGHT+2
                        end
                        ChangeLight(inst,inst.light)
                    end
                    if inst.components.mana:GetMana() > 0 then
                        inst.components.mana:UseMana(0.015)
                        if inst.components.mana:GetMana() <= 0 then
                            inst.components.mana.currentmana = 0
                            TUNING.FUTARADRAGON_USING = 0
                        end
                    end
                elseif TUNING.FUTARADRAGON_SKILLUSING == 7 then
                    if inst.darksiderrushdelay > 0 then
                        if inst.darksiderrushdelay == TUNING.FUTARADRAGON_DARKSIDERRUSHDELAY then
                            Talk(inst,TUNING.FUTARADRAGON_SAYDARKSIDER,TUNING.FUTARADRAGON_SAYDARKSIDERMAX)
                        end
                        inst.darksiderrushdelay = inst.darksiderrushdelay - 1
                    else
                        inst.darksiderrush = 1
                    end
                    if inst.darksiderdarkfielddelay > 0 then
                        inst.darksiderdarkfielddelay = inst.darksiderdarkfielddelay - 1
                    end
                    if inst.darksiderdarkfield == 1 then
                        SetDarkArea(inst)
                        inst.darksiderdarkfield = 0
                        inst.darksiderdarkfielddelay = TUNING.FUTARADRAGON_DARKSIDERDARKFIELDDELAY
                    end
                    if inst.components.mana:GetMana() > 0 then
                        inst.components.mana:UseMana(0.1)
                        if inst.components.mana:GetMana() <= 0 then
                            inst.components.mana.currentmana = 0
                        end
                    else
                        if inst.components.health:GetPercent() > 0.10 then
                            inst.components.health.currenthealth = inst.components.health.currenthealth - 1
                        else
                            TUNING.FUTARADRAGON_USING = 0
                        end
                    end
                end
                if inst.skilltalk == 0 then
                    Talk(inst,TUNING.FUTARADRAGON_SKILLSAY[TUNING.FUTARADRAGON_SKILLUSING],TUNING.FUTARADRAGON_SKILLSAYMAX)
                    inst.skilltalk = 1
                end
            elseif inst.skilltime <= 0 or TUNING.FUTARADRAGON_USING == 0 then
                if TUNING.FUTARADRAGON_SKILLUSING == -1 then

                elseif TUNING.FUTARADRAGON_SKILLUSING == 1 then
                elseif TUNING.FUTARADRAGON_SKILLUSING == 2 then
                    if inst.components.sanityaura.aura ~= TUNING.SANITYAURA_TINY then
                        inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY
                    end
                elseif TUNING.FUTARADRAGON_SKILLUSING == 3 then
                elseif TUNING.FUTARADRAGON_SKILLUSING == 4 then
                    if inst.skilltalk == 0 then
                        Talk(inst,TUNING.FUTARADRAGON_SKILLSAY[TUNING.FUTARADRAGON_SKILLUSING],TUNING.FUTARADRAGON_SKILLSAYMAX)
                        inst.skilltalk = 1
                    end
                elseif TUNING.FUTARADRAGON_SKILLUSING == 5 then
                    inst.followmin = TUNING.FUTARADRAGON_MINFOLLOW
                    inst.followtarget = TUNING.FUTARADRAGON_TARGETFOLLOW
                    inst.followmax = TUNING.FUTARADRAGON_MAXFOLLOW
                    inst.light = 0
                    inst.skilllight = 0
                    inst.components.mana:StartRegen(TUNING.FUTARADRAGON_MNRE, TUNING.FUTARADRAGON_MNPI)
                    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[3])
                    inst.atktype = true
                elseif TUNING.FUTARADRAGON_SKILLUSING == 6 then
                    if inst.skilltalk == 0 then
                        Talk(inst,TUNING.FUTARADRAGON_SKILLSAY[TUNING.FUTARADRAGON_SKILLUSING],TUNING.FUTARADRAGON_SKILLSAYMAX)
                        inst.skilltalk = 1
                    end
                elseif TUNING.FUTARADRAGON_SKILLUSING == 7 then
                    inst.AnimState:SetBuild("futaradga")
                    inst.components.mana:StartRegen(TUNING.FUTARADRAGON_MNRE, TUNING.FUTARADRAGON_MNPI)
                    inst.components.health:StartRegen(TUNING.FUTARADRAGON_HPRE, TUNING.FUTARADRAGON_HPPI)
                    inst:RemoveTag("ghost")
                    inst.Light:SetColour(255/255,255/255,255/255)
                    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[3])
                    inst.Physics:ClearMotorVelOverride()
                    inst.darksidermode = 0
                    inst.atktype = true
                end
                if inst.skilltime <= 0 then
                    if TUNING.FUTARADRAGON_SKILLUSING ~= 4 and TUNING.FUTARADRAGON_SKILLUSING ~= 6 then
                        Talk(inst,TUNING.FUTARADRAGON_SAYSKILLLIMIT,TUNING.FUTARADRAGON_SAYSKILLLIMITMAX)
                    end
                elseif TUNING.FUTARADRAGON_USING == 0 then
                    Talk(inst,TUNING.FUTARADRAGON_SAYSKILLCANCEL,TUNING.FUTARADRAGON_SAYSKILLCANCELMAX)
                end
                if GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSSKILL[TUNING.FUTARADRAGON_SKILLUSING] then
                    SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSSKILL[TUNING.FUTARADRAGON_SKILLUSING])
                end
                SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,1)
                TUNING.FUTARADRAGON_USING = 0
                TUNING.FUTARADRAGON_ACTION = 1
            end
        else
            if GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSSKILL[TUNING.FUTARADRAGON_SKILLUSING] then
                SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSSKILL[TUNING.FUTARADRAGON_SKILLUSING])
            end
            if inst.skillsound == 0 then
                inst.sg:GoToState("charge")
                inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_raise")
                inst.skillsound = 1
            end
            if inst.skilldelay > TUNING.FUTARADRAGON_SKILLDELAY then
               inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
            end
            ChangeLight(inst,((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))/TUNING.FUTARADRAGON_SKILLDELAY)*TUNING.FUTARADRAGON_LIGHT)
            ChangeManaFX((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))*4)
            UpdateSkillDelay(inst)
            if GetTrueSkillDelay(inst) then
                if TUNING.FUTARADRAGON_SKILLUSING > 0 then
                    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLUSINGFX,TUNING.FUTARADRAGON_SKILLUSING)
                end
                if TUNING.FUTARADRAGON_SKILLUSING == -1 then
                    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,2)
                    inst.sg:GoToState("magicspell")
                    SetDarkArea(inst)
                elseif TUNING.FUTARADRAGON_SKILLUSING == 1 then
                    inst.sg:GoToState("magicspell")
                elseif TUNING.FUTARADRAGON_SKILLUSING == 2 then
                    inst.sg:GoToState("magicspell")
                elseif TUNING.FUTARADRAGON_SKILLUSING == 3 then
                    inst.sg:GoToState("idle")
                elseif TUNING.FUTARADRAGON_SKILLUSING == 4 then
                    SwapPlayer(inst)
                elseif TUNING.FUTARADRAGON_SKILLUSING == 5 then
                    inst.followmin = 0
                    inst.followtarget = 1
                    inst.followmax = 1
                    inst.light = TUNING.FUTARADRAGON_LIGHT
                    inst.skilllight = 1
                    inst.atktype = true
                    inst.components.mana:StopRegen()
                    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[2])
                    inst.sg:GoToState("idle")
                elseif TUNING.FUTARADRAGON_SKILLUSING == 6 then
                    local SummonID = 1
                    SummonID = SummonGPCHK(inst,SummonID)
                    SummonID = SummonGPCHK(inst,SummonID)
                    SummonID = SummonGPCHK(inst,SummonID)
                    SummonID = SummonGPCHK(inst,SummonID)
                elseif TUNING.FUTARADRAGON_SKILLUSING == 7 then
                    inst.darksidermode = 1
                    inst.AnimState:SetBuild("futaradgd")
                    inst.sg:GoToState("idle")
                    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[2])
                    inst.components.mana:StopRegen()
                    inst.components.health:StopRegen()
                    inst:AddTag("ghost")
                    inst.Light:SetColour(255/255,50/255,50/255)
                    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,2)
                    if GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSGLOBAL[6] then
                        SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSGLOBAL[6])
                    end
                    inst.atktype = true
                end
            end
        end
    end
end

local function StartUpdating(inst)
    if not inst.loop then
        inst.loop = {}
    end
    inst.loop.amount = 0
    inst.loop.period = 0.1
    if not inst.loop.task then
        inst.loop.task = inst:DoPeriodicTask(inst.loop.period, function() Update(inst) end)
    end
end

local function OnNewTarget(inst, data)
    if TUNING.FUTARADRAGON_ACTION == 1 and GetTrueDelay(inst) or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 5 or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 7 then
        return FindEntity(inst, TUNING.FUTARADRAGON_ATK_DIST,
        function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() and inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST) then
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (guy:HasTag("futdg") or guy:HasTag("futdgs") or guy:HasTag("player"))
            end
        end)
    end
end

local function OnAttacked(inst, data)
    ResetLongRangeDelay(inst)
    if inst.components.health:GetPercent() > 0.25 then
        if TUNING.FUTARADRAGON_ACTION == 1 and GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSGLOBAL[2] then
            SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSGLOBAL[2])
        end
        if TUNING.FUTARADRAGON_SKILLUSING ~= 7 then
            Talk(inst,TUNING.FUTARADRAGON_SAYHIT,TUNING.FUTARADRAGON_SAYHITMAX)
        end
    else
        if TUNING.FUTARADRAGON_ACTION == 1 and GetIconStatus(inst) ~= TUNING.FUTARADRAGON_STATUSGLOBAL[3] then
            SetIconStatus(inst,TUNING.FUTARADRAGON_STATUSGLOBAL[3])
        end
        inst.skilldanger = 1
        if TUNING.FUTARADRAGON_SKILLUSING ~= 7 then
            Talk(inst,TUNING.FUTARADRAGON_SAYHELP,TUNING.FUTARADRAGON_SAYHELPMAX)
        end 
    end
    inst.statusalert = TUNING.FUTARADRAGON_STATUSALERTTIME
    if TUNING.FUTARADRAGON_ACTION == 1 and GetTrueDelay(inst) or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 5 or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 7 then
        if data.attacker ~= inst.components.follower.leader and data.attacker ~= GetPlayer then
            inst.components.combat:SetTarget(data.attacker)
            inst.components.combat:ShareTarget(data.attacker, 30,function(dude)
            return (dude:HasTag("futdg") or dude:HasTag("futdgs") or dude:HasTag("companion")) and not dude.components.health:IsDead()
        end, 5)
        end
    end
end

local function Retarget(inst)
    if TUNING.FUTARADRAGON_ACTION == 1 and GetTrueDelay(inst) or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 5 or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 7 then
        return FindEntity(inst, TUNING.FUTARADRAGON_ATK_DIST,
        function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() and inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST) then
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (guy:HasTag("futdg") or guy:HasTag("futdgs") or guy:HasTag("player") or guy == GetPlayer())
            end
        end)
    end
end

local function KeepTarget(inst, target)
    if TUNING.FUTARADRAGON_ACTION == 1 and GetTrueDelay(inst) or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 5 or TUNING.FUTARADRAGON_ACTION == 2 and TUNING.FUTARADRAGON_SKILLUSING == 7 then
        return inst.components.combat:CanTarget(target)
        and (not target.LightWatcher or target.LightWatcher:IsInLight() and inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST))
        and not (target.sg and target.sg:HasStateTag("transform") or target:HasTag("futdg") or target:HasTag("futdgs") or target:HasTag("player") or target == GetPlayer() )
    end
end

local function ShouldWakeUp(inst)
    if TUNING.FUTARADRAGON_ACTION == 1 and GetTrueDelay(inst) then
        inst:AddComponent("cooker")
        return not inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_SLEEPDIST) or DefaultWakeTest(inst) or TUNING.FUTARADRAGON_USING == 1
    end
end

local function ShouldSleep(inst)
    if TUNING.FUTARADRAGON_ACTION == 1 and GetTrueDelay(inst) then
        inst:RemoveComponent("cooker")
        return DefaultSleepTest(inst) and TUNING.FUTARADRAGON_USING ~= 1
    end
end

local function GetHeatFn(inst)
    return 220
end

local function OnWingDown(inst)
    inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/flap")
end

local function create_futaradragon()

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    local player = GetPlayer()
    local emitter = inst.entity:AddParticleEmitter()
    
    inst.entity:AddLabel()

    inst.Label:SetFontSize(24)
    inst.Label:SetFont(TALKINGFONT)
    inst.Label:SetPos(0,4.5,0)
    inst.Label:Enable(true)

    inst:AddTag("companion")
    inst:AddTag("character")
    inst:AddTag("scarytoprey")
    inst:AddTag("futdg")
    inst:AddTag("notraptrigger")
    inst:AddTag("noauradamage")
    inst:AddTag("flying")

    inst.entity:AddTransform()

    InitSkillFX()

    inst.death = 0
    inst.delay = 0
    inst.saydelay = TUNING.FUTARADRAGON_SAYDELAY*math.random(500,1000)
    inst.longrangedelay = TUNING.FUTARADRAGON_ATK_LONGRANGEDELAY
    inst.longrangeaction = 0
    inst.skillfx = 0
    inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
    inst.skillsound = 1
    inst.skilltime = 0
    inst.skilltalk = 0
    inst.skilldanger = 0
    inst.skilllight = 0
    inst.atktype = false
    inst.scale = 0.1
    inst.light = 0
    inst.loop = nil
    inst.iconstatus = TUNING.FUTARADRAGON_STATUSGLOBAL[1]
    inst.statusalert = 0
    inst.darksidermode = 0
    inst.darksiderrush = 0
    inst.darksiderrushdelay = 0
    inst.darksiderdarkfield = 0
    inst.darksiderdarkfielddelay = 0
    inst.followmin = TUNING.FUTARADRAGON_MINFOLLOW
    inst.followtarget = TUNING.FUTARADRAGON_TARGETFOLLOW
    inst.followmax = TUNING.FUTARADRAGON_MAXFOLLOW
    TUNING.FUTARADRAGON_ACTION = 0

    inst.Transform:SetScale(inst.scale, inst.scale, inst.scale)

    inst.entity:AddParticleEmitter()
    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,1)
    inst.ParticleEmitter:SetMaxNumParticles(10000)
    inst.ParticleEmitter:EnableBloomPass(true)
    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[3])

    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "batcave.png" )

    inst.entity:AddAnimState()
    inst.AnimState:SetBank("bat")
    inst.AnimState:SetBuild("futaradga")

    inst.entity:AddSoundEmitter()
    inst.soundgroup = "mctusk"

    inst.entity:AddDynamicShadow()
    local shadow = inst.entity:AddDynamicShadow()
    shadow:SetSize( 2, 1 )

    MakeGhostPhysics(inst, 10, .25)
    RemovePhysicsColliders(inst)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    --inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)

    inst.Transform:SetFourFaced()

    inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetIntensity(0.85)
    inst.Light:SetColour(255/255,255/255,255/255)
    inst.Light:SetFalloff(0.5)
    inst.Light:SetRadius(inst.light)
    
    inst.persists = false

    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "bat_body"
    inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_ATK)
    inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_ATK_PERIOD)
    inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_RANGE)
    inst.components.combat:SetRetargetFunction(TUNING.FUTARADRAGON_ATK_RETARGET, Retarget)
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetTarget(nil)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.FUTARADRAGON_HPMAX)
    inst.components.health:StartRegen(TUNING.FUTARADRAGON_HPRE, TUNING.FUTARADRAGON_HPPI)

    inst:AddComponent("mana")
    inst.components.mana:SetMaxMana(TUNING.FUTARADRAGON_MNMAX)
    inst.components.mana:StartRegen(TUNING.FUTARADRAGON_MNRE, TUNING.FUTARADRAGON_MNPI)

    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn

    inst:AddComponent("inspectable")

    inst:AddComponent("cooker")

    inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier(1)
    inst.components.locomotor:SetTriggersCreep(false)
    inst.components.locomotor.pathcaps = { ignorecreep = true }
    inst.components.locomotor.walkspeed = TUNING.FUTARADRAGON_WALK
    inst.components.locomotor.runspeed = TUNING.FUTARADRAGON_RUN

    inst:AddComponent("lootdropper")

    inst:AddComponent("follower")

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY

    inst:AddComponent("aura")
    inst.components.aura.radius = 6
    inst.components.aura.tickperiod = 1

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    inst:ListenForEvent("attacked", OnAttacked)

    inst:AddComponent("knownlocations")

    inst:AddComponent("talker")

    MakeMediumBurnableCharacter(inst, "bat_body")
    MakeMediumFreezableCharacter(inst, "bat_body")

    inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
    inst.components.sleeper.testperiod = GetRandomWithVariance(6, 2)
    inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)

    inst:ListenForEvent("wingdown", OnWingDown)

    inst:AddComponent("teamattacker")
    inst.components.teamattacker.team_type = "futdgs"

    inst:AddComponent("inventory")

    inst:AddComponent("FutaraDragonUseSkill")

    inst:SetStateGraph("SGfutaradragon")

    local brain = require "brains/futaradragonbrain"
    inst:SetBrain(brain)

    local TimeSec = TheSim:GetTickTime()

    local PEFX = inst.ParticleEmitter

    local PEFXTE = 1

    local PEFXFN = function()
        local VX, VY, VZ = inst.ParticleVX * math.random(inst.ParticleVXM,inst.ParticleVXL), inst.ParticleVY * math.random(inst.ParticleVYM,inst.ParticleVYL) , inst.ParticleVZ * math.random(inst.ParticleVZM,inst.ParticleVZL)
        local lifetime = inst.ParticleLT 
        local PX, PY, PZ
        PX, PY, PZ = inst.ParticleSize()
        PX = PX
        PZ = PZ
        PY = PY + 2.5
        local UVOS = math.random( 0, 0 ) * 0.25
        PEFX:AddParticleUV(
            lifetime,
            PX, PY, PZ,
            VX, VY, VZ,
            UVOS, 0
        )
    end
    
    local PEFXFN = function()
        while PEFXTE > 1 do
            PEFXFN(PEFX)
            PEFXTE = PEFXTE - 1
        end
        local PEFXPS = TUNING.FUTARADRAGON_SKILLFX * TimeSec
        PEFXTE = PEFXTE + PEFXPS
    end

    EmitterManager:AddEmitter( inst, nil, PEFXFN)

    StartUpdating(inst)
    return inst
end

return Prefab( "common/objects/futaradragon", create_futaradragon, assets,prefabs)
