local assets = TUNING.FUTARADRAGONBALL_ASSET

local function OnHit(inst, owner, target)
    inst.SoundEmitter:PlaySound("dontstarve/wilson/fireball_explo")
    inst.components.projectile:SetSpeed(TUNING.FUTARADRAGON_BALL_SPD)
    inst.HitStatus = 1
end

local function ChangePECFX(number)
    inst.PECount = number
end

local function SetParticleFX(inst,LT,VX,VXM,VXL,VY,VYM,VYL,VZ,VZM,VZL,TX,PC,PS,SW,SH,SZ,BM)
    inst.ParticleLT = LT
    inst.ParticleVX = VX
    inst.ParticleVXM = VXM
    inst.ParticleVXL = VXL
    inst.ParticleVY = VY
    inst.ParticleVYM = VYM
    inst.ParticleVYL = VYL
    inst.ParticleVZ = VZ
    inst.ParticleVZM = VZM
    inst.ParticleVZL = VZL
    inst.ParticleEmitter:SetRenderResources(TUNING.FDFNDM.."fx/"..TX..".tex", TUNING.FUTARADRAGON_SHADER[1])
    inst.ParticleEmitter:SetBlendMode(BM)
    inst.ParticleEmitter:SetMaxLifetime(inst.ParticleLT)
    inst.ParticleEmitter:SetColourEnvelope(PC)
    inst.ParticleEmitter:SetScaleEnvelope(PS);
    inst.ParticleEmitter:SetUVFrameSize(SW,SH)
    inst.ParticleSize = CreateSphereEmitter(SZ)
end

local function SetParticleSet(inst,setting,slot)
    local FX = setting[slot]
    SetParticleFX(inst,FX[1],FX[2],FX[3],FX[4],FX[5],FX[6],FX[7],FX[8],FX[9],FX[10],FX[11],FX[12],FX[13],FX[14],FX[15],FX[16],FX[17])
end

local function Update(inst)
    if inst.PECount > 0 then
        inst.PECount = inst.PECount - 1
        inst.LightRadius = inst.PECount/10
        inst.Light:SetRadius(inst.LightRadius)
    end
    if inst.HitStatus == 1 or inst.PECount <= 0 then
        if inst.PECount > 0 then
            inst.PECount = inst.PECount - 5
            inst.LightRadius = inst.PECount/10
            inst.Light:SetRadius(inst.LightRadius)
        else
            if inst.PECount < 0 then
                inst.PECount = 0
                inst.Light:SetRadius(0)
            end
            if inst.delayout > 0 then
                inst.Light:SetRadius(0)
                inst.delayout = inst.delayout - 1
            else
                inst:Remove()
            end
        end
    end
end

local function StartUpdating(inst)
    if not inst.loop then
        inst.loop = {}
    end
    inst.loop.amount = 0
    inst.loop.period = 0.1
    if not inst.loop.task then
        inst.loop.task = inst:DoPeriodicTask(inst.loop.period, function() Update(inst) end)
    end
end

local function RunPE(inst)
    local TimeSec = TheSim:GetTickTime()

    local PEFX = inst.ParticleEmitter

    local PEFXTE = 1

    local PEFXFN = function()
        local VX, VY, VZ = inst.ParticleVX * math.random(inst.ParticleVXM,inst.ParticleVXL), inst.ParticleVY * math.random(inst.ParticleVYM,inst.ParticleVYL) , inst.ParticleVZ * math.random(inst.ParticleVZM,inst.ParticleVZL)
        local lifetime = inst.ParticleLT 
        local PX, PY, PZ
        PX, PY, PZ = inst.ParticleSize()
        PX = PX
        PZ = PZ
        PY = PY + 2.5
        local UVOS = math.random( 0, 0 ) * 0.25
        PEFX:AddParticleUV(
            lifetime,
            PX, PY, PZ,
            VX, VY, VZ,
            UVOS, 0
        )
    end
    
    local PEFXFN = function()
        while PEFXTE > 1 do
            PEFXFN(PEFX)
            PEFXTE = PEFXTE - 1
        end
        local PEFXPS = inst.PECount * TimeSec
        PEFXTE = PEFXTE + PEFXPS
    end

    EmitterManager:AddEmitter( inst, nil, PEFXFN)
end

local function BallFn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local emitter = inst.entity:AddParticleEmitter()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    inst.entity:AddParticleEmitter()
    inst.ParticleEmitter:SetMaxNumParticles(10000)
    inst.ParticleEmitter:EnableBloomPass(true)
    anim:SetBank("projectile")
    anim:SetBuild("futaradragonball")
    inst:AddTag("projectile")
    inst:AddComponent("projectile")
    inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.HitStatus = 0
    inst.delayout = 50
    inst.PECount = TUNING.FUTARADRAGON_BALL_TM
    inst.LightRadius = inst.PECount/10
    return inst
end

local function FireBall()
    local inst = BallFn()
    inst.Transform:SetScale(0.1, 0.1, 0.1)
    inst.Light:SetIntensity(0.85)
    inst.Light:SetColour(255/255,255/255,255/255)
    inst.Light:SetFalloff(0.5)
    inst.Light:SetRadius(2)
    inst.components.projectile:SetSpeed(TUNING.FUTARADRAGON_BALL_SPD)
    inst.components.projectile:SetHoming(TUNING.FUTARADRAGON_BALL_HM)
    inst.components.projectile:SetHitDist(TUNING.FUTARADRAGON_BALL_HD)
    inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
    inst.AnimState:PlayAnimation("ice_spin_loop", true)
    inst.AnimState:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[2])
    inst.AnimState:SetMultColour(0,0,0,0)
    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLOTHERFX,1)
    RunPE(inst)
    StartUpdating(inst)
    return inst
end

return Prefab("common/inventory/futaradragonfireball", FireBall, assets) 
