
local assets = TUNING.FUTARADRAGONCIS_ASSET

local SPAWN_DIST = 5

local function ChangeItemImage(inst,data)
    inst.components.inventoryitem.atlasname = TUNING.FDFNDM.."inventoryimages/"..data..".xml"
    inst.components.inventoryitem:ChangeImageName(data)
    inst.ItemPicture = data
end

local function GetTrueDelay(inst)
    return inst.ItemStatusDelay <= 0
end

local function GetDelay(inst)
    return inst.ItemStatusDelay
end

local function ResetDelay(inst)
    inst.ItemStatusDelay = TUNING.FUTARADRAGON_STATUSDELAY
end

local function UpdateDelay(inst)
    inst.ItemStatusDelay = inst.ItemStatusDelay - 1
end

local function GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = SPAWN_DIST
    local offset = FindWalkableOffset(pt, theta, radius, 12, true)
    if offset then
        return pt+offset
    end
end

local function SpawnFutaraDragon(inst)
    local pt = Vector3(inst.Transform:GetWorldPosition())
    local spawn_pt = GetSpawnPoint(pt)
    if spawn_pt then
        local FutaraDragon = SpawnPrefab("futaradragon")
        if FutaraDragon then
            FutaraDragon.Physics:Teleport(spawn_pt:Get())
            FutaraDragon:FacePoint(pt)
            return FutaraDragon
        end
    else
    end
end

local function AddLeader(prefab)
    if prefab then
        local player = GetPlayer()
        prefab.components.follower:SetLeader(player)
    end
end

local function Update(inst)
    if TUNING.FUTARADRAGON_ALIVE == 1 then
        local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
        if not FutaraDragon then
            FutaraDragon = SpawnFutaraDragon(inst)
            inst.FutaraDragon = FutaraDragon
            AddLeader(FutaraDragon)
        end
        if TUNING.FUTARADRAGON_CRIS == 1 then
            if GetTrueDelay(inst) then
                if FutaraDragon and FutaraDragon.iconstatus ~= nil then
                    if inst.ItemPicture ~= FutaraDragon.iconstatus then
                        ChangeItemImage(inst,FutaraDragon.iconstatus)
                    end
                end
            else
                if inst.ItemPicture ~= TUNING.FUTARADRAGON_SKILL then
                    ChangeItemImage(inst,TUNING.FUTARADRAGON_STATUSCIS[TUNING.FUTARADRAGON_SKILL])
                end
                UpdateDelay(inst)
            end
        end
    else
        if TUNING.FUTARADRAGON_CRIS == 1 then
            if GetTrueDelay(inst) then
                if inst.ItemPicture ~= TUNING.FUTARADRAGON_STATUSGLOBAL[5] then
                    ChangeItemImage(inst,TUNING.FUTARADRAGON_STATUSGLOBAL[5])
                end
            else
                if inst.ItemPicture ~= TUNING.FUTARADRAGON_SKILL then
                    ChangeItemImage(inst,TUNING.FUTARADRAGON_STATUSCIS[TUNING.FUTARADRAGON_SKILL])
                end
                UpdateDelay(inst)
            end
            if TUNING.FUTARADRAGON_CHARGE < TUNING.FUTARADRAGON_CHARGEMAX then
                TUNING.FUTARADRAGON_CHARGE = TUNING.FUTARADRAGON_CHARGE + 1
            elseif TUNING.FUTARADRAGON_CHARGE >= TUNING.FUTARADRAGON_CHARGEMAX then
                TUNING.FUTARADRAGON_ALIVE = 1
                TUNING.FUTARADRAGON_CHARGE = 0
            end
        end
    end
end

local function StartUpdating(inst)
    if not inst.loop then
        inst.loop = {}
    end
    inst.loop.amount = 0
    inst.loop.period = 0.1
    if not inst.loop.task then
        inst.loop.task = inst:DoPeriodicTask(inst.loop.period, function() Update(inst) end)
    end
end

local function OnPutInInventory(inst)
    if TUNING.FUTARADRAGON_CRIS == 0 then
        TUNING.FUTARADRAGON_CRIS = 1
        if TUNING.FUTARADRAGON_SKILLUSING == -1 then
            TUNING.FUTARADRAGON_SKILLUSING = TUNING.FUTARADRAGON_SKILL
        end
        STRINGS.ACTIONS.FUTARADRAGONAC1 = "Call FutaraDragon Use Skill "..TUNING.FUTARADRAGON_SKILLNAME[TUNING.FUTARADRAGON_SKILLUSING]
        STRINGS.ACTIONS.FUTARADRAGONAC2 = "Call FutaraDragon Cancel Skill "..TUNING.FUTARADRAGON_SKILLNAME[TUNING.FUTARADRAGON_SKILLUSING]
    else

    end
end

local function GetStatus(inst)
    if inst.respawntask then
        return "WAITING"
    end
end

local function OnDropped(inst)
    TUNING.FUTARADRAGON_CRIS = 0
    STRINGS.ACTIONS.FUTARADRAGONAC1 = "Can't Call FutaraDragon"
    STRINGS.ACTIONS.FUTARADRAGONAC2 = "Can't Call FutaraDragon"
end

local function OnSave(inst, data)
        data.Alive = TUNING.FUTARADRAGON_ALIVE
        data.Cris = TUNING.FUTARADRAGON_CRIS
        data.Charge = TUNING.FUTARADRAGON_CHARGE
        data.summon = TUNING.FUTARADRAGON_SUMMON
        local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
        inst.FutaraDragon = FutaraDragon
        if inst.FutaraDragon then
            data.FutaraDragon = inst.FutaraDragon:GetSaveRecord()
        end
        local FutaraDragonG1 = TheSim:FindFirstEntityWithTag(TUNING.FUTARADRAGON_SUMMONID[1])
        if FutaraDragonG1 then
            data.FutaraDragonG1 = FutaraDragonG1:GetSaveRecord()
        end
        local FutaraDragonG2 = TheSim:FindFirstEntityWithTag(TUNING.FUTARADRAGON_SUMMONID[2])
        if FutaraDragonG2 then
            data.FutaraDragonG2 = FutaraDragonG2:GetSaveRecord()
        end
        local FutaraDragonG3 = TheSim:FindFirstEntityWithTag(TUNING.FUTARADRAGON_SUMMONID[3])
        if FutaraDragonG3 then
            data.FutaraDragonG3 = FutaraDragonG3:GetSaveRecord()
        end
        local FutaraDragonG4 = TheSim:FindFirstEntityWithTag(TUNING.FUTARADRAGON_SUMMONID[4])
        if FutaraDragonG4 then
            data.FutaraDragonG4 = FutaraDragonG4:GetSaveRecord()
        end
    return data
end

local function OnLoad(inst, data)
    if data then
        TUNING.FUTARADRAGON_ALIVE = data.Alive
        TUNING.FUTARADRAGON_CRIS = data.Cris
        TUNING.FUTARADRAGON_CHARGE = data.Charge
        if data.summon then
            TUNING.FUTARADRAGON_SUMMON = data.summon
        end
        if TUNING.FUTARADRAGON_ALIVE == 1 then
            if data.FutaraDragon then
                local FutaraDragon = SpawnSaveRecord(data.FutaraDragon, data)
                AddLeader(FutaraDragon)
            end
        end
        if TUNING.FUTARADRAGON_SUMMON[1] == 1 then
            if data.FutaraDragonG1 then
                local FutaraDragonG1 = SpawnSaveRecord(data.FutaraDragonG1, data)
            end
        end
        if TUNING.FUTARADRAGON_SUMMON[2] == 1 then
            if data.FutaraDragonG2 then
                local FutaraDragonG2 = SpawnSaveRecord(data.FutaraDragonG2, data)
            end
        end
        if TUNING.FUTARADRAGON_SUMMON[3] == 1 then
            if data.FutaraDragonG3 then
                local FutaraDragonG3 = SpawnSaveRecord(data.FutaraDragonG3, data)
            end
        end
        if TUNING.FUTARADRAGON_SUMMON[4] == 1 then
            if data.FutaraDragonG4 then
                local FutaraDragonG4 = SpawnSaveRecord(data.FutaraDragonG4, data)
            end
        end
    end
end

local function fn(Sim)
    local FDCrystal = TheSim:FindFirstEntityWithTag("FDCrystal")
    if TUNING.FUTARADRAGON_CRIS == 0 and not FDCrystal then
        local inst = CreateEntity()
        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddSoundEmitter()
        inst.soundgroup = "mctusk"

        inst.ItemStatusDelay = 0
        inst.ItemPicture = nil

        inst:AddTag("FDCrystal")
        inst:AddTag("irreplaceable")
        inst:AddTag("nonpotatable")

        local minimap = inst.entity:AddMiniMapEntity()
        minimap:SetIcon( "batcave.png" )

        MakeInventoryPhysics(inst)
        
        inst.AnimState:SetBank("eyebone")
        inst.AnimState:SetBuild("futaradragoncis")
        inst.AnimState:PlayAnimation("idle_loop", true)

        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = TUNING.FDFNDM.."inventoryimages/futaradragoncis.xml"
        inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
        inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
 
        inst:AddComponent("inspectable")
        inst.components.inspectable.getstatus = GetStatus

        inst:AddComponent("leader")

        inst:AddComponent("stackable")
        inst.components.stackable.maxsize = 1

        inst:AddComponent("edible")
        inst.components.edible.inst = nil
        inst.components.edible.healthvalue = 0
        inst.components.edible.hungervalue = 0 
        inst.components.edible.sanityvalue = 0 
        inst.components.edible.foodtype = nil

        inst:AddComponent("perishable")
        inst.components.perishable.perishfn = nil
        inst.components.perishable.perishtime = nil
        inst.components.perishable.targettime = nil
        inst.components.perishable.perishremainingtime = nil
        inst.components.perishable.updatetask = nil
        inst.components.perishable.dt = nil
        inst.components.perishable.onperishreplacement = nil

        inst:AddComponent("finiteuses")

        inst:AddComponent("FutaraDragonHPHUD")
        inst.components.FutaraDragonHPHUD.nearleader = 14
        inst.components.FutaraDragonHPHUD:RunHUD()
        inst.components.FutaraDragonHPHUD:StartUpdating()

        inst:AddComponent("FutaraDragonSetSkill")
        
        inst.OnLoad = OnLoad
        inst.OnSave = OnSave

        inst.loop = nil
        inst.FutaraDragon = nil
        StartUpdating(inst)

        return inst
    else
        local player = GetPlayer()
        local item = SpawnPrefab("purplegem")
        player.components.inventory:GiveItem(item)
        item = SpawnPrefab("bluegem")
        player.components.inventory:GiveItem(item)
        item = SpawnPrefab("redgem")
        player.components.inventory:GiveItem(item)
    end
end

return Prefab( "common/inventory/futaradragoncis", fn, assets)
