local assets = TUNING.FUTARADRAGONDARK_ASSET

local function SetHPDmg(inst,target,damage,FutaraDragon)
    if target.components.health and target.components.combat then
        inst:PushEvent("onareaattackother", {target = target})
        target.components.combat:GetAttacked(inst, damage, nil)
        if FutaraDragon.death ~= 1 then
            if FutaraDragon.components.mana.currentmana < FutaraDragon.components.mana.maxmana then
                FutaraDragon.components.mana.currentmana = FutaraDragon.components.mana.currentmana+(FutaraDragon.components.mana.maxmana*TUNING.FUTARADRAGON_DARKSIDERDARKFIELDDRAINMP)
                if FutaraDragon.components.mana.currentmana > FutaraDragon.components.mana.maxmana then
                    FutaraDragon.components.mana.currentmana = FutaraDragon.components.mana.maxmana
                end
            end
            if FutaraDragon.components.health.currenthealth < FutaraDragon.components.health.maxhealth then
                FutaraDragon.components.health.currenthealth = FutaraDragon.components.health.currenthealth+(FutaraDragon.components.health.maxhealth*TUNING.FUTARADRAGON_DARKSIDERDARKFIELDDRAINHP)
                if FutaraDragon.components.health.currenthealth > FutaraDragon.components.health.maxhealth then
                    FutaraDragon.components.health.currenthealth = FutaraDragon.components.health.maxhealth
                 end
            end
        end
    end
end

local function CHKUnAtk(inst,target)
    if not target 
       or not target.components.combat
       or not target.entity:IsValid()
       or not target.entity:IsVisible()
       or not target.components.health
       or target == inst
       or target.components.health:IsDead() then
        return false
    else
        return true
    end
end

local function SetDarkArea(inst,range,damage,FutaraDragon)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, range)
    for i,ent in ipairs(ents) do
        if ent ~= GetPlayer() and CHKUnAtk(FutaraDragon,ent) then
            if ent.components.combat and not ent.components.combat:IsAlly(GetPlayer()) and not ent.components.combat:IsAlly(FutaraDragon) then
                SetHPDmg(inst,ent,damage,FutaraDragon)
            end
        end
    end
end

local function ChangePECFX(number)
    inst.PECount = number
end

local function SetParticleFX(inst,LT,VX,VXM,VXL,VY,VYM,VYL,VZ,VZM,VZL,TX,PC,PS,SW,SH,SZ,BM)
    inst.ParticleLT = LT
    inst.ParticleVX = VX
    inst.ParticleVXM = VXM
    inst.ParticleVXL = VXL
    inst.ParticleVY = VY
    inst.ParticleVYM = VYM
    inst.ParticleVYL = VYL
    inst.ParticleVZ = VZ
    inst.ParticleVZM = VZM
    inst.ParticleVZL = VZL
    inst.ParticleEmitter:SetRenderResources(TUNING.FDFNDM.."fx/"..TX..".tex", TUNING.FUTARADRAGON_SHADER[1])
    inst.ParticleEmitter:SetBlendMode(BM)
    inst.ParticleEmitter:SetMaxLifetime(inst.ParticleLT)
    inst.ParticleEmitter:SetColourEnvelope(PC)
    inst.ParticleEmitter:SetScaleEnvelope(PS);
    inst.ParticleEmitter:SetUVFrameSize(SW,SH)
    inst.ParticleSize = CreateSphereEmitter(SZ)
end

local function SetParticleSet(inst,setting,slot)
    local FX = setting[slot]
    SetParticleFX(inst,FX[1],FX[2],FX[3],FX[4],FX[5],FX[6],FX[7],FX[8],FX[9],FX[10],FX[11],FX[12],FX[13],FX[14],FX[15],FX[16],FX[17])
end

local function Update(inst)
    if inst.darklight > 0 then
        inst.Light:SetRadius(inst.darklight)
        inst.darklight = inst.darklight - inst.darklightdown
    else
        inst.Light:SetRadius(0)
    end
    if inst.timer > 0 then
        if inst.hitdelay > 0 then
            inst.hitdelay = inst.hitdelay - 1
        else
            local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
            if FutaraDragon then
                inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_poof")
                SetDarkArea(inst,4,TUNING.FUTARADRAGON_DARKSIDERDARKFIELDDAMAGE,FutaraDragon)
                inst.PEFXFN(inst.PEFX)
                inst.darklight = 5
                inst.hitdelay = inst.hitdelaydef
            end
        end
        inst.timer = inst.timer - 1
    else
        if inst.timerout > 0 then
            inst.timerout = inst.timerout - 1
        else
            inst:Remove()
        end
    end
end

local function StartUpdating(inst)
    if not inst.loop then
        inst.loop = {}
    end
    inst.loop.amount = 0
    inst.loop.period = 0.1
    if not inst.loop.task then
        inst.loop.task = inst:DoPeriodicTask(inst.loop.period, function() Update(inst) end)
    end
end

local function RunPE(inst)
    local TimeSec = TheSim:GetTickTime()

    local PEFX = inst.ParticleEmitter
    inst.PEFX = PEFX

    local PEFXTE = 1

    local PEFXFN = function()
        local VX, VY, VZ = inst.ParticleVX * math.random(inst.ParticleVXM,inst.ParticleVXL), inst.ParticleVY * math.random(inst.ParticleVYM,inst.ParticleVYL) , inst.ParticleVZ * math.random(inst.ParticleVZM,inst.ParticleVZL)
        local lifetime = inst.ParticleLT 
        local PX, PY, PZ
        PX, PY, PZ = inst.ParticleSize()
        PX = PX
        PZ = PZ
        PY = PY + 2.5
        local UVOS = math.random( 0, 0 ) * 0.25
        PEFX:AddParticleUV(
            lifetime,
            PX, PY, PZ,
            VX, VY, VZ,
            UVOS, 0
        )
    end
    inst.PEFXFN = PEFXFN
    
    local PEFXFN = function()
        while PEFXTE > 1 do
            PEFXFN(PEFX)
            PEFXTE = PEFXTE - 1
        end
        local PEFXPS = inst.PECount * TimeSec
        PEFXTE = PEFXTE + PEFXPS
    end
end

local function DarkFieldFn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local emitter = inst.entity:AddParticleEmitter()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    inst.entity:AddParticleEmitter()
    inst.ParticleEmitter:SetMaxNumParticles(10000)
    inst.ParticleEmitter:EnableBloomPass(true)
    inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.timer = TUNING.FUTARADRAGON_DARKSIDERDARKFIELDTIMER
    inst.timerout = 5
    inst.damage = TUNING.FUTARADRAGON_DARKSIDERDARKFIELDDAMAGE
    inst.hitdelay = 0
    inst.hitdelaydef = TUNING.FUTARADRAGON_DARKSIDERDARKFIELDHITDELAY
    inst.darklight = 0
    inst.darklightdown = 1
    return inst
end

local function DarkField()
    local inst = DarkFieldFn()
    inst.Transform:SetScale(0.1, 0.1, 0.1)
    inst.Light:SetIntensity(0.85)
    inst.Light:SetColour(255/255,0/255,0/255)
    inst.Light:SetFalloff(0.5)
    inst.Light:SetRadius(2)
    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLUSINGFX,7)
    RunPE(inst)
    StartUpdating(inst)
    return inst
end

return Prefab("common/inventory/futaradragondarkfield", DarkField, assets) 
