
local assets = TUNING.FUTARADRAGONG_ASSET

local FONTS = {
    { filename = TUNING.FUTARADRAGON_FONT, alias = DIALOGFONT },
}

AddFontAssets( assets, FONTS )

local SPAWN_DIST = 5

local function InitSkillFX()
    if TUNING.FUTARADRAGON_SHADERED == 0 then
        if EnvelopeManager then
            local SDCS,SDCE,SDCD = TUNING.FUTARADRAGON_SHADER_CMAX,1,-1
            for F = SDCS,SDCE,SDCD do
                EnvelopeManager:AddColourEnvelope(TUNING.FUTARADRAGON_SHADER_C[F][1],TUNING.FUTARADRAGON_SHADER_C[F][2])
            end
            local SDSS,SDSE,SDSD = TUNING.FUTARADRAGON_SHADER_SMAX,1,-1
            for D = SDSS,SDSE,SDSD do
                EnvelopeManager:AddVector2Envelope(TUNING.FUTARADRAGON_SHADER_S[D][1],TUNING.FUTARADRAGON_SHADER_S[D][2])
            end
            TUNING.FUTARADRAGON_SHADERED = 1
        end
    end
end

local function ChangeLight(inst,update)
    inst.Light:SetRadius(update)
end

local function GetNormalScale()
    return TUNING.FUTARADRAGON_SUMMONSCALE
end

local function ChangeScale(inst,update)
    inst.Transform:SetScale(update, update, update)
end

local function ChangeManaFX(inst,number)
    inst.skillfxcount = number
end

local function GetTrueDelay(inst)
    return inst.delay <= 0
end

local function GetTrueDelayNotMax(inst)
    return inst.delay ~= TUNING.FUTARADRAGON_DELAY
end

local function ResetDelay(inst)
    inst.delay = TUNING.FUTARADRAGON_DELAY
end

local function UpdateDelay(inst)
    inst.delay = inst.delay - 1
end

local function GetTrueSkillDelay(inst)
    return inst.skilldelay <= 0
end

local function GetTrueSkillDelayNotMax(inst)
    return inst.skilldelay ~= TUNING.FUTARADRAGON_SKILLDELAY
end

local function ResetSkillDelay(inst)
    inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
end

local function UpdateSkillDelay(inst)
    inst.skilldelay = inst.skilldelay - 1
end

local function GetSkillDelay(inst)
    return inst.skilldelay
end

local function GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = SPAWN_DIST
    local offset = FindWalkableOffset(pt, theta, radius, 12, true)
    if offset then
        return pt+offset
    end
end

local function ReWarpFutaraDragon(inst)
    local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
    if FutaraDragon then
        local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
        local spawn_pt = GetSpawnPoint(pt)
        if spawn_pt then
            inst.Physics:Teleport(spawn_pt:Get())
            inst:FacePoint(pt)
        else
        end
    elseif GetPlayer() then
        local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
        local spawn_pt = GetSpawnPoint(pt)
        if spawn_pt then
            inst.Physics:Teleport(spawn_pt:Get())
            inst:FacePoint(pt)
        else
        end
    end
end

local function GetPoint(pt)
    return pt
end

local function SwapPlayer(inst)
    local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
    if FutaraDragon then
        local PYP = Vector3(FutaraDragon.Transform:GetWorldPosition())
        local FDP = Vector3(inst.Transform:GetWorldPosition())
        local PYPP = GetPoint(PYP)
        local FDPP = GetPoint(FDP)
        if PYPP and FDPP then
            FutaraDragon.Physics:Teleport(FDPP:Get())
            inst.Physics:Teleport(PYPP:Get())
        end
    end
end

local function SetParticleFX(inst,LT,VX,VXM,VXL,VY,VYM,VYL,VZ,VZM,VZL,TX,PC,PS,SW,SH,SZ,BM)
    inst.ParticleLT = LT
    inst.ParticleVX = VX
    inst.ParticleVXM = VXM
    inst.ParticleVXL = VXL
    inst.ParticleVY = VY
    inst.ParticleVYM = VYM
    inst.ParticleVYL = VYL
    inst.ParticleVZ = VZ
    inst.ParticleVZM = VZM
    inst.ParticleVZL = VZL
    inst.ParticleEmitter:SetRenderResources(TUNING.FDFNDM.."fx/"..TX..".tex", TUNING.FUTARADRAGON_SHADER[1])
    inst.ParticleEmitter:SetBlendMode(BM)
    inst.ParticleEmitter:SetMaxLifetime(inst.ParticleLT)
    inst.ParticleEmitter:SetColourEnvelope(PC)
    inst.ParticleEmitter:SetScaleEnvelope(PS);
    inst.ParticleEmitter:SetUVFrameSize(SW,SH)
    inst.ParticleSize = CreateSphereEmitter(SZ)
end

local function SetParticleSet(inst,setting,slot)
    local FX = setting[slot]
    SetParticleFX(inst,FX[1],FX[2],FX[3],FX[4],FX[5],FX[6],FX[7],FX[8],FX[9],FX[10],FX[11],FX[12],FX[13],FX[14],FX[15],FX[16],FX[17])
end

local function ReLeader(inst)
    local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
    if FutaraDragon then
        inst.components.follower:SetLeader(FutaraDragon)
    else
        inst.components.follower:SetLeader(GetPlayer())
    end
end

local function ResetAllStatus(inst)
    inst.delay = 0
    inst.skillfx = 0
    inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
    inst.skillsound = 1
    inst.skilltime = 0
    inst.scale = 0.1
    inst.Action = 0
    inst.Transform:SetScale(inst.scale, inst.scale, inst.scale)
    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,1)
    ChangeLight(inst,TUNING.FUTARADRAGON_SUMMONIDLELIGHT)
    ChangeManaFX(inst,0)
    inst.followmin = 1
    inst.followtarget = 2
    inst.followmax = 3
    ReLeader(inst)
    if inst.components.combat.target ~= nil then
        inst.components.combat:SetTarget(nil)
        inst.components.combat.retargettask = nil
        inst.components.combat.target = nil
    end
end

local function AIAutoHelpFriend(inst)
    if inst.components.combat.target == nil then
        local pos = Vector3(inst.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 30)
        for i,ent in ipairs(ents) do
            if not inst.components.combat:IsAlly(ent) then
                if GetPlayer().components.combat.target == ent
                or ent.components.combat.target == GetPlayer()
                or ent.components.combat.target == inst.components.follower.leader 
                or ent.components.combat.target == inst  
                then
                    if ent ~= GetPlayer() and ent ~= inst.components.follower.leader then
                        if ent.components.follower and ent.components.follower.leader ~= inst.components.follower.leader and ent.components.follower.leader ~= GetPlayer and ent.components.follower.leader ~= inst then
                            inst.components.combat:SetTarget(ent)
                            inst.components.combat.target = ent
                            inst.components.combat:ShareTarget(ent, 30,function(dude) return (dude:HasTag("futdg") or dude:HasTag("futdgs") or dude:HasTag("companion")) and not dude.components.health:IsDead() end, 5)
                        elseif ent.components.follower and ent.components.follower.leader == inst.components.follower.leader then
                        
                        else
                            inst.components.combat:SetTarget(ent)
                            inst.components.combat.target = ent
                            inst.components.combat:ShareTarget(ent, 30,function(dude) return (dude:HasTag("futdg") or dude:HasTag("futdgs") or dude:HasTag("companion")) and not dude.components.health:IsDead() end, 5)
                        end
                    end
                end
            end
        end
    else
        if inst.components.combat.target.components.health then
            if inst.components.combat.target.components.combat and inst.components.combat.target.components.health:IsDead() or not inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST) then
                inst.components.combat:SetTarget(nil)
                inst.components.combat.retargettask = nil
                inst.components.combat.target = nil
            elseif inst.components.combat.target.components.combat and (inst.components.combat:IsAlly(inst.components.combat.target) or inst.components.combat.target.components.combat:IsAlly(inst) or inst.components.combat.target.components.combat:IsAlly(inst.components.follower.leader) or inst.components.combat.target == GetPlayer()) then
                inst.components.combat:SetTarget(nil)
                inst.components.combat.retargettask = nil
                inst.components.combat.target = nil
            end
        end
    end
end

local function Update(inst)
    local FutaraDragon = TheSim:FindFirstEntityWithTag("futdg")
    AIAutoHelpFriend(inst)
    if inst.components.health.currenthealth <= 0 and inst.death == 0 then
        inst.Action = -1
        ChangeLight(inst,0.0)
        ChangeManaFX(inst,0)
        inst.sg:GoToState("death")
        TUNING.FUTARADRAGON_SUMMON[inst.TypeForm] = 0
        inst.death = 1
    end
    if inst.components.follower and FutaraDragon and inst.components.follower.leader ~= FutaraDragon then
        ReLeader(inst)
    elseif inst.components.follower and inst.components.follower.leader ~= GetPlayer()  then
        ReLeader(inst)
    end
    if inst.death ~= 1 and inst.components.follower.leader ~= nil and not inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_WARPDIST) then
        ResetAllStatus(inst)
        ReWarpFutaraDragon(inst)
    end
    if inst.Action == 0 then
        if GetTrueSkillDelay(inst) then
            inst.Action = 1
        else
            if inst.skillsound == 1 then
                inst.sg:GoToState("charge")
                inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_raise")
                inst.skillsound = 0
            end
            if inst.skilldelay > TUNING.FUTARADRAGON_SKILLDELAY then
               inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
            end
            ChangeScale(inst,((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))/TUNING.FUTARADRAGON_SKILLDELAY)*GetNormalScale())
            ChangeLight(inst,((TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))/TUNING.FUTARADRAGON_SKILLDELAY)*TUNING.FUTARADRAGON_LIGHT+TUNING.FUTARADRAGON_SUMMONIDLELIGHT)
            ChangeManaFX(inst,(TUNING.FUTARADRAGON_SKILLDELAY-GetSkillDelay(inst))*4)
            UpdateSkillDelay(inst)
        end
        if GetTrueDelayNotMax(inst) then
            ResetDelay(inst)
        end
    elseif inst.Action == 1 then
        if GetTrueDelay(inst) then
  
        else
            if inst.delay > TUNING.FUTARADRAGON_DELAY then
               inst.delay = TUNING.FUTARADRAGON_DELAY
            end
            UpdateDelay(inst)
            ChangeLight(inst,TUNING.FUTARADRAGON_SUMMONIDLELIGHT+(inst.delay/TUNING.FUTARADRAGON_DELAY)*TUNING.FUTARADRAGON_LIGHT)
            ChangeManaFX(inst,(inst.delay)*8)
            inst.light = 0
            if inst.skillsound == 1 then
                inst.sg:GoToState("charge")
                inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_raise")
                inst.skillsound = 0
            end
            if inst.skillfx == 1 then
                inst.skillfx = 0
            end
            if GetTrueDelay(inst) then
                inst.sg:GoToState("idle")
            end
            if GetTrueDelay(inst) then
                ChangeLight(inst,TUNING.FUTARADRAGON_SUMMONIDLELIGHT)
                ChangeManaFX(inst,10)
            end
        end
    end
end

local function StartUpdating(inst)
    if not inst.loop then
        inst.loop = {}
    end
    inst.loop.amount = 0
    inst.loop.period = 0.1
    if not inst.loop.task then
        inst.loop.task = inst:DoPeriodicTask(inst.loop.period, function() Update(inst) end)
    end
end

local function OnNewTarget(inst, data)
    if inst.Action == 1 and GetTrueDelay(inst) then
        return FindEntity(inst, TUNING.FUTARADRAGON_ATK_DIST,
        function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() and inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST) then
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (guy:HasTag("futdg") or guy:HasTag("futdgs") or guy:HasTag("player"))
            end
        end)
    end
end

local function OnAttacked(inst, data)
    if inst.Action == 1 and GetTrueDelay(inst) then
        if data.attacker ~= inst.components.follower.leader and data.attacker ~= GetPlayer()then
            inst.components.combat:SetTarget(data.attacker)
            inst.components.combat:ShareTarget(data.attacker, 30,function(dude)
            return (dude:HasTag("futdg") or dude:HasTag("futdgs") or dude:HasTag("companion")) and not dude.components.health:IsDead()
        end, 5)
        end
    end
end

local function Retarget(inst)
    if inst.Action == 1 and GetTrueDelay(inst) then
        return FindEntity(inst, TUNING.FUTARADRAGON_ATK_DIST,
        function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() and inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST) then
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (guy:HasTag("futdg") or guy:HasTag("futdgs") or guy:HasTag("player") or guy == GetPlayer())
            end
        end)
    end
end

local function KeepTarget(inst, target)
    if inst.Action == 1 and GetTrueDelay(inst) then
        return inst.components.combat:CanTarget(target)
        and (not target.LightWatcher or target.LightWatcher:IsInLight() and inst.components.follower:IsNearLeader(TUNING.FUTARADRAGON_FOLLOWDIST))
        and not (target.sg and target.sg:HasStateTag("transform") or target:HasTag("futdg") or target:HasTag("futdgs") or target:HasTag("player") or target == GetPlayer())
    end
end

local function ShouldWakeUp(inst)
    return false
end

local function ShouldSleep(inst)
    return false
end

local function OnWingDown(inst)
    --inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/flap") --More Sound when it more than one. And it is the light not have sound
end

local function create_futaradragonguardian()

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    local player = GetPlayer()
    local emitter = inst.entity:AddParticleEmitter()
    
    inst.entity:AddLabel()

    inst:AddTag("companion")
    inst:AddTag("character")
    inst:AddTag("scarytoprey")
    inst:AddTag("futdgs")
    inst:AddTag("notraptrigger")
    inst:AddTag("noauradamage")
    inst:AddTag("flying")
    inst:AddTag("ghost")

    inst.entity:AddTransform()

    InitSkillFX()

    inst.death = 0
    inst.delay = 0
    inst.skillfx = 0
    inst.skillfxcount = 0
    inst.skilldelay = TUNING.FUTARADRAGON_SKILLDELAY
    inst.skillsound = 1
    inst.skilltime = 0
    inst.skilllight = 0
    inst.scale = 0.1
    inst.loop = nil
    inst.followmin = TUNING.FUTARADRAGON_SUMMONFOLLOWMIN
    inst.followtarget = TUNING.FUTARADRAGON_SUMMONFOLLOWTARGET
    inst.followmax = TUNING.FUTARADRAGON_SUMMONFOLLOWMAX
    inst.Action = 0
    inst.usedmana = 0

    inst.Transform:SetScale(inst.scale, inst.scale, inst.scale)

    inst.entity:AddParticleEmitter()
    SetParticleSet(inst,TUNING.FUTARADRAGON_SKILLDEF,1)
    inst.ParticleEmitter:SetMaxNumParticles(1000)
    inst.ParticleEmitter:EnableBloomPass(true)

    --local minimap = inst.entity:AddMiniMapEntity()
    --minimap:SetIcon( "batcave.png" )

    inst.entity:AddAnimState()
    inst.AnimState:SetBank("bat")
    inst.AnimState:SetBuild("futaradgg")
    anim:SetBloomEffectHandle(TUNING.FUTARADRAGON_SHADER[2])

    inst.entity:AddSoundEmitter()

    inst.entity:AddDynamicShadow()
    --local shadow = inst.entity:AddDynamicShadow() --No Shadow
    --shadow:SetSize( 1.5, 0.75 )

    MakeGhostPhysics(inst, 10, .25)
    
    RemovePhysicsColliders(inst)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    --inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)

    inst.Transform:SetFourFaced()

    inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetIntensity(0.85)
    inst.Light:SetColour(255/255,255/255,255/255)
    inst.Light:SetFalloff(0.5)
    inst.Light:SetRadius(0)
    
    inst.persists = false

    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "bat_body"
    inst.components.combat:SetDefaultDamage(TUNING.FUTARADRAGON_SUMMONATK)
    inst.components.combat:SetAttackPeriod(TUNING.FUTARADRAGON_SUMMONATKPERIOD)
    inst.components.combat:SetRange(TUNING.FUTARADRAGON_ATK_RANGE)
    inst.components.combat:SetRetargetFunction(TUNING.FUTARADRAGON_ATK_RETARGET, Retarget)
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetTarget(nil)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.FUTARADRAGON_SUMMONHPMAX)
    inst.components.health:StartRegen(TUNING.FUTARADRAGON_HPRE, TUNING.FUTARADRAGON_HPPI)

    inst:AddComponent("inspectable")

    inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier(1)
    inst.components.locomotor:SetTriggersCreep(false)
    inst.components.locomotor.pathcaps = { ignorecreep = true }
    inst.components.locomotor.walkspeed = TUNING.FUTARADRAGON_WALK
    inst.components.locomotor.runspeed = TUNING.FUTARADRAGON_RUN

    inst:SetStateGraph("SGfutaradragonguardian")

    inst:AddComponent("lootdropper")

    inst:AddComponent("follower")

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    inst:ListenForEvent("attacked", OnAttacked)

    inst:AddComponent("knownlocations")

    MakeMediumBurnableCharacter(inst, "bat_body")
    MakeMediumFreezableCharacter(inst, "bat_body")

    inst:ListenForEvent("wingdown", OnWingDown)

    inst:AddComponent("teamattacker")
    inst.components.teamattacker.team_type = "futdgs"

    local brain = require "brains/futaradragonsgbrain"
    inst:SetBrain(brain)

    return inst
end

local function create_futaradragonguardianother(inst)

    local TimeSec = TheSim:GetTickTime()

    local PEFX = inst.ParticleEmitter

    local PEFXTE = 1

    local PEFXFN = function()
        local VX, VY, VZ = inst.ParticleVX * math.random(inst.ParticleVXM,inst.ParticleVXL), inst.ParticleVY * math.random(inst.ParticleVYM,inst.ParticleVYL) , inst.ParticleVZ * math.random(inst.ParticleVZM,inst.ParticleVZL)
        local lifetime = inst.ParticleLT 
        local PX, PY, PZ
        PX, PY, PZ = inst.ParticleSize()
        PX = PX
        PZ = PZ
        PY = PY + 2
        local UVOS = math.random( 0, 0 ) * 0.25
        PEFX:AddParticleUV(
            lifetime,
            PX, PY, PZ,
            VX, VY, VZ,
            UVOS, 0
        )
    end
    
    local PEFXFN = function()
        while PEFXTE > 1 do
            PEFXFN(PEFX)
            PEFXTE = PEFXTE - 1
        end
        local PEFXPS = inst.skillfxcount * TimeSec
        PEFXTE = PEFXTE + PEFXPS
    end

    EmitterManager:AddEmitter( inst, nil, PEFXFN)

    return inst
end

local function create_futaradragonguardiantype1()
    local inst = create_futaradragonguardian()
    inst:AddTag(TUNING.FUTARADRAGON_SUMMONID[1])
    TUNING.FUTARADRAGON_SUMMON[1] = 1
    inst.TypeForm = 1
    inst = create_futaradragonguardianother(inst)
    StartUpdating(inst)
    return inst
end

local function create_futaradragonguardiantype2()
    local inst = create_futaradragonguardian()
    inst:AddTag(TUNING.FUTARADRAGON_SUMMONID[2])
    TUNING.FUTARADRAGON_SUMMON[2] = 1
    inst.TypeForm = 2
    inst = create_futaradragonguardianother(inst)
    StartUpdating(inst)
    return inst
end

local function create_futaradragonguardiantype3()
    local inst = create_futaradragonguardian()
    inst:AddTag(TUNING.FUTARADRAGON_SUMMONID[3])
    TUNING.FUTARADRAGON_SUMMON[3] = 1
    inst.TypeForm = 3
    inst = create_futaradragonguardianother(inst)
    StartUpdating(inst)
    return inst
end

local function create_futaradragonguardiantype4()
    local inst = create_futaradragonguardian()
    inst:AddTag(TUNING.FUTARADRAGON_SUMMONID[4])
    TUNING.FUTARADRAGON_SUMMON[4] = 1
    inst.TypeForm = 4
    inst = create_futaradragonguardianother(inst)
    StartUpdating(inst)
    return inst
end

return Prefab( "common/objects/futaradragonsg1", create_futaradragonguardiantype1, assets),
Prefab( "common/objects/futaradragonsg2", create_futaradragonguardiantype2, assets),
Prefab( "common/objects/futaradragonsg3", create_futaradragonguardiantype3, assets),
Prefab( "common/objects/futaradragonsg4", create_futaradragonguardiantype4, assets)
