require("stategraphs/commonstates")

local actionhandlers =
{
    ActionHandler(ACTIONS.GOHOME, "action"),
    ActionHandler(ACTIONS.EAT, "eat_loop"),
    ActionHandler(ACTIONS.PICKUP, "eat_enter")
}

local events=
{
    CommonHandlers.OnLocomote(false, true),
    CommonHandlers.OnFreeze(),
    CommonHandlers.OnAttack(),
    CommonHandlers.OnAttacked(),
    CommonHandlers.OnDeath(),
    CommonHandlers.OnSleep(),
}

local states =
{
    State{
        
        name = "idle",
        tags = {"idle", "canrotate"},
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            if playanim then
                inst.AnimState:PlayAnimation(playanim)
                inst.AnimState:PushAnimation("fly_loop", true)
            else
                inst.AnimState:PlayAnimation("fly_loop", true)
            end
        end,
        
        timeline = 
        {
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        name = "idlespell",
        tags = {"busy"},
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            if playanim then
                inst.AnimState:PlayAnimation(playanim)
                inst.AnimState:PushAnimation("fly_loop", true)
            else
                inst.AnimState:PlayAnimation("fly_loop", true)
            end
        end,
        
        timeline = 
        {
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        
        name = "action",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("fly_loop", true)
            inst:PerformBufferedAction()
        end,
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    }, 

    State{
        name = "attacktype",
        tags = {"attack", "busy"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("atk")
        end,

        timeline = 
        {
                TimeEvent(2* FRAMES, function(inst) 
                    if inst.darksidermode == 1 then
                        inst.components.combat:DoAttack() 
                    end
                end),
                TimeEvent(8* FRAMES, function(inst) 
                    PlayCreatureSound(inst, "attack")
                    if inst.darksidermode == 1 then 
                        inst.components.combat:DoAttack()
                    end 
                end),
                TimeEvent(11*FRAMES, function(inst)
                    if inst.longrangeaction == 1 then
                        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
                    end 
                    inst.components.combat:DoAttack()
                    inst:PushEvent("wingdown")
                end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        name = "attacktypejump",
        tags = {"attack", "canrotate", "busy", "jumping"},
        
        onenter = function(inst)
            inst.components.locomotor:Stop()
            inst.components.locomotor:EnableGroundSpeedMultiplier(false)
            inst.SoundEmitter:PlaySound("dontstarve/common/rebirth_amulet_poof")
            inst.components.combat:StartAttack()
            inst.AnimState:PlayAnimation("fly_loop")
            inst.sg.statemem.target = inst.components.combat.target
        end,

        onexit = function(inst)
            inst.components.locomotor:Stop()
            inst.components.locomotor:EnableGroundSpeedMultiplier(true)
        end,
        
        timeline =
        {
            TimeEvent(0*FRAMES, function(inst) 
                inst.Physics:SetMotorVelOverride(30,0,0)
            end),
            TimeEvent(5*FRAMES, function(inst) 
                inst.components.combat:DoAttack(inst.sg.statemem.target)
                inst:PushEvent("wingdown")
            end),
            TimeEvent(7*FRAMES, function(inst) 
                inst.Physics:SetMotorVelOverride(20,0,0)
                inst:PushEvent("wingdown")
            end),
            TimeEvent(14*FRAMES, function(inst) 
                inst.Physics:SetMotorVelOverride(15,0,0)
                inst.components.combat:DoAttack(inst.sg.statemem.target)
                inst:PushEvent("wingdown")
            end),
            TimeEvent(17*FRAMES, function(inst) 
                inst.Physics:SetMotorVelOverride(5,0,0)
                inst:PushEvent("wingdown")
            end),
            TimeEvent(20*FRAMES, function(inst) 
                inst.Physics:ClearMotorVelOverride()
                inst.components.locomotor:Stop()
            end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        name = "taunt",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("atk")
        end,

        timeline = 
        {
            TimeEvent(1*FRAMES, function(inst) end ),
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            TimeEvent(18*FRAMES, function(inst) inst:PushEvent("wingdown") PlayCreatureSound(inst, "taunt") end ),
            TimeEvent(28*FRAMES, function(inst) inst:PushEvent("wingdown") end ),
            TimeEvent(43*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        name = "charge",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("taunt")
        end,

        timeline = 
        {
            TimeEvent(1*FRAMES, function(inst) end ),
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            TimeEvent(18*FRAMES, function(inst) inst:PushEvent("wingdown") PlayCreatureSound(inst, "taunt") end ),
            TimeEvent(28*FRAMES, function(inst) inst:PushEvent("wingdown") end ),
            TimeEvent(43*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("charge") end),
        },
    },

    State{
        name = "magicspell",
        tags = {"busy"},

        onenter = function(inst, playanim)
            inst.Physics:Stop()
            if playanim then
                inst.AnimState:PlayAnimation(playanim)
                inst.AnimState:PushAnimation("fly_loop", true)
            else
                inst.AnimState:PlayAnimation("fly_loop", true)
            end
        end,

        timeline = 
        {
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("magicspell") end),
        },
    },

    State{
        name = "eat_enter",
        tags = {"busy"},

        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("eat", false)
        end,

        onexit = function(inst)

        end,

        timeline = 
        {
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            TimeEvent(9*FRAMES, function(inst) inst:PerformBufferedAction()
            inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/bite") end ), --take food
            TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },

        events = 
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end)
        },
    },

    State{
        name = "eat_loop",
        tags = {"busy"},

        onenter = function(inst)
            inst.AnimState:PlayAnimation("eat_loop", true)
            inst.sg:SetTimeout(1+math.random()*2)
        end,

        ontimeout= function(inst)
            inst.lastmeal = GetTime()
            inst:PerformBufferedAction()
            inst.sg:GoToState("idle")
        end,

        timeline = 
        {
            TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/chew")  end ),
            TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/chew")  end ),
        },
    },
}

local walkanims = 
{
    startwalk = "fly_loop",
    walk = "fly_loop",
    stopwalk = "fly_loop",
}

CommonStates.AddWalkStates(states,
{
    starttimeline =
    {
        TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
    },

    walktimeline = 
    {
        TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
    },

    endtimeline =
    {
        TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
    },

}, walkanims, true)


CommonStates.AddSleepStates(states,
{
    starttimeline = 
    {
        TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),       
    },

    sleeptimeline = 
    {
        TimeEvent(23*FRAMES, function(inst) PlayCreatureSound(inst, "sleep") end),
    },

    endtimeline =
    {
        TimeEvent(13*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
    },
})

CommonStates.AddCombatStates(states,
{
    attacktimeline = 
    {
            TimeEvent(1* FRAMES, function(inst)
                if inst.darksidermode == 1 and inst.darksiderrush == 1 and inst.components.combat.target ~= nil then
                    if inst.components.mana.currentmana < inst.components.mana.maxmana then
                        inst.components.mana.currentmana = inst.components.mana.currentmana+(inst.components.mana.maxmana*TUNING.FUTARADRAGON_DARKSIDERDRAINMP)
                        if inst.components.mana.currentmana > inst.components.mana.maxmana then
                            inst.components.mana.currentmana = inst.components.mana.maxmana
                        end
                    end
                    if inst.components.health.currenthealth < inst.components.health.maxhealth then
                        inst.components.health.currenthealth = inst.components.health.currenthealth+(inst.components.health.maxhealth*TUNING.FUTARADRAGON_DARKSIDERDRAINHP)
                        if inst.components.health.currenthealth > inst.components.health.maxhealth then
                            inst.components.health.currenthealth = inst.components.health.maxhealth
                        end
                    end
                    inst.darksiderrush = 0
                    inst.darksiderrushdelay = TUNING.FUTARADRAGON_DARKSIDERRUSHDELAY
                    inst.sg:GoToState("attacktypejump")
                else
                    if inst.darksidermode == 1 then
                        if inst.components.mana.currentmana < inst.components.mana.maxmana then
                            inst.components.mana.currentmana = inst.components.mana.currentmana+(inst.components.mana.maxmana*TUNING.FUTARADRAGON_DARKSIDERDRAINMP)
                            if inst.components.mana.currentmana > inst.components.mana.maxmana then
                                inst.components.mana.currentmana = inst.components.mana.maxmana
                            end
                        end
                        if inst.components.health.currenthealth < inst.components.health.maxhealth then
                            inst.components.health.currenthealth = inst.components.health.currenthealth+(inst.components.health.maxhealth*TUNING.FUTARADRAGON_DARKSIDERDRAINHP)
                            if inst.components.health.currenthealth > inst.components.health.maxhealth then
                                inst.components.health.currenthealth = inst.components.health.maxhealth
                            end
                        end
                    end
                    inst.sg:GoToState("attacktype")
                end
            end),
    },

    hittimeline =
    {
            TimeEvent(1*FRAMES, function(inst) 
                if inst.darksidermode == 1 then 
                    if inst.darksiderdarkfielddelay <= 0 then
                        inst.darksiderdarkfield = 1
                    end
                    inst.sg:GoToState("attacktypejump")
                else
                    PlayCreatureSound(inst, "hurt")
                end 
            end),
            TimeEvent(7*FRAMES, function(inst) 
                inst:PushEvent("wingdown") 
            end),
    },

    deathtimeline =
    {
        TimeEvent(1*FRAMES, function(inst)  
        PlayCreatureSound(inst, "death")
        end),
        TimeEvent(4*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
    },
})

CommonStates.AddFrozenStates(states)


return StateGraph("futaradragon", states, events, "idle", actionhandlers)