Assets = {
		Asset("ANIM", "anim/signinventoryimages1.zip"),
		Asset("ANIM", "anim/signinventoryimages2.zip"),
		Asset("ANIM", "anim/signinventoryimages3.zip"),
		Asset("ANIM", "anim/signinventoryimages4.zip"),
		Asset("ANIM", "anim/signinventoryimages5.zip"),
		Asset("ANIM", "anim/signinventoryimages6.zip"),
		Asset("ANIM", "anim/signinventoryimages7.zip"),
		Asset("IMAGE", "images/inventoryimages/minisign_item.tex"),
		Asset("ATLAS", "images/inventoryimages/minisign_item.xml"),
		Asset("IMAGE", "images/inventoryimages/minisign_drawn.tex"),
		Asset("ATLAS", "images/inventoryimages/minisign_drawn.xml"),	
	
		Asset("IMAGE", "images/inventoryimages/minisign.tex"),
		Asset("ATLAS", "images/inventoryimages/minisign.xml"),	
		
		Asset("IMAGE", "images/inventoryimages/featherpencil.tex"),
		Asset("ATLAS", "images/inventoryimages/featherpencil.xml"),			

}
PrefabFiles = {
			'minisignown',
			'featherpencil',
}

local LAN = GetModConfigData("LANGUAGE")

local require = GLOBAL.require
local ST = GLOBAL.STRINGS

if LAN then  
ST.DRAW = "描绘"
ST.ACTIONS.DRAWITEM="描绘 {item}"
ST.CHARACTERS.GENERIC.ACTIONFAIL.DRAW={NOIMAGE = "有东西做参考最好了",
										TOHARD = '这个物品太难画了',
										}

ST.NAMES.FEATHERPENCIL = "羽毛笔"
ST.RECIPE_DESC.FEATHERPENCIL = "画画羽毛笔是必须的."
ST.CHARACTERS.GENERIC.DESCRIBE.FEATHERPENCIL="羽毛笔增加了写作的科学性."

ST.NAMES.MINISIGN = "小木牌"
ST.NAMES.MINISIGN_DRAWN = "{item} 小木牌"
ST.NAMES.MINISIGN_ITEM = "小木牌"
ST.RECIPE_DESC.MINISIGN_ITEM = "用羽毛笔在上面画画"
ST.CHARACTERS.GENERIC.DESCRIBE.MINISIGN_ITEM = '安置后才能发挥作用'
ST.CHARACTERS.GENERIC.DESCRIBE.MINISIGN = {	UNDRAWN = "画幅画吧",
											GENERIC = "挺好看的",
											}
else  
ST.DRAW = "Draw"
ST.ACTIONS.DRAWITEM="Draw {item}"
ST.CHARACTERS.GENERIC.ACTIONFAIL.DRAW={NOIMAGE = "This'd be easier if I had the item in front of it.",
										TOHARD = "It's too difficult to draw",
										}

ST.NAMES.FEATHERPENCIL = "Feather Pencil"
ST.RECIPE_DESC.FEATHERPENCIL = "Yes, the feather IS necessary."
ST.CHARACTERS.GENERIC.DESCRIBE.FEATHERPENCIL="The feather increases the scientific properties of the writing."

ST.NAMES.MINISIGN = "Mini Sign"
ST.NAMES.MINISIGN_DRAWN = "{item} Sign"
ST.NAMES.MINISIGN_ITEM = "Mini Sign"
ST.RECIPE_DESC.MINISIGN_ITEM = "Draw on these with a Feather Pencil."
ST.CHARACTERS.GENERIC.DESCRIBE.MINISIGN_ITEM = "It's not much use like this. We should place it."
ST.CHARACTERS.GENERIC.DESCRIBE.MINISIGN = {	UNDRAWN = "We should draw something on there.",
											GENERIC = "I could draw better than that!",
											}
end

local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler
local ACTIONS = GLOBAL.ACTIONS

local featherpencil = Recipe("featherpencil",{Ingredient("twigs", 1), Ingredient("charcoal", 1), Ingredient("feather_crow", 1)}, RECIPETABS.SCIENCE,TECH.SCIENCE_ONE,nil,nil,nil,not GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) and 3 or nil,GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) and 3 or nil)
featherpencil.sortkey = 1
featherpencil.atlas = "images/inventoryimages/featherpencil.xml"

local minisign_item = Recipe("minisign_item",{Ingredient("boards",1)}, RECIPETABS.SCIENCE,TECH.SCIENCE_ONE,nil,nil,nil,not GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) and 6 or nil,GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) and 6 or nil)
minisign_item.sortkey = 2
minisign_item.atlas = "images/inventoryimages/minisign_item.xml"

GLOBAL.TUNING.MINISIGNMODINFO={
	---1
	boards={animnum=1},  
	rocks={animnum=1},   
	cutgrass={animnum=1}, 
	flint={animnum=1},    
	green_cap={animnum=1},  
	blue_cap={animnum=1},
	red_cap={animnum=1},
	log={animnum=1},        
	silk={animnum=1},       
	twigs={animnum=1},      
	livinglog={animnum=1}, 
	petals={animnum=1}, 
	poop={animnum=1},  
	rope={animnum=1},  
	cutstone={animnum=1}, 
	goldnugget={animnum=1},
	ash={animnum=1},
	cutreeds={animnum=1},
	stinger={animnum=1},
	lightbulb={animnum=1},
	bluegem={animnum=1},
	redgem={animnum=1},  
	purplegem={animnum=1},
	gears={animnum=1}, 
	bamboo={animnum=1},
	sand={animnum=1}, 
	coral={animnum=1}, 
	limestone={animnum=1}, 
	vine={animnum=1},
	palmleaf={animnum=1}, 
	snakeskin={animnum=1}, 
	obsidian={animnum=1}, 
	seashell={animnum=1}, 
	dubloon={animnum=1}, 
	fabric={animnum=1}, 
	doydoyfeather={animnum=1},
	hail_ice={animnum=1}, 
	messagebottleempty={animnum=1}, 
	--signinventoryimages anim
	houndstooth={animnum=1},
	nitre={animnum=1},
	nightmarefuel={animnum=1},
	spoiled_food={animnum=1},
	pigskin={animnum=1},
	charcoal={animnum=1},
	beefalowool={animnum=1},

	---2
	sewing_kit={animnum=2}, 
	umbrella={animnum=2},
	axe={animnum=2}, 
	hammer={animnum=2}, 
	goldenaxe={animnum=2}, 
	trap={animnum=2}, 
	hambat={animnum=2},
	torch={animnum=2}, 
	trap_teeth={animnum=2}, 
	birdtrap={animnum=2}, 
	amulet ={animnum=2},  
	blueamulet={animnum=2},
	purpleamulet={animnum=2},
	yellowamulet={animnum=2},
	--orangeamulet  
	--greenamulet 
	pickaxe={animnum=2}, 
	goldenpickaxe={animnum=2},
	shovel={animnum=2},
	goldenshovel={animnum=2},
	pitchfork={animnum=2},
	--goldenpitchfork --
	heatrock={animnum=2}, 
	spear={animnum=2}, 
	razor={animnum=2},
	panflute={animnum=2}, 
	bugnet={animnum=2}, 
	fishingrod={animnum=2},
	boomerang={animnum=2}, 
	nightsword={animnum=2},
	icestaff={animnum=2},
	firestaff ={animnum=2},
	greenstaff ={animnum=2},
	yellowstaff ={animnum=2},
	cane={animnum=2},
	lantern={animnum=2},
	multitool_axe_pickaxe={animnum=2},
	ruins_bat={animnum=2},
	needlespear={animnum=2}, 
	peg_leg={animnum=2},
	machete={animnum=2},
	goldenmachete ={animnum=2},
	chiminea={animnum=2},
	bottlelantern={animnum=2},
	telescope={animnum=2},
	antivenom={animnum=2},
	brainjellyhat={animnum=2},
	volcanostaff={animnum=2},
	sail_stick={animnum=2},
	venomgland={animnum=2},
	spoiled_fish={animnum=2},
	cutlass={animnum=2},

	--3
	dug_grass={animnum=3},
	dug_sapling={animnum=3},
	dug_berrybush={animnum=3},
	dug_berrybush2={animnum=3},
	dug_marsh_bush={animnum=3},
	petals_evil={animnum=3},
	dug_bambootree={animnum=3},
	dug_coffeebush={animnum=3},
	coconut={animnum=3},
	backpack={animnum=3},
	piratepack ={animnum=3}, --beibao
	supertelescope={animnum=3},
	spidereggsack={animnum=3},
	spidergland={animnum=3},
	sandbagsmall_item={animnum=3},
	parrot={animnum=3},
	parrot_pirate={animnum=3}, --haidao
	jungletreeseed={animnum=3},
	fireflies={animnum=3},
	bioluminescence={animnum=3},
	doydoybaby={animnum=3},
	doydoy={animnum=3},
	fertilizer={animnum=3},
	pinecone={animnum=3},
	--venus={animnum=3},
	--venus_flowerglass={animnum=3},
	
	--4
	turf_woodfloor={animnum=4},
	turf_road={animnum=4},
	turf_checkerfloor={animnum=4},
	turf_carpetfloor={animnum=4},
	turf_snakeskinfloor={animnum=4},
	turf_volcano={animnum=4},
	turf_ash={animnum=4},
	turf_underrock={animnum=4},
	turf_fungus={animnum=4},
	turf_fungus_red={animnum=4},
	turf_fungus_green={animnum=4},
	turf_sinkhole={animnum=4},
	turf_cave={animnum=4},
	turf_mud={animnum=4},
	turf_meadow={animnum=4},
	turf_tidalmarsh={animnum=4},
	turf_magmafield={animnum=4},
	turf_jungle={animnum=4},
	turf_desertdirt={animnum=4},
	turf_deciduous={animnum=4},
	turf_savanna={animnum=4},
	turf_rocky={animnum=4},
	turf_marsh={animnum=4},
	turf_grass={animnum=4},
	turf_forest={animnum=4},

	--5
	armor_sanity={animnum=5},
	armorcactus={animnum=5},
	armordragonfly={animnum=5},
	armorgrass={animnum=5},
	armorlimestone={animnum=5},
	armormarble={animnum=5},
	armorobsidian={animnum=5},
	armorruins={animnum=5},
	armorseashell={animnum=5},
	armorsnurtleshell={animnum=5},
	armorwood={animnum=5},
	beehat={animnum=5},
	footballhat={animnum=5},
	oxhat={animnum=5},
	ruinshat={animnum=5},
	slurtlehat={animnum=5},
	slurtlehat={animnum=5},
	wathgrithrhat={animnum=5},
	--6
	book_birds={animnum=6},
	book_brimstone={animnum=6},
	book_gardening={animnum=6},
	book_meteor={animnum=6},
	book_sleep={animnum=6},
	book_tentacles={animnum=6},
	waxwelljournal={animnum=6},
	
	--7
	strawhat={animnum=7},
	flowerhat={animnum=7},
	earmuffshat={animnum=7},
	beefalohat={animnum=7},
	featherhat={animnum=7},
	bushhat={animnum=7},
	winterhat={animnum=7},
	tophat={animnum=7},
	sweatervest={animnum=7},
	trunkvest_summer={animnum=7},
	trunkvest_winter={animnum=7},
	catcoonhat={animnum=7},
	rainhat={animnum=7},
	raincoat={animnum=7},
	sewing_kit={animnum=7},
	watermelonhat={animnum=7},
	icehat={animnum=7},
	reflectivevest={animnum=7},
	hawaiianshirt={animnum=7},
	eyebrellahat={animnum=7},
	snakeskinhat={animnum=7},
	armor_snakeskin={animnum=7},
	armor_windbreaker={animnum=7},
	shark_teethhat={animnum=7},
	double_umbrellahat={animnum=7},
	armor_lifejacket={animnum=7},
	captainhat={animnum=7},
	piratehat={animnum=7},
	woodlegshat={animnum=7},
	gashat={animnum=7},
	minerhat={animnum=7},
	blubbersuit={animnum=7},
	aerodynamichat={animnum=7},
}

GLOBAL.subfmt=function(s, tab)
  return (s:gsub('(%b{})', function(w) return tab[w:sub(2, -2)] or w end))
end
GLOBAL.GetBasicDisplayName=function(self)
    return (self.displaynamefn ~= nil and self:displaynamefn())
        or (self.nameoverride ~= nil and ST.NAMES[string.upper(self.nameoverride)])
		or self.name
end

require("components/drawingtool")
local DRAW = Action(1)
DRAW.str = ST.DRAW
DRAW.stroverridefn = function(act)
    local item = GLOBAL.FindEntityToDraw(act.target, act.invobject)
    return item ~= nil
        and GLOBAL.subfmt(ST.ACTIONS.DRAWITEM, { item = item.drawnameoverride or GLOBAL.GetBasicDisplayName(item) })
        or nil
end
DRAW.id = "DRAW"
DRAW.fn = function(act)
    if act.invobject ~= nil and
        act.target ~= nil and
        act.invobject.components.drawingtool ~= nil and
        act.target.components.drawable ~= nil and
        act.target.components.drawable:CanDraw() then
        local image, src = act.invobject.components.drawingtool:GetImageToDraw(act.target)
        if image == nil or TUNING.MINISIGNMODINFO[image]==nil and act.doer.prefab==image then
		return false, "NOIMAGE"
        elseif TUNING.MINISIGNMODINFO[image]==nil then
		return false, "TOHARD"
        end 		
        act.invobject.components.drawingtool:Draw(act.target, image, src)
        return true
    end
end
AddAction(DRAW)

AddPlayerPostInit(function(inst)
	if inst and inst.sg and inst.sg.sg and inst.sg.sg.actionhandlers then
		inst.sg.sg.actionhandlers[ACTIONS.DRAW] = ActionHandler(ACTIONS.DRAW,"dolongaction")
	end
end)