/*
Navicat MySQL Data Transfer

Source Server         : Local
Source Server Version : 50200
Source Host           : 127.0.0.1:3306
Source Database       : h2012h

Target Server Type    : MYSQL
Target Server Version : 50200
File Encoding         : 65001

Date: 2016-09-10 21:33:17
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `administration_file`
-- ----------------------------
DROP TABLE IF EXISTS `administration_file`;
CREATE TABLE `administration_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `office` varchar(60) DEFAULT NULL,
  `time` timestamp NULL DEFAULT NULL,
  `description` varchar(60) DEFAULT NULL,
  `filetitle` varchar(40) DEFAULT NULL,
  `filenumber` mediumint(4) DEFAULT '0',
  `fileheading` varchar(40) DEFAULT NULL,
  `detail` longtext,
  `user` char(10) DEFAULT NULL,
  `attachment` longblob,
  `ext` varchar(100) DEFAULT NULL,
  `sparefield` char(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of administration_file
-- ----------------------------

-- ----------------------------
-- Table structure for `admission_line`
-- ----------------------------
DROP TABLE IF EXISTS `admission_line`;
CREATE TABLE `admission_line` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grade` int(3) DEFAULT NULL,
  `testname` varchar(60) DEFAULT NULL,
  `myyear` int(5) DEFAULT NULL,
  `pici` varchar(10) DEFAULT NULL,
  `score` decimal(4,1) DEFAULT NULL,
  `classtype` varchar(20) DEFAULT NULL,
  `totalc` varchar(10) DEFAULT NULL,
  `totale` varchar(10) DEFAULT NULL,
  `upper` varchar(50) DEFAULT NULL,
  `subjects` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of admission_line
-- ----------------------------

-- ----------------------------
-- Table structure for `analysisdata`
-- ----------------------------
DROP TABLE IF EXISTS `analysisdata`;
CREATE TABLE `analysisdata` (
  `ID` int(4) NOT NULL AUTO_INCREMENT,
  `GradeID` int(2) DEFAULT NULL,
  `TypeOfClass` varchar(30) DEFAULT NULL,
  `PersonalCode` bigint(10) DEFAULT NULL,
  `Sname` varchar(30) DEFAULT NULL,
  `Class` char(20) DEFAULT NULL,
  `Sex` char(4) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of analysisdata
-- ----------------------------

-- ----------------------------
-- Table structure for `analysislist`
-- ----------------------------
DROP TABLE IF EXISTS `analysislist`;
CREATE TABLE `analysislist` (
  `ID` int(4) NOT NULL AUTO_INCREMENT,
  `Type` varchar(50) DEFAULT NULL,
  `Category` varchar(100) DEFAULT NULL,
  `ItemNo` smallint(3) DEFAULT NULL,
  `ItemType` varchar(50) DEFAULT NULL,
  `TestContent` varchar(120) DEFAULT NULL,
  `AbilityType` varchar(60) DEFAULT NULL,
  `Marks` int(3) DEFAULT NULL,
  `Source` varchar(100) DEFAULT NULL,
  `DegreeOfDifficulty` int(4) DEFAULT NULL,
  `GradeAvg` int(4) DEFAULT NULL,
  `ClassAvg` int(4) DEFAULT NULL,
  `TypeAvg` int(4) DEFAULT NULL,
  `Others` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of analysislist
-- ----------------------------

-- ----------------------------
-- Table structure for `assessment`
-- ----------------------------
DROP TABLE IF EXISTS `assessment`;
CREATE TABLE `assessment` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `sname` varchar(20) DEFAULT NULL,
  `class` varchar(30) DEFAULT NULL,
  `subject` varchar(60) DEFAULT NULL,
  `teacher` varchar(20) DEFAULT NULL,
  `classroom` varchar(40) DEFAULT NULL,
  `classtime` varchar(30) DEFAULT NULL,
  `classtype` varchar(30) DEFAULT NULL,
  `spare` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of assessment
-- ----------------------------

-- ----------------------------
-- Table structure for `ass_item`
-- ----------------------------
DROP TABLE IF EXISTS `ass_item`;
CREATE TABLE `ass_item` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `itemno` tinyint(2) DEFAULT NULL,
  `itemname` varchar(40) DEFAULT NULL,
  `itemdescripton` varchar(200) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `used` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ass_item
-- ----------------------------
INSERT INTO `ass_item` VALUES ('1', '1', '教学态度', '指教师上课是否有迟到、早退情况、上课备课情况、课堂认真态度等', '选修课', '0');
INSERT INTO `ass_item` VALUES ('2', '2', '课程内容', '指教师选材是否符合实际？是否有自主创新内容等，教材是否对本校学生认知水平有促进作用。', '选修课', '0');
INSERT INTO `ass_item` VALUES ('3', '3', '课堂管理', '指上课学生出勤记录管理、上课对学生的纪律管理等。', '选修课', '0');
INSERT INTO `ass_item` VALUES ('4', '4', '学习成效', '指学生在课堂上收获如何？课后在认知过程中成效如何？', '选修课', '0');
INSERT INTO `ass_item` VALUES ('5', '1', '课堂教学态度', '师德修养：老师的课堂教学态度', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('6', '2', '思想行规教育', '师德修养：老师在课堂进行学生思想和行规教育的情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('7', '3', '师生关系情况', '师德修养：老师与学生的关系情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('8', '4', '学科专业知识', '专业知识：老师的学科专业知识水平', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('9', '5', '处理问题能力', '专业知识：老师的分析、解决问题的能力和方法', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('10', '6', '备课认真程度', '课堂教学：老师的备课认真程度', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('11', '7', '课堂思路清晰', '课堂教学：老师的上课重点突出及调理清晰程度', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('12', '8', '调动积极性', '课堂教学：老师授课时启发学生思考和调动学习兴趣情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('13', '9', '课堂语言板书', '课堂教学：老师的课堂教学语言和板书情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('14', '10', '现代化教学', '课堂教学：老师恰当使用现代化教学手段情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('15', '11', '内容听懂程度', '课堂教学：老师讲课内容听懂的程度', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('16', '12', '关心学习困难', '课堂教学：老师对学习困难学生的关心程度', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('17', '13', '迟到学生管理', '课堂纪律：课堂、晚自习对迟到学生的管理', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('18', '14', '睡觉学生管理', '课堂纪律：课堂、晚自习对睡觉学生的管理', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('19', '15', '开小差管理', '课堂纪律：课堂、晚自修对开小差学生的管理', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('20', '16', '课堂组织管理', '学业管理：老师的课堂组织管理能力情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('21', '17', '习惯方法指导', '学业管理：老师对学习习惯的培养和学习方法的指导情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('22', '18', '布置作业质量', '学业管理：老师布置作业质和量的情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('23', '19', '作业批改反馈', '学业管理：老师对同学的作业的批改和反馈的认真程度', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('24', '20', '辅导答疑情况', '学业管理：老师对班级同学辅导答疑的情况', '期末考评', '1');
INSERT INTO `ass_item` VALUES ('25', '21', '总体评价', '你对该老师的总体评价如何？', '选修课', '0');

-- ----------------------------
-- Table structure for `ass_questions`
-- ----------------------------
DROP TABLE IF EXISTS `ass_questions`;
CREATE TABLE `ass_questions` (
  `id` smallint(3) NOT NULL AUTO_INCREMENT,
  `questions` varchar(200) DEFAULT NULL,
  `answers` varchar(200) DEFAULT NULL,
  `author` varchar(20) DEFAULT NULL,
  `class` varchar(20) DEFAULT NULL,
  `used` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ass_questions
-- ----------------------------

-- ----------------------------
-- Table structure for `ass_result`
-- ----------------------------
DROP TABLE IF EXISTS `ass_result`;
CREATE TABLE `ass_result` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `teacher` varchar(20) DEFAULT NULL,
  `item` varchar(40) DEFAULT NULL,
  `mark` tinyint(3) DEFAULT '0',
  `sname` varchar(20) DEFAULT NULL,
  `class` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ass_result
-- ----------------------------

-- ----------------------------
-- Table structure for `ass_users`
-- ----------------------------
DROP TABLE IF EXISTS `ass_users`;
CREATE TABLE `ass_users` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `sname` varchar(20) DEFAULT NULL,
  `pw` varchar(20) DEFAULT NULL,
  `class` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ass_users
-- ----------------------------

-- ----------------------------
-- Table structure for `a_s_division`
-- ----------------------------
DROP TABLE IF EXISTS `a_s_division`;
CREATE TABLE `a_s_division` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `personalcode` bigint(10) DEFAULT NULL,
  `class` char(50) DEFAULT NULL,
  `sname` varchar(16) DEFAULT NULL,
  `artorscience` varchar(20) DEFAULT NULL,
  `sex` varchar(4) DEFAULT NULL,
  `address` varchar(80) DEFAULT NULL,
  `art` varchar(10) DEFAULT NULL,
  `pe` varchar(10) DEFAULT NULL,
  `other` varchar(10) DEFAULT NULL,
  `otherinfo` varchar(40) DEFAULT NULL,
  `total` decimal(4,1) DEFAULT NULL,
  `classid` tinyint(3) DEFAULT NULL,
  `gradeid` tinyint(3) DEFAULT NULL,
  `IDcardNo` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of a_s_division
-- ----------------------------

-- ----------------------------
-- Table structure for `a_s_division_record`
-- ----------------------------
DROP TABLE IF EXISTS `a_s_division_record`;
CREATE TABLE `a_s_division_record` (
  `id` smallint(10) NOT NULL AUTO_INCREMENT,
  `tablename` varchar(50) DEFAULT NULL,
  `datevalue` varchar(60) DEFAULT NULL,
  `grade` char(4) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of a_s_division_record
-- ----------------------------

-- ----------------------------
-- Table structure for `backup`
-- ----------------------------
DROP TABLE IF EXISTS `backup`;
CREATE TABLE `backup` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `students` char(40) DEFAULT NULL,
  `teachers` char(40) DEFAULT NULL,
  `managers` char(20) DEFAULT NULL,
  `TestTable` char(60) DEFAULT NULL,
  `wdb` char(60) DEFAULT NULL,
  `time` char(30) DEFAULT NULL,
  `TestEnglishTable` char(60) DEFAULT NULL,
  `OtherTables` char(60) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of backup
-- ----------------------------

-- ----------------------------
-- Table structure for `db_version`
-- ----------------------------
DROP TABLE IF EXISTS `db_version`;
CREATE TABLE `db_version` (
  `db_version` char(70) DEFAULT '0',
  `required` varchar(50) DEFAULT '0',
  `id` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk COMMENT='InnoDB free: 41984 kB';

-- ----------------------------
-- Records of db_version
-- ----------------------------
INSERT INTO `db_version` VALUES ('0.77', '0', '1');
INSERT INTO `db_version` VALUES ('乐清市芙蓉中学', 'a05ecc59-e0e1c1e1-120b83b8-7000b666', '2');

-- ----------------------------
-- Table structure for `file_to_vote`
-- ----------------------------
DROP TABLE IF EXISTS `file_to_vote`;
CREATE TABLE `file_to_vote` (
  `id` smallint(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) DEFAULT NULL,
  `agree` mediumint(8) DEFAULT '0',
  `disagree` mediumint(8) DEFAULT '0',
  `noidea` mediumint(8) DEFAULT '0',
  `end` char(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of file_to_vote
-- ----------------------------

-- ----------------------------
-- Table structure for `file_vote_user`
-- ----------------------------
DROP TABLE IF EXISTS `file_vote_user`;
CREATE TABLE `file_vote_user` (
  `id` mediumint(4) NOT NULL AUTO_INCREMENT,
  `user` varchar(60) DEFAULT NULL,
  `pass` varchar(100) DEFAULT NULL,
  `file_10` char(30) DEFAULT NULL,
  `file_9` char(30) DEFAULT NULL,
  `file_8` char(30) DEFAULT NULL,
  `file_7` char(30) DEFAULT NULL,
  `file_6` char(30) DEFAULT NULL,
  `file_5` char(30) DEFAULT NULL,
  `file_4` char(30) DEFAULT NULL,
  `file_3` char(30) DEFAULT NULL,
  `file_2` char(30) DEFAULT NULL,
  `file_1` char(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of file_vote_user
-- ----------------------------

-- ----------------------------
-- Table structure for `formula`
-- ----------------------------
DROP TABLE IF EXISTS `formula`;
CREATE TABLE `formula` (
  `FormulaName` varchar(200) DEFAULT NULL,
  `FormulaRule` varchar(200) DEFAULT NULL,
  `ForTable` int(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of formula
-- ----------------------------

-- ----------------------------
-- Table structure for `ftp`
-- ----------------------------
DROP TABLE IF EXISTS `ftp`;
CREATE TABLE `ftp` (
  `id` bigint(255) unsigned NOT NULL AUTO_INCREMENT,
  `subject` char(14) DEFAULT NULL,
  `dir` varchar(120) DEFAULT NULL,
  `user` char(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ftp
-- ----------------------------

-- ----------------------------
-- Table structure for `ftpserver`
-- ----------------------------
DROP TABLE IF EXISTS `ftpserver`;
CREATE TABLE `ftpserver` (
  `server` blob,
  `user` blob,
  `password` blob,
  `port` tinyint(3) DEFAULT NULL,
  `passive` char(3) DEFAULT '否',
  `id` smallint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ftpserver
-- ----------------------------

-- ----------------------------
-- Table structure for `ia_record`
-- ----------------------------
DROP TABLE IF EXISTS `ia_record`;
CREATE TABLE `ia_record` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `tablename` varchar(40) DEFAULT NULL,
  `etablename` varchar(100) DEFAULT NULL,
  `datevalue` varchar(20) DEFAULT NULL,
  `grade` varchar(10) DEFAULT NULL,
  `visible` tinyint(1) DEFAULT '0',
  `dfb` varchar(40) DEFAULT NULL,
  `edfb` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ia_record
-- ----------------------------

-- ----------------------------
-- Table structure for `ia_tips_setting`
-- ----------------------------
DROP TABLE IF EXISTS `ia_tips_setting`;
CREATE TABLE `ia_tips_setting` (
  `ID` tinyint(2) NOT NULL AUTO_INCREMENT,
  `GradeID` tinyint(2) NOT NULL DEFAULT '0',
  `message` text,
  `titlefont` char(40) DEFAULT NULL,
  `titlesize` smallint(3) DEFAULT NULL,
  `subtitlefont` char(40) DEFAULT NULL,
  `subtitlesize` smallint(3) DEFAULT NULL,
  `formfont` char(40) DEFAULT NULL,
  `formsize1` smallint(3) DEFAULT NULL,
  `formsize2` smallint(3) DEFAULT NULL,
  `formalign` tinyint(1) DEFAULT NULL,
  `otherfont` char(40) DEFAULT NULL,
  `othersize` smallint(3) DEFAULT NULL,
  `topb` smallint(4) DEFAULT NULL,
  `bottomb` smallint(4) DEFAULT NULL,
  `leftb` smallint(4) DEFAULT NULL,
  `rightb` smallint(4) DEFAULT NULL,
  PRIMARY KEY (`ID`,`GradeID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ia_tips_setting
-- ----------------------------

-- ----------------------------
-- Table structure for `invigilating_arrangement`
-- ----------------------------
DROP TABLE IF EXISTS `invigilating_arrangement`;
CREATE TABLE `invigilating_arrangement` (
  `id` tinyint(3) NOT NULL AUTO_INCREMENT,
  `examno` tinyint(3) DEFAULT NULL,
  `datevalue` date DEFAULT NULL,
  `dayvalue` varchar(10) DEFAULT NULL,
  `dayperiod` varchar(10) DEFAULT NULL,
  `duration` varchar(20) DEFAULT NULL,
  `examroom` varchar(400) DEFAULT '',
  `subject` varchar(20) DEFAULT NULL,
  `teachers` varchar(600) DEFAULT NULL,
  `workers` varchar(200) DEFAULT NULL,
  `editingdate` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of invigilating_arrangement
-- ----------------------------

-- ----------------------------
-- Table structure for `model_config`
-- ----------------------------
DROP TABLE IF EXISTS `model_config`;
CREATE TABLE `model_config` (
  `myname` varchar(40) DEFAULT NULL,
  `text_one` varchar(60) DEFAULT NULL,
  `text_two` varchar(60) DEFAULT NULL,
  `text_three` varchar(60) DEFAULT NULL,
  `text_four` varchar(60) DEFAULT NULL,
  `chosen` tinyint(2) DEFAULT '0',
  `useterm` char(4) DEFAULT '真',
  `classcluded` char(4) DEFAULT '假'
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_config
-- ----------------------------
INSERT INTO `model_config` VALUES ('教师证书', '同志：', '       在', '中，荣获', '称号，特发此状，以资鼓励。', '0', '假', '假');
INSERT INTO `model_config` VALUES ('学生证书', '同学：', '     在', '中，荣获', '，特发此证，以资鼓励。', '1', '真', '真');
INSERT INTO `model_config` VALUES ('课题证书', '老师：', '       你指导的研究性课题《', '》在二零一零年全校评比活动中，荣获', '，你被评为优秀指导教师。特发此证，以资鼓励。', '0', '假', '假');
INSERT INTO `model_config` VALUES ('聘书', '老师：', '     经校委会决定', '决定特聘请您到我校作《', '》的专题报告。', '0', '假', '假');
INSERT INTO `model_config` VALUES ('新老结对', '', '         兹聘请           老师担任            老师的指导师，', '聘期        年   月至        年   月。', '此聘。', '0', '真', '假');

-- ----------------------------
-- Table structure for `offices`
-- ----------------------------
DROP TABLE IF EXISTS `offices`;
CREATE TABLE `offices` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` char(30) DEFAULT NULL,
  `hiddenmenu` varchar(200) DEFAULT '',
  `sparefield` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of offices
-- ----------------------------

-- ----------------------------
-- Table structure for `operatinglist`
-- ----------------------------
DROP TABLE IF EXISTS `operatinglist`;
CREATE TABLE `operatinglist` (
  `id` bigint(100) unsigned NOT NULL AUTO_INCREMENT,
  `operating` varchar(80) DEFAULT '',
  `user` char(10) DEFAULT '',
  `time` timestamp NULL DEFAULT NULL,
  `ip` char(18) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of operatinglist
-- ----------------------------

-- ----------------------------
-- Table structure for `paperlist`
-- ----------------------------
DROP TABLE IF EXISTS `paperlist`;
CREATE TABLE `paperlist` (
  `ID` int(4) NOT NULL AUTO_INCREMENT,
  `PaperName` varchar(50) DEFAULT NULL,
  `Author` varchar(10) DEFAULT NULL,
  `Grade` varchar(10) DEFAULT NULL,
  `Subject` varchar(20) DEFAULT NULL,
  `Time` date DEFAULT NULL,
  `PaperNameE` varchar(100) DEFAULT NULL,
  `AnaDate` varchar(30) DEFAULT NULL,
  `Others` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of paperlist
-- ----------------------------

-- ----------------------------
-- Table structure for `print_config`
-- ----------------------------
DROP TABLE IF EXISTS `print_config`;
CREATE TABLE `print_config` (
  `type` char(50) NOT NULL DEFAULT '',
  `height` mediumint(9) DEFAULT NULL,
  `width` mediumint(9) DEFAULT NULL,
  `mainleft` mediumint(9) DEFAULT NULL,
  `maintop` mediumint(9) DEFAULT NULL,
  `mainheight` mediumint(9) DEFAULT NULL,
  `sheight` mediumint(9) DEFAULT NULL,
  `sleft` mediumint(9) DEFAULT NULL,
  `stop` mediumint(9) DEFAULT NULL,
  `mainsize` mediumint(9) DEFAULT NULL,
  `mainchar` varchar(30) DEFAULT NULL,
  `ssize` mediumint(9) DEFAULT NULL,
  `schar` varchar(30) DEFAULT NULL,
  `chosen` varchar(6) DEFAULT '0',
  `mainwidth` mediumint(9) DEFAULT NULL,
  `default` tinyint(1) DEFAULT '0',
  `description` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of print_config
-- ----------------------------

-- ----------------------------
-- Table structure for `record`
-- ----------------------------
DROP TABLE IF EXISTS `record`;
CREATE TABLE `record` (
  `record` char(3) DEFAULT '',
  `id` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of record
-- ----------------------------

-- ----------------------------
-- Table structure for `reward_or_penalty_record`
-- ----------------------------
DROP TABLE IF EXISTS `reward_or_penalty_record`;
CREATE TABLE `reward_or_penalty_record` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) DEFAULT NULL,
  `class` char(20) DEFAULT NULL,
  `classid` smallint(5) DEFAULT '0',
  `gradeid` tinyint(2) DEFAULT '0',
  `name` char(10) DEFAULT NULL,
  `sex` char(4) DEFAULT NULL,
  `myrange` char(20) DEFAULT NULL,
  `event` varchar(100) DEFAULT NULL,
  `point` smallint(4) DEFAULT NULL,
  `classtime` smallint(2) DEFAULT '0',
  `date` date DEFAULT NULL,
  `result` varchar(40) DEFAULT NULL,
  `operator` char(20) DEFAULT NULL,
  `sparefield2` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of reward_or_penalty_record
-- ----------------------------

-- ----------------------------
-- Table structure for `reward_or_penalty_rule`
-- ----------------------------
DROP TABLE IF EXISTS `reward_or_penalty_rule`;
CREATE TABLE `reward_or_penalty_rule` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `myrange` char(20) DEFAULT NULL,
  `event` varchar(100) DEFAULT NULL,
  `point` int(3) DEFAULT '0',
  `sparefield` char(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of reward_or_penalty_rule
-- ----------------------------

-- ----------------------------
-- Table structure for `sequence`
-- ----------------------------
DROP TABLE IF EXISTS `sequence`;
CREATE TABLE `sequence` (
  `id` bigint(40) NOT NULL AUTO_INCREMENT,
  `guid` bigint(40) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `sfz` varchar(20) DEFAULT NULL,
  `bz` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of sequence
-- ----------------------------

-- ----------------------------
-- Table structure for `student_room_list`
-- ----------------------------
DROP TABLE IF EXISTS `student_room_list`;
CREATE TABLE `student_room_list` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `forsex` varchar(4) DEFAULT NULL,
  `forgrade` tinyint(2) DEFAULT NULL,
  `roomname` varchar(50) DEFAULT NULL,
  `numberofbed` tinyint(2) DEFAULT NULL,
  `usednumber` tinyint(2) DEFAULT NULL,
  `sparefield` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of student_room_list
-- ----------------------------

-- ----------------------------
-- Table structure for `temptable`
-- ----------------------------
DROP TABLE IF EXISTS `temptable`;
CREATE TABLE `temptable` (
  `id` bigint(40) NOT NULL AUTO_INCREMENT,
  `班级` varchar(40) DEFAULT NULL,
  `分类` varchar(40) DEFAULT NULL,
  `XM` varchar(40) DEFAULT NULL,
  `SFZH` varchar(40) DEFAULT NULL,
  `听力` varchar(40) DEFAULT NULL,
  `技术` varchar(40) DEFAULT NULL,
  `加分` varchar(40) DEFAULT NULL,
  `语文` varchar(40) DEFAULT NULL,
  `数学` varchar(40) DEFAULT NULL,
  `笔试` varchar(40) DEFAULT NULL,
  `英语` varchar(40) DEFAULT NULL,
  `综合` varchar(40) DEFAULT NULL,
  `自选` varchar(40) DEFAULT NULL,
  `总分一` varchar(40) DEFAULT NULL,
  `总分二` varchar(40) DEFAULT NULL,
  `总分三` varchar(40) DEFAULT NULL,
  `总分四` varchar(40) DEFAULT NULL,
  `MSCJ` varchar(40) DEFAULT NULL,
  `YYCJ` varchar(40) DEFAULT NULL,
  `WDCJ` varchar(40) DEFAULT NULL,
  `MSZHF2` varchar(40) DEFAULT NULL,
  `YYZHF2` varchar(40) DEFAULT NULL,
  `WDZHF2` varchar(40) DEFAULT NULL,
  `MSZHF4` varchar(40) DEFAULT NULL,
  `YYZHF4` varchar(40) DEFAULT NULL,
  `WDZHF4` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of temptable
-- ----------------------------

-- ----------------------------
-- Table structure for `tmp`
-- ----------------------------
DROP TABLE IF EXISTS `tmp`;
CREATE TABLE `tmp` (
  `uid` bigint(10) DEFAULT NULL,
  `name` varchar(30) DEFAULT NULL,
  `subject` decimal(4,1) DEFAULT NULL,
  `pmsubject` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tmp
-- ----------------------------

-- ----------------------------
-- Table structure for `type_of_class`
-- ----------------------------
DROP TABLE IF EXISTS `type_of_class`;
CREATE TABLE `type_of_class` (
  `id` tinyint(1) DEFAULT '1',
  `type` varchar(60) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of type_of_class
-- ----------------------------
INSERT INTO `type_of_class` VALUES ('1', '文本|理本|艺术|文专|理专|体育||');
INSERT INTO `type_of_class` VALUES ('2', '13');

-- ----------------------------
-- Table structure for `users`
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `User` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `PassWord` varchar(70) CHARACTER SET utf8 DEFAULT '',
  `Office` char(20) CHARACTER SET utf8 DEFAULT '',
  `Level` char(6) CHARACTER SET utf8 DEFAULT '',
  `Description` char(20) CHARACTER SET utf8 DEFAULT '' COMMENT '是否班主任判断',
  `ClassTutor` char(20) CHARACTER SET utf8 DEFAULT '' COMMENT '班主任标志',
  `GradeID` varchar(90) CHARACTER SET utf8 DEFAULT '' COMMENT '任教年级标志',
  `ClassID` varchar(90) CHARACTER SET utf8 DEFAULT '',
  `Class` varchar(180) CHARACTER SET utf8 DEFAULT '' COMMENT '任教班级',
  `Online` tinyint(1) DEFAULT '0',
  `LastIP` varchar(25) CHARACTER SET utf8 DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('1', '钱丰衡', '46717615c7d203a0abe7006251f6b332fd566634', '教务处', '1111', '', '', '', '', '', '0', '192.168.3.131 ');

-- ----------------------------
-- Table structure for `wzlk`
-- ----------------------------
DROP TABLE IF EXISTS `wzlk`;
CREATE TABLE `wzlk` (
  `id` smallint(2) NOT NULL AUTO_INCREMENT,
  `outers` varchar(40) DEFAULT NULL,
  `innerC` varchar(40) DEFAULT NULL,
  `innerE` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of wzlk
-- ----------------------------

-- ----------------------------
-- Table structure for `wzsetting`
-- ----------------------------
DROP TABLE IF EXISTS `wzsetting`;
CREATE TABLE `wzsetting` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT NULL,
  `top1` smallint(5) DEFAULT NULL,
  `top2` smallint(5) DEFAULT NULL,
  `top3` smallint(5) DEFAULT NULL,
  `col` int(2) DEFAULT NULL,
  `include0` tinyint(1) DEFAULT NULL,
  `includetec0` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of wzsetting
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_dfblist`
-- ----------------------------
DROP TABLE IF EXISTS `xk_dfblist`;
CREATE TABLE `xk_dfblist` (
  `ID` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `TableName` varchar(40) CHARACTER SET utf8 DEFAULT NULL COMMENT '登分表名称，一般选择最大的id操作',
  `TableEnglishName` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `ExtraInfo` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `GradeID` char(2) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_dfblist
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_dyn_tablelist`
-- ----------------------------
DROP TABLE IF EXISTS `xk_dyn_tablelist`;
CREATE TABLE `xk_dyn_tablelist` (
  `ID` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` varchar(50) DEFAULT NULL COMMENT '分登表生成日期',
  `tname` varchar(40) CHARACTER SET utf8 DEFAULT NULL COMMENT '登分表名称，一般选择最大的id操作',
  `etname` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `including1` varchar(255) DEFAULT NULL,
  `including2` varchar(255) DEFAULT NULL,
  `gradeid` char(2) CHARACTER SET utf8 DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `total1` varchar(80) DEFAULT NULL,
  `total2` varchar(80) DEFAULT NULL,
  `subjectnamec` varchar(150) DEFAULT NULL,
  `subjectnamee` varchar(200) DEFAULT NULL,
  `standard` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_dyn_tablelist
-- ----------------------------
INSERT INTO `xk_dyn_tablelist` VALUES ('1', '2016年5月13日', '201501高二期末考', '201501gaoerqimokao', '201501高二期末考', '201501GaoErQiMoKao', '32', '登分表', null, null, null, null, null);
INSERT INTO `xk_dyn_tablelist` VALUES ('2', '2016年5月16日', '201502高二选学考模拟', '201502gaoerxuanxuekaomoni', '201502高二选学考模拟', '201502GaoErXuanXueKaoMoNi', '32', '登分表', '100,100,70,70,70,70,70,30', '100,100,100,100,100,100,100,100', '语文,数学,化学,生物,政治,历史,地理,电脑,通用', 'Subject1,Subject2,Subject5,Subject6,Subject7,Subject8,Subject9,Subject10,Subject11', '85,60');
INSERT INTO `xk_dyn_tablelist` VALUES ('3', '2016年7月5日', '201402高一期中考', '201402gaoyiqizhongkao', '201402高一期中考', '201402GaoYiQiZhongKao', '32', '登分表', '100,100,100,100,100,100,100,100,100,50', '100,100,100,100,100,100,100,100,100,100', '语文,数学,英语,物理,化学,生物,政治,历史,地理,电脑,通用', 'Subject1,Subject2,Subject3,Subject4,Subject5,Subject6,Subject7,Subject8,Subject9,Subject10,Subject11', '85,60');

-- ----------------------------
-- Table structure for `xk_etablename`
-- ----------------------------
DROP TABLE IF EXISTS `xk_etablename`;
CREATE TABLE `xk_etablename` (
  `ID` smallint(4) NOT NULL AUTO_INCREMENT,
  `stuname` char(10) DEFAULT NULL,
  `sex` char(4) DEFAULT NULL,
  `class` char(20) DEFAULT NULL,
  `IDcardNo` varchar(30) DEFAULT NULL,
  `TypeOfClass` varchar(30) DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT NULL,
  `PersonalCode` bigint(10) DEFAULT NULL,
  `subjname1` varchar(50) DEFAULT NULL,
  `subjname2` varchar(50) DEFAULT NULL,
  `subjname3` varchar(50) DEFAULT NULL,
  `cat1` varchar(10) DEFAULT NULL,
  `cat2` varchar(10) DEFAULT NULL,
  `cat3` varchar(10) DEFAULT NULL,
  `subno` mediumint(6) DEFAULT NULL,
  `GradeID` tinyint(2) DEFAULT NULL,
  `source` char(20) DEFAULT NULL,
  `score` tinyint(2) DEFAULT NULL,
  `newclass` char(20) DEFAULT NULL,
  `period` tinyint(2) DEFAULT NULL,
  `art` varchar(10) DEFAULT NULL,
  `totalscore` decimal(9,4) DEFAULT NULL,
  `sparefield` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk ROW_FORMAT=COMPACT COMMENT='InnoDB free: 153600 kB';

-- ----------------------------
-- Records of xk_etablename
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_exam_arrangement`
-- ----------------------------
DROP TABLE IF EXISTS `xk_exam_arrangement`;
CREATE TABLE `xk_exam_arrangement` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PersonalCode` bigint(10) DEFAULT '0',
  `sname` char(10) DEFAULT NULL,
  `class` char(50) DEFAULT NULL,
  `teachingclass` char(50) DEFAULT NULL,
  `ExamCode` varchar(20) DEFAULT NULL,
  `DeskNo` varchar(4) DEFAULT NULL,
  `ExamRoom` varchar(30) DEFAULT NULL,
  `RoomNo` varchar(20) DEFAULT NULL,
  `examnamec` varchar(40) DEFAULT '',
  `examnamee` varchar(100) DEFAULT NULL,
  `GradeID` char(2) DEFAULT NULL,
  `termno` mediumint(8) DEFAULT NULL,
  `lastplace` smallint(4) DEFAULT NULL,
  `subject` varchar(30) DEFAULT '',
  `orderID` smallint(4) DEFAULT NULL,
  `OtherInfo` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_exam_arrangement
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_nickclass`
-- ----------------------------
DROP TABLE IF EXISTS `xk_nickclass`;
CREATE TABLE `xk_nickclass` (
  `ID` smallint(2) unsigned NOT NULL AUTO_INCREMENT,
  `formalclass` varchar(30) DEFAULT NULL,
  `nickclass` varchar(30) DEFAULT NULL,
  `classid` smallint(4) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_nickclass
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_result_grade`
-- ----------------------------
DROP TABLE IF EXISTS `xk_result_grade`;
CREATE TABLE `xk_result_grade` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PersonalCode` bigint(10) DEFAULT NULL,
  `GradeID` tinyint(4) DEFAULT NULL,
  `IDcardNo` varchar(30) DEFAULT NULL,
  `subject1type` varchar(10) DEFAULT NULL,
  `subject2type` varchar(10) DEFAULT NULL,
  `subject3type` varchar(10) DEFAULT NULL,
  `subject4type` varchar(10) DEFAULT NULL,
  `subject5type` varchar(10) DEFAULT NULL,
  `subject6type` varchar(10) DEFAULT NULL,
  `subject7type` varchar(10) DEFAULT NULL,
  `subject8type` varchar(10) DEFAULT NULL,
  `subject9type` varchar(10) DEFAULT NULL,
  `subject10type` varchar(10) DEFAULT NULL,
  `subject11type` varchar(10) DEFAULT NULL,
  `subject12type` varchar(10) DEFAULT NULL,
  `subject13type` varchar(10) DEFAULT NULL,
  `subject14type` varchar(10) DEFAULT NULL,
  `subject15type` varchar(10) DEFAULT NULL,
  `subject16type` varchar(10) DEFAULT NULL,
  `subject17type` varchar(10) DEFAULT NULL,
  `subject18type` varchar(10) DEFAULT NULL,
  `subject19type` varchar(10) DEFAULT NULL,
  `subject20type` varchar(10) DEFAULT NULL,
  `subject1grade` varchar(4) DEFAULT NULL,
  `subject2grade` varchar(10) DEFAULT NULL,
  `subject3grade` varchar(10) DEFAULT NULL,
  `subject4grade` varchar(10) DEFAULT NULL,
  `subject5grade` varchar(10) DEFAULT NULL,
  `subject6grade` varchar(10) DEFAULT NULL,
  `subject7grade` varchar(10) DEFAULT NULL,
  `subject8grade` varchar(10) DEFAULT NULL,
  `subject9grade` varchar(10) DEFAULT NULL,
  `subject10grade` varchar(10) DEFAULT NULL,
  `subject11grade` varchar(10) DEFAULT NULL,
  `subject12grade` varchar(10) DEFAULT NULL,
  `subject13grade` varchar(10) DEFAULT NULL,
  `subject14grade` varchar(10) DEFAULT NULL,
  `subject15grade` varchar(10) DEFAULT NULL,
  `subject16grade` varchar(10) DEFAULT NULL,
  `subject17grade` varchar(10) DEFAULT NULL,
  `subject18grade` varchar(10) DEFAULT NULL,
  `subject19grade` varchar(10) DEFAULT NULL,
  `subject20grade` varchar(10) DEFAULT NULL,
  `SpareField` varchar(40) DEFAULT NULL,
  `otherinfo` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_result_grade
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_student_info`
-- ----------------------------
DROP TABLE IF EXISTS `xk_student_info`;
CREATE TABLE `xk_student_info` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PersonalCode` bigint(10) DEFAULT NULL,
  `stuname` char(10) DEFAULT NULL,
  `GradeID` tinyint(3) DEFAULT NULL,
  `class` char(50) DEFAULT NULL,
  `options` char(50) DEFAULT NULL,
  `teachingtype` char(40) DEFAULT NULL,
  `subject1` varchar(30) DEFAULT NULL,
  `subject2` varchar(30) DEFAULT NULL,
  `subject3` varchar(30) DEFAULT NULL,
  `subject4` varchar(30) DEFAULT NULL,
  `subject5` varchar(30) DEFAULT NULL,
  `subject6` varchar(30) DEFAULT NULL,
  `subject7` varchar(30) DEFAULT NULL,
  `subject8` varchar(30) DEFAULT NULL,
  `subject9` varchar(30) DEFAULT NULL,
  `subject10` varchar(30) DEFAULT NULL,
  `subject11` varchar(30) DEFAULT NULL,
  `subject12` varchar(30) DEFAULT NULL,
  `subject13` varchar(30) DEFAULT NULL,
  `subject14` varchar(30) DEFAULT NULL,
  `subject15` varchar(30) DEFAULT NULL,
  `subject16` varchar(30) DEFAULT NULL,
  `subject17` varchar(30) DEFAULT NULL,
  `subject18` varchar(30) DEFAULT NULL,
  `subject19` varchar(30) DEFAULT NULL,
  `subject20` varchar(30) DEFAULT NULL,
  `subject1t` char(30) DEFAULT NULL,
  `subject2t` char(30) DEFAULT NULL,
  `subject3t` char(30) DEFAULT NULL,
  `subject4t` char(30) DEFAULT NULL,
  `subject5t` char(30) DEFAULT NULL,
  `subject6t` char(30) DEFAULT NULL,
  `subject7t` char(30) DEFAULT NULL,
  `subject8t` char(30) DEFAULT NULL,
  `subject9t` char(30) DEFAULT NULL,
  `subject10t` char(30) DEFAULT NULL,
  `subject11t` char(30) DEFAULT NULL,
  `subject12t` char(30) DEFAULT NULL,
  `subject13t` char(30) DEFAULT NULL,
  `subject14t` char(30) DEFAULT NULL,
  `subject15t` char(30) DEFAULT NULL,
  `subject16t` char(30) DEFAULT NULL,
  `subject17t` char(30) DEFAULT NULL,
  `subject18t` char(30) DEFAULT NULL,
  `subject19t` char(30) DEFAULT NULL,
  `subject20t` char(30) DEFAULT NULL,
  `SpareField` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_student_info
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_student_users`
-- ----------------------------
DROP TABLE IF EXISTS `xk_student_users`;
CREATE TABLE `xk_student_users` (
  `ID` bigint(50) NOT NULL AUTO_INCREMENT,
  `sname` char(10) DEFAULT NULL,
  `sex` char(4) DEFAULT NULL,
  `class` char(20) DEFAULT NULL,
  `IDcardNo` varchar(30) DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT NULL,
  `GradeID` tinyint(3) DEFAULT NULL,
  `TypeOfClass` varchar(30) DEFAULT NULL,
  `PersonalCode` bigint(10) DEFAULT NULL,
  `pd` varchar(70) DEFAULT NULL,
  `pwstyle` tinyint(1) DEFAULT NULL,
  `SpareField` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_student_users
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_subject`
-- ----------------------------
DROP TABLE IF EXISTS `xk_subject`;
CREATE TABLE `xk_subject` (
  `ID` smallint(4) NOT NULL AUTO_INCREMENT,
  `sname` varchar(50) DEFAULT NULL,
  `cat1` varchar(10) DEFAULT NULL,
  `cat2` varchar(10) DEFAULT NULL,
  `cat3` varchar(10) DEFAULT NULL,
  `for_xk` tinyint(1) DEFAULT '0',
  `subno` mediumint(6) DEFAULT NULL,
  `GradeID` tinyint(2) DEFAULT NULL,
  `source` char(20) DEFAULT NULL,
  `score` smallint(2) DEFAULT NULL,
  `period` tinyint(2) DEFAULT NULL,
  `sparefield` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_subject
-- ----------------------------

-- ----------------------------
-- Table structure for `xk_tablelist`
-- ----------------------------
DROP TABLE IF EXISTS `xk_tablelist`;
CREATE TABLE `xk_tablelist` (
  `ID` mediumint(20) NOT NULL AUTO_INCREMENT,
  `tablename` varchar(50) DEFAULT NULL,
  `etablename` varchar(70) DEFAULT NULL,
  `gradeid` tinyint(2) DEFAULT NULL,
  `term` varchar(20) DEFAULT NULL,
  `score` tinyint(2) DEFAULT NULL,
  `period` tinyint(2) DEFAULT NULL,
  `for_xk` tinyint(1) DEFAULT NULL,
  `instruction` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of xk_tablelist
-- ----------------------------

-- ----------------------------
-- Table structure for `分析报表1`
-- ----------------------------
DROP TABLE IF EXISTS `分析报表1`;
CREATE TABLE `分析报表1` (
  `ID` bigint(3) NOT NULL DEFAULT '0',
  `class` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject1` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject2` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject3` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject4` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject5` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject6` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject7` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject8` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject9` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject10` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject11` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject12` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject13` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject14` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject15` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject16` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject17` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject18` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject19` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject20` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT1` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT2` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT3` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT4` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT5` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT6` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT7` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT8` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT9` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT10` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT11` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT12` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT13` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT14` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `SubjectT15` char(18) CHARACTER SET utf8 DEFAULT NULL,
  `ExcellenceRate1` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate2` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate3` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate4` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate5` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate6` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate7` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate8` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate9` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate10` decimal(10,2) DEFAULT '0.00',
  `ExcellenceRate11` decimal(10,2) DEFAULT NULL,
  `ExcellenceRate12` decimal(10,2) DEFAULT NULL,
  `ExcellenceRate13` decimal(10,2) DEFAULT NULL,
  `ExcellenceRate14` decimal(10,2) DEFAULT NULL,
  `ExcellenceRate15` decimal(10,2) DEFAULT NULL,
  `PassRate1` decimal(10,2) DEFAULT NULL,
  `PassRate2` decimal(10,2) DEFAULT NULL,
  `PassRate3` decimal(10,2) DEFAULT NULL,
  `PassRate4` decimal(10,2) DEFAULT NULL,
  `PassRate5` decimal(10,2) DEFAULT NULL,
  `PassRate6` decimal(10,2) DEFAULT NULL,
  `PassRate7` decimal(10,2) DEFAULT NULL,
  `PassRate8` decimal(10,2) DEFAULT NULL,
  `PassRate9` decimal(10,2) DEFAULT NULL,
  `PassRate10` decimal(10,2) DEFAULT NULL,
  `PassRate11` decimal(10,2) DEFAULT NULL,
  `PassRate12` decimal(10,2) DEFAULT NULL,
  `PassRate13` decimal(10,2) DEFAULT NULL,
  `PassRate14` decimal(10,2) DEFAULT NULL,
  `PassRate15` decimal(10,2) DEFAULT NULL,
  `Avg1` decimal(10,2) DEFAULT NULL,
  `Avg2` decimal(10,2) DEFAULT NULL,
  `Avg3` decimal(10,2) DEFAULT NULL,
  `Avg4` decimal(10,2) DEFAULT NULL,
  `Avg5` decimal(10,2) DEFAULT NULL,
  `Avg6` decimal(10,2) DEFAULT NULL,
  `Avg7` decimal(10,2) DEFAULT NULL,
  `Avg8` decimal(10,2) DEFAULT NULL,
  `Avg9` decimal(10,2) DEFAULT NULL,
  `Avg10` decimal(10,2) DEFAULT NULL,
  `Avg11` decimal(10,2) DEFAULT NULL,
  `Avg12` decimal(10,2) DEFAULT NULL,
  `Avg13` decimal(10,2) DEFAULT NULL,
  `Avg14` decimal(10,2) DEFAULT NULL,
  `Avg15` decimal(10,2) DEFAULT NULL,
  `Top1` decimal(10,0) DEFAULT NULL,
  `Top2` decimal(10,0) DEFAULT NULL,
  `Top3` decimal(10,0) DEFAULT NULL,
  `Top4` decimal(10,0) DEFAULT NULL,
  `Top5` decimal(10,0) DEFAULT NULL,
  `Top6` decimal(10,0) DEFAULT NULL,
  `Top7` decimal(10,0) DEFAULT NULL,
  `Top8` decimal(10,0) DEFAULT NULL,
  `Top9` decimal(10,0) DEFAULT NULL,
  `Top10` decimal(10,0) DEFAULT NULL,
  `Top11` decimal(10,0) DEFAULT NULL,
  `Top12` decimal(10,0) DEFAULT NULL,
  `Top13` decimal(10,0) DEFAULT NULL,
  `Top14` decimal(10,0) DEFAULT NULL,
  `Top15` decimal(10,0) DEFAULT NULL,
  `SNumber1` smallint(3) DEFAULT NULL,
  `SNumber2` smallint(3) DEFAULT NULL,
  `SNumber3` smallint(3) DEFAULT NULL,
  `SNumber4` smallint(3) DEFAULT NULL,
  `SNumber5` smallint(3) DEFAULT NULL,
  `SNumber6` smallint(3) DEFAULT NULL,
  `SNumber7` smallint(3) DEFAULT NULL,
  `SNumber8` smallint(3) DEFAULT NULL,
  `SNumber9` smallint(3) DEFAULT NULL,
  `SNumber10` smallint(3) DEFAULT NULL,
  `SNumber11` smallint(3) DEFAULT NULL,
  `SNumber12` smallint(3) DEFAULT NULL,
  `SNumber13` smallint(3) DEFAULT NULL,
  `SNumber14` smallint(3) DEFAULT NULL,
  `SNumber15` smallint(3) DEFAULT NULL,
  `Ninety1` smallint(3) DEFAULT NULL,
  `Ninety2` smallint(3) DEFAULT NULL,
  `Ninety3` smallint(3) DEFAULT NULL,
  `Ninety4` smallint(3) DEFAULT NULL,
  `Ninety5` smallint(3) DEFAULT NULL,
  `Ninety6` smallint(3) DEFAULT NULL,
  `Ninety7` smallint(3) DEFAULT NULL,
  `Ninety8` smallint(3) DEFAULT NULL,
  `Ninety9` smallint(3) DEFAULT NULL,
  `Ninety10` smallint(3) DEFAULT NULL,
  `Ninety11` smallint(3) DEFAULT NULL,
  `Ninety12` smallint(3) DEFAULT NULL,
  `Ninety13` smallint(3) DEFAULT NULL,
  `Ninety14` smallint(3) DEFAULT NULL,
  `Ninety15` smallint(3) DEFAULT NULL,
  `TypeOfClass` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `OtherInfo` varchar(40) CHARACTER SET utf8 DEFAULT '',
  `Eighty1` smallint(3) DEFAULT NULL,
  `Eighty2` smallint(3) DEFAULT NULL,
  `Eighty3` smallint(3) DEFAULT NULL,
  `Eighty4` smallint(3) DEFAULT NULL,
  `Eighty5` smallint(3) DEFAULT NULL,
  `Eighty6` smallint(3) DEFAULT NULL,
  `Eighty7` smallint(3) DEFAULT NULL,
  `Eighty8` smallint(3) DEFAULT NULL,
  `Eighty9` smallint(3) DEFAULT NULL,
  `Eighty10` smallint(3) DEFAULT NULL,
  `Eighty11` smallint(3) DEFAULT NULL,
  `Eighty12` smallint(3) DEFAULT NULL,
  `Eighty13` smallint(3) DEFAULT NULL,
  `Eighty14` smallint(3) DEFAULT NULL,
  `Eighty15` smallint(3) DEFAULT NULL,
  `Seventy1` smallint(3) DEFAULT NULL,
  `Seventy2` smallint(3) DEFAULT NULL,
  `Seventy3` smallint(3) DEFAULT NULL,
  `Seventy4` smallint(3) DEFAULT NULL,
  `Seventy5` smallint(3) DEFAULT NULL,
  `Seventy6` smallint(3) DEFAULT NULL,
  `Seventy7` smallint(3) DEFAULT NULL,
  `Seventy8` smallint(3) DEFAULT NULL,
  `Seventy9` smallint(3) DEFAULT NULL,
  `Seventy10` smallint(3) DEFAULT NULL,
  `Seventy11` smallint(3) DEFAULT NULL,
  `Seventy12` smallint(3) DEFAULT NULL,
  `Seventy13` smallint(3) DEFAULT NULL,
  `Seventy14` smallint(3) DEFAULT NULL,
  `Seventy15` smallint(3) DEFAULT NULL,
  `Sixty1` smallint(3) DEFAULT NULL,
  `Sixty2` smallint(3) DEFAULT NULL,
  `Sixty3` smallint(3) DEFAULT NULL,
  `Sixty4` smallint(3) DEFAULT NULL,
  `Sixty5` smallint(3) DEFAULT NULL,
  `Sixty6` smallint(3) DEFAULT NULL,
  `Sixty7` smallint(3) DEFAULT NULL,
  `Sixty8` smallint(3) DEFAULT NULL,
  `Sixty9` smallint(3) DEFAULT NULL,
  `Sixty10` smallint(3) DEFAULT NULL,
  `Sixty11` smallint(3) DEFAULT NULL,
  `Sixty12` smallint(3) DEFAULT NULL,
  `Sixty13` smallint(3) DEFAULT NULL,
  `Sixty14` smallint(3) DEFAULT NULL,
  `Sixty15` smallint(3) DEFAULT NULL,
  `Fifty1` smallint(3) DEFAULT NULL,
  `Fifty2` smallint(3) DEFAULT NULL,
  `Fifty3` smallint(3) DEFAULT NULL,
  `Fifty4` smallint(3) DEFAULT NULL,
  `Fifty5` smallint(3) DEFAULT NULL,
  `Fifty6` smallint(3) DEFAULT NULL,
  `Fifty7` smallint(3) DEFAULT NULL,
  `Fifty8` smallint(3) DEFAULT NULL,
  `Fifty9` smallint(3) DEFAULT NULL,
  `Fifty10` smallint(3) DEFAULT NULL,
  `Fifty11` smallint(3) DEFAULT NULL,
  `Fifty12` smallint(3) DEFAULT NULL,
  `Fifty13` smallint(3) DEFAULT NULL,
  `Fifty14` smallint(3) DEFAULT NULL,
  `Fifty15` smallint(3) DEFAULT NULL,
  `Forty1` smallint(3) DEFAULT NULL,
  `Forty2` smallint(3) DEFAULT NULL,
  `Forty3` smallint(3) DEFAULT NULL,
  `Forty4` smallint(3) DEFAULT NULL,
  `Forty5` smallint(3) DEFAULT NULL,
  `Forty6` smallint(3) DEFAULT NULL,
  `Forty7` smallint(3) DEFAULT NULL,
  `Forty8` smallint(3) DEFAULT NULL,
  `Forty9` smallint(3) DEFAULT NULL,
  `Forty10` smallint(3) DEFAULT NULL,
  `Forty11` smallint(3) DEFAULT NULL,
  `Forty12` smallint(3) DEFAULT NULL,
  `Forty13` smallint(3) DEFAULT NULL,
  `Forty14` smallint(3) DEFAULT NULL,
  `Forty15` smallint(3) DEFAULT NULL,
  `Thirty1` smallint(3) DEFAULT NULL,
  `Thirty2` smallint(3) DEFAULT NULL,
  `Thirty3` smallint(3) DEFAULT NULL,
  `Thirty4` smallint(3) DEFAULT NULL,
  `Thirty5` smallint(3) DEFAULT NULL,
  `Thirty6` smallint(3) DEFAULT NULL,
  `Thirty7` smallint(3) DEFAULT NULL,
  `Thirty8` smallint(3) DEFAULT NULL,
  `Thirty9` smallint(3) DEFAULT NULL,
  `Thirty10` smallint(3) DEFAULT NULL,
  `Thirty11` smallint(3) DEFAULT NULL,
  `Thirty12` smallint(3) DEFAULT NULL,
  `Thirty13` smallint(3) DEFAULT NULL,
  `Thirty14` smallint(3) DEFAULT NULL,
  `Thirty15` smallint(3) DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` tinyint(3) DEFAULT '0',
  `Total1` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total2` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total3` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total4` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total5` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total6` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total7` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total8` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total9` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total10` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `TotalExcellenceRate1` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate2` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate3` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate4` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate5` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate6` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate7` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate8` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate9` decimal(10,2) DEFAULT NULL,
  `TotalExcellenceRate10` decimal(10,2) DEFAULT NULL,
  `TotalPassRate1` decimal(10,2) DEFAULT NULL,
  `TotalPassRate2` decimal(10,2) DEFAULT NULL,
  `TotalPassRate3` decimal(10,2) DEFAULT NULL,
  `TotalPassRate4` decimal(10,2) DEFAULT NULL,
  `TotalPassRate5` decimal(10,2) DEFAULT NULL,
  `TotalPassRate6` decimal(10,2) DEFAULT NULL,
  `TotalPassRate7` decimal(10,2) DEFAULT NULL,
  `TotalPassRate8` decimal(10,2) DEFAULT NULL,
  `TotalPassRate9` decimal(10,2) DEFAULT NULL,
  `TotalPassRate10` decimal(10,2) DEFAULT NULL,
  `TotalAvg1` decimal(10,2) DEFAULT NULL,
  `TotalAvg2` decimal(10,2) DEFAULT NULL,
  `TotalAvg3` decimal(10,2) DEFAULT NULL,
  `TotalAvg4` decimal(10,2) DEFAULT NULL,
  `TotalAvg5` decimal(10,2) DEFAULT NULL,
  `TotalAvg6` decimal(10,2) DEFAULT NULL,
  `TotalAvg7` decimal(10,2) DEFAULT NULL,
  `TotalAvg8` decimal(10,2) DEFAULT NULL,
  `TotalAvg9` decimal(10,2) DEFAULT NULL,
  `TotalAvg10` decimal(10,2) DEFAULT NULL,
  `TotalTop1` decimal(10,0) DEFAULT NULL,
  `TotalTop2` decimal(10,0) DEFAULT NULL,
  `TotalTop3` decimal(10,0) DEFAULT NULL,
  `TotalTop4` decimal(10,0) DEFAULT NULL,
  `TotalTop5` decimal(10,0) DEFAULT NULL,
  `TotalTop6` decimal(10,0) DEFAULT NULL,
  `TotalTop7` decimal(10,0) DEFAULT NULL,
  `TotalTop8` decimal(10,0) DEFAULT NULL,
  `TotalTop9` decimal(10,0) DEFAULT NULL,
  `TotalTop10` decimal(10,0) DEFAULT NULL,
  `TotalSNumber1` smallint(3) DEFAULT NULL,
  `TotalSNumber2` smallint(3) DEFAULT NULL,
  `TotalSNumber3` smallint(3) DEFAULT NULL,
  `TotalSNumber4` smallint(3) DEFAULT NULL,
  `TotalSNumber5` smallint(3) DEFAULT NULL,
  `TotalSNumber6` smallint(3) DEFAULT NULL,
  `TotalSNumber7` smallint(3) DEFAULT NULL,
  `TotalSNumber8` smallint(3) DEFAULT NULL,
  `TotalSNumber9` smallint(3) DEFAULT NULL,
  `TotalSNumber10` smallint(3) DEFAULT NULL,
  `TotalNinety1` smallint(3) DEFAULT NULL COMMENT '第一门课第一分数段',
  `TotalNinety2` smallint(3) DEFAULT NULL,
  `TotalNinety3` smallint(3) DEFAULT NULL,
  `TotalNinety4` smallint(3) DEFAULT NULL,
  `TotalNinety5` smallint(3) DEFAULT NULL,
  `TotalNinety6` smallint(3) DEFAULT NULL,
  `TotalNinety7` smallint(3) DEFAULT NULL,
  `TotalNinety8` smallint(3) DEFAULT NULL,
  `TotalNinety9` smallint(3) DEFAULT NULL,
  `TotalNinety10` smallint(3) DEFAULT NULL,
  `TotalEighty1` smallint(3) DEFAULT NULL,
  `TotalEighty2` smallint(3) DEFAULT NULL,
  `TotalEighty3` smallint(3) DEFAULT NULL,
  `TotalEighty4` smallint(3) DEFAULT NULL,
  `TotalEighty5` smallint(3) DEFAULT NULL,
  `TotalEighty6` smallint(3) DEFAULT NULL,
  `TotalEighty7` smallint(3) DEFAULT NULL,
  `TotalEighty8` smallint(3) DEFAULT NULL,
  `TotalEighty9` smallint(3) DEFAULT NULL,
  `TotalEighty10` smallint(3) DEFAULT NULL,
  `TotalSeventy1` smallint(3) DEFAULT NULL,
  `TotalSeventy2` smallint(3) DEFAULT NULL,
  `TotalSeventy3` smallint(3) DEFAULT NULL,
  `TotalSeventy4` smallint(3) DEFAULT NULL,
  `TotalSeventy5` smallint(3) DEFAULT NULL,
  `TotalSeventy6` smallint(3) DEFAULT NULL,
  `TotalSeventy7` smallint(3) DEFAULT NULL,
  `TotalSeventy8` smallint(3) DEFAULT NULL,
  `TotalSeventy9` smallint(3) DEFAULT NULL,
  `TotalSeventy10` smallint(3) DEFAULT NULL,
  `TotalSixty1` smallint(3) DEFAULT NULL,
  `TotalSixty2` smallint(3) DEFAULT NULL,
  `TotalSixty3` smallint(3) DEFAULT NULL,
  `TotalSixty4` smallint(3) DEFAULT NULL,
  `TotalSixty5` smallint(3) DEFAULT NULL,
  `TotalSixty6` smallint(3) DEFAULT NULL,
  `TotalSixty7` smallint(3) DEFAULT NULL,
  `TotalSixty8` smallint(3) DEFAULT NULL,
  `TotalSixty9` smallint(3) DEFAULT NULL,
  `TotalSixty10` smallint(3) DEFAULT NULL,
  `TotalFifty1` smallint(3) DEFAULT NULL,
  `TotalFifty2` smallint(3) DEFAULT NULL,
  `TotalFifty3` smallint(3) DEFAULT NULL,
  `TotalFifty4` smallint(3) DEFAULT NULL,
  `TotalFifty5` smallint(3) DEFAULT NULL,
  `TotalFifty6` smallint(3) DEFAULT NULL,
  `TotalFifty7` smallint(3) DEFAULT NULL,
  `TotalFifty8` smallint(3) DEFAULT NULL,
  `TotalFifty9` smallint(3) DEFAULT NULL,
  `TotalFifty10` smallint(3) DEFAULT NULL,
  `TotalForty1` smallint(3) DEFAULT NULL,
  `TotalForty2` smallint(3) DEFAULT NULL,
  `TotalForty3` smallint(3) DEFAULT NULL,
  `TotalForty4` smallint(3) DEFAULT NULL,
  `TotalForty5` smallint(3) DEFAULT NULL,
  `TotalForty6` smallint(3) DEFAULT NULL,
  `TotalForty7` smallint(3) DEFAULT NULL,
  `TotalForty8` smallint(3) DEFAULT NULL,
  `TotalForty9` smallint(3) DEFAULT NULL,
  `TotalForty10` smallint(3) DEFAULT NULL,
  `TotalThirty1` smallint(3) DEFAULT NULL,
  `TotalThirty2` smallint(3) DEFAULT NULL,
  `TotalThirty3` smallint(3) DEFAULT NULL,
  `TotalThirty4` smallint(3) DEFAULT NULL,
  `TotalThirty5` smallint(3) DEFAULT NULL,
  `TotalThirty6` smallint(3) DEFAULT NULL,
  `TotalThirty7` smallint(3) DEFAULT NULL,
  `TotalThirty8` smallint(3) DEFAULT NULL,
  `TotalThirty9` smallint(3) DEFAULT NULL,
  `TotalThirty10` smallint(3) DEFAULT NULL,
  `90percent1` smallint(3) DEFAULT NULL,
  `90percent2` smallint(3) DEFAULT NULL,
  `90percent3` smallint(3) DEFAULT NULL,
  `90percent4` smallint(3) DEFAULT NULL,
  `90percent5` smallint(3) DEFAULT NULL,
  `90percent6` smallint(3) DEFAULT NULL,
  `90percent7` smallint(3) DEFAULT NULL,
  `90percent8` smallint(3) DEFAULT NULL,
  `90percent9` smallint(3) DEFAULT NULL,
  `90percent10` smallint(3) DEFAULT NULL,
  `90percent11` smallint(3) DEFAULT NULL,
  `90percent12` smallint(3) DEFAULT NULL,
  `90percent13` smallint(3) DEFAULT NULL,
  `90percent14` smallint(3) DEFAULT NULL,
  `90percent15` smallint(3) DEFAULT NULL,
  `80percent1` smallint(3) DEFAULT NULL,
  `80percent2` smallint(3) DEFAULT NULL,
  `80percent3` smallint(3) DEFAULT NULL,
  `80percent4` smallint(3) DEFAULT NULL,
  `80percent5` smallint(3) DEFAULT NULL,
  `80percent6` smallint(3) DEFAULT NULL,
  `80percent7` smallint(3) DEFAULT NULL,
  `80percent8` smallint(3) DEFAULT NULL,
  `80percent9` smallint(3) DEFAULT NULL,
  `80percent10` smallint(3) DEFAULT NULL,
  `80percent11` smallint(3) DEFAULT NULL,
  `80percent12` smallint(3) DEFAULT NULL,
  `80percent13` smallint(3) DEFAULT NULL,
  `80percent14` smallint(3) DEFAULT NULL,
  `80percent15` smallint(3) DEFAULT NULL,
  `70percent1` smallint(3) DEFAULT NULL,
  `70percent2` smallint(3) DEFAULT NULL,
  `70percent3` smallint(3) DEFAULT NULL,
  `70percent4` smallint(3) DEFAULT NULL,
  `70percent5` smallint(3) DEFAULT NULL,
  `70percent6` smallint(3) DEFAULT NULL,
  `70percent7` smallint(3) DEFAULT NULL,
  `70percent8` smallint(3) DEFAULT NULL,
  `70percent9` smallint(3) DEFAULT NULL,
  `70percent10` smallint(3) DEFAULT NULL,
  `70percent11` smallint(3) DEFAULT NULL,
  `70percent12` smallint(3) DEFAULT NULL,
  `70percent13` smallint(3) DEFAULT NULL,
  `70percent14` smallint(3) DEFAULT NULL,
  `70percent15` smallint(3) DEFAULT NULL,
  `60percent1` smallint(3) DEFAULT NULL,
  `60percent2` smallint(3) DEFAULT NULL,
  `60percent3` smallint(3) DEFAULT NULL,
  `60percent4` smallint(3) DEFAULT NULL,
  `60percent5` smallint(3) DEFAULT NULL,
  `60percent6` smallint(3) DEFAULT NULL,
  `60percent7` smallint(3) DEFAULT NULL,
  `60percent8` smallint(3) DEFAULT NULL,
  `60percent9` smallint(3) DEFAULT NULL,
  `60percent10` smallint(3) DEFAULT NULL,
  `60percent11` smallint(3) DEFAULT NULL,
  `60percent12` smallint(3) DEFAULT NULL,
  `60percent13` smallint(3) DEFAULT NULL,
  `60percent14` smallint(3) DEFAULT NULL,
  `60percent15` smallint(3) DEFAULT NULL,
  `50percent1` smallint(3) DEFAULT NULL,
  `50percent2` smallint(3) DEFAULT NULL,
  `50percent3` smallint(3) DEFAULT NULL,
  `50percent4` smallint(3) DEFAULT NULL,
  `50percent5` smallint(3) DEFAULT NULL,
  `50percent6` smallint(3) DEFAULT NULL,
  `50percent7` smallint(3) DEFAULT NULL,
  `50percent8` smallint(3) DEFAULT NULL,
  `50percent9` smallint(3) DEFAULT NULL,
  `50percent10` smallint(3) DEFAULT NULL,
  `50percent11` smallint(3) DEFAULT NULL,
  `50percent12` smallint(3) DEFAULT NULL,
  `50percent13` smallint(3) DEFAULT NULL,
  `50percent14` smallint(3) DEFAULT NULL,
  `50percent15` smallint(3) DEFAULT NULL,
  `40percent1` smallint(3) DEFAULT NULL,
  `40percent2` smallint(3) DEFAULT NULL,
  `40percent3` smallint(3) DEFAULT NULL,
  `40percent4` smallint(3) DEFAULT NULL,
  `40percent5` smallint(3) DEFAULT NULL,
  `40percent6` smallint(3) DEFAULT NULL,
  `40percent7` smallint(3) DEFAULT NULL,
  `40percent8` smallint(3) DEFAULT NULL,
  `40percent9` smallint(3) DEFAULT NULL,
  `40percent10` smallint(3) DEFAULT NULL,
  `40percent11` smallint(3) DEFAULT NULL,
  `40percent12` smallint(3) DEFAULT NULL,
  `40percent13` smallint(3) DEFAULT NULL,
  `40percent14` smallint(3) DEFAULT NULL,
  `40percent15` smallint(3) DEFAULT NULL,
  `under40percent1` smallint(3) DEFAULT NULL,
  `under40percent2` smallint(3) DEFAULT NULL,
  `under40percent3` smallint(3) DEFAULT NULL,
  `under40percent4` smallint(3) DEFAULT NULL,
  `under40percent5` smallint(3) DEFAULT NULL,
  `under40percent6` smallint(3) DEFAULT NULL,
  `under40percent7` smallint(3) DEFAULT NULL,
  `under40percent8` smallint(3) DEFAULT NULL,
  `under40percent9` smallint(3) DEFAULT NULL,
  `under40percent10` smallint(3) DEFAULT NULL,
  `under40percent11` smallint(3) DEFAULT NULL,
  `under40percent12` smallint(3) DEFAULT NULL,
  `under40percent13` smallint(3) DEFAULT NULL,
  `under40percent14` smallint(3) DEFAULT NULL,
  `under40percent15` smallint(3) DEFAULT NULL,
  `Total90percent1` smallint(3) DEFAULT NULL,
  `Total90percent2` smallint(3) DEFAULT NULL,
  `Total90percent3` smallint(3) DEFAULT NULL,
  `Total90percent4` smallint(3) DEFAULT NULL,
  `Total90percent5` smallint(3) DEFAULT NULL,
  `Total90percent6` smallint(3) DEFAULT NULL,
  `Total90percent7` smallint(3) DEFAULT NULL,
  `Total90percent8` smallint(3) DEFAULT NULL,
  `Total90percent9` smallint(3) DEFAULT NULL,
  `Total90percent10` smallint(3) DEFAULT NULL,
  `Total90percent11` smallint(3) DEFAULT NULL,
  `Total90percent12` smallint(3) DEFAULT NULL,
  `Total90percent13` smallint(3) DEFAULT NULL,
  `Total90percent14` smallint(3) DEFAULT NULL,
  `Total90percent15` smallint(3) DEFAULT NULL,
  `Total80percent1` smallint(3) DEFAULT NULL,
  `Total80percent2` smallint(3) DEFAULT NULL,
  `Total80percent3` smallint(3) DEFAULT NULL,
  `Total80percent4` smallint(3) DEFAULT NULL,
  `Total80percent5` smallint(3) DEFAULT NULL,
  `Total80percent6` smallint(3) DEFAULT NULL,
  `Total80percent7` smallint(3) DEFAULT NULL,
  `Total80percent8` smallint(3) DEFAULT NULL,
  `Total80percent9` smallint(3) DEFAULT NULL,
  `Total80percent10` smallint(3) DEFAULT NULL,
  `Total80percent11` smallint(3) DEFAULT NULL,
  `Total80percent12` smallint(3) DEFAULT NULL,
  `Total80percent13` smallint(3) DEFAULT NULL,
  `Total80percent14` smallint(3) DEFAULT NULL,
  `Total80percent15` smallint(3) DEFAULT NULL,
  `Total70percent1` smallint(3) DEFAULT NULL,
  `Total70percent2` smallint(3) DEFAULT NULL,
  `Total70percent3` smallint(3) DEFAULT NULL,
  `Total70percent4` smallint(3) DEFAULT NULL,
  `Total70percent5` smallint(3) DEFAULT NULL,
  `Total70percent6` smallint(3) DEFAULT NULL,
  `Total70percent7` smallint(3) DEFAULT NULL,
  `Total70percent8` smallint(3) DEFAULT NULL,
  `Total70percent9` smallint(3) DEFAULT NULL,
  `Total70percent10` smallint(3) DEFAULT NULL,
  `Total70percent11` smallint(3) DEFAULT NULL,
  `Total70percent12` smallint(3) DEFAULT NULL,
  `Total70percent13` smallint(3) DEFAULT NULL,
  `Total70percent14` smallint(3) DEFAULT NULL,
  `Total70percent15` smallint(3) DEFAULT NULL,
  `Total60percent1` smallint(3) DEFAULT NULL,
  `Total60percent2` smallint(3) DEFAULT NULL,
  `Total60percent3` smallint(3) DEFAULT NULL,
  `Total60percent4` smallint(3) DEFAULT NULL,
  `Total60percent5` smallint(3) DEFAULT NULL,
  `Total60percent6` smallint(3) DEFAULT NULL,
  `Total60percent7` smallint(3) DEFAULT NULL,
  `Total60percent8` smallint(3) DEFAULT NULL,
  `Total60percent9` smallint(3) DEFAULT NULL,
  `Total60percent10` smallint(3) DEFAULT NULL,
  `Total60percent11` smallint(3) DEFAULT NULL,
  `Total60percent12` smallint(3) DEFAULT NULL,
  `Total60percent13` smallint(3) DEFAULT NULL,
  `Total60percent14` smallint(3) DEFAULT NULL,
  `Total60percent15` smallint(3) DEFAULT NULL,
  `Total50percent1` smallint(3) DEFAULT NULL,
  `Total50percent2` smallint(3) DEFAULT NULL,
  `Total50percent3` smallint(3) DEFAULT NULL,
  `Total50percent4` smallint(3) DEFAULT NULL,
  `Total50percent5` smallint(3) DEFAULT NULL,
  `Total50percent6` smallint(3) DEFAULT NULL,
  `Total50percent7` smallint(3) DEFAULT NULL,
  `Total50percent8` smallint(3) DEFAULT NULL,
  `Total50percent9` smallint(3) DEFAULT NULL,
  `Total50percent10` smallint(3) DEFAULT NULL,
  `Total50percent11` smallint(3) DEFAULT NULL,
  `Total50percent12` smallint(3) DEFAULT NULL,
  `Total50percent13` smallint(3) DEFAULT NULL,
  `Total50percent14` smallint(3) DEFAULT NULL,
  `Total50percent15` smallint(3) DEFAULT NULL,
  `Total40percent1` smallint(3) DEFAULT NULL,
  `Total40percent2` smallint(3) DEFAULT NULL,
  `Total40percent3` smallint(3) DEFAULT NULL,
  `Total40percent4` smallint(3) DEFAULT NULL,
  `Total40percent5` smallint(3) DEFAULT NULL,
  `Total40percent6` smallint(3) DEFAULT NULL,
  `Total40percent7` smallint(3) DEFAULT NULL,
  `Total40percent8` smallint(3) DEFAULT NULL,
  `Total40percent9` smallint(3) DEFAULT NULL,
  `Total40percent10` smallint(3) DEFAULT NULL,
  `Total40percent11` smallint(3) DEFAULT NULL,
  `Total40percent12` smallint(3) DEFAULT NULL,
  `Total40percent13` smallint(3) DEFAULT NULL,
  `Total40percent14` smallint(3) DEFAULT NULL,
  `Total40percent15` smallint(3) DEFAULT NULL,
  `Totalunder40percent1` smallint(3) DEFAULT NULL,
  `Totalunder40percent2` smallint(3) DEFAULT NULL,
  `Totalunder40percent3` smallint(3) DEFAULT NULL,
  `Totalunder40percent4` smallint(3) DEFAULT NULL,
  `Totalunder40percent5` smallint(3) DEFAULT NULL,
  `Totalunder40percent6` smallint(3) DEFAULT NULL,
  `Totalunder40percent7` smallint(3) DEFAULT NULL,
  `Totalunder40percent8` smallint(3) DEFAULT NULL,
  `Totalunder40percent9` smallint(3) DEFAULT NULL,
  `Totalunder40percent10` smallint(3) DEFAULT NULL,
  `Totalunder40percent11` smallint(3) DEFAULT NULL,
  `Totalunder40percent12` smallint(3) DEFAULT NULL,
  `Totalunder40percent13` smallint(3) DEFAULT NULL,
  `Totalunder40percent14` smallint(3) DEFAULT NULL,
  `Totalunder40percent15` smallint(3) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 分析报表1
-- ----------------------------

-- ----------------------------
-- Table structure for `分析报表二`
-- ----------------------------
DROP TABLE IF EXISTS `分析报表二`;
CREATE TABLE `分析报表二` (
  `ID` bigint(3) unsigned NOT NULL AUTO_INCREMENT,
  `GradeID` tinyint(3) DEFAULT '0',
  `ClassID` smallint(5) DEFAULT '0',
  `class` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `TypeOfClass` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `headteacher` varchar(30) DEFAULT NULL,
  `Subject1` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject2` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject3` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject4` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject5` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject6` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject7` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject8` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject9` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject10` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject11` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject12` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject13` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject14` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject15` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject16` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject17` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject18` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject19` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Subject20` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Total1` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total2` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total3` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total4` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total5` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total6` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total7` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total8` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total9` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total10` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `detailedinfo` varchar(20) DEFAULT NULL,
  `OtherInfo` varchar(40) CHARACTER SET utf8 DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 分析报表二
-- ----------------------------

-- ----------------------------
-- Table structure for `分班表`
-- ----------------------------
DROP TABLE IF EXISTS `分班表`;
CREATE TABLE `分班表` (
  `id` bigint(40) NOT NULL AUTO_INCREMENT,
  `准考证` varchar(40) DEFAULT NULL,
  `姓名` varchar(40) DEFAULT NULL,
  `入学学校` varchar(40) DEFAULT NULL,
  `总分` varchar(40) DEFAULT NULL,
  `身份证号码` varchar(40) DEFAULT NULL,
  `性别` varchar(40) DEFAULT NULL,
  `家庭住址` varchar(40) DEFAULT NULL,
  `电话` varchar(40) DEFAULT NULL,
  `语文` varchar(40) DEFAULT NULL,
  `数学` varchar(40) DEFAULT NULL,
  `英语` varchar(40) DEFAULT NULL,
  `听力` varchar(40) DEFAULT NULL,
  `自然` varchar(40) DEFAULT NULL,
  `总分一` varchar(40) DEFAULT NULL,
  `my_class_for_dividing` varchar(20) DEFAULT '0',
  `comm` varchar(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 分班表
-- ----------------------------

-- ----------------------------
-- Table structure for `分班表记录`
-- ----------------------------
DROP TABLE IF EXISTS `分班表记录`;
CREATE TABLE `分班表记录` (
  `id` tinyint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) DEFAULT NULL,
  `time` char(30) DEFAULT NULL,
  `accordingly` varchar(60) DEFAULT NULL,
  `accordingly2` varchar(50) DEFAULT NULL,
  `sex` varchar(50) DEFAULT NULL,
  `male` varchar(50) DEFAULT NULL,
  `female` varchar(50) DEFAULT NULL,
  `studentname` varchar(50) DEFAULT NULL,
  `origin` varchar(6) DEFAULT NULL,
  `cprimefield` varchar(100) DEFAULT NULL,
  `eprimefield` varchar(100) DEFAULT NULL,
  `gradeid` tinyint(2) DEFAULT NULL,
  `cfieldname` varchar(400) DEFAULT NULL,
  `efieldname` varchar(400) DEFAULT NULL,
  `insertornot` char(4) DEFAULT '否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 分班表记录
-- ----------------------------

-- ----------------------------
-- Table structure for `到学籍表`
-- ----------------------------
DROP TABLE IF EXISTS `到学籍表`;
CREATE TABLE `到学籍表` (
  `ID` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `TestName` varchar(30) CHARACTER SET utf8 DEFAULT 'empty',
  `GradeID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 到学籍表
-- ----------------------------

-- ----------------------------
-- Table structure for `学籍表`
-- ----------------------------
DROP TABLE IF EXISTS `学籍表`;
CREATE TABLE `学籍表` (
  `ID` bigint(50) unsigned NOT NULL AUTO_INCREMENT,
  `StudentNumber` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `name` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `sex` char(4) CHARACTER SET utf8 DEFAULT NULL,
  `nationality` char(8) CHARACTER SET utf8 DEFAULT NULL,
  `birthday` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `EntranceDate` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `class` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `Positon` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `HomeAddress` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Telephone` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `Residence` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `NativePlace` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `ParentA` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `NameOfParentA` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `WorkPlaceOfParentA` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TelephoneOfParentA` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `ParentB` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `NameOfParentB` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `WorkPlaceOfParentB` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TelephoneOfParentB` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Photo` longblob COMMENT 'pic',
  `ResidentStudent` tinyint(1) DEFAULT '0',
  `roomname` varchar(30) DEFAULT NULL,
  `bednumber` tinyint(2) DEFAULT NULL,
  `CommentOfThisTerm` text CHARACTER SET utf8,
  `GeneralComment` text CHARACTER SET utf8,
  `GeneralCommentTime` varchar(20) DEFAULT NULL,
  `MidTerm1` decimal(4,1) DEFAULT '0.0',
  `MidTerm2` decimal(4,1) DEFAULT '0.0',
  `MidTerm3` decimal(4,1) DEFAULT '0.0',
  `MidTerm4` decimal(4,1) DEFAULT '0.0',
  `MidTerm5` decimal(4,1) DEFAULT '0.0',
  `MidTerm6` decimal(4,1) DEFAULT '0.0',
  `MidTerm7` decimal(4,1) DEFAULT '0.0',
  `MidTerm8` decimal(4,1) DEFAULT '0.0',
  `MidTerm9` decimal(4,1) DEFAULT '0.0',
  `MidTerm10` decimal(4,1) DEFAULT '0.0',
  `MidTerm11` decimal(4,1) DEFAULT '0.0',
  `MidTerm12` decimal(4,1) DEFAULT '0.0',
  `MidTerm13` decimal(4,1) DEFAULT '0.0',
  `MidTerm14` decimal(4,1) DEFAULT '0.0',
  `MidTerm15` decimal(4,1) DEFAULT '0.0',
  `MidTerm16` decimal(4,1) DEFAULT '0.0',
  `MidTerm17` decimal(4,1) DEFAULT '0.0',
  `MidTerm18` decimal(4,1) DEFAULT '0.0',
  `MidTerm19` decimal(4,1) DEFAULT '0.0',
  `MidTerm20` decimal(4,1) DEFAULT '0.0',
  `TermEnd1` decimal(4,1) DEFAULT '0.0',
  `TermEnd2` decimal(4,1) DEFAULT '0.0',
  `TermEnd3` decimal(4,1) DEFAULT '0.0',
  `TermEnd4` decimal(4,1) DEFAULT '0.0',
  `TermEnd5` decimal(4,1) DEFAULT '0.0',
  `TermEnd6` decimal(4,1) DEFAULT '0.0',
  `TermEnd7` decimal(4,1) DEFAULT '0.0',
  `TermEnd8` decimal(4,1) DEFAULT '0.0',
  `TermEnd9` decimal(4,1) DEFAULT '0.0',
  `TermEnd10` decimal(4,1) DEFAULT '0.0',
  `TermEnd11` decimal(4,1) DEFAULT '0.0',
  `TermEnd12` decimal(4,1) DEFAULT '0.0',
  `TermEnd13` decimal(4,1) DEFAULT '0.0',
  `TermEnd14` decimal(4,1) DEFAULT '0.0',
  `TermEnd15` decimal(4,1) DEFAULT '0.0',
  `TermEnd16` decimal(4,1) DEFAULT '0.0',
  `TermEnd17` decimal(4,1) DEFAULT '0.0',
  `TermEnd18` decimal(4,1) DEFAULT '0.0',
  `TermEnd19` decimal(4,1) DEFAULT '0.0',
  `TermEnd20` decimal(4,1) DEFAULT '0.0',
  `LeavingDate` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingCause` char(100) CHARACTER SET utf8 DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` tinyint(3) DEFAULT '0',
  `IDcardNo` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `TypeOfClass` varchar(30) CHARACTER SET utf8 DEFAULT '无分类',
  `SN` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Other1` decimal(4,1) DEFAULT '0.0',
  `Other2` decimal(4,1) DEFAULT '0.0',
  `Other3` decimal(4,1) DEFAULT '0.0',
  `Other4` decimal(4,1) DEFAULT '0.0',
  `Other5` decimal(4,1) DEFAULT '0.0',
  `Other6` decimal(4,1) DEFAULT '0.0',
  `Other7` decimal(4,1) DEFAULT '0.0',
  `Other8` decimal(4,1) DEFAULT '0.0',
  `Other9` decimal(4,1) DEFAULT '0.0',
  `Other10` decimal(4,1) DEFAULT '0.0',
  `Other11` decimal(4,1) DEFAULT '0.0',
  `Other12` decimal(4,1) DEFAULT '0.0',
  `Other13` decimal(4,1) DEFAULT '0.0',
  `Other14` decimal(4,1) DEFAULT '0.0',
  `Other15` decimal(4,1) DEFAULT '0.0',
  `Other16` decimal(4,1) DEFAULT '0.0',
  `Other17` decimal(4,1) DEFAULT '0.0',
  `Other18` decimal(4,1) DEFAULT '0.0',
  `Other19` decimal(4,1) DEFAULT '0.0',
  `Other20` decimal(4,1) DEFAULT '0.0',
  `Morality` char(20) CHARACTER SET utf8 DEFAULT NULL COMMENT '思想品德评定',
  `LateArrival` smallint(2) DEFAULT '0' COMMENT '迟到次数',
  `ClassCutting` smallint(2) DEFAULT '0' COMMENT '旷课次数',
  `PersonalLeave` smallint(2) DEFAULT '0' COMMENT '事假次数',
  `SickLeave` smallint(2) DEFAULT '0' COMMENT '病假次数',
  `Reward` varchar(60) CHARACTER SET utf8 DEFAULT '无',
  `MidClassPlace` smallint(2) DEFAULT '0',
  `MidGradePlace` smallint(3) DEFAULT '0',
  `EndClassPlace` smallint(3) DEFAULT '0',
  `EndGradePlace` smallint(3) DEFAULT '0',
  `OtherClassPlace` smallint(3) DEFAULT '0',
  `OtherGradePlace` smallint(3) DEFAULT '0',
  `LeagueMember` char(4) CHARACTER SET utf8 DEFAULT '否',
  `LeagueJoiningTime` varchar(40) DEFAULT NULL,
  `Total` decimal(7,1) DEFAULT '0.0',
  `PersonalCode` bigint(10) DEFAULT '0',
  `SpareField` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 学籍表
-- ----------------------------

-- ----------------------------
-- Table structure for `总分统计法`
-- ----------------------------
DROP TABLE IF EXISTS `总分统计法`;
CREATE TABLE `总分统计法` (
  `TotalField` char(30) DEFAULT NULL,
  `ComputingMethod` varchar(300) DEFAULT NULL,
  `Description` varchar(255) DEFAULT NULL,
  `Time` char(50) DEFAULT NULL,
  `ID` bigint(100) unsigned NOT NULL AUTO_INCREMENT,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` int(3) DEFAULT '0',
  `Class` char(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 总分统计法
-- ----------------------------

-- ----------------------------
-- Table structure for `成绩单信息`
-- ----------------------------
DROP TABLE IF EXISTS `成绩单信息`;
CREATE TABLE `成绩单信息` (
  `id` tinyint(10) unsigned NOT NULL AUTO_INCREMENT,
  `info` text,
  `otherinfo` text,
  `class` varchar(40) DEFAULT NULL,
  `time` varchar(50) DEFAULT NULL,
  `print` char(4) DEFAULT 'no',
  `type` char(10) DEFAULT '横向',
  `subjects` varchar(150) DEFAULT NULL,
  `Csubjects` varchar(150) DEFAULT NULL,
  `gradeplace` char(8) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 成绩单信息
-- ----------------------------

-- ----------------------------
-- Table structure for `招生表格`
-- ----------------------------
DROP TABLE IF EXISTS `招生表格`;
CREATE TABLE `招生表格` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `识别码` varchar(255) DEFAULT NULL,
  `姓名` varchar(255) DEFAULT NULL,
  `班级` varchar(255) DEFAULT NULL,
  `准考证` varchar(255) DEFAULT NULL,
  `座位号` varchar(255) DEFAULT NULL,
  `试场` varchar(255) DEFAULT NULL,
  `语文` varchar(255) DEFAULT NULL,
  `生源类型` char(30) DEFAULT NULL,
  `缴费数额` decimal(7,1) DEFAULT '0.0',
  `身高` decimal(7,1) DEFAULT '0.0',
  `是否住校` char(30) DEFAULT '否',
  `操作员` char(20) DEFAULT NULL,
  `备注` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 招生表格
-- ----------------------------

-- ----------------------------
-- Table structure for `排序依据表`
-- ----------------------------
DROP TABLE IF EXISTS `排序依据表`;
CREATE TABLE `排序依据表` (
  `ID` smallint(20) NOT NULL AUTO_INCREMENT,
  `TypeOfClass` char(10) DEFAULT NULL COMMENT '排序分类',
  `AccordingToA` char(50) DEFAULT NULL COMMENT '中文显示',
  `AccordingToB` char(50) DEFAULT NULL COMMENT '字段名显示',
  `GradeID` tinyint(2) DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT NULL,
  `OtherInfo` char(80) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 排序依据表
-- ----------------------------

-- ----------------------------
-- Table structure for `操作记录表`
-- ----------------------------
DROP TABLE IF EXISTS `操作记录表`;
CREATE TABLE `操作记录表` (
  `id` mediumint(30) unsigned NOT NULL AUTO_INCREMENT,
  `user` char(100) DEFAULT NULL,
  `time` varchar(50) DEFAULT NULL,
  `Date` char(30) DEFAULT NULL,
  `operation` varchar(200) DEFAULT NULL,
  `otherinfo` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 操作记录表
-- ----------------------------

-- ----------------------------
-- Table structure for `教员表`
-- ----------------------------
DROP TABLE IF EXISTS `教员表`;
CREATE TABLE `教员表` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Sex` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Nationality` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Birthday` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HighestDegree` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `PoliticalSituation` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `WorkingTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `JoiningTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `WorkingYears` smallint(3) DEFAULT '0',
  `CaculatingTime` year(4) DEFAULT NULL,
  `Graduation` varchar(80) DEFAULT NULL,
  `ClassesOfWeek` smallint(2) DEFAULT NULL,
  `Position` varchar(60) DEFAULT NULL,
  `JobTitle` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TimeToGet` varchar(50) DEFAULT NULL,
  `FileNo` varchar(100) DEFAULT NULL,
  `Office` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `IDNumber` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `MobilePhoneNumber` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HomeAddress` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HomeTelephone` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `NativePlace` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Residence` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Photo` longblob,
  `PersonalResume` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `OtherMaterial` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingCause` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Level` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `cardtype` varchar(50) DEFAULT NULL,
  `governingzoneid` mediumint(10) DEFAULT NULL,
  `secrecy` char(4) DEFAULT NULL,
  `p_rank` varchar(40) DEFAULT NULL,
  `insurancedate` varchar(60) DEFAULT NULL,
  `unittype` varchar(60) DEFAULT NULL,
  `type_prereform` varchar(50) DEFAULT NULL,
  `tec_pos_grade_prereform` varchar(50) DEFAULT NULL,
  `tec_salary_grade_prereform` varchar(20) DEFAULT NULL,
  `management_grade_prereform` varchar(60) DEFAULT NULL,
  `management_salarygrade_prereform` varchar(20) DEFAULT NULL,
  `worker_pos_grade` varchar(60) DEFAULT NULL,
  `worker_salary_grade` varchar(20) DEFAULT NULL,
  `post_code` varchar(40) DEFAULT NULL,
  `email_add` varchar(100) DEFAULT NULL,
  `SpareField` varchar(40) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 教员表
-- ----------------------------

-- ----------------------------
-- Table structure for `最高分记录`
-- ----------------------------
DROP TABLE IF EXISTS `最高分记录`;
CREATE TABLE `最高分记录` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `TypeOfClass` varchar(40) DEFAULT NULL COMMENT 'class and typeofclass',
  `TestName` varchar(100) DEFAULT NULL,
  `Subject1` mediumint(4) DEFAULT '0',
  `Subject2` mediumint(4) DEFAULT '0',
  `Subject3` mediumint(4) DEFAULT '0',
  `Subject4` mediumint(4) DEFAULT '0',
  `Subject5` mediumint(4) DEFAULT '0',
  `Subject6` mediumint(4) DEFAULT '0',
  `Subject7` mediumint(4) DEFAULT '0',
  `Subject8` mediumint(4) DEFAULT '0',
  `Subject9` mediumint(4) DEFAULT '0',
  `Subject10` mediumint(4) DEFAULT '0',
  `Subject11` mediumint(4) DEFAULT '0',
  `Subject12` mediumint(4) DEFAULT '0',
  `Subject13` mediumint(4) DEFAULT '0',
  `Subject14` mediumint(4) DEFAULT '0',
  `Subject15` mediumint(4) DEFAULT '0',
  `Subject16` mediumint(4) DEFAULT '0',
  `Subject17` mediumint(4) DEFAULT '0',
  `Subject18` mediumint(4) DEFAULT '0',
  `Subject19` mediumint(4) DEFAULT '0',
  `Subject20` mediumint(4) DEFAULT '0',
  `Total1` mediumint(4) DEFAULT '0',
  `Total2` mediumint(4) DEFAULT '0',
  `Total3` mediumint(4) DEFAULT '0',
  `Total4` mediumint(4) DEFAULT '0',
  `Total5` mediumint(4) DEFAULT '0',
  `Total6` mediumint(4) DEFAULT '0',
  `Total7` mediumint(4) DEFAULT '0',
  `Total8` mediumint(4) DEFAULT '0',
  `Total9` mediumint(4) DEFAULT '0',
  `Total10` mediumint(4) DEFAULT '0',
  `Class` varchar(300) DEFAULT NULL,
  `GradeID` smallint(2) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 最高分记录
-- ----------------------------

-- ----------------------------
-- Table structure for `标准成绩`
-- ----------------------------
DROP TABLE IF EXISTS `标准成绩`;
CREATE TABLE `标准成绩` (
  `ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PersonalCode` bigint(10) DEFAULT '0',
  `name` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `class` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `ExamCode` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `DeskNo` varchar(4) DEFAULT NULL,
  `ExamRoom` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `RoomNo` varchar(20) DEFAULT NULL,
  `Subject1` decimal(4,1) DEFAULT '0.0',
  `Subject2` decimal(4,1) DEFAULT '0.0',
  `Subject3` decimal(4,1) DEFAULT '0.0',
  `Subject4` decimal(4,1) DEFAULT '0.0',
  `Subject5` decimal(4,1) DEFAULT '0.0',
  `Subject6` decimal(4,1) DEFAULT '0.0',
  `Subject7` decimal(4,1) DEFAULT '0.0',
  `Subject8` decimal(4,1) DEFAULT '0.0',
  `Subject9` decimal(4,1) DEFAULT '0.0',
  `Subject10` decimal(4,1) DEFAULT '0.0',
  `Subject11` decimal(4,1) DEFAULT '0.0',
  `Subject12` decimal(4,1) DEFAULT '0.0',
  `Subject13` decimal(4,1) DEFAULT '0.0',
  `Subject14` decimal(4,1) DEFAULT '0.0',
  `Subject15` decimal(4,1) DEFAULT '0.0',
  `Subject16` decimal(4,1) DEFAULT '0.0',
  `Subject17` decimal(4,1) DEFAULT '0.0',
  `Subject18` decimal(4,1) DEFAULT '0.0',
  `Subject19` decimal(4,1) DEFAULT '0.0',
  `Subject20` decimal(4,1) DEFAULT '0.0',
  `Total1` decimal(4,1) DEFAULT '0.0',
  `Total2` decimal(4,1) DEFAULT '0.0',
  `Total3` decimal(4,1) DEFAULT '0.0',
  `Total4` decimal(4,1) DEFAULT '0.0',
  `Total5` decimal(4,1) DEFAULT '0.0',
  `Total6` decimal(4,1) DEFAULT '0.0',
  `Total7` decimal(4,1) DEFAULT '0.0',
  `Total8` decimal(4,1) DEFAULT '0.0',
  `Total9` decimal(4,1) DEFAULT '0.0',
  `Total10` decimal(4,1) DEFAULT '0.0',
  `LastPlace` smallint(10) DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` tinyint(3) DEFAULT '0',
  `IDcardNo` varchar(20) CHARACTER SET utf8 DEFAULT '0',
  `TypeOfClass` varchar(30) CHARACTER SET utf8 DEFAULT '无分类',
  `ClassPlace` smallint(5) DEFAULT NULL,
  `GradePlace` smallint(5) DEFAULT NULL,
  `OtherInfo` varchar(40) CHARACTER SET utf8 DEFAULT '',
  `Guid` smallint(5) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 标准成绩
-- ----------------------------

-- ----------------------------
-- Table structure for `毕业时间表`
-- ----------------------------
DROP TABLE IF EXISTS `毕业时间表`;
CREATE TABLE `毕业时间表` (
  `GraduationTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 毕业时间表
-- ----------------------------

-- ----------------------------
-- Table structure for `毕业表`
-- ----------------------------
DROP TABLE IF EXISTS `毕业表`;
CREATE TABLE `毕业表` (
  `ID` bigint(50) unsigned NOT NULL AUTO_INCREMENT,
  `StudentNumber` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `name` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `sex` char(4) CHARACTER SET utf8 DEFAULT NULL,
  `nationality` char(8) CHARACTER SET utf8 DEFAULT NULL,
  `birthday` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `EntranceDate` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `class` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `Positon` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `HomeAddress` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Telephone` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `Residence` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `NativePlace` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `ParentA` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `NameOfParentA` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `WorkPlaceOfParentA` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TelephoneOfParentA` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `ParentB` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `NameOfParentB` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `WorkPlaceOfParentB` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TelephoneOfParentB` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Photo` longblob COMMENT 'pic',
  `ResidentStudent` tinyint(1) DEFAULT '0',
  `roomname` varchar(30) DEFAULT NULL,
  `bednumber` tinyint(2) DEFAULT NULL,
  `CommentOfThisTerm` text CHARACTER SET utf8,
  `GeneralComment` text CHARACTER SET utf8,
  `GeneralCommentTime` varchar(20) DEFAULT NULL,
  `MidTerm1` smallint(4) DEFAULT NULL,
  `MidTerm2` smallint(4) DEFAULT NULL,
  `MidTerm3` smallint(4) DEFAULT NULL,
  `MidTerm4` smallint(4) DEFAULT NULL,
  `MidTerm5` smallint(4) DEFAULT NULL,
  `MidTerm6` smallint(4) DEFAULT NULL,
  `MidTerm7` smallint(4) DEFAULT NULL,
  `MidTerm8` smallint(4) DEFAULT NULL,
  `MidTerm9` smallint(4) DEFAULT NULL,
  `MidTerm10` smallint(4) DEFAULT NULL,
  `MidTerm11` smallint(4) DEFAULT NULL,
  `MidTerm12` smallint(4) DEFAULT NULL,
  `MidTerm13` smallint(4) DEFAULT NULL,
  `MidTerm14` smallint(4) DEFAULT NULL,
  `MidTerm15` smallint(4) DEFAULT NULL,
  `MidTerm16` smallint(4) DEFAULT NULL,
  `MidTerm17` smallint(4) DEFAULT NULL,
  `MidTerm18` smallint(4) DEFAULT NULL,
  `MidTerm19` smallint(4) DEFAULT NULL,
  `MidTerm20` smallint(4) DEFAULT NULL,
  `TermEnd1` smallint(4) DEFAULT NULL,
  `TermEnd2` smallint(4) DEFAULT NULL,
  `TermEnd3` smallint(4) DEFAULT NULL,
  `TermEnd4` smallint(4) DEFAULT NULL,
  `TermEnd5` smallint(4) DEFAULT NULL,
  `TermEnd6` smallint(4) DEFAULT NULL,
  `TermEnd7` smallint(4) DEFAULT NULL,
  `TermEnd8` smallint(4) DEFAULT NULL,
  `TermEnd9` smallint(4) DEFAULT NULL,
  `TermEnd10` smallint(4) DEFAULT NULL,
  `TermEnd11` smallint(4) DEFAULT NULL,
  `TermEnd12` smallint(4) DEFAULT NULL,
  `TermEnd13` smallint(4) DEFAULT NULL,
  `TermEnd14` smallint(4) DEFAULT NULL,
  `TermEnd15` smallint(4) DEFAULT NULL,
  `TermEnd16` smallint(4) DEFAULT NULL,
  `TermEnd17` smallint(4) DEFAULT NULL,
  `TermEnd18` smallint(4) DEFAULT NULL,
  `TermEnd19` smallint(4) DEFAULT NULL,
  `TermEnd20` smallint(4) DEFAULT NULL,
  `LeavingDate` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingCause` char(100) CHARACTER SET utf8 DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` tinyint(3) DEFAULT '0',
  `IDcardNo` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `TypeOfClass` varchar(30) CHARACTER SET utf8 DEFAULT '无分类',
  `SN` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Other1` smallint(4) DEFAULT NULL,
  `Other2` smallint(4) DEFAULT NULL,
  `Other3` smallint(4) DEFAULT NULL,
  `Other4` smallint(4) DEFAULT NULL,
  `Other5` smallint(4) DEFAULT NULL,
  `Other6` smallint(4) DEFAULT NULL,
  `Other7` smallint(4) DEFAULT NULL,
  `Other8` smallint(4) DEFAULT NULL,
  `Other9` smallint(4) DEFAULT NULL,
  `Other10` smallint(4) DEFAULT NULL,
  `Other11` smallint(4) DEFAULT NULL,
  `Other12` smallint(4) DEFAULT NULL,
  `Other13` smallint(4) DEFAULT NULL,
  `Other14` smallint(4) DEFAULT NULL,
  `Other15` smallint(4) DEFAULT NULL,
  `Other16` smallint(4) DEFAULT NULL,
  `Other17` smallint(4) DEFAULT NULL,
  `Other18` smallint(4) DEFAULT NULL,
  `Other19` smallint(4) DEFAULT NULL,
  `Other20` smallint(4) DEFAULT NULL,
  `Morality` char(20) CHARACTER SET utf8 DEFAULT NULL COMMENT '思想品德评定',
  `LateArrival` smallint(2) DEFAULT '0' COMMENT '迟到次数',
  `ClassCutting` smallint(2) DEFAULT '0' COMMENT '旷课次数',
  `PersonalLeave` smallint(2) DEFAULT '0' COMMENT '事假次数',
  `SickLeave` smallint(2) DEFAULT '0' COMMENT '病假次数',
  `Reward` varchar(20) CHARACTER SET utf8 DEFAULT '无',
  `MidClassPlace` smallint(2) DEFAULT '0',
  `MidGradePlace` smallint(3) DEFAULT '0',
  `EndClassPlace` smallint(3) DEFAULT '0',
  `EndGradePlace` smallint(3) DEFAULT '0',
  `OtherClassPlace` smallint(3) DEFAULT '0',
  `OtherGradePlace` smallint(3) DEFAULT '0',
  `LeagueMember` char(4) CHARACTER SET utf8 DEFAULT '否',
  `LeagueJoiningTime` varchar(40) DEFAULT NULL,
  `Total` decimal(4,1) DEFAULT '0.0',
  `PersonalCode` bigint(10) DEFAULT '0',
  `SpareField` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 毕业表
-- ----------------------------

-- ----------------------------
-- Table structure for `班级表`
-- ----------------------------
DROP TABLE IF EXISTS `班级表`;
CREATE TABLE `班级表` (
  `Class` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `ClassTutor` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week11` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week12` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week13` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week14` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week15` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week16` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week17` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week18` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week21` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week22` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week23` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week24` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week25` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week26` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week27` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week28` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week31` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week32` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week33` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week34` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week35` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week36` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week37` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week38` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week41` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week42` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week43` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week44` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week45` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week46` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week47` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week48` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week51` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week52` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week53` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week54` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week55` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week56` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week57` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week58` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week61` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week62` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week63` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week64` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week65` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week66` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week67` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Week68` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `ClassCategories` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject1` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject2` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject3` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject4` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject5` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject6` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject7` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject8` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject9` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject10` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject11` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject12` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject13` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject14` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject15` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject16` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject17` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject18` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject19` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject20` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total1` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total2` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total3` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total4` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total5` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total6` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total7` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total8` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total9` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Total10` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `TypeOfClass` varchar(30) CHARACTER SET utf8 DEFAULT '无',
  `ClassID` smallint(5) NOT NULL DEFAULT '0',
  `GradeID` tinyint(3) NOT NULL DEFAULT '0',
  `Subject1T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject2T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject3T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject4T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject5T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject6T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject7T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject8T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject9T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject10T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject11T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject12T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject13T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject14T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject15T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject16T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject17T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject18T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject19T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Subject20T` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `FullSubject1` smallint(4) DEFAULT NULL,
  `FullSubject2` smallint(4) DEFAULT NULL,
  `FullSubject3` smallint(4) DEFAULT NULL,
  `FullSubject4` smallint(4) DEFAULT NULL,
  `FullSubject5` smallint(4) DEFAULT NULL,
  `FullSubject6` smallint(4) DEFAULT NULL,
  `FullSubject7` smallint(4) DEFAULT NULL,
  `FullSubject8` smallint(4) DEFAULT NULL,
  `FullSubject9` smallint(4) DEFAULT NULL,
  `FullSubject10` smallint(4) DEFAULT NULL,
  `FullSubject11` smallint(4) DEFAULT NULL,
  `FullSubject12` smallint(4) DEFAULT NULL,
  `FullSubject13` smallint(4) DEFAULT NULL,
  `FullSubject14` smallint(4) DEFAULT NULL,
  `FullSubject15` smallint(4) DEFAULT NULL,
  `FullSubject16` smallint(4) DEFAULT NULL,
  `FullSubject17` smallint(4) DEFAULT NULL,
  `FullSubject18` smallint(4) DEFAULT NULL,
  `FullSubject19` smallint(4) DEFAULT NULL,
  `FullSubject20` smallint(4) DEFAULT NULL,
  `FullTotal1` smallint(4) DEFAULT NULL,
  `FullTotal2` smallint(4) DEFAULT NULL,
  `FullTotal3` smallint(4) DEFAULT NULL,
  `FullTotal4` smallint(4) DEFAULT NULL,
  `FullTotal5` smallint(4) DEFAULT NULL,
  `FullTotal6` smallint(4) DEFAULT NULL,
  `FullTotal7` smallint(4) DEFAULT NULL,
  `FullTotal8` smallint(4) DEFAULT NULL,
  `FullTotal9` smallint(4) DEFAULT NULL,
  `FullTotal10` smallint(4) DEFAULT NULL,
  `SpareField` varchar(40) CHARACTER SET utf8 DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 班级表
-- ----------------------------

-- ----------------------------
-- Table structure for `生源设置`
-- ----------------------------
DROP TABLE IF EXISTS `生源设置`;
CREATE TABLE `生源设置` (
  `type` char(30) DEFAULT NULL,
  `totalname` varchar(50) DEFAULT NULL,
  `min` decimal(5,1) DEFAULT NULL,
  `max` decimal(5,1) DEFAULT NULL,
  `biggestnumber` int(4) DEFAULT NULL,
  `field` varchar(60) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 生源设置
-- ----------------------------

-- ----------------------------
-- Table structure for `登分表`
-- ----------------------------
DROP TABLE IF EXISTS `登分表`;
CREATE TABLE `登分表` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `PersonalCode` bigint(10) DEFAULT '0',
  `name` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `class` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `ExamCode` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `DeskNo` varchar(4) DEFAULT NULL,
  `ExamRoom` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `RoomNo` varchar(20) DEFAULT NULL,
  `Subject1` smallint(4) DEFAULT '0',
  `Subject2` smallint(4) DEFAULT '0',
  `Subject3` smallint(4) DEFAULT '0',
  `Subject4` smallint(4) DEFAULT '0',
  `Subject5` smallint(4) DEFAULT '0',
  `Subject6` smallint(4) DEFAULT '0',
  `Subject7` smallint(4) DEFAULT '0',
  `Subject8` smallint(4) DEFAULT '0',
  `Subject9` smallint(4) DEFAULT '0',
  `Subject10` smallint(4) DEFAULT '0',
  `Subject11` smallint(4) DEFAULT '0',
  `Subject12` smallint(4) DEFAULT '0',
  `Subject13` smallint(4) DEFAULT '0',
  `Subject14` smallint(4) DEFAULT '0',
  `Subject15` smallint(4) DEFAULT '0',
  `Subject16` smallint(4) DEFAULT '0',
  `Subject17` smallint(4) DEFAULT '0',
  `Subject18` smallint(4) DEFAULT '0',
  `Subject19` smallint(4) DEFAULT '0',
  `Subject20` smallint(4) DEFAULT '0',
  `Total1` smallint(4) DEFAULT '0',
  `Total2` smallint(4) DEFAULT '0',
  `Total3` smallint(4) DEFAULT '0',
  `Total4` smallint(4) DEFAULT '0',
  `Total5` smallint(4) DEFAULT '0',
  `Total6` smallint(4) DEFAULT '0',
  `Total7` smallint(4) DEFAULT '0',
  `Total8` smallint(4) DEFAULT '0',
  `Total9` smallint(4) DEFAULT '0',
  `Total10` smallint(4) DEFAULT '0',
  `LastPlace` smallint(10) DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` tinyint(3) DEFAULT '0',
  `IDcardNo` bigint(20) DEFAULT '0',
  `TypeOfClass` varchar(30) CHARACTER SET utf8 DEFAULT '无分类',
  `ClassPlace` smallint(5) DEFAULT NULL,
  `GradePlace` smallint(5) DEFAULT NULL,
  `OtherInfo` varchar(40) CHARACTER SET utf8 DEFAULT '',
  `Guid` smallint(5) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 登分表
-- ----------------------------

-- ----------------------------
-- Table structure for `登分表记录`
-- ----------------------------
DROP TABLE IF EXISTS `登分表记录`;
CREATE TABLE `登分表记录` (
  `ID` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `Time` varchar(20) CHARACTER SET utf8 DEFAULT NULL COMMENT '分登表生成日期',
  `TableName` varchar(40) CHARACTER SET utf8 DEFAULT NULL COMMENT '登分表名称，一般选择最大的id操作',
  `TableEnglishName` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `ExtraInfo` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `Operating` char(4) CHARACTER SET utf8 DEFAULT 'no',
  `OpenOrNot` char(3) CHARACTER SET utf8 DEFAULT 'no',
  `BakOrNot` char(4) CHARACTER SET utf8 DEFAULT 'no' COMMENT '是否备份了',
  `BakTime` varchar(30) CHARACTER SET utf8 DEFAULT NULL COMMENT '备份时间',
  `EmptyOrNot` char(4) CHARACTER SET utf8 DEFAULT 'yes',
  `WritingLevel` varchar(10) DEFAULT NULL,
  `GradeID` char(2) CHARACTER SET utf8 DEFAULT NULL,
  `Sequenced` varchar(40) DEFAULT '0' COMMENT '登分表排序时间',
  `Analyzed` varchar(40) DEFAULT '0' COMMENT '登分表分析一时间',
  `Two` tinyint(3) DEFAULT '0',
  `ShowWindow` tinyint(1) DEFAULT '0',
  `pm` tinyint(1) DEFAULT '0',
  `jt` tinyint(1) DEFAULT NULL,
  `zoukaoc` varchar(200) DEFAULT NULL,
  `zoukaoe` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 登分表记录
-- ----------------------------

-- ----------------------------
-- Table structure for `统分表记录`
-- ----------------------------
DROP TABLE IF EXISTS `统分表记录`;
CREATE TABLE `统分表记录` (
  `ID` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `Time` varchar(50) DEFAULT NULL COMMENT '分登表生成日期',
  `TableName` varchar(40) CHARACTER SET utf8 DEFAULT NULL COMMENT '登分表名称，一般选择最大的id操作',
  `TableEnglishName` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `including1` varchar(255) DEFAULT NULL,
  `including2` varchar(255) DEFAULT NULL,
  `GradeID` char(2) CHARACTER SET utf8 DEFAULT NULL,
  `percent` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 统分表记录
-- ----------------------------

-- ----------------------------
-- Table structure for `评语表`
-- ----------------------------
DROP TABLE IF EXISTS `评语表`;
CREATE TABLE `评语表` (
  `ID` int(50) unsigned NOT NULL AUTO_INCREMENT,
  `Type` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Sort` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Content` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Sample` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 评语表
-- ----------------------------
INSERT INTO `评语表` VALUES ('1', '小学评语库', '分类1', '你是一个懂事的孩子，小小年纪知道怎样管理好自己。', 'ddd');
INSERT INTO `评语表` VALUES ('2', '小学评语库', '分类1', '你是个热情大方心地善良、乐于助人的孩子。', 'fgg');
INSERT INTO `评语表` VALUES ('3', '小学评语库', '分类1', '做事踏实、认真，为人忠厚、老实，是你最突出的优点。', 'dggh');
INSERT INTO `评语表` VALUES ('4', '小学评语库', '分类1', '你是一个朴实的孩子，平时总是默默地做事、任劳任怨。', 'hj');
INSERT INTO `评语表` VALUES ('5', '小学评语库', '分类1', '你不爱说话，但勤奋好学，诚实可爱。', 'jkk');
INSERT INTO `评语表` VALUES ('6', '小学评语库', '分类1', '你是同学们可信赖的人，是老师较得力的助手。', 'kkll');
INSERT INTO `评语表` VALUES ('7', '小学评语库', '分类1', '你的聪明伶俐，心灵手巧给我留下深刻印象。', '');
INSERT INTO `评语表` VALUES ('8', '小学评语库', '分类1', '你活泼好动，争强好胜给我留下深刻印象。', '');
INSERT INTO `评语表` VALUES ('9', '小学评语库', '分类1', '你品学皆优、奋进向上，是老师最满意的学生。', '');
INSERT INTO `评语表` VALUES ('10', '小学评语库', '分类1', '你朴实无华，积极上进，身处逆境也永不退缩。', '');
INSERT INTO `评语表` VALUES ('11', '小学评语库', '分类1', '你是个懂礼貌、明事理的孩子，虽然不爱言语，对事物却有自己独到的见解。', '');
INSERT INTO `评语表` VALUES ('12', '小学评语库', '分类1', '虽然平日你默默无闻，却看得出你样样要强。', '');
INSERT INTO `评语表` VALUES ('13', '小学评语库', '分类1', '你是一个自我管理能力很强的好孩子，无论在哪你都能严格要求自己。', '');
INSERT INTO `评语表` VALUES ('14', '小学评语库', '分类1', '你是个人见人爱的小女孩，每件事都做得那么细致、认真。', '');
INSERT INTO `评语表` VALUES ('15', '小学评语库', '分类1', '你是一个聪明、勇敢、集体荣誉感极强的男子汉。', '');
INSERT INTO `评语表` VALUES ('16', '小学评语库', '分类1', '你很聪明，也很灵气，你本来不应该是一个普普通通的学生，只可惜，你太贪玩了。', '');
INSERT INTO `评语表` VALUES ('17', '小学评语库', '分类1', '你的自尊心很强，这本来会帮你成功，但你却常常因这而犯错。', '');
INSERT INTO `评语表` VALUES ('18', '小学评语库', '分类1', '不知你有没有觉察到自己性格暴躁，脾气大，希望能自觉控制自己的情绪。', '');
INSERT INTO `评语表` VALUES ('19', '小学评语库', '分类1', '你有时处理问题自以为是，一意孤行，课余有不文明的举止。', '');
INSERT INTO `评语表` VALUES ('21', '小学评语库', '分类2', '看着你的学习成绩不断进步，老师为你高兴、为你自豪。', '');
INSERT INTO `评语表` VALUES ('22', '小学评语库', '分类2', '你勤奋好学，在学习上有钻劲，学习成绩稳步提高。', '');
INSERT INTO `评语表` VALUES ('23', '小学评语库', '分类2', '你踏踏实实的学习态度换来了可喜的成绩。', '');
INSERT INTO `评语表` VALUES ('24', '小学评语库', '分类2', '在学习上你谦虚好学刻苦努力，学习成绩名列前茅。', '');
INSERT INTO `评语表` VALUES ('25', '小学评语库', '分类2', '学习成绩优秀，这有赖于你良好的学习习惯。', '');
INSERT INTO `评语表` VALUES ('26', '小学评语库', '分类2', '学习上的进步，老师和同学们都看在眼里，同样也为你感到高兴。', '');
INSERT INTO `评语表` VALUES ('27', '小学评语库', '分类2', '聪明的你在行为和学习习惯上都取得了很大的进步。', '');
INSERT INTO `评语表` VALUES ('28', '小学评语库', '分类2', '在学习上，好学上进，有一股不服输的韧劲儿。', '');
INSERT INTO `评语表` VALUES ('29', '小学评语库', '分类2', '在学习上，能够不断地何优秀生学习，弥补自己的不足。', '');
INSERT INTO `评语表` VALUES ('30', '小学评语库', '分类2', '在学习上，好学爱钻，不把问题搞清楚就誓不罢休的钻劲儿，是老师最欣赏你的地方。', '');
INSERT INTO `评语表` VALUES ('31', '小学评语库', '分类2', '在学习上很自觉，所以从来不会落到别人后面。', '');
INSERT INTO `评语表` VALUES ('32', '小学评语库', '分类2', '学习上你好学上进，积极要求进步，能够比较严格的要求自己。', '');
INSERT INTO `评语表` VALUES ('33', '小学评语库', '分类2', '后半学期，在学习上有很大进步，大家都为你的进步感到高兴。', '');
INSERT INTO `评语表` VALUES ('34', '小学评语库', '分类2', '学习成绩优秀，你是同学们的好榜样！', '');
INSERT INTO `评语表` VALUES ('35', '小学评语库', '分类2', '这学期你学习自觉了，成绩进步了，老师为你的进步而高兴。', '');
INSERT INTO `评语表` VALUES ('36', '小学评语库', '分类2', '学习上，你有很强的自觉性，成绩也基本稳定，如果你能讲究方法，多学多问，做得稳中有进就更好了。', '');
INSERT INTO `评语表` VALUES ('37', '小学评语库', '分类2', '你动作太慢，学习方法也有待改善，思维能力要进一步培养。', '');
INSERT INTO `评语表` VALUES ('38', '小学评语库', '分类2', '你的学习态度着实令老师着急，只要告别懒惰，相信你不会比别人差。', '');
INSERT INTO `评语表` VALUES ('39', '小学评语库', '分类2', '学习上你不够重视，上课容易分心，影响听课效率，这一点以后应改纠正。', '');
INSERT INTO `评语表` VALUES ('40', '小学评语库', '分类2', '你只要有什么不懂的及时向别人请教，成绩是会跟上来的，你并不是笨，只是还没有掌握学习的方法。', '');
INSERT INTO `评语表` VALUES ('41', '小学评语库', '分类3', '课上，你思维敏捷，积极回答问题，受到了各课老师的好评。', '');
INSERT INTO `评语表` VALUES ('42', '小学评语库', '分类3', '上课的时候能够积极思考，踊跃发言；', '');
INSERT INTO `评语表` VALUES ('43', '小学评语库', '分类3', '课上你能认真听讲，积极举手回答问题；', '');
INSERT INTO `评语表` VALUES ('44', '小学评语库', '分类3', '课堂上有时能听到你富有“创造性”的发言；', '');
INSERT INTO `评语表` VALUES ('45', '小学评语库', '分类3', '课堂上回答问题，声音清脆响亮；', '');
INSERT INTO `评语表` VALUES ('46', '小学评语库', '分类3', '课上你能集中注意力和老师配合完成课堂学习；', '');
INSERT INTO `评语表` VALUES ('47', '小学评语库', '分类3', '你的作业本干净，整齐，你抢着回答问题时急切的表情让老师感受到你对知识的渴望。', '');
INSERT INTO `评语表` VALUES ('48', '小学评语库', '分类3', '课堂作业总是第一个完成，而且准确率很高。', '');
INSERT INTO `评语表` VALUES ('49', '小学评语库', '分类3', '每当我看到你工工整整的作业，就忍不住停下来欣赏，刻若踏实的学习精神也很让我喜欢。', '');
INSERT INTO `评语表` VALUES ('50', '小学评语库', '分类3', '作业一次比一次整洁，成绩总是保持优良；', '');
INSERT INTO `评语表` VALUES ('51', '小学评语库', '分类3', '许多老师和同学都叹服你作业写得又快又认真。', '');
INSERT INTO `评语表` VALUES ('52', '小学评语库', '分类3', '你的作业本总是那么干干净净，整整齐齐，使老师总是看了一遍又一遍。', '');
INSERT INTO `评语表` VALUES ('53', '小学评语库', '分类3', '每次的作业都能欣赏到你那清秀的字体。', '');
INSERT INTO `评语表` VALUES ('54', '小学评语库', '分类3', '上课注意力不够集中，经常做小动作。', '');
INSERT INTO `评语表` VALUES ('55', '小学评语库', '分类3', '课堂上的回答声音是那么小，能大声点吗？', '');
INSERT INTO `评语表` VALUES ('56', '小学评语库', '分类3', '课堂上要多脑筋，多举手发言。', '');
INSERT INTO `评语表` VALUES ('57', '小学评语库', '分类3', '你做作业时表现出的字迹潦草、马虎粗心是那么明显。', '');
INSERT INTO `评语表` VALUES ('58', '小学评语库', '分类3', '但有时作业不能按时完成，字迹潦草。', '');
INSERT INTO `评语表` VALUES ('59', '小学评语库', '分类3', '你能按时完成作业，但错误较多，说明你写作业时不够认真。', '');
INSERT INTO `评语表` VALUES ('60', '小学评语库', '分类3', '如果做作业时能和\"细心\"交上朋友，相信你会更出色的。', '');
INSERT INTO `评语表` VALUES ('61', '小学评语库', '分类4', '不多言多语的你，总是把工作做得井井有条，从不让老师操心。', '');
INSERT INTO `评语表` VALUES ('62', '小学评语库', '分类4', '班集体的事你时刻放在心上，是个很热情的孩子。', '');
INSERT INTO `评语表` VALUES ('63', '小学评语库', '分类4', '你对班级工作认真负责，尤其是卫生清洁，总是任劳任怨，一丝不苟，从不推诿。', '');
INSERT INTO `评语表` VALUES ('64', '小学评语库', '分类4', '对待班集体的事情热心，喜欢帮助同学。', '');
INSERT INTO `评语表` VALUES ('65', '小学评语库', '分类4', '关心班集体，热爱劳动，总会不声不响的为集体做好事。', '');
INSERT INTO `评语表` VALUES ('66', '小学评语库', '分类4', '对于班里的事情，不论大小你总是抢着干，集体的荣誉你时时放在心上。', '');
INSERT INTO `评语表` VALUES ('67', '小学评语库', '分类4', '你对班级工作认真负责，而且能够虚心地接受老师对你的建议。', '');
INSERT INTO `评语表` VALUES ('68', '小学评语库', '分类4', '你工作积极，乐意为老师当小助手。', '');
INSERT INTO `评语表` VALUES ('69', '小学评语库', '分类4', '课下你同大家一起把我们的班集体建设的那样好，班里的每一面红旗都有你的一份努力。', '');
INSERT INTO `评语表` VALUES ('70', '小学评语库', '分类4', '担任***的你更是能严格要求自己，积极组织各种活动，对工作认真负责的劲真让人佩服！', '');
INSERT INTO `评语表` VALUES ('71', '小学评语库', '分类4', '担任***后，你更是能严格要求自己，处处做同学们的榜样，真棒！', '');
INSERT INTO `评语表` VALUES ('72', '小学评语库', '分类4', '对***工作，认真负责、勤勤恳恳，是个称职的好干部。', '');
INSERT INTO `评语表` VALUES ('73', '小学评语库', '分类4', '科代表工作认真负责，能主动帮助老师搞好班里的工作。', '');
INSERT INTO `评语表` VALUES ('74', '小学评语库', '分类4', '在班里每次都能积极主动地做好值日生工作。', '');
INSERT INTO `评语表` VALUES ('75', '小学评语库', '分类4', '你对班级工作认真负责，在任何情况下，总是稳稳当当、扎扎实实地完成老师交给的任务。', '');
INSERT INTO `评语表` VALUES ('76', '小学评语库', '分类4', '你热爱集体，关心同学，能热心为班极、为同学服务。', '');
INSERT INTO `评语表` VALUES ('77', '小学评语库', '分类4', '你不够重视劳动，未能按时完成日常的值日工作，态度较马虎。', '');
INSERT INTO `评语表` VALUES ('78', '小学评语库', '分类4', '你做值日生时有嫌脏怕累的思想，有时不听组长的指挥。', '');
INSERT INTO `评语表` VALUES ('79', '小学评语库', '分类4', '班务工作，你不够主动大胆，所以尽管付出了一定的时间和精力，但效果较差。', '');
INSERT INTO `评语表` VALUES ('80', '小学评语库', '分类4', '在班务工作中要发扬优点，并在工作上多想想办法，你会更加优秀。', '');
INSERT INTO `评语表` VALUES ('81', '小学评语库', '分类5', '能接受别人的批评和帮助，待人真诚，别人的优点能主动学习。', '');
INSERT INTO `评语表` VALUES ('82', '小学评语库', '分类5', '你的心地比较善良，能同情理解别人，许多同学都把你当作知己。', '');
INSERT INTO `评语表` VALUES ('83', '小学评语库', '分类5', '你对同学十分友善，态度谦和。', '');
INSERT INTO `评语表` VALUES ('84', '小学评语库', '分类5', '平时，你对人有礼貌，和同学相处融洽。', '');
INSERT INTO `评语表` VALUES ('85', '小学评语库', '分类5', '在班里与同学友爱相处，遇到老师能主动打招呼。', '');
INSERT INTO `评语表` VALUES ('86', '小学评语库', '分类5', '待人接物，举止大方，对同学充满爱心。', '');
INSERT INTO `评语表` VALUES ('87', '小学评语库', '分类5', '你待人真诚，守信用。', '');
INSERT INTO `评语表` VALUES ('88', '小学评语库', '分类5', '每当别人有困难时，你总是尽其所能地帮助。', '');
INSERT INTO `评语表` VALUES ('89', '小学评语库', '分类5', '对人有礼貌，说话讲究文明用语。', '');
INSERT INTO `评语表` VALUES ('90', '小学评语库', '分类5', '你的正直赢得了同学们对你的信任。', '');
INSERT INTO `评语表` VALUES ('91', '小学评语库', '分类5', '善于同学交往，珍惜同学之间的友谊，与人相处能乐于助人，不计个人得失。', '');
INSERT INTO `评语表` VALUES ('92', '小学评语库', '分类5', '与人相处能够让人信任，能善意地指出别人的错误，具有较强的集体主义观念。', '');
INSERT INTO `评语表` VALUES ('93', '小学评语库', '分类5', '遇到同学有矛盾的时候，你总是主动积极规劝，对有困难同学能毫不犹豫地伸出援助之手。', '');
INSERT INTO `评语表` VALUES ('94', '小学评语库', '分类5', '但你性格内向,不爱敞开心扉与同学交朋友。', '');
INSERT INTO `评语表` VALUES ('95', '小学评语库', '分类5', '可你太文静了，要多与同学沟通。', '');
INSERT INTO `评语表` VALUES ('96', '小学评语库', '分类5', '可惜你听不进别人的劝告，性格过于固执。', '');
INSERT INTO `评语表` VALUES ('97', '小学评语库', '分类5', '你比较怕事不爱言语，要注意与同学沟通。', '');
INSERT INTO `评语表` VALUES ('98', '小学评语库', '分类5', '同学相处，注意真诚和宽容。', '');
INSERT INTO `评语表` VALUES ('99', '小学评语库', '分类5', '要乐于接受老师的批评。', '');
INSERT INTO `评语表` VALUES ('100', '小学评语库', '分类5', '你能够勇于揭发不良现象，帮助同学改正错误。', '');
INSERT INTO `评语表` VALUES ('101', '小学评语库', '分类6', '绘画是你的特长，常在墙报上看到你的作品。', '');
INSERT INTO `评语表` VALUES ('102', '小学评语库', '分类6', '你能歌善舞，是班级中的文娱积极分子。', '');
INSERT INTO `评语表` VALUES ('103', '小学评语库', '分类6', '你在校运会上每次都为班级争得了荣誉。', '');
INSERT INTO `评语表` VALUES ('104', '小学评语库', '分类6', '你是咱们班的运动健将，跑道上总能看见你矫健的身影。', '');
INSERT INTO `评语表` VALUES ('105', '小学评语库', '分类6', '体育比赛中你灵活的动作轻盈的跳跃给老师留下了深刻的印象。', '');
INSERT INTO `评语表` VALUES ('106', '小学评语库', '分类6', '文艺、体育你样样拿手，咱们班好多同学都特别佩服你。', '');
INSERT INTO `评语表` VALUES ('107', '小学评语库', '分类6', '由于你广泛阅读课外书籍，必将为你的人生增添光彩。', '');
INSERT INTO `评语表` VALUES ('108', '小学评语库', '分类6', '真高兴经常看到你在黑板报上留下的漂亮的粉笔字。', '');
INSERT INTO `评语表` VALUES ('109', '小学评语库', '分类6', '特别令我高兴的是你的作文水平还是不错的。', '');
INSERT INTO `评语表` VALUES ('110', '小学评语库', '分类6', '你的日记写得真有趣呀，给老师和同学们留下了多么深刻的印象。', '');
INSERT INTO `评语表` VALUES ('111', '小学评语库', '分类6', '老师从你的日记里得知你非常喜欢电脑，而且在这方面有着丰富的知识。', '');
INSERT INTO `评语表` VALUES ('112', '小学评语库', '分类6', '你是我们班上出了名的小画家。', '');
INSERT INTO `评语表` VALUES ('113', '小学评语库', '分类6', '你还是我们班的小歌星呢！', '');
INSERT INTO `评语表` VALUES ('114', '小学评语库', '分类6', '你在音乐，绘画等方面都有特长，在其它方面也表现不错。', '');
INSERT INTO `评语表` VALUES ('115', '小学评语库', '分类6', '你有说相声的才能，常常逗得大家前仰后合。', '');
INSERT INTO `评语表` VALUES ('116', '小学评语库', '分类6', '你的体育成绩未能令人满意，需加强锻炼。', '');
INSERT INTO `评语表` VALUES ('117', '小学评语库', '分类6', '你身体太差，这直接影响到你的学习，需要加强体育锻炼。', '');
INSERT INTO `评语表` VALUES ('118', '小学评语库', '分类7', '希望你继续努力，争取更大的进步。', '');
INSERT INTO `评语表` VALUES ('119', '小学评语库', '分类7', '多一份勤奋，多一份刻苦，持之以恒地努力下去，你会取得好成绩。', '');
INSERT INTO `评语表` VALUES ('120', '小学评语库', '分类7', '老师还希望你能够戒骄戒躁，踏踏实实地搞好学习，争取成为全面发展的好孩子。', '');
INSERT INTO `评语表` VALUES ('121', '小学评语库', '分类7', '在下学期里，希望你能够做老师的小助手，帮助其他同学更快的进步。', '');
INSERT INTO `评语表` VALUES ('122', '小学评语库', '分类7', '今后多读一些书，积累好词好句，用以提高自己的作文水平，好吗？', '');
INSERT INTO `评语表` VALUES ('123', '小学评语库', '分类7', '老师希望你百尺竿头更进一步，争取在新的学期里取得更大进步！', '');
INSERT INTO `评语表` VALUES ('124', '小学评语库', '分类7', '在下学期里，应该端正学习的态度，按时完成作业，让学习成为一件乐事', '');
INSERT INTO `评语表` VALUES ('125', '小学评语库', '分类7', '望你继续努力，老师关注着你的进步。', '');
INSERT INTO `评语表` VALUES ('126', '小学评语库', '分类7', '希望你能改掉贪玩的毛病，端正学习态度，在新的一年里，争取更大的进步。', '');
INSERT INTO `评语表` VALUES ('127', '小学评语库', '分类7', '希望你在课堂上能认真听讲，开动脑筋，遇到问题敢于请教。', '');
INSERT INTO `评语表` VALUES ('128', '小学评语库', '分类7', '老师最希望看到你的作业干净、整齐。', '');
INSERT INTO `评语表` VALUES ('129', '小学评语库', '分类7', '今后如果你能认真做每一次的作业，不断努力，相信你的学习成绩会有很大的提高，你有信心吗？', '');
INSERT INTO `评语表` VALUES ('130', '小学评语库', '分类7', '希望你能够和马虎“断交”，向着更高的目标迈进。', '');
INSERT INTO `评语表` VALUES ('131', '小学评语库', '分类7', '你的作业本上缺少干净、工整，你能想想办法吗？', '');
INSERT INTO `评语表` VALUES ('132', '小学评语库', '分类7', '有时你却让老师头疼，作业本上缺少干净和整齐，**成绩还有待提高，你能努力让自己做得更好吗？', '');
INSERT INTO `评语表` VALUES ('133', '小学评语库', '分类7', '假期里，你如果能抓紧时间补一补课，下学期你一定会赶上来的！', '');
INSERT INTO `评语表` VALUES ('134', '小学评语库', '分类7', '希望以后积极参加学校组织的各项文体活动。', '');
INSERT INTO `评语表` VALUES ('135', '小学评语库', '分类7', '希望你今后能够改掉浮躁的坏毛病，争取成为一个全面发展的好孩子！', '');
INSERT INTO `评语表` VALUES ('136', '中学评语库', '分类1', '本学期思想日臻成熟，心理趋于稳定，成绩有所提高。', '');
INSERT INTO `评语表` VALUES ('137', '中学评语库', '分类1', '经历了前一段时间的松懈以及由此带来的成绩下跌后，能反躬自省，端正态度，思想日臻成熟。', '');
INSERT INTO `评语表` VALUES ('138', '中学评语库', '分类1', '沉稳深刻、思维严密是你的优点。', '');
INSERT INTO `评语表` VALUES ('139', '中学评语库', '分类1', '具有一个农家孩子朴素、勤奋的品质，你的自立能力给人印象深刻。', '');
INSERT INTO `评语表` VALUES ('140', '中学评语库', '分类1', '领悟力强，为人诚朴，品行端正，温文尔雅。', '');
INSERT INTO `评语表` VALUES ('141', '中学评语库', '分类1', '眉清目秀，机智敏捷，你的身上洋溢着青春的气息，你应该是一位有出息的女孩。', '');
INSERT INTO `评语表` VALUES ('142', '中学评语库', '分类1', '你本学期以来，心理上成熟了许多，为人处事有了自己的主见。', '');
INSERT INTO `评语表` VALUES ('143', '中学评语库', '分类1', '你的勤奋刻苦是无与伦比的，你惊人的意志力令我欣慰不已。', '');
INSERT INTO `评语表` VALUES ('144', '中学评语库', '分类1', '你是一个守纪、肯学、求上进的学生，为人谨慎，心性坦荡。', '');
INSERT INTO `评语表` VALUES ('145', '中学评语库', '分类1', '你思想上积极要求上进，为人诚恳，思维敏捷，有较强的接受能力。', '');
INSERT INTO `评语表` VALUES ('146', '中学评语库', '分类1', '你忠实厚道，朴直豁达，自信乐群是你成功的前提和保证。', '');
INSERT INTO `评语表` VALUES ('147', '中学评语库', '分类1', '你有非常优秀的领悟力和理解力，思维的严谨性堪称一流。', '');
INSERT INTO `评语表` VALUES ('148', '中学评语库', '分类1', '你思想较单纯，有良好的文明卫生习惯，集体活动积极。', '');
INSERT INTO `评语表` VALUES ('149', '中学评语库', '分类1', '勤勤恳恳，埋头作业，整洁大方是你给诸位老师留下的共同印象。', '');
INSERT INTO `评语表` VALUES ('150', '中学评语库', '分类1', '顽强的意志力和拼搏精神感染着每一个人，不愧是班级同学的榜样。', '');
INSERT INTO `评语表` VALUES ('151', '中学评语库', '分类1', '学习踏踏实实，做人认认真真。', '');
INSERT INTO `评语表` VALUES ('152', '中学评语库', '分类1', '你头脑聪明，但你没有充分利用，你的精力较分散，花在学习上的精力不多。', '');
INSERT INTO `评语表` VALUES ('153', '中学评语库', '分类1', '不知你有没有觉察到自己性格暴躁，脾气大，希望能自觉控制自己的情绪。', '');
INSERT INTO `评语表` VALUES ('154', '中学评语库', '分类1', '你平时处理问题以自我为中心，不太注意考虑别人的感受。', '');
INSERT INTO `评语表` VALUES ('155', '中学评语库', '分类1', '你平时待人接物不够大方，过分计较个人的得失。', '');
INSERT INTO `评语表` VALUES ('156', '中学评语库', '分类2', '成绩进步很大，能力也有了提高，更重要的是探索出了一条适合自己的道路。', '');
INSERT INTO `评语表` VALUES ('157', '中学评语库', '分类2', '你在本学期进步非常显著，辛勤的耕耘终于有了丰硕的回报。', '');
INSERT INTO `评语表` VALUES ('158', '中学评语库', '分类2', '你能合理地安排作息时间，不为各种言行左右，把精力放在学习上，让师长放心，真的难能可贵。', '');
INSERT INTO `评语表` VALUES ('159', '中学评语库', '分类2', '本学期最突出的成果是学习逐步走向正轨，逐渐掌握了高中课程的学习方法。', '');
INSERT INTO `评语表` VALUES ('160', '中学评语库', '分类2', '经过一个学期的努力，成绩终于达到预期的水平，这与你这个学期踏实的学风不无关系。', '');
INSERT INTO `评语表` VALUES ('161', '中学评语库', '分类2', '你有较强的应变力和适应力，善于调整自己的知识结构，学习踏实，表现优秀。', '');
INSERT INTO `评语表` VALUES ('162', '中学评语库', '分类2', '努力、执着、向上，是你步步攀登的力量；拼搏、追求、奋斗，是你学业成功的保证。', '');
INSERT INTO `评语表` VALUES ('163', '中学评语库', '分类2', '你的学习有所进步，尽管步履艰难，但说明你是在努力了，对此老师感到欣慰。', '');
INSERT INTO `评语表` VALUES ('164', '中学评语库', '分类2', '你有良好的思维能力，有思想深度，自立自强，未来充满了希望。', '');
INSERT INTO `评语表` VALUES ('165', '中学评语库', '分类2', '一贯保持旺盛的拼搏进取精神，学习非常的刻苦自觉，成绩优良。', '');
INSERT INTO `评语表` VALUES ('166', '中学评语库', '分类2', '学习避免了浅尝辄止，能深入钻研，形成了良好的学习方法。', '');
INSERT INTO `评语表` VALUES ('167', '中学评语库', '分类2', '你有优秀的思维素质和能力，学习异常刻苦，成绩优异。', '');
INSERT INTO `评语表` VALUES ('168', '中学评语库', '分类2', '你有强烈的进取心，有端正的学习态度。', '');
INSERT INTO `评语表` VALUES ('169', '中学评语库', '分类2', '成绩稳定，但有提高的很大空间，你要关注学习方法，提高效率，向更高的目标迈进。', '');
INSERT INTO `评语表` VALUES ('170', '中学评语库', '分类2', '保持当前良好的学习心态，激发学习热情，是当务之急。', '');
INSERT INTO `评语表` VALUES ('171', '中学评语库', '分类2', '理科的学习仍是困难多多，应在学法上多加思索，加强练习，提高成绩。', '');
INSERT INTO `评语表` VALUES ('172', '中学评语库', '分类2', '你未能培养起良好的学习品质，缺乏顽强的学习意志和科学的学习方法。', '');
INSERT INTO `评语表` VALUES ('173', '中学评语库', '分类2', '上课不能认真听讲，有些得过且过，缺乏朝气。', '');
INSERT INTO `评语表` VALUES ('174', '中学评语库', '分类2', '对学习的主动性还不够，学习的专注、严谨离老师的希望仍有差距。', '');
INSERT INTO `评语表` VALUES ('175', '中学评语库', '分类2', '在学习上，没有紧迫感，缺少动力。', '');
INSERT INTO `评语表` VALUES ('176', '中学评语库', '分类3', '上课能专心听讲，注意力集中。', '');
INSERT INTO `评语表` VALUES ('177', '中学评语库', '分类3', '上课时能积极思考老师提出的问题。', '');
INSERT INTO `评语表` VALUES ('178', '中学评语库', '分类3', '课前你是充分的，课上你是认真的，课后你是自信的。', '');
INSERT INTO `评语表` VALUES ('179', '中学评语库', '分类3', '上课的时候能够积极思考，踊跃发言', '');
INSERT INTO `评语表` VALUES ('180', '中学评语库', '分类3', '课堂上常常能回答出别人难以回答的问题。', '');
INSERT INTO `评语表` VALUES ('181', '中学评语库', '分类3', '课堂上常常发挥出良好的语言表达能力。', '');
INSERT INTO `评语表` VALUES ('182', '中学评语库', '分类3', '课上你能集中注意力和老师配合完成课堂学习。', '');
INSERT INTO `评语表` VALUES ('183', '中学评语库', '分类3', '能自觉遵守学校的各项规章制度，自觉抵制各种不良思想。', '');
INSERT INTO `评语表` VALUES ('184', '中学评语库', '分类3', '儒雅的你，上课总是全神贯注，无论是作业还是考试，书写总是工工整整。', '');
INSERT INTO `评语表` VALUES ('185', '中学评语库', '分类3', '课堂上你精彩的发言常常博得阵阵掌声，也给老师留下了很好印象。', '');
INSERT INTO `评语表` VALUES ('186', '中学评语库', '分类3', '工整、正确的作业常常是同学的榜样。', '');
INSERT INTO `评语表` VALUES ('187', '中学评语库', '分类3', '认真完成作业，背书速度较快，记忆力较强。', '');
INSERT INTO `评语表` VALUES ('188', '中学评语库', '分类3', '在完成作业的基础上，能自觉钻研。', '');
INSERT INTO `评语表` VALUES ('189', '中学评语库', '分类3', '作业里的字体还太潦草，能否把写好一点呢', '');
INSERT INTO `评语表` VALUES ('190', '中学评语库', '分类3', '有时上课注意力不够集中，还有些小动作。', '');
INSERT INTO `评语表` VALUES ('191', '中学评语库', '分类4', '班级活动能主动献策出力，同学关系融洽。', '');
INSERT INTO `评语表` VALUES ('192', '中学评语库', '分类4', '热心班集体工作，能协助老师完成班务工作。', '');
INSERT INTO `评语表` VALUES ('193', '中学评语库', '分类4', '你积极参加集体活动，勇于为班级争光，品行较好。', '');
INSERT INTO `评语表` VALUES ('194', '中学评语库', '分类4', '为人朴实，性格沉静，虽然言语不多，但能感觉出你对班级的关心和参与。', '');
INSERT INTO `评语表` VALUES ('195', '中学评语库', '分类4', '你对同学的关心和出色的组织活动能力，使整个班级都受益匪浅。', '');
INSERT INTO `评语表` VALUES ('196', '中学评语库', '分类4', '你能认真负责地完成老师布置的任务，起好带头作用，在同学中有一定的威信。', '');
INSERT INTO `评语表` VALUES ('197', '中学评语库', '分类4', '科代表工作认真负责，能主动帮助老师搞好班里的工作。', '');
INSERT INTO `评语表` VALUES ('198', '中学评语库', '分类4', '平时能自觉遵守校纪班规，爱护班级公物和卫生，有较强的集体主义观点。', '');
INSERT INTO `评语表` VALUES ('199', '中学评语库', '分类4', '平时劳动积极，每次大扫除，你总是主动积极完成任务。', '');
INSERT INTO `评语表` VALUES ('200', '中学评语库', '分类4', '对班上的坏人坏事敢于大胆揭发。', '');
INSERT INTO `评语表` VALUES ('201', '中学评语库', '分类4', '劳动时你总是默默无闻地出色完成任务。', '');
INSERT INTO `评语表` VALUES ('202', '中学评语库', '分类4', '在班务工作中积极主动，细心负责，为老师分担了不少的工作，深得老师和同学的好评。', '');
INSERT INTO `评语表` VALUES ('203', '中学评语库', '分类4', '小组长工作能以身作则，大胆督促同学。', '');
INSERT INTO `评语表` VALUES ('204', '中学评语库', '分类4', '你是一名优秀的班干部，对自己的本职工作尤其负责，收发作业，认真及时。', '');
INSERT INTO `评语表` VALUES ('205', '中学评语库', '分类4', '你待人善良，律己严格，具有强烈的责任感和服务意识，且工作能力很强。', '');
INSERT INTO `评语表` VALUES ('206', '中学评语库', '分类4', '班务工作，你不够主动大胆，所以尽管付出了一定的时间和精力，但效果较差。', '');
INSERT INTO `评语表` VALUES ('207', '中学评语库', '分类4', '你不够重视劳动，未能按时完成日常的值日工作，态度较马虎。', '');
INSERT INTO `评语表` VALUES ('208', '中学评语库', '分类5', '由于你的宽厚仁道，不激进，不与人争锋，使同学都乐意亲近你。', '');
INSERT INTO `评语表` VALUES ('209', '中学评语库', '分类5', '你的心地比较善良，能同情理解别人，许多同学都把你当作知己。', '');
INSERT INTO `评语表` VALUES ('210', '中学评语库', '分类5', '你能够和同学之间互相帮助，自信、乐观、和群。', '');
INSERT INTO `评语表` VALUES ('211', '中学评语库', '分类5', '你的适应能力很强，与同学们打得火热，无话不说，活泼开朗。', '');
INSERT INTO `评语表` VALUES ('212', '中学评语库', '分类5', '你善良、朴实、懂事，做事一贯认真，经常帮助教师排忧解难，帮助其他同学攻克难关。', '');
INSERT INTO `评语表` VALUES ('213', '中学评语库', '分类5', '你思想纯朴，待人随和、诚恳，处事稳重；同学关系好，热爱集体，乐意助人。', '');
INSERT INTO `评语表` VALUES ('214', '中学评语库', '分类5', '你有很多优秀的品质，遵守纪律，认真学习，和同学相处时宽容大度，热心班上的人和事。', '');
INSERT INTO `评语表` VALUES ('215', '中学评语库', '分类5', '同学们都喜欢围在你身边，和你一起玩，因为你善解人意，宽容大方。', '');
INSERT INTO `评语表` VALUES ('216', '中学评语库', '分类5', '你能够和每一位同学成为好朋友，也能时时为别人着想，体贴和关心身边的每一个人。', '');
INSERT INTO `评语表` VALUES ('217', '中学评语库', '分类5', '你有一颗善良包容的心，你对人很温和，有副好脾气。', '');
INSERT INTO `评语表` VALUES ('218', '中学评语库', '分类5', '你活泼可爱，为人坦诚。', '');
INSERT INTO `评语表` VALUES ('219', '中学评语库', '分类5', '能接受别人的批评和帮助，待人真诚，别人的优点能主动学习。', '');
INSERT INTO `评语表` VALUES ('220', '中学评语库', '分类5', '你为人诚实，与同学关系相处不错。', '');
INSERT INTO `评语表` VALUES ('221', '中学评语库', '分类5', '你对同学十分友善，态度谦和。', '');
INSERT INTO `评语表` VALUES ('222', '中学评语库', '分类5', '同学们都喜欢围在你身边，和你一起玩，因为你善解人意，宽容大度。', '');
INSERT INTO `评语表` VALUES ('223', '中学评语库', '分类5', '对人有礼貌，说话讲究文明用语，很少与别人发生矛盾。', '');
INSERT INTO `评语表` VALUES ('224', '中学评语库', '分类5', '你情绪波动较大，遇到不开心的事情时就会郁郁寡欢，与其他同学隔开距离，这样也影响到学习的成绩。', '');
INSERT INTO `评语表` VALUES ('225', '中学评语库', '分类6', '你的写作水平出类拔萃，每次作文都会被老师当作范文在全班朗读，优美的语句让同学们非常佩服。', '');
INSERT INTO `评语表` VALUES ('226', '中学评语库', '分类6', '你的口头表达能力较强，有一定的演讲才能。', '');
INSERT INTO `评语表` VALUES ('227', '中学评语库', '分类6', '你特别喜爱阅读课外书籍，写作能力较高。', '');
INSERT INTO `评语表` VALUES ('228', '中学评语库', '分类6', '你能写一手好字，人见人夸。', '');
INSERT INTO `评语表` VALUES ('229', '中学评语库', '分类6', '你平时能广泛阅读课外书，所以文笔优美，使人看了惊叹。', '');
INSERT INTO `评语表` VALUES ('230', '中学评语库', '分类6', '你不但弹得一手好吉他，还弹得一手好钢琴。', '');
INSERT INTO `评语表` VALUES ('231', '中学评语库', '分类6', '你那婀娜的舞姿，成了同学们心中一道美丽的风景线。', '');
INSERT INTO `评语表` VALUES ('232', '中学评语库', '分类6', '你能歌善舞，是班级中的文娱积极分子。', '');
INSERT INTO `评语表` VALUES ('233', '中学评语库', '分类6', '你在音乐，绘画等方面都有特长，在其它方面也表现不错。', '');
INSERT INTO `评语表` VALUES ('234', '中学评语库', '分类6', '辩论会上你口若悬河，让同学十分叹服。', '');
INSERT INTO `评语表` VALUES ('235', '中学评语库', '分类6', '你好像很关心国家大事，因为每次谈到有关国内新闻或国际风云，你往往能侃侃而谈，令人赞叹。', '');
INSERT INTO `评语表` VALUES ('236', '中学评语库', '分类6', '你的笛子吹得真棒，清脆悦耳，让大家佩服。', '');
INSERT INTO `评语表` VALUES ('237', '中学评语库', '分类6', '你写的作文很好，平凡的语言中散发不平凡的魅力。', '');
INSERT INTO `评语表` VALUES ('238', '中学评语库', '分类6', '你是咱们班的运动健将，跑道上总能看见你矫健的身影。', '');
INSERT INTO `评语表` VALUES ('239', '中学评语库', '分类6', '运动赛场上，你是班级和学校的骄傲，总是用优异的体育成绩向老师和同学们报喜。', '');
INSERT INTO `评语表` VALUES ('240', '中学评语库', '分类6', '真高兴经常看到你在黑板报上留下的漂亮的粉笔字。', '');
INSERT INTO `评语表` VALUES ('241', '中学评语库', '分类6', '丰富的课外生活和广泛的兴趣爱好使你越来越聪明活泼。', '');
INSERT INTO `评语表` VALUES ('242', '中学评语库', '分类7', '老师真诚地希望你充分发挥自己的聪明才智，努力开拓学习的深度和广度。', '');
INSERT INTO `评语表` VALUES ('243', '中学评语库', '分类7', '面对越来越近的高考，你应该更加清醒，只有坚持到最后一刻，才能把成功紧紧握在手中。', '');
INSERT INTO `评语表` VALUES ('244', '中学评语库', '分类7', '希望多关注学法，提高效率，愿你时时拥有自信的笑意。', '');
INSERT INTO `评语表` VALUES ('245', '中学评语库', '分类7', '你应该向知识的深度和广度发展，坚定、稳重，去迎接更大的挑战。', '');
INSERT INTO `评语表` VALUES ('246', '中学评语库', '分类7', '希望保持良好的发展势头，向知识深度、广度推进，把成绩提高到一个新的水平。', '');
INSERT INTO `评语表` VALUES ('247', '中学评语库', '分类7', '希望今后在学习上加把劲，在最后一学期里，把各门功课赶上去。', '');
INSERT INTO `评语表` VALUES ('248', '中学评语库', '分类7', '希望今后向品学兼优的同学看齐，向他们学习，并记住：近朱者赤，近墨者黑。', '');
INSERT INTO `评语表` VALUES ('249', '中学评语库', '分类7', '希望你继续努力，总结方法，提高效率，日积月累，你一定会达到希望的目标。', '');
INSERT INTO `评语表` VALUES ('250', '中学评语库', '分类7', '希望你能勇敢面对困难，树立信心，弥补缺陷，逐步提高成绩。', '');
INSERT INTO `评语表` VALUES ('251', '中学评语库', '分类7', '希望你现在赶快清醒过来，把精力放在学习上，把学习赶上去。', '');
INSERT INTO `评语表` VALUES ('252', '中学评语库', '分类7', '只有“高分”是不够的，要在学习中增长知识，尤其是学习的方法、能力，才能取得更大地进步。', '');
INSERT INTO `评语表` VALUES ('253', '中学评语库', '分类7', '你最需要的是要自信而不自卑，事到万难须放胆，困难是一定可以克服的。', '');
INSERT INTO `评语表` VALUES ('254', '中学评语库', '分类7', '希望今后要保持持之以恒的精神状态，戒骄戒躁、扬鞭奋蹄、不断进取。', '');
INSERT INTO `评语表` VALUES ('255', '中学评语库', '分类7', '希望今后加强控制能力的培养，提高明辩是非，抗干扰能力。', '');
INSERT INTO `评语表` VALUES ('256', '中学评语库', '分类7', '希望你今后更加关心集体，团结同学，不囿于传统，不安于现有的成绩，知识的追求永无止境。', '');
INSERT INTO `评语表` VALUES ('257', '中学评语库', '分类7', '希望你能以全新的面貌和高度热情投入学习，不能辜负父母对你的殷切期望。', '');
INSERT INTO `评语表` VALUES ('258', '中学评语库', '分类7', '现在是打基础的时候，不论你今后从事何种职业，基础打牢些总是有用的。', '');
INSERT INTO `评语表` VALUES ('260', '小学评语库', '优等生评语范例', '', '没有绝对享乐主义的角落，没有完全不必承担责任的地方。无论哪里，人们都靠辛勤劳作才为我们开辟了道路。我们可以无忧无虑地把自己抛上一张吊床，但却为编织者在制作吊床时并非无忧无虑而高兴。\r\n    一个有英雄气概的猎人，如果遇到困难，哪怕有性命出入，他也等闲视之，他，总是先干了再说，就是放弃今后任何飞黄腾达的机会，他也在所不惜。');
INSERT INTO `评语表` VALUES ('266', '小学评语库', '优等生评语范例', '', '亲爱的同学们，快乐与悲伤，成功与失败，都将化作我们人生中的一段宝贵财富，激励着我们走进新的充满希冀与梦想的一年。\r\n    这是一个充满凝聚力、向心力的集体。我知道，每个同学都是热爱这个集体的，每个同学内心都有一颗努力向上的种子，这颗种子破土而出，即将长成一棵参天大树！');
INSERT INTO `评语表` VALUES ('267', '小学评语库', '优等生评语范例', '', '青春是让你可以拥有许多美好回忆的快乐，可以痛定思痛的痛，是痛并快乐着的一种感受。青春没有遗憾，只有缺憾，因为青春是年轻，是不谙世事，是不加修饰的单纯。年轻的你们该是多么的幸运，一个动感的，灵活的，日新月异的世界呈现在你们面前，青春在这样的空间像展翅高飞的鸟儿，可以尽情的释放。We  must  accept  finite  disappointment , but  we  must  never  lose  infinite  hope.');
INSERT INTO `评语表` VALUES ('268', '小学评语库', '优等生评语范例', '', '一转眼，三分之一的高中生活已成过去。回首这一年，我们取得了很大的突破。你们的每一次进步都让我高兴，哪怕只有一点点；你们的每一次团结都让我骄傲，哪怕还有点磨擦；你们的每一次荣誉都让我难忘，哪怕它在别人眼里无关紧要。你们认真学习时，我为你们高兴；你们围着老师问问题时，我为你们高兴；你们在自己的薄弱科目上取得进步，我为你们高兴！\r\n    同学们，我希望你们的人生有所成功，不要过多的彷徨，要矢志不移，沉静中取得胜利，在胜利中保持沉静，争取人生的每一次成功！');
INSERT INTO `评语表` VALUES ('269', '小学评语库', '优等生评语范例', '', '亲爱的同学：\"相聚一团火，分散满天星\"，祝愿我们曾属高一(6)班的每颗星星都能发出璀璨的光芒！路还很长，或许也很坎坷，不管怎样，我希望大家能昂起头，坚定地走下去，相信明天总会更好，只要你还在努力！有几句话，觉得不错，写下来与大家共勉：\r\n你不能控制他人，但可以掌握自己；你不能预知明天，但可以把握今天；\r\n你不能左右天气，但你可以改变心情；你不能选择容貌，但你可以展现笑容。最后祝愿每个同学都能度过一个愉快而有意义的暑假！');
INSERT INTO `评语表` VALUES ('270', '小学评语库', '优等生评语范例', '', '只有一个忠告给你--做你自己的主人。拼搏无极限。相信：机会是创造来的，不是等来的。用汗水织就实力，用毅力成就梦想，用拼搏铸就辉煌。\r\n    高一已经过去，接下来两年的高中学习时间，你还会碰到很多困难，困惑，但是老师希望你无论何时、何地，积极的态度象太阳，照到哪里哪里亮；消极的态度象月亮，初一、十五不一样。\r\n    不管以后师生关系会不会继续，望时时听到你进步的消息。愿你在未来的日子里张扬个性，放飞梦想！');
INSERT INTO `评语表` VALUES ('271', '小学评语库', '优等生评语范例', '', '本学期我们展现了优秀团体的实力：红三月评比一枝独秀，艺术节活动一马当先，五项竞赛一如既往地稳定，十佳学生高票当选。我们亲手种下象征友谊的五株樱花树香飘校园，我们每天课间在跑道上挥洒自己的汗水，留下我们的青春记忆。我们读书写作，自己办班刊，我们用自己的方式经历别样的人生。\r\n   经历是人生最大的财富。让我们怀着\"天生我才必有用\"的信念勇往直前吧！记住：心有多大，舞台就有多大！');
INSERT INTO `评语表` VALUES ('272', '小学评语库', '优等生评语范例', '', '同学们，在我们相处的这段日子里，我们坚信“良好的开始是成功的一半”，我们为营造良好的班风和学风共同努力；我们坚信“众人添柴火焰高”，为了班集体的荣誉，我们一起流汗、流泪；我们坚信“天生我才必有用”，为了成才，我们日夜雕琢自己……。\r\n    为实现你们的理想，我希望在今后的日子里，每位同学要意志坚定、积极进取、刻苦学习。坚信古训：\"有志者事竟成，破釜沉舟百二秦关终属楚；苦心人天不负，卧薪尝胆三千越甲可吞吴\"，用积极的态度和行动铸就我们人生的辉煌。');
INSERT INTO `评语表` VALUES ('273', '小学评语库', '优等生评语范例', '', '“思想决定行为；行为决定习惯；习惯决定性格；性格决定命运！”你的思想高度在哪里，理想的方向就在哪里，自我调控的能力就在哪里！高中最后一年，希望同学们能够从已出发，自我监督，自我完善，自我突破！即使在拼搏努力的过程中遇到艰难困苦、挫折懈怠，也能够一如既往地坚持下去，勇往直前，通过自己的努力，收获属于你们的明天！');
INSERT INTO `评语表` VALUES ('274', '小学评语库', '优等生评语范例', '', '时光飞逝，已经到了高三，相信你肯定有自己的收获，不过我想过去的只能回顾和总结，我们还有一年的时间，我相信你定能找到自己的目标，并会以切实的行动努力起来，虽然行动未必能带来幸福，但是不行动就肯定没有幸福。假期的时间对我们来说亦非常的宝贵，希望你能合理的安排利用。');
INSERT INTO `评语表` VALUES ('275', '小学评语库', '优等生评语范例', '', '成功的人不抱怨，抱怨的人不成功！\r\n心有多大，舞台就有多大！\r\n人生能有几回搏，此时不搏，更待何时？\r\n送给准高三的你们，高三，你们准备好了吗？');
INSERT INTO `评语表` VALUES ('276', '小学评语库', '优等生评语范例', '', '失败只有一种，那就是放弃努力。\r\n    输掉什么，也别输掉精神；放弃什么，请别放弃努力。\r\n    高三就在眼前，十年寒窗就磨此一剑。卧薪尝胆，尝破茧而触痛。破釜沉舟，愿你圆金色六月梦！');
INSERT INTO `评语表` VALUES ('277', '小学评语库', '优等生评语范例', '', '成功来源于自己，世界上没有什么事情是不能够做到的，只要你想做，只要你有了坚强的毅力，再大的困难也无法让你趴下!虽然你比别人在学习中更加艰难一些，但是你永远不要因为这一点而气馁，因为生活不相信眼泪!');
INSERT INTO `评语表` VALUES ('278', '小学评语库', '优等生评语范例', '', '漫长人生路上的跋涉者，常常会因为一时的挫折和失败而放弃前进的努力，往往在距成功只有一步之遥时却半途而废。《易经》有云：天行健，君子以自强不息。顺境时自制诚不易，而逆境时自强亦多艰。\r\n    只要有一颗健康的心灵，人总会越来越强大，日子总会越来越好，理想总会实现，我们总会为自己的存在而感到骄傲，别人也必将为你的存在而感到骄傲！');
INSERT INTO `评语表` VALUES ('279', '小学评语库', '优等生评语范例', '', '反思昨天，激情与汗水同行，经历与收获同在。把握今天，勤奋与惜时同行，追求与奋进同在。展望明天，机遇与挑战同行，希望与压力同在。\r\n2012年6月，为了我们能一起去飞翔，希望全班同学--我们大家一起做到：\r\n寒窗十二，豪情满怀。欲览苍穹，壮志擎天。欲霸人生，天道酬勤。吾等青春年少，当志存高远，卧薪尝胆。吾等时代雄鹰，当搏击长空，勤耕不辍。吾等驰骋沙场，当遨游题海，乐战不息。用呐喊唤醒沉默，用汗水诠释人生，用激情挑战未来。我行！我能行！我一定能行！');
INSERT INTO `评语表` VALUES ('280', '小学评语库', '优等生评语范例', '', '美国流传着这样一句名言：如果连你自己都不相信自己，谁还会信任你呢？老师把这句话送给你们，希望能对你们有所启示。其实你们都很聪明，只要对自己有信心，特别是薄弱科目。端正了学习态度，在老师的帮助下付诸努力，相信你们一定能收获令人喜悦的成果。');
INSERT INTO `评语表` VALUES ('281', '小学评语库', '优等生评语范例', '', '时光匆匆，转眼间在你们在芙中度过了一个学期。在这一学期当中你们既享受了高中生活的快乐，也体味到了高中生活的艰辛。\r\n在未来的日子里我希望你们能够更有力的前行，我梦想着这样的一个集体出现：你们既拥抱物质生活，又体认精神世界；你们现实，但有梦想；你们精明，但有坚持；你们富有激情，又尊重规则和秩序；你们以幸福为生活的首要目标，又不摒弃远见；你们仁爱，但不软弱。');
INSERT INTO `评语表` VALUES ('282', '小学评语库', '优等生评语范例', '', '久有凌云志，此志可问天，心慕象牙塔，魂系梦亦牵，百万学子竞渡扁扁小舟心几叶，风急浪无边。遂了心愿，何惜衣带宽，胜勇敢更坚，是好汉，一十二年将去，弹指一挥间，可上清华揽月，可上北大摘星。世上无难事，只要肯登攀。\r\n    伟人之所以伟大，是因为他与别人共处逆境时，别人失去了信心，他却下决心实现自己的目标！');
INSERT INTO `评语表` VALUES ('289', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('290', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('291', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('292', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('293', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('294', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('295', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('296', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('297', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('298', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('299', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('300', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('301', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('302', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('303', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('304', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('305', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('306', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('307', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('308', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('309', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('310', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('311', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('312', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('313', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('314', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('315', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('316', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('317', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('318', '小学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('319', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('320', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('321', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('322', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('323', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('324', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('325', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('326', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('327', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('328', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('329', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('330', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('331', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('332', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('333', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('334', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('335', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('336', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('337', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('338', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('339', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('340', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('341', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('342', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('343', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('344', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('345', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('346', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('347', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('348', '小学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('349', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('350', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('351', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('352', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('353', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('354', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('355', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('356', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('357', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('358', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('359', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('360', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('361', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('362', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('363', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('364', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('365', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('366', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('367', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('368', '中学评语库', '优等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('369', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('370', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('371', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('372', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('373', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('374', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('375', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('376', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('377', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('378', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('379', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('380', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('381', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('382', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('383', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('384', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('385', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('386', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('387', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('388', '中学评语库', '中等生评语范例', '', '');
INSERT INTO `评语表` VALUES ('389', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('390', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('391', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('392', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('393', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('394', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('395', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('396', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('397', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('398', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('399', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('400', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('401', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('402', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('403', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('404', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('405', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('406', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('407', '中学评语库', '后进生评语范例', '', '');
INSERT INTO `评语表` VALUES ('409', '小学评语库', '分类1', '', 'cf');

-- ----------------------------
-- Table structure for `试场表`
-- ----------------------------
DROP TABLE IF EXISTS `试场表`;
CREATE TABLE `试场表` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `Classroom` char(20) DEFAULT NULL,
  `Seat` int(3) DEFAULT '0',
  `ClassroomNo` char(10) DEFAULT '',
  `UsedFor` varchar(40) DEFAULT '0',
  `UsedOrNot` char(2) DEFAULT '否',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 试场表
-- ----------------------------

-- ----------------------------
-- Table structure for `调离表`
-- ----------------------------
DROP TABLE IF EXISTS `调离表`;
CREATE TABLE `调离表` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Sex` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Nationality` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Birthday` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HighestDegree` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `PoliticalSituation` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `WorkingTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `JoiningTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `WorkingYears` smallint(3) DEFAULT '0',
  `CaculatingTime` year(4) DEFAULT NULL,
  `Graduation` varchar(80) DEFAULT NULL,
  `ClassesOfWeek` smallint(2) DEFAULT NULL,
  `Position` varchar(60) DEFAULT NULL,
  `JobTitle` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TimeToGet` varchar(50) DEFAULT NULL,
  `FileNo` varchar(100) DEFAULT NULL,
  `Office` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `IDNumber` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `MobilePhoneNumber` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HomeAddress` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HomeTelephone` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `NativePlace` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Residence` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Photo` longblob,
  `PersonalResume` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `OtherMaterial` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingCause` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Level` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `cardtype` varchar(50) DEFAULT NULL,
  `governingzoneid` mediumint(10) DEFAULT NULL,
  `secrecy` char(4) DEFAULT NULL,
  `p_rank` varchar(40) DEFAULT NULL,
  `insurancedate` varchar(60) DEFAULT NULL,
  `unittype` varchar(60) DEFAULT NULL,
  `type_prereform` varchar(50) DEFAULT NULL,
  `tec_pos_grade_prereform` varchar(50) DEFAULT NULL,
  `tec_salary_grade_prereform` varchar(20) DEFAULT NULL,
  `management_grade_prereform` varchar(60) DEFAULT NULL,
  `management_salarygrade_prereform` varchar(20) DEFAULT NULL,
  `worker_pos_grade` varchar(60) DEFAULT NULL,
  `worker_salary_grade` varchar(20) DEFAULT NULL,
  `post_code` varchar(40) DEFAULT NULL,
  `email_add` varchar(100) DEFAULT NULL,
  `SpareField` varchar(40) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 调离表
-- ----------------------------

-- ----------------------------
-- Table structure for `转退表`
-- ----------------------------
DROP TABLE IF EXISTS `转退表`;
CREATE TABLE `转退表` (
  `ID` bigint(50) unsigned NOT NULL AUTO_INCREMENT,
  `StudentNumber` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `name` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `sex` char(4) CHARACTER SET utf8 DEFAULT NULL,
  `nationality` char(8) CHARACTER SET utf8 DEFAULT NULL,
  `birthday` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `EntranceDate` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `class` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `Positon` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `HomeAddress` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Telephone` char(40) CHARACTER SET utf8 DEFAULT NULL,
  `Residence` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `NativePlace` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `ParentA` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `NameOfParentA` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `WorkPlaceOfParentA` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TelephoneOfParentA` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `ParentB` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `NameOfParentB` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `WorkPlaceOfParentB` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TelephoneOfParentB` char(20) CHARACTER SET utf8 DEFAULT NULL,
  `Photo` longblob COMMENT 'pic',
  `ResidentStudent` tinyint(1) DEFAULT '0',
  `roomname` varchar(30) DEFAULT NULL,
  `bednumber` tinyint(2) DEFAULT NULL,
  `CommentOfThisTerm` text CHARACTER SET utf8,
  `GeneralComment` text CHARACTER SET utf8,
  `GeneralCommentTime` varchar(20) DEFAULT NULL,
  `MidTerm1` smallint(4) DEFAULT NULL,
  `MidTerm2` smallint(4) DEFAULT NULL,
  `MidTerm3` smallint(4) DEFAULT NULL,
  `MidTerm4` smallint(4) DEFAULT NULL,
  `MidTerm5` smallint(4) DEFAULT NULL,
  `MidTerm6` smallint(4) DEFAULT NULL,
  `MidTerm7` smallint(4) DEFAULT NULL,
  `MidTerm8` smallint(4) DEFAULT NULL,
  `MidTerm9` smallint(4) DEFAULT NULL,
  `MidTerm10` smallint(4) DEFAULT NULL,
  `MidTerm11` smallint(4) DEFAULT NULL,
  `MidTerm12` smallint(4) DEFAULT NULL,
  `MidTerm13` smallint(4) DEFAULT NULL,
  `MidTerm14` smallint(4) DEFAULT NULL,
  `MidTerm15` smallint(4) DEFAULT NULL,
  `MidTerm16` smallint(4) DEFAULT NULL,
  `MidTerm17` smallint(4) DEFAULT NULL,
  `MidTerm18` smallint(4) DEFAULT NULL,
  `MidTerm19` smallint(4) DEFAULT NULL,
  `MidTerm20` smallint(4) DEFAULT NULL,
  `TermEnd1` smallint(4) DEFAULT NULL,
  `TermEnd2` smallint(4) DEFAULT NULL,
  `TermEnd3` smallint(4) DEFAULT NULL,
  `TermEnd4` smallint(4) DEFAULT NULL,
  `TermEnd5` smallint(4) DEFAULT NULL,
  `TermEnd6` smallint(4) DEFAULT NULL,
  `TermEnd7` smallint(4) DEFAULT NULL,
  `TermEnd8` smallint(4) DEFAULT NULL,
  `TermEnd9` smallint(4) DEFAULT NULL,
  `TermEnd10` smallint(4) DEFAULT NULL,
  `TermEnd11` smallint(4) DEFAULT NULL,
  `TermEnd12` smallint(4) DEFAULT NULL,
  `TermEnd13` smallint(4) DEFAULT NULL,
  `TermEnd14` smallint(4) DEFAULT NULL,
  `TermEnd15` smallint(4) DEFAULT NULL,
  `TermEnd16` smallint(4) DEFAULT NULL,
  `TermEnd17` smallint(4) DEFAULT NULL,
  `TermEnd18` smallint(4) DEFAULT NULL,
  `TermEnd19` smallint(4) DEFAULT NULL,
  `TermEnd20` smallint(4) DEFAULT NULL,
  `LeavingDate` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingCause` char(100) CHARACTER SET utf8 DEFAULT NULL,
  `ClassID` smallint(5) DEFAULT '0',
  `GradeID` tinyint(3) DEFAULT '0',
  `IDcardNo` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `TypeOfClass` varchar(30) CHARACTER SET utf8 DEFAULT '无分类',
  `SN` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Other1` smallint(4) DEFAULT NULL,
  `Other2` smallint(4) DEFAULT NULL,
  `Other3` smallint(4) DEFAULT NULL,
  `Other4` smallint(4) DEFAULT NULL,
  `Other5` smallint(4) DEFAULT NULL,
  `Other6` smallint(4) DEFAULT NULL,
  `Other7` smallint(4) DEFAULT NULL,
  `Other8` smallint(4) DEFAULT NULL,
  `Other9` smallint(4) DEFAULT NULL,
  `Other10` smallint(4) DEFAULT NULL,
  `Other11` smallint(4) DEFAULT NULL,
  `Other12` smallint(4) DEFAULT NULL,
  `Other13` smallint(4) DEFAULT NULL,
  `Other14` smallint(4) DEFAULT NULL,
  `Other15` smallint(4) DEFAULT NULL,
  `Other16` smallint(4) DEFAULT NULL,
  `Other17` smallint(4) DEFAULT NULL,
  `Other18` smallint(4) DEFAULT NULL,
  `Other19` smallint(4) DEFAULT NULL,
  `Other20` smallint(4) DEFAULT NULL,
  `Morality` char(20) CHARACTER SET utf8 DEFAULT NULL COMMENT '思想品德评定',
  `LateArrival` smallint(2) DEFAULT '0' COMMENT '迟到次数',
  `ClassCutting` smallint(2) DEFAULT '0' COMMENT '旷课次数',
  `PersonalLeave` smallint(2) DEFAULT '0' COMMENT '事假次数',
  `SickLeave` smallint(2) DEFAULT '0' COMMENT '病假次数',
  `Reward` varchar(20) CHARACTER SET utf8 DEFAULT '无',
  `MidClassPlace` smallint(2) DEFAULT '0',
  `MidGradePlace` smallint(3) DEFAULT '0',
  `EndClassPlace` smallint(3) DEFAULT '0',
  `EndGradePlace` smallint(3) DEFAULT '0',
  `OtherClassPlace` smallint(3) DEFAULT '0',
  `OtherGradePlace` smallint(3) DEFAULT '0',
  `LeagueMember` char(4) CHARACTER SET utf8 DEFAULT '否',
  `LeagueJoiningTime` varchar(40) DEFAULT NULL,
  `Total` decimal(4,1) DEFAULT '0.0',
  `PersonalCode` bigint(10) DEFAULT '0',
  `SpareField` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 转退表
-- ----------------------------

-- ----------------------------
-- Table structure for `退休表`
-- ----------------------------
DROP TABLE IF EXISTS `退休表`;
CREATE TABLE `退休表` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Sex` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Nationality` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Birthday` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HighestDegree` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `PoliticalSituation` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `WorkingTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `JoiningTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `WorkingYears` smallint(3) DEFAULT '0',
  `CaculatingTime` year(4) DEFAULT NULL,
  `Graduation` varchar(80) DEFAULT NULL,
  `ClassesOfWeek` smallint(2) DEFAULT NULL,
  `Position` varchar(60) DEFAULT NULL,
  `JobTitle` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `TimeToGet` varchar(50) DEFAULT NULL,
  `FileNo` varchar(100) DEFAULT NULL,
  `Office` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `IDNumber` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `MobilePhoneNumber` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HomeAddress` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `HomeTelephone` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `NativePlace` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Residence` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Photo` longblob,
  `PersonalResume` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `OtherMaterial` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingTime` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `LeavingCause` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `Level` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `cardtype` varchar(50) DEFAULT NULL,
  `governingzoneid` mediumint(10) DEFAULT NULL,
  `secrecy` char(4) DEFAULT NULL,
  `p_rank` varchar(40) DEFAULT NULL,
  `insurancedate` varchar(60) DEFAULT NULL,
  `unittype` varchar(60) DEFAULT NULL,
  `type_prereform` varchar(50) DEFAULT NULL,
  `tec_pos_grade_prereform` varchar(50) DEFAULT NULL,
  `tec_salary_grade_prereform` varchar(20) DEFAULT NULL,
  `management_grade_prereform` varchar(60) DEFAULT NULL,
  `management_salarygrade_prereform` varchar(20) DEFAULT NULL,
  `worker_pos_grade` varchar(60) DEFAULT NULL,
  `worker_salary_grade` varchar(20) DEFAULT NULL,
  `post_code` varchar(40) DEFAULT NULL,
  `email_add` varchar(100) DEFAULT NULL,
  `SpareField` varchar(40) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 退休表
-- ----------------------------

-- ----------------------------
-- Table structure for `通讯录`
-- ----------------------------
DROP TABLE IF EXISTS `通讯录`;
CREATE TABLE `通讯录` (
  `ID` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(30) DEFAULT NULL,
  `Position` varchar(30) DEFAULT NULL,
  `OfficeTel` varchar(30) DEFAULT NULL,
  `HomeTel` varchar(30) DEFAULT NULL,
  `XiaoLinTong` varchar(30) DEFAULT NULL,
  `Mobile` varchar(30) DEFAULT NULL,
  `ShortTel` varchar(30) DEFAULT NULL,
  `WorkPlace` varchar(30) DEFAULT NULL,
  `Email` varchar(30) DEFAULT NULL,
  `OtherInfo` varchar(30) DEFAULT NULL,
  `Higher` char(4) DEFAULT '否',
  `SpareField` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of 通讯录
-- ----------------------------
