local assets=
{
	Asset("ANIM", "anim/armor_grass.zip"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour") 
end


local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "armor_grass", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("armor_grass")
    inst.AnimState:SetBuild("armor_grass")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("grass")
    
    inst:AddComponent("inspectable")
local function OnDeploy (inst, pt) 
    local oven = SpawnPrefab("armorgrass")
    oven.Transform:SetPosition(pt.x, pt.y, pt.z)
    oven.AnimState:SetBank("skull_chest")
    oven.AnimState:SetBuild("skull_chest")
    oven.AnimState:PlayAnimation("closed")
    oven.Transform:SetScale(1.5, 1.5, 1.5)
    oven:AddTag("fridge")
    oven:AddTag("ovens")
    oven:RemoveComponent("inventoryitem")
    oven:RemoveComponent("fuel")
    oven:RemoveComponent("armor")
    oven:RemoveComponent("equippable")
    oven:AddComponent("workable")
    oven.components.workable:SetWorkAction(ACTIONS.HAMMER)
    oven.components.workable:SetWorkLeft(3)
    oven.components.workable:SetOnFinishCallback(function(oven)
        SpawnPrefab("collapse_big").Transform:SetPosition(oven.Transform:GetWorldPosition())
        GetPlayer().SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
        oven:Remove()
    end )
    oven.components.container.canbeopened = true
    inst:Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("ovens") then
        data.ovens = true
    end
end
local function onload(inst, data)
  if data and data.ovens then
    inst.AnimState:SetBank("skull_chest")
    inst.AnimState:SetBuild("skull_chest")
    inst.AnimState:PlayAnimation("closed")
    inst.Transform:SetScale(1.5, 1.5, 1.5)
    inst:AddTag("fridge")
    inst:AddTag("ovens")
    inst:RemoveComponent("inventoryitem")
    inst:RemoveComponent("fuel")
    inst:RemoveComponent("armor")
    inst:RemoveComponent("equippable")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
    inst.components.workable:SetOnFinishCallback(function(inst)
        SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
        GetPlayer().SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
        inst:Remove()
    end )
    inst.components.container.canbeopened = true
  end
end
local function itemtest(inst, item, slot)
    if item.prefab == "carrot" or item.prefab == "corn" or item.prefab == "pumpkin" or item.prefab == "eggplant" or item.prefab == "durian" or item.prefab == "pomegranate" or item.prefab == "dragonfruit" or item.prefab == "carrot_seeds" or item.prefab == "corn_seeds" or item.prefab == "pumpkin_seeds" or item.prefab == "eggplant_seeds" or item.prefab == "durian_seeds" or item.prefab == "pomegranate_seeds" or item.prefab == "dragonfruit_seeds" or item.prefab == "seeds" or item.prefab == "spoiled_food" or item.prefab == "lightbulb" then
       return true
    end
    return false
end
local slotpos = {}
for y = 2, 0, -1 do
    for x = 0, 14 do
        table.insert(slotpos, Vector3(75*x-75*2+75, 75*y-75*2+75,0))
    end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    inst:AddComponent("container")
local widgetbuttoninfo = {
    text = "Start",
    position = Vector3(450, -150, 0),
    fn = function(inst)
      if inst:HasTag("ovens") and inst.components.container:Has("lightbulb", 1) then
       inst.components.container:ConsumeByName("lightbulb", 1)
       inst.components.container:Close(GetPlayer())
       inst.components.container.canbeopened = false
       inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
       inst:DoTaskInTime(10, function()
           inst.AnimState:SetBloomEffectHandle("")
           GetPlayer().SoundEmitter:PlaySound("dontstarve/HUD/research_available")
           inst.components.container.canbeopened = true
           for k,v in pairs(inst.components.container.slots) do
               if v and v.prefab == "carrot_seeds" then
                  v:Remove()
                  local carrot = SpawnPrefab("carrot")
                  inst.components.container:GiveItem(carrot)
               end
               if v and v.prefab == "corn_seeds" then
                  v:Remove()
                  local corn = SpawnPrefab("corn")
                  inst.components.container:GiveItem(corn)
               end
               if v and v.prefab == "pumpkin_seeds" then
                  v:Remove()
                  local pumpkin = SpawnPrefab("pumpkin")
                  inst.components.container:GiveItem(pumpkin)
               end
               if v and v.prefab == "eggplant_seeds" then
                  v:Remove()
                  local eggplant = SpawnPrefab("eggplant")
                  inst.components.container:GiveItem(eggplant)
               end
               if v and v.prefab == "durian_seeds" then
                  v:Remove()
                  local durian = SpawnPrefab("durian")
                  inst.components.container:GiveItem(durian)
               end
               if v and v.prefab == "pomegranate_seeds" then
                  v:Remove()
                  local pomegranate = SpawnPrefab("pomegranate")
                  inst.components.container:GiveItem(pomegranate)
               end
               if v and v.prefab == "dragonfruit_seeds" then
                  v:Remove()
                  local dragonfruit = SpawnPrefab("dragonfruit")
                  inst.components.container:GiveItem(dragonfruit)
               end
               if v and v.prefab == "seeds" then
                  v:Remove()
                  local names = {"carrot","corn","pumpkin","eggplant","durian","pomegranate","dragonfruit"}
                  local name = names[math.random(#names)]
                  local fruit = SpawnPrefab(name)
                  inst.components.container:GiveItem(fruit)
               end
               if v.prefab == "carrot" or v.prefab == "corn" or v.prefab == "pumpkin" or v.prefab == "eggplant" or v.prefab == "durian" or v.prefab == "pomegranate" or v.prefab == "dragonfruit" then
                  v:Remove()
                  local spoiled = SpawnPrefab("spoiled_food")
                  inst.components.container:GiveItem(spoiled)
               end
           end
       end )
      end
    end }
    inst.components.container.widgetbuttoninfo = widgetbuttoninfo
    inst.components.container.acceptsstacks = false
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetpos = Vector3(-250,200,0)
    inst.components.container.side_align_tip = 160
    inst.components.container.canbeopened = false
    inst.components.container.itemtestfn = itemtest
    inst.components.container.onopenfn = function(inst) inst.AnimState:PlayAnimation("open") end
    inst.components.container.onclosefn = function(inst) inst.AnimState:PlayAnimation("close") end
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/grassarmour"

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORGRASS, TUNING.ARMORGRASS_ABSORPTION)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end


return Prefab( "common/inventory/armorgrass", fn, assets) 
