local assets=
{
	Asset("ANIM", "anim/swap_bedroll_furry.zip"),
}

local function onsleep(inst, sleeper)
	local br = nil
	if inst.components.stackable then
		br = inst.components.stackable:Get()
	else
		br = inst
	end

	if br and br.components.finiteuses then
		if br.components.finiteuses:GetUses() <= 1 then
			br:Remove()
			br.persists = false
		end
	end
	GetPlayer().HUD:Hide()
	TheFrontEnd:Fade(false,1)
	inst:DoTaskInTime(1.2, function() 
		TheFrontEnd:Fade(true,1) 
		GetPlayer().HUD:Show()
		
		
		sleeper.sg:GoToState("wakeup")
		
		if sleeper.components.hunger then
			-- Check SGwilson, state "bedroll", if you change this value
			sleeper.components.hunger:DoDelta(-TUNING.CALORIES_HUGE, false, true)
		end

		if sleeper.components.sanity then
			sleeper.components.sanity:DoDelta(TUNING.SANITY_HUGE, false)
		end

		if sleeper.components.health then
			sleeper.components.health:DoDelta(TUNING.HEALING_MEDLARGE, false, "bedroll", true)
		end
		
		if sleeper.components.temperature then
			sleeper.components.temperature:SetTemperature(sleeper.components.temperature.maxtemp)
		end

		GetClock():MakeNextDay()
	end)
end

local function onuse()
	GetPlayer().AnimState:OverrideSymbol("swap_bedroll", "swap_bedroll_furry", "bedroll_furry")	
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("swap_bedroll_furry")
    anim:SetBuild("swap_bedroll_furry")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
local function createhospital(inst)
    local pt = inst:GetPosition()
    local nurse = SpawnPrefab("bedroll_furry")
    nurse.Transform:SetPosition(pt.x, pt.y, pt.z)
    nurse.AnimState:SetBank("wilson")
    nurse.AnimState:SetBuild("wendy")
    nurse.AnimState:OverrideSymbol("swap_body", "armor_sweatervest", "swap_body")
    nurse.AnimState:Hide("ARM_carry")
    nurse.AnimState:Show("ARM_normal")
    nurse.Transform:SetFourFaced()
    nurse.AnimState:PlayAnimation("idle")
    nurse:RemoveComponent("inventoryitem")
    nurse:RemoveComponent("finiteuses")
    nurse:RemoveComponent("fuel")
    nurse:RemoveComponent("sleepingbag")
    nurse:RemoveComponent("deployable")
    MakeLargeBurnable(nurse)
    MakeLargePropagator(nurse)
    nurse:AddTag("nurse")
    nurse:AddComponent("heater")
    nurse.components.heater.heat = 180
    local light = nurse.entity:AddLight()
    light:SetFalloff(1)
    light:SetIntensity(.8)
    light:SetRadius(5)
    light:SetColour(180/255, 195/255, 50/255)
    light:Enable(true)
    nurse:AddComponent("trader")
    nurse.components.trader:SetAcceptTest(function(nurse, item) 
        if GetPlayer().components.inventory:Has("goldnugget", 5) then
           if item.prefab == "goldnugget" then
              return true
           end
        end
        return false
    end )
    nurse.components.trader.onaccept = function(nurse, giver, item)
        GetPlayer().components.inventory:ConsumeByName("goldnugget", 4)
        GetPlayer().components.playercontroller:Enable(false)
        nurse.AnimState:OverrideSymbol("swap_object", "swap_hammer", "swap_hammer")
        nurse.AnimState:Hide("ARM_normal")
        nurse.AnimState:Show("ARM_carry")
        nurse.task = nurse:DoPeriodicTask(1, function(nurse)
            nurse.Transform:SetRotation(GetPlayer().Transform:GetRotation() - 180)
            nurse.AnimState:PlayAnimation("pickaxe_pre")
            nurse.AnimState:PlayAnimation("pickaxe_loop", false)
            GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
            GetPlayer().sg:GoToState("hit")
        end )
        nurse:DoTaskInTime(5, function()
            TheFrontEnd:Fade(false,1)
            if nurse.task then nurse.task:Cancel() nurse.task = nil end
            nurse.Transform:SetRotation(0)
            nurse:DoTaskInTime(1, function()
                nurse.AnimState:Hide("ARM_carry")
                nurse.AnimState:Show("ARM_normal")
                nurse.AnimState:PlayAnimation("idle_onemanband1_loop",true)
                nurse:DoTaskInTime(3, function() nurse.AnimState:PlayAnimation("idle") end )
                TheFrontEnd:Fade(true,1)
                GetPlayer().components.health:DoDelta(GetPlayer().components.health.maxhealth)
                GetPlayer().sg:GoToState("wakeup")
                GetPlayer().components.playercontroller:Enable(true)
            end )
        end )
    end
    local medicinebox = SpawnPrefab("bedroll_furry")
    medicinebox.Transform:SetPosition(pt.x+1.2, 0, pt.z-1.2)
    medicinebox.AnimState:SetBank("icebox")
    medicinebox.AnimState:SetBuild("ice_box")
    medicinebox.AnimState:PlayAnimation("closed")
    medicinebox.Transform:SetScale(0.5, 0.5, 0.5)
    medicinebox:RemoveComponent("inventoryitem")
    medicinebox:RemoveComponent("finiteuses")
    medicinebox:RemoveComponent("fuel")
    medicinebox:RemoveComponent("sleepingbag")
    medicinebox:RemoveComponent("deployable")
    MakeLargeBurnable(medicinebox)
    MakeLargePropagator(medicinebox)
    medicinebox:AddTag("goodbye")
    medicinebox:AddComponent("trader")
    medicinebox.components.trader:SetAcceptTest(function(medicinebox, item) 
        if GetPlayer().components.inventory:Has("goldnugget", 5) then
           if item.prefab == "goldnugget" then
              return true
           end
        end
        return false
    end )
    medicinebox.components.trader.onaccept = function(medicinebox, giver, item)
        GetPlayer().components.inventory:ConsumeByName("goldnugget", 4)
        local medicine = SpawnPrefab("bedroll_furry")
        medicine.AnimState:SetBank("carrot")
        medicine.AnimState:SetBuild("carrot")
        medicine.AnimState:PlayAnimation("cooked")
        medicine.components.inventoryitem:ChangeImageName("carrot_cooked")
        medicine:RemoveComponent("finiteuses")
        medicine:RemoveComponent("fuel")
        medicine:RemoveComponent("sleepingbag")
        medicine:RemoveComponent("burnable")
        medicine:RemoveComponent("propagator")
        medicine:RemoveComponent("deployable")
        medicine:AddComponent("edible")
        medicine.components.edible.healthvalue = GetPlayer().components.health.maxhealth *0.5
        medicine.components.edible.hungervalue = 0
        medicine.components.edible.sanityvalue = GetPlayer().components.sanity.max *0.5
        medicine.components.edible.foodtype = "VEGGIE"
        medicine:AddTag("medicine")
        GetPlayer().components.inventory:GiveItem(medicine)
    end
    local hospital = SpawnPrefab("bedroll_furry")
    hospital.Transform:SetPosition(pt.x-2, 0, pt.z-2)
    hospital.AnimState:SetBank("tent")
    hospital.AnimState:SetBuild("tent")
    hospital.AnimState:PlayAnimation("idle", true)
    hospital.Transform:SetScale(1.2, 1.2, 1.2)
    hospital:RemoveComponent("inventoryitem")
    hospital:RemoveComponent("finiteuses")
    hospital:RemoveComponent("fuel")
    hospital:RemoveComponent("sleepingbag")
    hospital:RemoveComponent("deployable")
    MakeLargeBurnable(hospital)
    MakeLargePropagator(hospital)
    hospital:AddTag("goodbye")
    hospital:AddComponent("trader")
    hospital.components.trader:SetAcceptTest(function(hospital, item) 
        if GetPlayer().components.inventory:Has("goldnugget", 5) then
           if item.prefab == "goldnugget" then
              return true
           end
        end
        return false
    end )
    hospital.components.trader.onaccept = function(hospital, giver, item)
        GetPlayer().components.inventory:ConsumeByName("goldnugget", 4)
        GetPlayer().components.playercontroller:Enable(false)
        TheFrontEnd:Fade(false,1)
        hospital:DoTaskInTime(2, function()
            TheFrontEnd:Fade(true,1)
            GetPlayer().components.sanity:DoDelta(GetPlayer().components.sanity.max)
            GetPlayer().components.playercontroller:Enable(true)
        end )
    end
end
local function OnDeploy (inst, pt)
    createhospital(inst)
    inst:Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("goodbye") then
        data.goodbye = true
    end
    if inst:HasTag("nurse") then
        data.nurse = true
    end
    if inst:HasTag("medicine") then
        data.medicine = true
    end
end
local function onload(inst, data)
    if data and data.goodbye then
       inst:Remove()
    end
    if data and data.nurse then
       createhospital(inst)
       inst:Remove()
    end
    if data and data.medicine then
       inst.AnimState:SetBank("carrot")
       inst.AnimState:SetBuild("carrot")
       inst.AnimState:PlayAnimation("cooked")
       inst.components.inventoryitem:ChangeImageName("carrot_cooked")
       inst:RemoveComponent("finiteuses")
       inst:RemoveComponent("fuel")
       inst:RemoveComponent("sleepingbag")
       inst:RemoveComponent("burnable")
       inst:RemoveComponent("propagator")
       inst:RemoveComponent("deployable")
       inst:AddComponent("edible")
       inst.components.edible.healthvalue = GetPlayer().components.health.maxhealth *0.5
       inst.components.edible.hungervalue = 0
       inst.components.edible.sanityvalue = GetPlayer().components.sanity.max *0.5
       inst.components.edible.foodtype = "VEGGIE"
       inst:AddTag("medicine")
    end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    inst:AddComponent("inventoryitem")

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetConsumption(ACTIONS.SLEEPIN, 1)
    inst.components.finiteuses:SetMaxUses(3)
    inst.components.finiteuses:SetUses(3)

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
    
	MakeSmallBurnable(inst, TUNING.LONG_BURNABLE)
    MakeSmallPropagator(inst)
    inst:AddComponent("sleepingbag")
	inst.components.sleepingbag.onsleep = onsleep
    
    inst.onuse = onuse
    
    
    return inst
end

return Prefab( "common/inventory/bedroll_furry", fn, assets) 
