PrefabFiles = 
{
	"cacao",
	"cacao_tree",
	"chocolate",
	"chocolate_milk",
	"choco_icecream", 
	"choco_cookies",
}

Assets = 
{
	Asset("ATLAS", "images/inventoryimages/cacao_tree.xml"),
}

AddMinimapAtlas("images/inventoryimages/cacao_tree.xml")

GLOBAL.STRINGS.NAMES.CACAO_SEEDS = "Cacao Seeds"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CACAO_SEEDS = "Cacao Seeds"

GLOBAL.STRINGS.NAMES.CACAO = "Cacao"

GLOBAL.STRINGS.NAMES.CACAO_COOKED = "Cacao Cooked"

GLOBAL.STRINGS.NAMES.CHOCOLATE = "Chocolate"

GLOBAL.STRINGS.NAMES.CACAO_TREE = "Cacao Tree"

GLOBAL.STRINGS.NAMES.CHOCOLATE_MILK = "Chocolate Milk"

GLOBAL.STRINGS.NAMES.CHOCO_ICECREAM = "Chocolate Icecream"

GLOBAL.STRINGS.NAMES.CHOCO_COOKIES = "Chocolate Cookies"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CACAO = "This fruit has a very hard shell."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CACAO_COOKED = "Delicious bitter roasted grains!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHOCOLATE = "It's hard to resist!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CACAO_TREE = "What a sweet surprise."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHOCOLATE_MILK = "This is my guilty pleasure!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHOCO_ICECREAM = "I'll scream twice for a chocolate with ice!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHOCO_COOKIES = "Tasty appetizer!"

--- Willow ---
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CACAO = "Heavy mystery.. I should burn it."
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CACAO_COOKED = "It's quite good I think."
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CHOCOLATE = "I wish it was hot chocolate."
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CACAO_TREE = "I should refrain from burning it."
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CHOCOLATE_MILK = "Ew. This chocolate smells like a goat."
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CHOCO_ICECREAM = "Even cold things can help sometimes."
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.CHOCO_COOKIES = "Chocolate cookies!!"

--- Wolfgang ---
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CACAO = "I could crush it with my fist!"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CACAO_COOKED = "Little seeds."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CHOCOLATE = "It reminds me of delicious Belgian chocolate."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CACAO_TREE = "strange tree with strange fruit. I should be careful."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CHOCOLATE_MILK = "Mighty drink for a strongman!"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CHOCO_ICECREAM = "Delicious schwarzwald ice cream!"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CHOCO_COOKIES = "Is super tasty cookies."

--- Wendy ---
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CACAO = "I wonder what mystery is hiding in it."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CACAO_COOKED = "Everything became clear."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CHOCOLATE = "This is deadly delicious!"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CACAO_TREE = "I feel a positive vibes from it."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CHOCOLATE_MILK = "This cup contains dark pleasure."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CHOCO_ICECREAM = "Chocolate ice cream.. Abigail can wait."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.CHOCO_COOKIES = "Cookies with a hint of dark climate."

--- WX-78 ---
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CACAO = "HEAVY ORGANIC FRUIT."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CACAO_COOKED = "LOOKS GOOD, TASTE GOOD?"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CHOCOLATE = "HIGH NUTRITIONAL VALUE DETECTED."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CACAO_TREE = "SWEET TREE DETECTED."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CHOCOLATE_MILK = "SWEET LIQUID IN RANGE."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CHOCO_ICECREAM = "EXTREMELY TASTY DAIRY."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.CHOCO_COOKIES = "TASTY COOKIES FILLED WITH CHOCOLATE."

--- Wickerbottom ---
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CACAO = "This cocoa fruit is unripe."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CACAO_COOKED = "Roasted grains are gaining an unusual flavour."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CHOCOLATE = "The essence of vitamins, copper, iron, theobromine, flavonoids and happiness."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CACAO_TREE = "Best thing is hidden in these fruits."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CHOCOLATE_MILK = "I dream of having a cup of chocolate by the fire."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CHOCO_ICECREAM = "Almost as enjoyable as the book."
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CHOCO_COOKIES = "It's time for a short rest. Too bad I don't have a glass of tea."

--- Woodie ---
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CACAO = "What should I do with it?"
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CACAO_COOKED = "They are tasty but also very hard."
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CHOCOLATE = "It can give me energy for chopping!"
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CACAO_TREE = "I can chop it.. or save it for fruits."
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CHOCOLATE_MILK = "Liquid sweet power is mine."
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CHOCO_ICECREAM = "I can take a short break in chopping.."
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.CHOCO_COOKIES = "Good source of energy for chopping."

--- Waxwell ---
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CACAO = "I can cook it, to reveal tasty grains."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CACAO_COOKED = "Here they are.. bitter and sweet."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CHOCOLATE = "Chocolate - a source of temptation and passion."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CACAO_TREE = "They used to grow in the ruins. Nature is nosy."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CHOCOLATE_MILK = "Ha! A cup of a liquid passion."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CHOCO_ICECREAM = "Good.. but not my favourite."
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CHOCO_COOKIES = "I upgraded ordinary cookies."

	if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then 

--- Wigfrid ---
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CACAO = "Not too useful for me."
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CACAO_COOKED = "Still, I don't want it!"
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CHOCOLATE = "They say that every warrior should have at least two of these in the pocket."
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CACAO_TREE = "I can cut it easily!"
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CHOCOLATE_MILK = "Warrior should eat a chocolate, not drink some drinks!"
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CHOCO_ICECREAM = "Good for children, not a warrior!"
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CHOCO_COOKIES = "I don't care. There's no meat in it."

--- Webber ---
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CACAO = "We could put it into the fire."
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CACAO_COOKED = "It's getting better and better."
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CHOCOLATE = "We need to share!"
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CACAO_TREE = "We can take this fruit on a journey!"
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CHOCOLATE_MILK = "This should be enough for us."
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CHOCO_ICECREAM = "We have chocolate ice bulbs!"
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.CHOCO_COOKIES = "Yum Yum!"
	end

local function ChocolateHP(inst)
    inst.components.edible.healthvalue = (GetModConfigData("ChocolateHP"))
end	
AddPrefabPostInit("chocolate", ChocolateHP)

local function Chocolate_MilkHP(inst)
    inst.components.edible.healthvalue = (GetModConfigData("Chocolate_MilkHP"))
end	
AddPrefabPostInit("chocolate_milk", Chocolate_MilkHP)

local function Cacao_CookedHP(inst)
    inst.components.edible.healthvalue = (GetModConfigData("Cacao_CookedHP"))
end	
AddPrefabPostInit("cacao_cooked", Cacao_CookedHP)

local function Chocolate_MilkTEMP(inst)
    inst.components.edible.temperaturedelta = (GetModConfigData("Chocolate_MilkTEMP"))
end	
AddPrefabPostInit("chocolate_milk", Chocolate_MilkTEMP)

local function Choco_IcecreamHP(inst)
    inst.components.edible.healthvalue = (GetModConfigData("Choco_IcecreamHP"))
end	
AddPrefabPostInit("choco_icecream", Choco_IcecreamHP)

local function Choco_IcecreamTEMP(inst)
    inst.components.edible.temperaturedelta = (GetModConfigData("Choco_IcecreamTEMP"))
end	
AddPrefabPostInit("choco_icecream", Choco_IcecreamTEMP)

local function Choco_CookiesHP(inst)
    inst.components.edible.healthvalue = (GetModConfigData("Choco_CookiesHP"))
end	
AddPrefabPostInit("choco_cookies", Choco_CookiesHP)


AddIngredientValues({"cacao_cooked"}, {cacao_cooked=1})

local chocolate_recipe = {
		name = "chocolate",
	    test = function(cooker, names, tags) return names.cacao_cooked and tags.cacao_cooked > 3 end,
		priority = 1,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = .5,
	}
	AddCookerRecipe("cookpot", chocolate_recipe)
	
	local choco_cookies_recipe = {
		name = "choco_cookies",
		test = function(cooker, names, tags) return (names.pumpkin or names.pumpkin_cooked) and names.cacao_cooked  and names.cacao_cooked and names.honey and not tags.meat and not tags.fruit and not tags.decoration and not tags.egg and not tags.inedible end,
		priority = 4,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = .5,
	}
	AddCookerRecipe("cookpot", choco_cookies_recipe)
	
	
	local chocolate_milk_recipe = {
		name = "chocolate_milk",
        test = function(cooker, names, tags) return (tags.cacao_cooked and tags.cacao_cooked>=1) and ((tags.dairy and tags.dairy>=1) or (tags.rawmilk and tags.rawmilk>=1) or (tags.dairy and tags.rawmilk and tags.rawmilk+tags.dairy>=1)) and not tags.meat and not tags.fruit and not tags.decoration and not tags.egg and not tags.frozen and not tags.inedible and not tags.sweetener and not tags.veggie end,
		priority = 10,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = .5,
	}
	AddCookerRecipe("cookpot", chocolate_milk_recipe)


if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then 	
	local choco_icecream_recipe = {
		name = "choco_icecream",
        test = function(cooker, names, tags) return names.ice and (tags.dairy or tags.rawmilk) and (tags.cacao_cooked and tags.cacao_cooked>=2) and not tags.meat and not tags.fruit and not tags.decoration and not tags.egg and not tags.inedible and not tags.sweetener and not tags.veggieend end,
		priority = 9,
		weight = 1,
		foodtype = "GENERIC",
		cooktime = .5,
	}
	AddCookerRecipe("cookpot", choco_icecream_recipe)
end