local function MakeVegStats(seedweight, hunger, health, perish_time, sanity, cooked_hunger, cooked_health, cooked_perish_time, cooked_sanity)
	return 
	{
		health = health,
		hunger = hunger,
		cooked_health = cooked_health,
		cooked_hunger = cooked_hunger,
		seed_weight = seedweight,
		perishtime = perish_time,
		cooked_perishtime = cooked_perish_time,
		sanity = sanity,
		cooked_sanity = cooked_sanity,
	}
end

local COMMON = 3
local UNCOMMON = 1
local RARE = .5

CACAO_VEGGIES =
{
	cacao = MakeVegStats(COMMON, 6, 0, TUNING.PERISH_SUPERSLOW, 0, 8, 0, TUNING.PERISH_SUPERSLOW, 4)
}

local function MakeVeggie(name, has_seeds)

	local assets =
	{
		Asset("ANIM", "anim/"..name..".zip"),
    	Asset("ATLAS", "images/inventoryimages/"..name..".xml"),
	}

	local assets_cooked =
	{
		Asset("ANIM", "anim/"..name.."_cooked.zip"),
	    Asset("ATLAS", "images/inventoryimages/"..name.."_cooked.xml"),
	}

	local assets_seeds =
	{
		Asset("ANIM", "anim/seeds.zip"),
	    Asset("ATLAS", "images/inventoryimages/"..name.."_seeds.xml"),
	}
		
	local prefabs =
	{	
		name.."_cooked",
		"spoiled_food",
	}
	
	if has_seeds then
		table.insert(prefabs, name.."_seeds")
	end

	local function fn_seeds()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		inst.entity:AddAnimState()
	    
		MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("seeds")
        inst.AnimState:SetBuild("seeds")
        inst.AnimState:SetRayTestOnBB(true)
		inst.AnimState:PlayAnimation("idle")

		inst:AddComponent("edible")
		inst.components.edible.healthvalue 	= TUNING.HEALING_TINY/2
		inst.components.edible.hungervalue 	= TUNING.CALORIES_TINY
		inst.components.edible.foodtype 	= "SEEDS"

        inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

		inst:AddComponent("tradable")
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
	    inst.components.inventoryitem.imagename = name.."_seeds"
	    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name.."_seeds.xml"

		inst:AddComponent("perishable")
		inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
		inst.components.perishable:StartPerishing()
		inst.components.perishable.onperishreplacement = "spoiled_food"

		inst:AddComponent("cookable")
		inst.components.cookable.product = "seeds_cooked"

		inst:AddComponent("bait")

		inst:AddComponent("plantable")
		inst.components.plantable.growtime = TUNING.SEEDS_GROW_TIME
		inst.components.plantable.product = name

		return inst
	end

	local function fn()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		inst.entity:AddAnimState()

		MakeInventoryPhysics(inst)

        inst.AnimState:SetBank(name)
        inst.AnimState:SetBuild(name)
        inst.AnimState:PlayAnimation("idle")

		inst:AddComponent("edible")
		inst.components.edible.healthvalue 	= CACAO_VEGGIES[name].health
		inst.components.edible.hungervalue 	= CACAO_VEGGIES[name].hunger
		inst.components.edible.sanityvalue 	= CACAO_VEGGIES[name].sanity or 0		
		inst.components.edible.foodtype 	= "VEGGIE"

        inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

		inst:AddComponent("tradable")
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
	    inst.components.inventoryitem.imagename = name
	    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name..".xml"

		inst:AddComponent("perishable")
		inst.components.perishable:SetPerishTime(CACAO_VEGGIES[name].perishtime)
		inst.components.perishable:StartPerishing()
		inst.components.perishable.onperishreplacement = "spoiled_food"   

		inst:AddComponent("bait")

		inst:AddComponent("cookable")
		inst.components.cookable.product = name.."_cooked"

	    MakeSmallBurnable(inst)
		MakeSmallPropagator(inst) 

		return inst
	end
	
	local function fn_cooked()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		inst.entity:AddAnimState()

		MakeInventoryPhysics(inst)

        inst.AnimState:SetBank(name.."_cooked")
        inst.AnimState:SetBuild(name.."_cooked")
        inst.AnimState:PlayAnimation("idle")

		inst:AddComponent("edible")
		inst.components.edible.healthvalue = CACAO_VEGGIES[name].cooked_health
		inst.components.edible.hungervalue = CACAO_VEGGIES[name].cooked_hunger
		inst.components.edible.sanityvalue = CACAO_VEGGIES[name].cooked_sanity or 0
		inst.components.edible.foodtype = "VEGGIE"

        inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

		inst:AddComponent("tradable")
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
	    inst.components.inventoryitem.imagename = name.."_cooked"
	    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name.."_cooked.xml"

		inst:AddComponent("perishable")
		inst.components.perishable:SetPerishTime(CACAO_VEGGIES[name].cooked_perishtime)
		inst.components.perishable:StartPerishing()
		inst.components.perishable.onperishreplacement = "spoiled_food"

		inst:AddComponent("bait")

	    MakeSmallBurnable(inst)
		MakeSmallPropagator(inst)

		return inst
	end

	local base = Prefab( "common/inventory/"..name, fn, assets, prefabs)
	local cooked = Prefab( "common/inventory/"..name.."_cooked", fn_cooked, assets_cooked)
	local seeds = has_seeds and Prefab( "common/inventory/"..name.."_seeds", fn_seeds, assets_seeds) or nil

	return base, cooked, seeds
end

local prefs = {}
for veggiename,veggiedata in pairs(CACAO_VEGGIES) do
	local veg, cooked, seeds

	veg, cooked, seeds = MakeVeggie(veggiename, true)

	table.insert(prefs, veg)
	table.insert(prefs, cooked)
	if seeds then
		table.insert(prefs, seeds)
		VEGGIES[veggiename] = veggiedata
	end
end

return unpack(prefs)