/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod;
import com.fs.starfarer.api.util.Misc;
import data.scripts.util.UW_Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;

public class CabalCargoCalc
extends BaseCommandPlugin {
    public static CargoAPI createCargoCopyWithCombinedCommodityStacks(CargoAPI cargo) {
        CargoAPI newCargo = Global.getFactory().createCargo(true);
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            newCargo.addFromStack(stack);
        }
        return newCargo;
    }

    public static float totalCargoValue(CargoAPI cargo) {
        float totalCreditsValue = 0.0f;
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            if (stack.isCommodityStack() && !stack.isCrewStack()) {
                float unadjustedValue = 0.0f;
                for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                    float thisUnadjustedValue = market.getDemandPrice(stack.getCommodityId(), (double)stack.getSize(), false);
                    unadjustedValue = Math.max(thisUnadjustedValue, unadjustedValue);
                }
                totalCreditsValue += unadjustedValue;
                continue;
            }
            if (!stack.isModSpecStack()) continue;
            float value = stack.getHullModSpecIfHullMod().getBaseValue() * stack.getSize();
            totalCreditsValue += value;
        }
        return totalCreditsValue;
    }

    public static float valueOfBiggestCommodityStack(CargoAPI cargo) {
        CargoAPI newCargo = CabalCargoCalc.createCargoCopyWithCombinedCommodityStacks(cargo);
        float supplyConsumptionPerDeploymentAndOneMonth = 0.0f;
        float fuelConsumptionIn20LY = 0.0f;
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            supplyConsumptionPerDeploymentAndOneMonth += member.getDeploymentCostSupplies();
            supplyConsumptionPerDeploymentAndOneMonth += member.getStats().getSuppliesPerMonth().getModifiedValue();
            fuelConsumptionIn20LY += member.getFuelUse() * 20.0f;
        }
        float biggestCreditsValue = 0.0f;
        for (CargoStackAPI stack : newCargo.getStacksCopy()) {
            float value;
            if (stack.isCommodityStack() && !stack.isCrewStack()) {
                float effectiveSize = stack.getSize();
                if (stack.isSupplyStack()) {
                    effectiveSize = Math.max(0.0f, effectiveSize - supplyConsumptionPerDeploymentAndOneMonth);
                }
                if (stack.isFuelStack()) {
                    effectiveSize = Math.max(0.0f, effectiveSize - fuelConsumptionIn20LY);
                }
                float value2 = 0.0f;
                for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                    float thisValue = market.getDemandPrice(stack.getCommodityId(), (double)effectiveSize, false);
                    value2 = Math.max(thisValue, value2);
                }
                if (!(value2 > biggestCreditsValue)) continue;
                biggestCreditsValue = value2;
                continue;
            }
            if (!stack.isModSpecStack() || !((value = stack.getHullModSpecIfHullMod().getBaseValue() * stack.getSize()) > biggestCreditsValue)) continue;
            biggestCreditsValue = value;
        }
        return biggestCreditsValue;
    }

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        float supplyConsumptionPerDeploymentAndOneMonth = 0.0f;
        float fuelConsumptionIn20LY = 0.0f;
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            supplyConsumptionPerDeploymentAndOneMonth += member.getDeploymentCostSupplies();
            supplyConsumptionPerDeploymentAndOneMonth += member.getStats().getSuppliesPerMonth().getModifiedValue();
            fuelConsumptionIn20LY += member.getFuelUse() * 20.0f;
        }
        CargoAPI cargo = CabalCargoCalc.createCargoCopyWithCombinedCommodityStacks(Global.getSector().getPlayerFleet().getCargo());
        float totalCreditsValue = CabalCargoCalc.totalCargoValue(cargo);
        double valueToTake = CabalPickExtortionMethod.extortionAmount(totalCreditsValue);
        valueToTake = Math.min(valueToTake, (double)fleet.getFleetPoints() * 5000.0);
        MarketAPI location = null;
        float biggestCreditsValue = 0.0f;
        float creditsPerBiggest = 0.0f;
        CargoStackAPI biggestStack = null;
        ArrayList<CargoExtortionInfo> multipleChoice = new ArrayList<CargoExtortionInfo>(2);
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            MarketAPI bestPriceAt;
            if (stack.isCommodityStack() && !stack.isCrewStack()) {
                float effectiveSize = stack.getSize();
                if (stack.isSupplyStack()) {
                    effectiveSize = Math.max(0.0f, effectiveSize - supplyConsumptionPerDeploymentAndOneMonth);
                }
                if (stack.isFuelStack()) {
                    effectiveSize = Math.max(0.0f, effectiveSize - fuelConsumptionIn20LY);
                }
                effectiveSize = (int)Math.min(effectiveSize, fleet.getCargo().getSpaceLeft());
                float value = 0.0f;
                bestPriceAt = null;
                for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                    float thisValue = market.getDemandPrice(stack.getCommodityId(), (double)effectiveSize, false);
                    if (!(thisValue > value)) continue;
                    bestPriceAt = market;
                    value = thisValue;
                }
                if (value > biggestCreditsValue) {
                    biggestCreditsValue = value;
                    creditsPerBiggest = value / effectiveSize;
                    biggestStack = stack;
                    location = bestPriceAt;
                }
                if (!((double)value > valueToTake)) continue;
                multipleChoice.add(new CargoExtortionInfo(stack, value, value / effectiveSize, bestPriceAt));
                continue;
            }
            if (!stack.isModSpecStack()) continue;
            float value = stack.getSize();
            if (stack.isModSpecStack()) {
                value *= stack.getHullModSpecIfHullMod().getBaseValue();
            }
            float stability = 0.0f;
            bestPriceAt = null;
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                float thisStability = market.getStabilityValue();
                if (!(thisStability > stability)) continue;
                bestPriceAt = market;
            }
            if (value > biggestCreditsValue) {
                biggestCreditsValue = value;
                creditsPerBiggest = value / stack.getSize();
                biggestStack = stack;
                location = bestPriceAt;
            }
            if (!((double)value > valueToTake)) continue;
            multipleChoice.add(new CargoExtortionInfo(stack, value, value / stack.getSize(), bestPriceAt));
        }
        if (!multipleChoice.isEmpty()) {
            int index = MathUtils.getRandomNumberInRange((int)0, (int)(multipleChoice.size() - 1));
            biggestStack = ((CargoExtortionInfo)multipleChoice.get((int)index)).stack;
            biggestCreditsValue = ((CargoExtortionInfo)multipleChoice.get((int)index)).value;
            creditsPerBiggest = ((CargoExtortionInfo)multipleChoice.get((int)index)).valuePerUnit;
            location = ((CargoExtortionInfo)multipleChoice.get((int)index)).location;
        }
        if (biggestStack == null || location == null) {
            return false;
        }
        float effectiveSize = biggestStack.getSize();
        if (biggestStack.isSupplyStack()) {
            effectiveSize = Math.max(0.0f, effectiveSize - supplyConsumptionPerDeploymentAndOneMonth);
        }
        if (biggestStack.isFuelStack()) {
            effectiveSize = Math.max(0.0f, effectiveSize - fuelConsumptionIn20LY);
        }
        effectiveSize = (int)Math.min(effectiveSize, fleet.getCargo().getSpaceLeft());
        int amountToTake = (int)UW_Util.roundToSignificantFiguresLong(Math.min((double)effectiveSize, valueToTake / (double)creditsPerBiggest), 2);
        int amountLeft = (int)(biggestStack.getSize() - (float)amountToTake);
        if (amountToTake < 1) {
            return false;
        }
        float finalValue = (float)amountToTake * (biggestCreditsValue / effectiveSize);
        float repImpact = finalValue <= 25000.0f ? 0.01f : (finalValue <= 50000.0f ? 0.02f : (finalValue <= 100000.0f ? 0.03f : (finalValue <= 200000.0f ? 0.04f : 0.05f)));
        memoryMap.get("local").set("$Cabal_cargo_name", (Object)biggestStack.getDisplayName().toLowerCase(), 0.0f);
        if (biggestStack.isCommodityStack()) {
            memoryMap.get("local").set("$Cabal_cargo_id", (Object)biggestStack.getCommodityId(), 0.0f);
        } else if (biggestStack.isModSpecStack()) {
            memoryMap.get("local").set("$Cabal_cargo_id", (Object)biggestStack.getHullModSpecIfHullMod().getId(), 0.0f);
        }
        memoryMap.get("local").set("$Cabal_cargo_amount", (Object)amountToTake, 0.0f);
        memoryMap.get("local").set("$Cabal_cargo_amount_string", (Object)Misc.getWithDGS((float)amountToTake), 0.0f);
        memoryMap.get("local").set("$Cabal_cargo_amount_left_string", (Object)Misc.getWithDGS((float)amountLeft), 0.0f);
        memoryMap.get("local").set("$Cabal_cargo_best_location", (Object)location.getName(), 0.0f);
        memoryMap.get("local").set("$Cabal_cargo_final_value", (Object)Misc.getWithDGS((float)UW_Util.roundToSignificantFiguresLong(finalValue, 2)), 0.0f);
        memoryMap.get("local").set("$Cabal_repImpact", (Object)Float.valueOf(repImpact), 0.0f);
        return true;
    }

    private static class CargoExtortionInfo {
        MarketAPI location;
        CargoStackAPI stack;
        float value;
        float valuePerUnit;

        CargoExtortionInfo(CargoStackAPI stack, float value, float valuePerUnit, MarketAPI location) {
            this.stack = stack;
            this.value = value;
            this.valuePerUnit = valuePerUnit;
            this.location = location;
        }
    }
}

