/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.util.Misc;
import data.scripts.util.UW_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;

public class CabalFighterCalc
extends BaseCommandPlugin {
    public static float bestFighterFanciness(CampaignFleetAPI fleet) {
        Collection<FighterExtortionInfo> fighters = CabalFighterCalc.getFleetFighters(fleet);
        float fanciestFighterFanciness = 0.0f;
        for (FighterExtortionInfo fighterInfo : fighters) {
            int maximum = 5;
            int effectiveCount = Math.min(fighterInfo.count, maximum);
            float baseValue = fighterInfo.fighterSpec.getBaseValue();
            int tier = fighterInfo.fighterSpec.getTier();
            float fanciness = (float)Math.sqrt(baseValue / 1000.0f) * (float)Math.pow(tier, 2.0) * (float)effectiveCount;
            if (!(fanciness > fanciestFighterFanciness)) continue;
            fanciestFighterFanciness = fanciness;
        }
        return fanciestFighterFanciness;
    }

    public static float totalFightersValue(CampaignFleetAPI fleet) {
        Collection<FighterExtortionInfo> fightersList = CabalFighterCalc.getFleetFighters(fleet);
        float totalFightersValue = 0.0f;
        for (FighterExtortionInfo fighterInfo : fightersList) {
            float value = fighterInfo.fighterSpec.getBaseValue() * (float)fighterInfo.count * Global.getSettings().getFloat("nonEconItemSellPriceMult");
            totalFightersValue += value;
        }
        return totalFightersValue;
    }

    private static Collection<FighterExtortionInfo> getFleetFighters(CampaignFleetAPI fleet) {
        LinkedHashMap<Object, FighterExtortionInfo> fighterInfoMap = new LinkedHashMap<Object, FighterExtortionInfo>(100);
        CargoAPI cargo = fleet.getCargo();
        for (CargoAPI.CargoItemQuantity fighterStack : cargo.getFighters()) {
            FighterExtortionInfo playerFighter = (FighterExtortionInfo)fighterInfoMap.get(fighterStack.getItem());
            if (playerFighter == null) {
                playerFighter = new FighterExtortionInfo(Global.getSettings().getFighterWingSpec((String)fighterStack.getItem()), 0);
                fighterInfoMap.put(fighterStack.getItem(), playerFighter);
            }
            playerFighter.count += fighterStack.getCount();
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isFighterWing()) continue;
            ShipVariantAPI variant = member.getVariant();
            for (int i = 0; i < 20; ++i) {
                FighterWingSpecAPI fighterSpec = variant.getWing(i);
                if (fighterSpec == null || !variant.getNonBuiltInWings().contains(fighterSpec.getId())) continue;
                FighterExtortionInfo playerFighter = (FighterExtortionInfo)fighterInfoMap.get(fighterSpec.getId());
                if (playerFighter == null) {
                    playerFighter = new FighterExtortionInfo(fighterSpec, 0);
                    fighterInfoMap.put(fighterSpec.getId(), playerFighter);
                }
                ++playerFighter.count;
            }
        }
        return fighterInfoMap.values();
    }

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        float totalCreditsValue = CabalFighterCalc.totalFightersValue(Global.getSector().getPlayerFleet());
        double valueToTake = CabalPickExtortionMethod.extortionAmount(totalCreditsValue);
        valueToTake = Math.min(valueToTake, (double)fleet.getFleetPoints() * 5000.0);
        Collection<FighterExtortionInfo> playerFighters = CabalFighterCalc.getFleetFighters(Global.getSector().getPlayerFleet());
        String fanciestFighterId = null;
        String fanciestFighterName = null;
        int fanciestFighterCount = 0;
        float fanciestFighterStackValue = 0.0f;
        float fanciestFighterFanciness = 0.0f;
        ArrayList<FighterExtortionInfo> multipleChoice = new ArrayList<FighterExtortionInfo>(2);
        for (FighterExtortionInfo fighterInfo : playerFighters) {
            boolean cargoSizePerUnit = true;
            int maximum = 5;
            int effectiveCount = Math.min(Math.min(fighterInfo.count, maximum), (int)(fleet.getCargo().getSpaceLeft() / (float)cargoSizePerUnit));
            float value = fighterInfo.fighterSpec.getBaseValue() * (float)effectiveCount * Global.getSettings().getFloat("nonEconItemSellPriceMult");
            float baseValue = fighterInfo.fighterSpec.getBaseValue();
            int tier = fighterInfo.fighterSpec.getTier();
            float fanciness = (float)Math.sqrt(baseValue / 1000.0f) * (float)Math.pow(tier, 2.0) * (float)effectiveCount;
            if (fanciness > fanciestFighterFanciness) {
                fanciestFighterId = fighterInfo.fighterSpec.getId();
                fanciestFighterName = fighterInfo.fighterSpec.getVariant().getFullDesignationWithHullName();
                fanciestFighterCount = effectiveCount;
                fanciestFighterStackValue = value;
                fanciestFighterFanciness = fanciness;
            }
            if (!((double)value > valueToTake)) continue;
            multipleChoice.add(fighterInfo);
        }
        if (!multipleChoice.isEmpty()) {
            int index = MathUtils.getRandomNumberInRange((int)0, (int)(multipleChoice.size() - 1));
            boolean cargoSizePerUnit = true;
            int effectiveCount = Math.min(((FighterExtortionInfo)multipleChoice.get((int)index)).count, (int)(fleet.getCargo().getSpaceLeft() / (float)cargoSizePerUnit));
            float baseValue = ((FighterExtortionInfo)multipleChoice.get((int)index)).fighterSpec.getBaseValue();
            int tier = ((FighterExtortionInfo)multipleChoice.get((int)index)).fighterSpec.getTier();
            fanciestFighterId = ((FighterExtortionInfo)multipleChoice.get((int)index)).fighterSpec.getId();
            fanciestFighterName = ((FighterExtortionInfo)multipleChoice.get((int)index)).fighterSpec.getVariant().getFullDesignationWithHullName();
            fanciestFighterCount = effectiveCount;
            fanciestFighterStackValue = ((FighterExtortionInfo)multipleChoice.get((int)index)).fighterSpec.getBaseValue() * (float)effectiveCount * Global.getSettings().getFloat("nonEconItemSellPriceMult");
            fanciestFighterFanciness = (float)Math.sqrt(baseValue / 1000.0f) * (float)Math.pow(tier, 2.0) * (float)effectiveCount;
        }
        if (fanciestFighterId == null) {
            return false;
        }
        float creditsPer = fanciestFighterStackValue / (float)fanciestFighterCount;
        int amountToTake = (int)UW_Util.roundToSignificantFiguresLong(Math.min((double)fanciestFighterCount, valueToTake / (double)creditsPer), 2);
        if (amountToTake < 1) {
            return false;
        }
        float finalFanciness = (float)amountToTake * (fanciestFighterFanciness / (float)fanciestFighterCount);
        float repImpact = finalFanciness <= 50.0f ? 0.01f : (finalFanciness <= 100.0f ? 0.02f : (finalFanciness <= 200.0f ? 0.03f : (finalFanciness <= 400.0f ? 0.04f : 0.05f)));
        float collectorValue = (float)amountToTake * (fanciestFighterStackValue / (float)fanciestFighterCount) / Global.getSettings().getFloat("nonEconItemSellPriceMult") * Global.getSettings().getFloat("nonEconItemBuyPriceMult") + finalFanciness * 500.0f;
        memoryMap.get("local").set("$Cabal_fighter_name", (Object)fanciestFighterName, 0.0f);
        memoryMap.get("local").set("$Cabal_fighter_names", (Object)(fanciestFighterName + (amountToTake > 1 ? "s" : "")), 0.0f);
        memoryMap.get("local").set("$Cabal_fighter_id", (Object)fanciestFighterId, 0.0f);
        memoryMap.get("local").set("$Cabal_fighter_amount", (Object)amountToTake, 0.0f);
        memoryMap.get("local").set("$Cabal_fighter_amount_string", (Object)Misc.getWithDGS((float)amountToTake), 0.0f);
        memoryMap.get("local").set("$Cabal_fighter_collector_value_string", (Object)Misc.getWithDGS((float)UW_Util.roundToSignificantFiguresLong(collectorValue, 2)), 0.0f);
        memoryMap.get("local").set("$Cabal_repImpact", (Object)Float.valueOf(repImpact), 0.0f);
        return true;
    }

    private static class FighterExtortionInfo {
        int count;
        FighterWingSpecAPI fighterSpec;

        FighterExtortionInfo(FighterWingSpecAPI fighterSpec, int count) {
            this.fighterSpec = fighterSpec;
            this.count = count;
        }
    }
}

