/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalCargoCalc;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalShipCalc;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalWeaponCalc;
import com.fs.starfarer.api.util.Misc;
import data.scripts.util.UW_Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CabalNormalTalk
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        ArrayList<String> marketList = new ArrayList<String>(10);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.hasCondition("cabal_influence")) continue;
            marketList.add(market.getName());
        }
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        float totalCargoValue = CabalCargoCalc.valueOfBiggestCommodityStack(Global.getSector().getPlayerFleet().getCargo());
        float totalWeaponsValue = CabalWeaponCalc.totalWeaponsValue(Global.getSector().getPlayerFleet());
        float totalShipsValue = CabalShipCalc.totalShipsValue(Global.getSector().getPlayerFleet());
        float netWorth = credits + totalCargoValue + totalWeaponsValue + totalShipsValue;
        String marketListStr = Misc.getAndJoined((String[])marketList.toArray(new String[marketList.size()]));
        memoryMap.get("local").set("$Cabal_markets", (Object)marketListStr, 0.0f);
        memoryMap.get("local").set("$Cabal_netWorthString", (Object)Misc.getDGSCredits((float)UW_Util.roundToSignificantFiguresLong(netWorth, 4)), 0.0f);
        return true;
    }
}

