/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalCargoCalc;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalFighterCalc;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalShipCalc;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalWeaponCalc;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.util.UW_Util;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CabalPickExtortionMethod
extends BaseCommandPlugin {
    public static Logger log = Global.getLogger(CabalPickExtortionMethod.class);

    public static double extortionAmount(float credits) {
        double tithe = credits < 200000.0f ? (double)credits / 2.0 : ((double)credits < 500000.0 ? 100000.0 + ((double)credits - 200000.0) / 3.0 : ((double)credits < 900000.0 ? 200000.0 + ((double)credits - 500000.0) / 4.0 : ((double)credits < 1400000.0 ? 300000.0 + ((double)credits - 900000.0) / 5.0 : ((double)credits < 2000000.0 ? 400000.0 + ((double)credits - 1400000.0) / 6.0 : ((double)credits < 2700000.0 ? 500000.0 + ((double)credits - 2000000.0) / 7.0 : ((double)credits < 3500000.0 ? 600000.0 + ((double)credits - 2700000.0) / 8.0 : ((double)credits < 4400000.0 ? 700000.0 + ((double)credits - 3500000.0) / 9.0 : ((double)credits < 5400000.0 ? 800000.0 + ((double)credits - 4400000.0) / 10.0 : ((double)credits < 6500000.0 ? 900000.0 + ((double)credits - 5400000.0) / 11.0 : ((double)credits < 7700000.0 ? 1000000.0 + ((double)credits - 6500000.0) / 12.0 : ((double)credits < 9000000.0 ? 1100000.0 + ((double)credits - 7700000.0) / 13.0 : ((double)credits < 1.04E7 ? 1200000.0 + ((double)credits - 9000000.0) / 14.0 : 1300000.0 + ((double)credits - 1.04E7) / 15.0))))))))))));
        return tithe;
    }

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        WeightedRandomPicker extortionMethods = new WeightedRandomPicker();
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        float totalCargoValue = CabalCargoCalc.totalCargoValue(Global.getSector().getPlayerFleet().getCargo());
        float totalWeaponsValue = CabalWeaponCalc.totalWeaponsValue(Global.getSector().getPlayerFleet());
        float totalFightersValue = CabalFighterCalc.totalFightersValue(Global.getSector().getPlayerFleet());
        float totalShipsValue = CabalShipCalc.totalShipsValue(Global.getSector().getPlayerFleet());
        float netWorth = credits + totalCargoValue + totalWeaponsValue + totalFightersValue + totalShipsValue;
        float targetExtortion = (float)CabalPickExtortionMethod.extortionAmount(netWorth);
        log.info((Object)("Seen credit value of " + credits));
        log.info((Object)("Calculated cargo value of " + totalCargoValue));
        log.info((Object)("Calculated weapons value of " + totalWeaponsValue));
        log.info((Object)("Calculated fighters value of " + totalFightersValue));
        log.info((Object)("Calculated ships value of " + totalShipsValue));
        log.info((Object)("Evaluated net worth at " + netWorth));
        log.info((Object)("Targeting extortion value at " + targetExtortion));
        float lowerThreshold = Math.min(200000.0f, (float)fleet.getFleetPoints() * 2500.0f);
        float upperThreshold = (float)fleet.getFleetPoints() * 5000.0f;
        if (credits > lowerThreshold) {
            float weight = (float)Math.sqrt(Math.min(credits, upperThreshold) / targetExtortion);
            extortionMethods.add((Object)"tithe", weight);
            log.info((Object)("Tithe extortion method at weight " + weight));
        }
        lowerThreshold = Math.min(25000.0f, (float)fleet.getFleetPoints() * 2500.0f);
        upperThreshold = (float)fleet.getFleetPoints() * 5000.0f;
        float cargoValue = CabalCargoCalc.valueOfBiggestCommodityStack(Global.getSector().getPlayerFleet().getCargo());
        if (cargoValue > lowerThreshold) {
            float weight = (float)Math.sqrt(Math.min(cargoValue, upperThreshold) / targetExtortion);
            extortionMethods.add((Object)"cargo", weight);
            log.info((Object)("Cargo extortion method at weight " + weight));
        }
        lowerThreshold = Math.min(50.0f, (float)fleet.getFleetPoints() * 5.0f);
        float weaponFanciness = CabalWeaponCalc.bestWeaponFanciness(Global.getSector().getPlayerFleet());
        if (weaponFanciness > lowerThreshold) {
            float weight = (float)Math.sqrt(weaponFanciness / (targetExtortion / 500.0f)) * 1.5f;
            extortionMethods.add((Object)"weapon", weight);
            log.info((Object)("Weapon extortion method at weight " + weight));
        }
        lowerThreshold = Math.min(40.0f, (float)fleet.getFleetPoints() * 4.0f);
        float fighterFanciness = CabalFighterCalc.bestFighterFanciness(Global.getSector().getPlayerFleet());
        if (fighterFanciness > lowerThreshold) {
            float weight = (float)Math.sqrt(fighterFanciness / (targetExtortion / 500.0f)) * 1.5f;
            extortionMethods.add((Object)"fighter", weight);
            log.info((Object)("Fighter extortion method at weight " + weight));
        }
        lowerThreshold = Math.min(25000.0f, (float)fleet.getFleetPoints() * 2500.0f);
        upperThreshold = (float)fleet.getFleetPoints() * 5000.0f;
        float shipValue = CabalShipCalc.bestShipValue(Global.getSector().getPlayerFleet(), upperThreshold);
        if (shipValue > lowerThreshold && CabalShipCalc.usableShips(Global.getSector().getPlayerFleet()) > 1) {
            float weight = (float)Math.sqrt(Math.min(shipValue, upperThreshold) / targetExtortion) * 0.5f;
            extortionMethods.add((Object)"ship", weight);
            log.info((Object)("Ship extortion method at weight " + weight));
        }
        if (extortionMethods.isEmpty()) {
            memoryMap.get("local").set("$Cabal_extortionMethod", (Object)"none", 0.0f);
            return false;
        }
        memoryMap.get("local").set("$Cabal_extortionMethod", extortionMethods.pick(), 7.0f);
        memoryMap.get("local").set("$Cabal_netWorthString", (Object)Misc.getDGSCredits((float)UW_Util.roundToSignificantFiguresLong(netWorth, 4)), 0.0f);
        return true;
    }
}

