/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;

public class CabalShipCalc
extends BaseCommandPlugin {
    public static float bestShipValue(CampaignFleetAPI fleet, float maxValue) {
        float bestShipValue = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float value = member.getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            if (!(value > bestShipValue) || !(value <= maxValue)) continue;
            bestShipValue = value;
        }
        return bestShipValue;
    }

    public static float totalShipsValue(CampaignFleetAPI fleet) {
        float totalShipValue = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float value = member.getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            totalShipValue += value;
        }
        return totalShipValue;
    }

    public static int usableShips(CampaignFleetAPI fleet) {
        int usableShips = 0;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isFighterWing()) continue;
            ++usableShips;
        }
        return usableShips;
    }

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        float totalCreditsValue = CabalShipCalc.totalShipsValue(Global.getSector().getPlayerFleet());
        double valueToTake = CabalPickExtortionMethod.extortionAmount(totalCreditsValue);
        valueToTake = Math.min(valueToTake, (double)fleet.getFleetPoints() * 5000.0);
        double minimumToTake = Math.min(valueToTake, (double)fleet.getFleetPoints() * 1000.0);
        float thresholdForMultipleChoice = Math.max((float)minimumToTake, totalCreditsValue / 2.0f);
        FleetMemberAPI bestShip = null;
        float bestShipValue = 0.0f;
        ArrayList<FleetMemberAPI> multipleChoice = new ArrayList<FleetMemberAPI>(Global.getSector().getPlayerFleet().getFleetData().getNumMembers());
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            float value = member.getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            if ((double)value > valueToTake) continue;
            if (value > bestShipValue) {
                bestShip = member;
                bestShipValue = value;
            }
            if (!(value > thresholdForMultipleChoice)) continue;
            multipleChoice.add(member);
        }
        if (!multipleChoice.isEmpty()) {
            int index = MathUtils.getRandomNumberInRange((int)0, (int)(multipleChoice.size() - 1));
            bestShipValue = ((FleetMemberAPI)multipleChoice.get(index)).getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            bestShip = (FleetMemberAPI)multipleChoice.get(index);
        }
        if (bestShip == null) {
            return false;
        }
        for (String slot : bestShip.getVariant().getFittedWeaponSlots()) {
            WeaponSpecAPI weapon = bestShip.getVariant().getWeaponSpec(slot);
            bestShipValue += weapon.getBaseValue() * Global.getSettings().getFloat("nonEconItemSellPriceMult");
        }
        float repImpact = bestShipValue <= 25000.0f ? 0.01f : (bestShipValue <= 50000.0f ? 0.02f : (bestShipValue <= 100000.0f ? 0.03f : (bestShipValue <= 200000.0f ? 0.04f : (bestShipValue <= 400000.0f ? 0.05f : (bestShipValue <= 800000.0f ? 0.06f : (bestShipValue <= 1600000.0f ? 0.07f : (bestShipValue <= 3200000.0f ? 0.08f : (bestShipValue <= 6400000.0f ? 0.09f : 0.1f))))))));
        memoryMap.get("local").set("$Cabal_ship_name", (Object)bestShip.getShipName(), 0.0f);
        memoryMap.get("local").set("$Cabal_ship_hull", (Object)bestShip.getHullSpec().getHullName(), 0.0f);
        memoryMap.get("local").set("$Cabal_ship_hull_full", (Object)bestShip.getVariant().getFullDesignationWithHullName(), 0.0f);
        memoryMap.get("local").set("$Cabal_ship_uuid", (Object)bestShip.getId(), 0.0f);
        memoryMap.get("local").set("$Cabal_ship_is_fighter", (Object)bestShip.isFighterWing(), 0.0f);
        memoryMap.get("local").set("$Cabal_repImpact", (Object)Float.valueOf(repImpact), 0.0f);
        return true;
    }
}

