/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class CabalTransferFighters
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        String id = params.get(0).getString(memoryMap);
        int qty = Math.round(params.get(1).getFloat(memoryMap));
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int currQty = cargo.getNumFighters(id);
        if (currQty >= qty) {
            cargo.removeItems(CargoAPI.CargoItemType.FIGHTER_CHIP, (Object)id, (float)qty);
            fleet.getCargo().addFighters(id, qty);
            return true;
        }
        if (currQty > 0) {
            cargo.removeItems(CargoAPI.CargoItemType.FIGHTER_CHIP, (Object)id, (float)currQty);
            cargo.removeEmptyStacks();
            qty -= currQty;
        }
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (member.isFighterWing()) continue;
            ShipVariantAPI variant = member.getVariant();
            boolean changed = false;
            for (int i = 0; i < 20; ++i) {
                String fighterId;
                FighterWingSpecAPI fighterSpec = variant.getWing(i);
                if (fighterSpec == null || (fighterId = fighterSpec.getId()) == null || !fighterId.contentEquals(id)) continue;
                changed = true;
                if (variant.getSource() == VariantSource.STOCK || variant.getSource() == VariantSource.HULL) {
                    variant = variant.clone();
                    variant.setSource(VariantSource.REFIT);
                }
                variant.setWingId(i, "");
                if (--qty > 0) continue;
                member.setVariant(variant, false, false);
                fleet.getCargo().addFighters(id, qty);
                return true;
            }
            if (!changed) continue;
            member.setVariant(variant, false, false);
        }
        fleet.getCargo().addFighters(id, qty);
        return true;
    }
}

