/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import data.scripts.util.UW_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;

public class CabalWeaponCalc
extends BaseCommandPlugin {
    public static float bestWeaponFanciness(CampaignFleetAPI fleet) {
        Collection<WeaponExtortionInfo> weapons = CabalWeaponCalc.getFleetWeapons(fleet);
        float fanciestWeaponFanciness = 0.0f;
        for (WeaponExtortionInfo weaponInfo : weapons) {
            int maximum = weaponInfo.weaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL ? 15 : (weaponInfo.weaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM ? 10 : 5);
            int effectiveCount = Math.min(weaponInfo.count, maximum);
            float baseValue = weaponInfo.weaponSpec.getBaseValue();
            int tier = weaponInfo.weaponSpec.getTier();
            float fanciness = (float)Math.sqrt(baseValue / 1000.0f) * (float)Math.pow(tier, 2.0) * (float)effectiveCount;
            if (!(fanciness > fanciestWeaponFanciness)) continue;
            fanciestWeaponFanciness = fanciness;
        }
        return fanciestWeaponFanciness;
    }

    public static float totalWeaponsValue(CampaignFleetAPI fleet) {
        Collection<WeaponExtortionInfo> weaponsList = CabalWeaponCalc.getFleetWeapons(fleet);
        float totalWeaponsValue = 0.0f;
        for (WeaponExtortionInfo weaponInfo : weaponsList) {
            float value = weaponInfo.weaponSpec.getBaseValue() * (float)weaponInfo.count * Global.getSettings().getFloat("nonEconItemSellPriceMult");
            totalWeaponsValue += value;
        }
        return totalWeaponsValue;
    }

    private static Collection<WeaponExtortionInfo> getFleetWeapons(CampaignFleetAPI fleet) {
        LinkedHashMap<Object, WeaponExtortionInfo> weaponInfoMap = new LinkedHashMap<Object, WeaponExtortionInfo>(100);
        CargoAPI cargo = fleet.getCargo();
        for (CargoAPI.CargoItemQuantity weaponStack : cargo.getWeapons()) {
            WeaponExtortionInfo playerWeapon = (WeaponExtortionInfo)weaponInfoMap.get(weaponStack.getItem());
            if (playerWeapon == null) {
                playerWeapon = new WeaponExtortionInfo(Global.getSettings().getWeaponSpec((String)weaponStack.getItem()), 0);
                weaponInfoMap.put(weaponStack.getItem(), playerWeapon);
            }
            playerWeapon.count += weaponStack.getCount();
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isFighterWing()) continue;
            ShipVariantAPI variant = member.getVariant();
            ShipHullSpecAPI hullSpec = member.getHullSpec();
            for (WeaponSlotAPI slot : hullSpec.getAllWeaponSlotsCopy()) {
                WeaponSpecAPI weaponSpec;
                if (slot.isBuiltIn() || slot.isDecorative() || slot.isSystemSlot() || (weaponSpec = variant.getWeaponSpec(slot.getId())) == null) continue;
                WeaponExtortionInfo playerWeapon = (WeaponExtortionInfo)weaponInfoMap.get(weaponSpec.getWeaponId());
                if (playerWeapon == null) {
                    playerWeapon = new WeaponExtortionInfo(weaponSpec, 0);
                    weaponInfoMap.put(weaponSpec.getWeaponId(), playerWeapon);
                }
                ++playerWeapon.count;
            }
        }
        return weaponInfoMap.values();
    }

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        float totalCreditsValue = CabalWeaponCalc.totalWeaponsValue(Global.getSector().getPlayerFleet());
        double valueToTake = CabalPickExtortionMethod.extortionAmount(totalCreditsValue);
        valueToTake = Math.min(valueToTake, (double)fleet.getFleetPoints() * 5000.0);
        Collection<WeaponExtortionInfo> playerWeapons = CabalWeaponCalc.getFleetWeapons(Global.getSector().getPlayerFleet());
        String fanciestWeaponId = null;
        String fanciestWeaponName = null;
        int fanciestWeaponCount = 0;
        float fanciestWeaponStackValue = 0.0f;
        float fanciestWeaponFanciness = 0.0f;
        ArrayList<WeaponExtortionInfo> multipleChoice = new ArrayList<WeaponExtortionInfo>(2);
        for (WeaponExtortionInfo weaponInfo : playerWeapons) {
            int maximum;
            int cargoSizePerUnit;
            if (weaponInfo.weaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                cargoSizePerUnit = 2;
                maximum = 15;
            } else if (weaponInfo.weaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                cargoSizePerUnit = 4;
                maximum = 10;
            } else {
                cargoSizePerUnit = 8;
                maximum = 5;
            }
            int effectiveCount = Math.min(Math.min(weaponInfo.count, maximum), (int)(fleet.getCargo().getSpaceLeft() / (float)cargoSizePerUnit));
            float value = weaponInfo.weaponSpec.getBaseValue() * (float)effectiveCount * Global.getSettings().getFloat("nonEconItemSellPriceMult");
            float baseValue = weaponInfo.weaponSpec.getBaseValue();
            int tier = weaponInfo.weaponSpec.getTier();
            float fanciness = (float)Math.sqrt(baseValue / 1000.0f) * (float)Math.pow(tier, 2.0) * (float)effectiveCount;
            if (fanciness > fanciestWeaponFanciness) {
                fanciestWeaponId = weaponInfo.weaponSpec.getWeaponId();
                fanciestWeaponName = weaponInfo.weaponSpec.getWeaponName();
                fanciestWeaponCount = effectiveCount;
                fanciestWeaponStackValue = value;
                fanciestWeaponFanciness = fanciness;
            }
            if (!((double)value > valueToTake)) continue;
            multipleChoice.add(weaponInfo);
        }
        if (!multipleChoice.isEmpty()) {
            int index = MathUtils.getRandomNumberInRange((int)0, (int)(multipleChoice.size() - 1));
            int cargoSizePerUnit = ((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL ? 2 : (((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM ? 4 : 8);
            int effectiveCount = Math.min(((WeaponExtortionInfo)multipleChoice.get((int)index)).count, (int)(fleet.getCargo().getSpaceLeft() / (float)cargoSizePerUnit));
            float baseValue = ((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getBaseValue();
            int tier = ((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getTier();
            fanciestWeaponId = ((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getWeaponId();
            fanciestWeaponName = ((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getWeaponName();
            fanciestWeaponCount = effectiveCount;
            fanciestWeaponStackValue = ((WeaponExtortionInfo)multipleChoice.get((int)index)).weaponSpec.getBaseValue() * (float)effectiveCount * Global.getSettings().getFloat("nonEconItemSellPriceMult");
            fanciestWeaponFanciness = (float)Math.sqrt(baseValue / 1000.0f) * (float)Math.pow(tier, 2.0) * (float)effectiveCount;
        }
        if (fanciestWeaponId == null) {
            return false;
        }
        float creditsPer = fanciestWeaponStackValue / (float)fanciestWeaponCount;
        int amountToTake = (int)UW_Util.roundToSignificantFiguresLong(Math.min((double)fanciestWeaponCount, valueToTake / (double)creditsPer), 2);
        if (amountToTake < 1) {
            return false;
        }
        float finalFanciness = (float)amountToTake * (fanciestWeaponFanciness / (float)fanciestWeaponCount);
        float repImpact = finalFanciness <= 50.0f ? 0.01f : (finalFanciness <= 100.0f ? 0.02f : (finalFanciness <= 200.0f ? 0.03f : (finalFanciness <= 400.0f ? 0.04f : 0.05f)));
        float collectorValue = (float)amountToTake * (fanciestWeaponStackValue / (float)fanciestWeaponCount) / Global.getSettings().getFloat("nonEconItemSellPriceMult") * Global.getSettings().getFloat("nonEconItemBuyPriceMult") + finalFanciness * 500.0f;
        memoryMap.get("local").set("$Cabal_weapon_name", (Object)fanciestWeaponName, 0.0f);
        memoryMap.get("local").set("$Cabal_weapon_names", (Object)(fanciestWeaponName + (amountToTake > 1 ? "s" : "")), 0.0f);
        memoryMap.get("local").set("$Cabal_weapon_id", (Object)fanciestWeaponId, 0.0f);
        memoryMap.get("local").set("$Cabal_weapon_amount", (Object)amountToTake, 0.0f);
        memoryMap.get("local").set("$Cabal_weapon_amount_string", (Object)Misc.getWithDGS((float)amountToTake), 0.0f);
        memoryMap.get("local").set("$Cabal_weapon_collector_value_string", (Object)Misc.getWithDGS((float)UW_Util.roundToSignificantFiguresLong(collectorValue, 2)), 0.0f);
        memoryMap.get("local").set("$Cabal_repImpact", (Object)Float.valueOf(repImpact), 0.0f);
        return true;
    }

    private static class WeaponExtortionInfo {
        int count;
        WeaponSpecAPI weaponSpec;

        WeaponExtortionInfo(WeaponSpecAPI weaponSpec, int count) {
            this.weaponSpec = weaponSpec;
            this.count = count;
        }
    }
}

