/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.ResourceCostPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class UW_ExtortFleet
extends BaseCommandPlugin {
    public static final Set<String> ALLOWED_FLEET_TYPES = new HashSet<String>(Arrays.asList("trade", "tradeLiner", "smallTrader", "tradeSmuggler", "foodReliefFleet", "scavengerSmall", "scavengerMedium", "scavengerLarge"));
    public static final float CARGO_DROP_MULT = 0.5f;
    public static final float FLEET_FP_XP_MULT = 20.0f;
    public static final float FLEET_VALUE_EXTORT_MULT = 0.15f;
    public static final String MEMORY_FLAG_CARGO = "$uw_fleetCargo";
    public static final float PATROL_ALERT_RANGE_HYPERSPACE = 2500.0f;

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String arg = params.get(0).getString(memoryMap);
        SectorEntityToken target = dialog.getInteractionTarget();
        MemoryAPI mem = memoryMap.get("entity");
        if (target == null || !(target instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI fleet = (CampaignFleetAPI)target;
        switch (arg) {
            case "addOptions": {
                this.addExtortOptions(fleet, dialog, mem);
                break;
            }
            case "getCredits": {
                return this.getCredits(fleet, mem) > 0.0f;
            }
            case "getCargo": {
                return !this.getCargo(fleet, mem).isEmpty();
            }
            case "printCargo": {
                this.printCargo(fleet, mem, dialog.getTextPanel());
                break;
            }
            case "modifyRep": {
                return this.modifyRep((SectorEntityToken)fleet, params.get(1).getString(memoryMap), dialog);
            }
            case "addXP": {
                this.addXP(fleet);
                break;
            }
            case "dropCargo": {
                this.dropCargo(fleet, mem);
                break;
            }
            case "rollViolentResistance": {
                this.rollViolentResistance(fleet, memoryMap.get("local").getString("$uw_extortMode"));
                break;
            }
            case "alertPatrols": {
                this.alertPatrols(fleet);
                break;
            }
            case "canExtortFleet": {
                return this.canExtortFleet(fleet, mem);
            }
        }
        return true;
    }

    protected void addCargoEntry(ResourceCostPanelAPI cost, String commodityId, int available, int toDrop) {
        Color curr = Global.getSector().getPlayerFaction().getColor();
        cost.addCost(commodityId, "" + toDrop + " (" + available + ")", curr);
    }

    protected void addExtortOptions(CampaignFleetAPI fleet, InteractionDialogAPI dialog, MemoryAPI mem) {
        if (!FleetInteractionDialogPluginImpl.inConversation) {
            return;
        }
        if (mem.getBoolean("$uw_extortResistViolently")) {
            return;
        }
        dialog.getOptionPanel().addOption("\"\u4f60\u6709\u4e00\u9879\u672a\u652f\u4ed8\u7684\u901a\u884c\u8d39!\"", (Object)"uw_extortCredits");
        dialog.getOptionPanel().addOption("\"\u629b\u5f03\u4f60\u7684\u8d27\u7269, \u5426\u5219\u540e\u679c\u81ea\u8d1f!\"", (Object)"uw_extortCargo");
        if (this.isHighRepImpact(fleet)) {
            String factionName = fleet.getFaction().getDisplayNameWithArticle();
            String isOrAre = fleet.getFaction().getDisplayNameIsOrAre();
            String extortConfirm = factionName + " " + isOrAre + " \u76ee\u524d\u8fd8\u4e0d\u5b58\u5728\u654c\u610f, \u56e0\u4e3a\u4f60\u5df2\u7ecf\u5f97\u5230\u4e86\u4ed6\u4eec\u7684\u80af\u5b9a\u4e0e\u8ba4\u540c. \u4f60\u786e\u5b9a\u8981\u62a2\u52ab\u4ed6\u4eec\u7684\u8230\u961f\uff1f";
            dialog.getOptionPanel().addOptionConfirmation((Object)"uw_extortCredits", extortConfirm, "\u786e\u5b9a", "\u53d6\u6d88");
            dialog.getOptionPanel().addOptionConfirmation((Object)"uw_extortCargo", extortConfirm, "\u786e\u5b9a", "\u53d6\u6d88");
        }
        mem.unset("$ignorePlayerCommRequests");
    }

    protected int addXP(CampaignFleetAPI target) {
        int xp = 0;
        for (FleetMemberAPI member : target.getMembersWithFightersCopy()) {
            if (member.isFighterWing()) continue;
            xp += member.getFleetPointCost();
        }
        xp = (int)((float)xp * 20.0f);
        Global.getSector().getPlayerFleet().getCommander().getStats().addXP((long)xp);
        return xp;
    }

    protected void alertPatrols(CampaignFleetAPI victim) {
        boolean hyperspace = victim.getContainingLocation().isHyperspace();
        boolean cryForHelp = false;
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        for (CampaignFleetAPI fleet : victim.getContainingLocation().getFleets()) {
            MemoryAPI mem = fleet.getMemoryWithoutUpdate();
            if (!mem.getBoolean("$isPatrol") || fleet.getFaction().isAtBest(victim.getFaction(), RepLevel.INHOSPITABLE)) continue;
            RepLevel victimRep = fleet.getFaction().getRelationshipLevel(victim.getFaction());
            if (fleet.getFaction().getRelationshipLevel("player").isAtWorst(victimRep.getOneBetter()) || hyperspace && MathUtils.isWithinRange((SectorEntityToken)fleet, (SectorEntityToken)victim, (float)2500.0f) || !this.canSeeFleet(fleet, victim) && !this.canSeeFleet(fleet, playerFleet)) continue;
            cryForHelp = true;
            Misc.setFlagWithReason((MemoryAPI)mem, (String)"$cfai_makeHostile", (String)"uw_extort_response", (boolean)true, (float)5.0f);
            Misc.setFlagWithReason((MemoryAPI)mem, (String)"$cfai_makeAggressive", (String)"uw_extort_response", (boolean)true, (float)5.0f);
            if (mem.getBoolean("$core_fleetBusy")) continue;
            fleet.addAssignmentAtStart(FleetAssignment.INTERCEPT, (SectorEntityToken)playerFleet, 5.0f, null);
            Global.getSector().addPing((SectorEntityToken)fleet, "uw_extortResponse");
            fleet.addFloatingText("\u505c\u6b62\u4f60\u7684\u72af\u7f6a\u884c\u4e3a!", fleet.getFaction().getBaseUIColor(), 1.5f);
        }
        if (cryForHelp) {
            Global.getSector().addPing((SectorEntityToken)victim, "uw_extortCryForHelp");
            victim.addFloatingText("\u6551\u6211!", victim.getFaction().getBaseUIColor(), 1.5f);
        }
    }

    protected boolean canExtortFleet(CampaignFleetAPI fleet, MemoryAPI mem) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet != null) {
            CampaignFleetAIAPI.EncounterOption option = fleet.getAI().pickEncounterOption(null, playerFleet);
            if (fleet.isHostileTo((SectorEntityToken)playerFleet) && (option == CampaignFleetAIAPI.EncounterOption.ENGAGE || option == CampaignFleetAIAPI.EncounterOption.HOLD)) {
                return false;
            }
        }
        if (mem.contains("$isTradeFleet")) {
            return true;
        }
        if (mem.contains("$isSmuggler")) {
            return true;
        }
        if (mem.contains("$isScavenger")) {
            return true;
        }
        return ALLOWED_FLEET_TYPES.contains(mem.getString("$fleetType"));
    }

    protected boolean canSeeFleet(CampaignFleetAPI seer, CampaignFleetAPI target) {
        SectorEntityToken.VisibilityLevel vis = target.getVisibilityLevelTo((SectorEntityToken)seer);
        return vis == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || vis == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS;
    }

    protected void dropCargo(CampaignFleetAPI fleet, MemoryAPI mem) {
        int count;
        CustomCampaignEntityAPI pods = Misc.addCargoPods((LocationAPI)fleet.getContainingLocation(), (Vector2f)fleet.getLocation());
        List<CargoStackAPI> cargoStacks = mem.contains(MEMORY_FLAG_CARGO) ? (List<CargoStackAPI>)mem.get(MEMORY_FLAG_CARGO) : this.getCargo(fleet, mem);
        for (CargoStackAPI stack : cargoStacks) {
            count = (int)(stack.getSize() * 0.5f);
            pods.getCargo().addCommodity(stack.getCommodityId(), (float)count);
        }
        for (CargoStackAPI stack : cargoStacks) {
            count = (int)(stack.getSize() * 0.5f);
            fleet.getCargo().removeCommodity(stack.getCommodityId(), (float)count);
        }
    }

    protected List<CargoStackAPI> getCargo(CampaignFleetAPI fleet, MemoryAPI mem) {
        ArrayList<CargoStackAPI> cargo = new ArrayList<CargoStackAPI>(fleet.getCargo().getStacksCopy().size());
        float value = 0.0f;
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("\u68c0\u67e5\u8230\u961f\u88c5\u8f7d\u7684\u8d27\u7269 " + fleet.getName()));
        for (CargoStackAPI stack : fleet.getCargo().getStacksCopy()) {
            Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("\u8230\u961f " + fleet.getName() + " has cargo stack " + stack.getCommodityId()));
            if (stack.isCrewStack() || stack.isMarineStack()) continue;
            int count = (int)stack.getSize();
            value += (float)(stack.getBaseValuePerUnit() * count);
            cargo.add(stack);
        }
        mem.set(MEMORY_FLAG_CARGO, cargo, 0.0f);
        mem.set("$uw_fleetCargoValue", (Object)Float.valueOf(value), 0.0f);
        return cargo;
    }

    protected float getCredits(CampaignFleetAPI fleet, MemoryAPI mem) {
        float value = 0.0f;
        for (FleetMemberAPI member : fleet.getMembersWithFightersCopy()) {
            if (member.isFighterWing()) continue;
            value += member.getBaseBuyValue();
        }
        value *= 0.15f;
        value = (float)Math.floor(value);
        mem.set("$uw_extortCredits", (Object)Float.valueOf(value), 0.0f);
        mem.set("$uw_extortCreditsStr", (Object)Misc.getDGSCredits((float)value), 0.0f);
        return value;
    }

    protected boolean isHighRepImpact(CampaignFleetAPI target) {
        if (!target.knowsWhoPlayerIs()) {
            return false;
        }
        if (target.getMemoryWithoutUpdate().getBoolean("$lowRepImpact")) {
            return false;
        }
        return !target.getFaction().isAtBest("player", RepLevel.INHOSPITABLE);
    }

    protected ResourceCostPanelAPI makeCostPanel(TextPanelAPI text, Color color, Color color2) {
        ResourceCostPanelAPI cost = text.addCostPanel("\u653e\u5f03\u7684\u8d27\u7269 (\u603b\u91cf)", 67.0f, color, color2);
        cost.setNumberOnlyMode(true);
        cost.setWithBorder(false);
        cost.setAlignment(Alignment.LMID);
        return cost;
    }

    protected boolean modifyRep(SectorEntityToken entity, String type, InteractionDialogAPI dialog) {
        CampaignFleetAPI fleet;
        CoreReputationPlugin.RepActionEnvelope envelope;
        CoreReputationPlugin.CustomRepImpact impact;
        float delta = -0.02f;
        if (type.equals("cargo")) {
            delta = -0.03f;
        }
        if (entity.getActivePerson() != null) {
            impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = delta * 2.0f;
            envelope = new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, dialog.getTextPanel());
            Global.getSector().adjustPlayerReputation((Object)envelope, entity.getActivePerson());
        }
        impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = delta;
        impact.limit = RepLevel.HOSTILE;
        if (entity instanceof CampaignFleetAPI && this.isHighRepImpact(fleet = (CampaignFleetAPI)entity)) {
            impact.ensureAtBest = RepLevel.INHOSPITABLE;
        }
        envelope = new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, dialog.getTextPanel());
        ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)envelope, entity.getFaction().getId());
        return result.delta != 0.0f;
    }

    protected void printCargo(CampaignFleetAPI fleet, MemoryAPI mem, TextPanelAPI text) {
        text.setFontVictor();
        text.setFontSmallInsignia();
        FactionAPI playerFaction = Global.getSector().getPlayerFaction();
        Color color = playerFaction.getColor();
        Color color2 = playerFaction.getDarkUIColor();
        List<CargoStackAPI> cargoStacks = mem.contains(MEMORY_FLAG_CARGO) ? (List<CargoStackAPI>)mem.get(MEMORY_FLAG_CARGO) : this.getCargo(fleet, mem);
        text.addParagraph("-----------------------------------------------------------------------------");
        ResourceCostPanelAPI cost = this.makeCostPanel(text, color, color2);
        int numEntries = 0;
        for (CargoStackAPI stack : cargoStacks) {
            if (numEntries >= 3) {
                cost = this.makeCostPanel(text, color, color2);
                numEntries = 0;
            }
            ++numEntries;
            this.addCargoEntry(cost, stack.getCommodityId(), (int)stack.getSize(), (int)stack.getSize() / 2);
            cost.update();
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
    }

    protected boolean rollViolentResistance(CampaignFleetAPI fleet, String extortType) {
        float relStrength;
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.contains("$uw_extortResistViolently")) {
            return mem.getBoolean("$uw_extortResistViolently");
        }
        float chance = 0.1f;
        if (Global.getSector().getPlayerFleet().getMemoryWithoutUpdate().getBoolean("$uw_extortMurderous")) {
            chance += 0.2f;
        }
        if ((relStrength = mem.getFloat("$relativeStrength")) >= 1.0f) {
            chance += 0.25f;
        } else if (relStrength >= 0.0f) {
            chance += 0.1f;
        }
        if (fleet.getFaction().isAtBest("player", RepLevel.VENGEFUL)) {
            chance += 0.2f;
        }
        PersonAPI person = fleet.getActivePerson();
        float personRel = fleet.getActivePerson().getRelToPlayer().getRel();
        if (personRel < 0.0f) {
            chance += -personRel / 2.0f;
        }
        switch (person.getPersonalityAPI().getId()) {
            case "reckless": {
                chance = 1.0f;
                break;
            }
            case "aggressive": {
                chance *= 1.5f;
                break;
            }
            case "cautious": {
                chance *= 0.5f;
                break;
            }
            case "timid": {
                chance = 0.0f;
            }
        }
        boolean resist = Math.random() <= (double)chance;
        mem.set("$uw_extortResistViolently", (Object)resist, 7.0f);
        return resist;
    }
}

