/*
 * Decompiled with CFR 0.152.
 */
package data.scripts;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.thoughtworks.xstream.XStream;
import data.scripts.UW_ModPluginAlt;
import data.scripts.campaign.econ.UW_CabalInfluence;
import data.scripts.campaign.events.UW_EventManager;
import data.scripts.campaign.events.UW_PillageEvent;
import data.scripts.campaign.events.UW_RepTrackerEvent;
import data.scripts.campaign.fleets.UW_CabalFleetManager;
import data.scripts.campaign.submarkets.UW_CabalMarketPlugin;
import data.scripts.campaign.submarkets.UW_ScrapyardMarketPlugin;
import data.scripts.util.UW_Util;
import data.scripts.world.underworld.UW_DickersonAssignmentAI;
import data.scripts.world.underworld.UW_DickersonFleetManager;
import data.scripts.world.underworld.UW_Styx;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.json.JSONException;
import org.json.JSONObject;

public class UnderworldModPlugin
extends BaseModPlugin {
    public static boolean Module_PillageFleets = true;
    public static boolean Module_StarlightCabal = true;
    public static boolean hasGraphicsLib = false;
    public static boolean hasSWP = false;
    public static boolean isExerelin = false;
    private static final String SETTINGS_FILE = "UNDERWORLD_OPTIONS.ini";

    public static void syncUnderworldScripts() {
        if (!Global.getSector().hasScript(UW_CabalFleetManager.class)) {
            Global.getSector().addScript((EveryFrameScript)new UW_CabalFleetManager());
        }
        UnderworldModPlugin.syncCabalMarkets();
    }

    public static void syncUnderworldScriptsExerelin() {
        if (!Global.getSector().hasScript(UW_CabalFleetManager.class)) {
            Global.getSector().addScript((EveryFrameScript)new UW_CabalFleetManager());
        }
        UnderworldModPlugin.syncCabalMarkets();
    }

    private static void initUnderworldRelationships(SectorAPI sector) {
        FactionAPI tritachyon = sector.getFaction("tritachyon");
        FactionAPI pirates = sector.getFaction("pirates");
        FactionAPI kol = sector.getFaction("knights_of_ludd");
        FactionAPI church = sector.getFaction("luddic_church");
        FactionAPI path = sector.getFaction("luddic_path");
        FactionAPI player = sector.getFaction("player");
        FactionAPI persean = sector.getFaction("persean");
        FactionAPI cabal = sector.getFaction("cabal");
        List allFactions = sector.getAllFactions();
        for (FactionAPI curFaction : allFactions) {
            if (curFaction == cabal || curFaction.isNeutralFaction()) continue;
            cabal.setRelationship(curFaction.getId(), RepLevel.HOSTILE);
        }
        cabal.setRelationship(tritachyon.getId(), RepLevel.FAVORABLE);
        cabal.setRelationship("blackrock_driveyards", RepLevel.NEUTRAL);
        cabal.setRelationship("exigency", RepLevel.SUSPICIOUS);
        cabal.setRelationship("exipirated", RepLevel.SUSPICIOUS);
        cabal.setRelationship("templars", RepLevel.SUSPICIOUS);
        cabal.setRelationship(pirates.getId(), RepLevel.SUSPICIOUS);
        cabal.setRelationship("mayorate", RepLevel.INHOSPITABLE);
        cabal.setRelationship(kol.getId(), RepLevel.VENGEFUL);
        cabal.setRelationship(church.getId(), RepLevel.VENGEFUL);
        cabal.setRelationship(path.getId(), RepLevel.VENGEFUL);
        player.setRelationship(cabal.getId(), -0.65f);
    }

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        Module_StarlightCabal = settings.getBoolean("starlightCabal");
        Module_PillageFleets = settings.getBoolean("pillageFleets");
    }

    private static void syncCabalMarkets() {
        String[] cabalMarkets = new String[]{"port_tse", "tibicena", "ii_duality_station"};
        if (Module_StarlightCabal) {
            Global.getSector().getFaction("cabal").setShowInIntelTab(true);
            for (String marketStr : cabalMarkets) {
                MarketAPI market = Global.getSector().getEconomy().getMarket(marketStr);
                if (market == null || market.hasCondition("cabal_influence")) continue;
                market.addCondition("cabal_influence");
                market.addSubmarket("uw_cabalmarket");
                UW_Util.setMarketInfluence(market, "cabal");
            }
        } else {
            Global.getSector().getFaction("cabal").setShowInIntelTab(false);
            for (String marketStr : cabalMarkets) {
                MarketAPI market = Global.getSector().getEconomy().getMarket(marketStr);
                if (market == null || !market.hasCondition("cabal_influence")) continue;
                market.removeCondition("cabal_influence");
                market.removeSubmarket("uw_cabalmarket");
                UW_Util.removeMarketInfluence(market, "cabal");
            }
        }
    }

    public void configureXStream(XStream x) {
        x.alias("UW_CabalFleetManager", UW_CabalFleetManager.class);
        x.alias("UW_CabalInfluence", UW_CabalInfluence.class);
        x.alias("UW_CabalMarketPlugin", UW_CabalMarketPlugin.class);
        x.alias("UW_Styx", UW_Styx.class);
        x.alias("UW_DickersonFleetManager", UW_DickersonFleetManager.class);
        x.alias("UW_DickersonAssignmentAI", UW_DickersonAssignmentAI.class);
        x.alias("UW_ScrapyardMarketPlugin", UW_ScrapyardMarketPlugin.class);
        x.alias("UW_EventManager", UW_EventManager.class);
        x.alias("UW_PillageEvent", UW_PillageEvent.class);
        x.alias("UW_RepTrackerEvent", UW_RepTrackerEvent.class);
    }

    public void onApplicationLoad() throws Exception {
        boolean hasLazyLib = Global.getSettings().getModManager().isModEnabled("lw_lazylib");
        if (!hasLazyLib) {
            throw new RuntimeException("\u661f\u5149\u7ed3\u793e \u9700\u8981 LazyLib \u7684\u652f\u6301");
        }
        hasGraphicsLib = Global.getSettings().getModManager().isModEnabled("shaderLib");
        if (!hasGraphicsLib) {
            throw new RuntimeException("\u661f\u5149\u7ed3\u793e \u9700\u8981 GraphicsLib \u7684\u652f\u6301");
        }
        UW_ModPluginAlt.initGraphicsLib();
        isExerelin = Global.getSettings().getModManager().isModEnabled("nexerelin");
        hasSWP = Global.getSettings().getModManager().isModEnabled("swp");
        if (Global.getSettings().getModManager().isModEnabled("dr_ssp")) {
            String[] verString = Global.getSettings().getModManager().getModSpec("dr_ssp").getVersion().split("\\.");
            int major = Integer.parseInt(verString[0]);
            int minor = Integer.parseInt(verString[1]);
            if (major <= 3 && minor < 8) {
                throw new RuntimeException("\u661f\u5149\u7ed3\u793e \u4e0d\u517c\u5bb9\u4e8e Starsector+");
            }
        }
        try {
            UnderworldModPlugin.loadSettings();
            UW_EventManager.reloadSettings();
            UW_CabalFleetManager.reloadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(UnderworldModPlugin.class).log((Priority)Level.ERROR, (Object)("\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25! " + e.getMessage()));
        }
    }

    public void onGameLoad(boolean newGame) {
        if (isExerelin) {
            UnderworldModPlugin.syncUnderworldScriptsExerelin();
        } else {
            UnderworldModPlugin.syncUnderworldScripts();
        }
        if (!Global.getSector().getEventManager().isOngoing(null, "uw_rep_tracker")) {
            Global.getSector().getEventManager().startEvent(null, "uw_rep_tracker", null);
        }
    }

    public void onNewGame() {
        UnderworldModPlugin.initUnderworldRelationships(Global.getSector());
        if (isExerelin) {
            UnderworldModPlugin.syncUnderworldScriptsExerelin();
        } else {
            UnderworldModPlugin.syncUnderworldScripts();
        }
        Global.getSector().addScript((EveryFrameScript)new UW_EventManager());
        UW_ModPluginAlt.initUW();
    }

    public void onNewGameAfterProcGen() {
        UW_Styx.generatePt2(Global.getSector());
    }

    public void onNewGameAfterTimePass() {
        UW_Styx.dickersonifyBaseStaff();
    }
}

