/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.econ;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;

public class UW_CabalInfluence
extends BaseMarketConditionPlugin {
    public void apply(String id) {
        if (!this.market.hasSubmarket("uw_cabalmarket")) {
            this.market.addSubmarket("uw_cabalmarket");
        }
        float mult = this.getBaseSizeMult();
        float stabilityMult = UW_CabalInfluence.getLowStabilityBonusMult((MarketAPI)this.market) * UW_CabalInfluence.getHighStabilityPenaltyMult((MarketAPI)this.market);
        this.market.getDemand("volatiles").getDemand().modifyFlat(id, (mult *= stabilityMult) * 500.0f);
        this.market.getDemand("organics").getDemand().modifyFlat(id, mult * 500.0f);
        float productionMult = UW_CabalInfluence.getProductionMult((MarketAPI)this.market, (String[])new String[]{"volatiles", "organics"});
        this.market.getCommodityData("drugs").getSupply().modifyFlat(id, mult * 1000.0f * productionMult);
    }

    public void unapply(String id) {
        this.market.getDemand("volatiles").getDemand().unmodify(id);
        this.market.getDemand("organics").getDemand().unmodify(id);
        this.market.getCommodityData("drugs").getSupply().unmodify(id);
    }
}

