/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.UnderworldModPlugin;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;

public class UW_EventManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static final float EXTORT_MURDEROUS_PENALTY_KNOWN_MULT = 4.0f;
    public static final float EXTORT_MURDEROUS_PENALTY_TIME = 20.0f;
    public static float PILLAGE_FREQUENCY = 200.0f;
    public static Logger log = Global.getLogger(UW_EventManager.class);
    private static final String SETTINGS_FILE = "UNDERWORLD_OPTIONS.ini";
    public float timeToPillageEvent = PILLAGE_FREQUENCY * ((float)Math.random() * 0.5f + 0.25f);
    private SectorEntityToken previousPreviousTarget = null;
    private SectorEntityToken previousTarget = null;
    private CampaignEventTarget target = null;

    public static void reloadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        PILLAGE_FREQUENCY = (float)settings.getDouble("pillageAverageFrequency");
    }

    public UW_EventManager() {
        super(true);
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (UnderworldModPlugin.Module_PillageFleets) {
            if (this.timeToPillageEvent > 0.0f) {
                this.timeToPillageEvent -= days;
                if (this.timeToPillageEvent <= 0.0f) {
                    SectorEntityToken origin = this.pickOrigin();
                    SectorEntityToken pick = this.pickTarget(origin);
                    if (pick == null) {
                        this.timeToPillageEvent = 1.0f;
                        return;
                    }
                    this.previousPreviousTarget = this.previousTarget;
                    this.previousTarget = pick;
                    this.target = new CampaignEventTarget(pick);
                    HashMap<String, SectorEntityToken> params = new HashMap<String, SectorEntityToken>(20);
                    params.put("origin", origin);
                    Global.getSector().getEventManager().startEvent(this.target, "uw_pillage", params);
                }
            } else if (!Global.getSector().getEventManager().isOngoing(this.target, "uw_pillage")) {
                this.timeToPillageEvent += PILLAGE_FREQUENCY * ((float)Math.random() * 0.8f + 0.6f);
            }
        }
    }

    public boolean isDone() {
        return false;
    }

    public void reportPlayerEngagement(EngagementResultAPI result) {
        if (!result.getBattle().isPlayerInvolvedAtStart()) {
            return;
        }
        if (result.getBattle().getNonPlayerSide().isEmpty()) {
            return;
        }
        CampaignFleetAPI otherMain = (CampaignFleetAPI)result.getBattle().getNonPlayerSide().get(0);
        if (otherMain.getMemoryWithoutUpdate().getBoolean("$uw_extorted")) {
            float time = 20.0f;
            if (otherMain.knowsWhoPlayerIs()) {
                time *= 4.0f;
            }
            Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$uw_extortMurderous", (Object)true, time);
        }
    }

    public boolean runWhilePaused() {
        return false;
    }

    private SectorEntityToken pickOrigin() {
        WeightedRandomPicker picker = new WeightedRandomPicker();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFaction().getId().equals("pirates")) continue;
            float weight = (float)Math.pow(2.0, (double)(6.0f - Math.abs(6.0f - (float)market.getSize())) / 2.0) * (float)Math.sqrt(2.0f + market.getStabilityValue());
            float boost = 1.0f;
            if (market.hasCondition("headquarters")) {
                boost += 0.2f;
            }
            if (market.hasCondition("military_base")) {
                boost += 0.3f;
            }
            if (market.hasCondition("regional_capital")) {
                boost += 0.2f;
            }
            if (market.hasCondition("spaceport")) {
                boost += 0.1f;
            }
            if (market.hasCondition("orbital_station")) {
                boost += 0.1f;
            }
            picker.add((Object)market, weight *= boost);
        }
        if (picker.isEmpty()) {
            return null;
        }
        return ((MarketAPI)picker.pick()).getPrimaryEntity();
    }

    private SectorEntityToken pickTarget(SectorEntityToken origin) {
        if (origin == null) {
            return null;
        }
        WeightedRandomPicker picker = new WeightedRandomPicker();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            float dist;
            if (!market.getFaction().isAtBest("pirates", RepLevel.HOSTILE) || market.hasCondition("cabal_influence") || market.getStarSystem() == null || market.getPrimaryEntity() == this.previousTarget || market.getPrimaryEntity() == this.previousPreviousTarget || market.getSize() < 4 || market.hasCondition("decivilized") || (dist = Misc.getDistance((Vector2f)market.getLocationInHyperspace(), (Vector2f)origin.getLocationInHyperspace())) > 100000.0f) continue;
            float weight = (float)Math.pow(2.0, (double)(6.0f - Math.abs(6.0f - (float)market.getSize())) / 2.0) * (float)Math.sqrt(2.0f + market.getStabilityValue());
            float boost = 1.0f;
            if (market.hasCondition("headquarters")) {
                // empty if block
            }
            if (market.hasCondition("military_base")) {
                boost -= 0.5f;
            }
            if (market.hasCondition("regional_capital")) {
                boost += 0.3f;
            }
            if (market.hasCondition("spaceport")) {
                boost += 0.1f;
            }
            if (market.hasCondition("orbital_station")) {
                boost += 0.1f;
            }
            weight *= (boost *= 5000.0f / Math.max(5000.0f, dist));
            if (market.getFaction().isAtBest("pirates", RepLevel.VENGEFUL)) {
                weight *= 2.0f;
            }
            picker.add((Object)market, weight);
        }
        if (picker.isEmpty()) {
            return null;
        }
        return ((MarketAPI)picker.pick()).getPrimaryEntity();
    }
}

