/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionPlugin;
import com.fs.starfarer.api.campaign.econ.MarketConnectionAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.RecentUnrestEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import data.scripts.campaign.UW_FleetFactory;
import data.scripts.campaign.econ.UW_Pillaged;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class UW_PillageEvent
extends BaseEventPlugin {
    public static final Logger log = Global.getLogger(UW_PillageEvent.class);
    private final List<CampaignFleetAPI> activeFleets = new LinkedList<CampaignFleetAPI>();
    private float creditsPaid = 0.0f;
    private int currentStabilityImpact = 0;
    private float daysPillaged = 0.0f;
    private boolean done = false;
    private SectorEntityToken origin = null;
    private CampaignFleetAPI pillageFleet = null;
    private int playerContrib = 0;
    private float remainingDaysInStage;
    private int stage;
    private final IntervalUtil tracker = new IntervalUtil(0.75f, 1.25f);

    private static void causeRecentUnrest(MarketAPI target, int stabilityPenalty) {
        if (stabilityPenalty <= 0) {
            return;
        }
        CampaignEventManagerAPI manager = Global.getSector().getEventManager();
        RecentUnrestEvent event = (RecentUnrestEvent)manager.getOngoingEvent(new CampaignEventTarget(target), "recent_unrest");
        if (event == null) {
            event = (RecentUnrestEvent)manager.startEvent(new CampaignEventTarget(target), "recent_unrest", null);
        }
        event.increaseStabilityPenalty(stabilityPenalty);
    }

    private static void setCRBuff(CampaignFleetAPI fleet, float buffAmount) {
        if (buffAmount <= 0.0f) {
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                member.getBuffManager().removeBuff("uw_pillagebuff");
            }
        } else {
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                BuffManagerAPI.Buff buff = member.getBuffManager().getBuff("uw_pillagebuff");
                if (buff instanceof CRBuff) {
                    CRBuff crBuff = (CRBuff)buff;
                    crBuff.setBuffAmount(buffAmount, member);
                    continue;
                }
                if (buff != null) continue;
                member.getBuffManager().addBuff((BuffManagerAPI.Buff)new CRBuff(buffAmount));
            }
        }
    }

    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (!this.origin.getMarket().getFactionId().contentEquals("pirates")) {
            this.endEvent();
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.stage == 2 || this.stage == 3) {
            this.daysPillaged += days;
            if ((int)(this.daysPillaged / 8.0f) > this.currentStabilityImpact) {
                this.currentStabilityImpact = (int)(this.daysPillaged / 8.0f);
                for (MarketConditionAPI marketConditionAPI : this.market.getConditions()) {
                    MarketConditionPlugin plugin = marketConditionAPI.getPlugin();
                    if (plugin instanceof UW_Pillaged) {
                        ((UW_Pillaged)plugin).getInfo().stabilityImpact = this.currentStabilityImpact;
                    }
                    marketConditionAPI.getPlugin().apply(marketConditionAPI.getIdForPluginModifications());
                }
                this.market.updatePriceMult();
            }
            this.tracker.advance(days);
            if (this.tracker.intervalElapsed()) {
                for (MarketConnectionAPI marketConnectionAPI : Global.getSector().getEconomy().getConnectionsCopy()) {
                    if (!marketConnectionAPI.getMarketIdOne().contentEquals(this.market.getId()) && !marketConnectionAPI.getMarketIdTwo().contentEquals(this.market.getId())) continue;
                    marketConnectionAPI.getPriceMod().modifyMult(this.getStatModId(), 1.5f);
                    marketConnectionAPI.getSmugglingMod().modifyMult(this.getStatModId(), 0.5f);
                }
                for (CommodityOnMarketAPI commodityOnMarketAPI : this.market.getAllCommodities()) {
                    float stockpile = commodityOnMarketAPI.getStockpile();
                    if (commodityOnMarketAPI.isNonEcon() || stockpile <= 1.0f) continue;
                    commodityOnMarketAPI.removeFromStockpile(stockpile / (40.0f + (float)Math.random() * 10.0f));
                }
                for (CampaignFleetAPI campaignFleetAPI : this.eventTarget.getLocation().getFleets()) {
                    if (!campaignFleetAPI.isAlive() || campaignFleetAPI.getAI() == null || campaignFleetAPI.getAI().getCurrentAssignment() == null || campaignFleetAPI.getAI().getCurrentAssignment().getTarget() == null || campaignFleetAPI.getAI().getCurrentAssignment().getTarget().getMarket() != this.eventTarget.getMarket() || campaignFleetAPI.getAI().getCurrentAssignment().getAssignment() != FleetAssignment.ORBIT_PASSIVE && campaignFleetAPI.getAI().getCurrentAssignment().getAssignment() != FleetAssignment.GO_TO_LOCATION_AND_DESPAWN && campaignFleetAPI.getAI().getCurrentAssignment().getAssignment() != FleetAssignment.DELIVER_CREW && campaignFleetAPI.getAI().getCurrentAssignment().getAssignment() != FleetAssignment.DELIVER_FUEL && campaignFleetAPI.getAI().getCurrentAssignment().getAssignment() != FleetAssignment.DELIVER_RESOURCES) continue;
                    if (campaignFleetAPI.getFaction().isAtWorst(this.eventTarget.getFaction(), RepLevel.FRIENDLY) && campaignFleetAPI.getFleetPoints() >= 30 && !campaignFleetAPI.getMemoryWithoutUpdate().contains("$isTradeFleet") && !campaignFleetAPI.getMemoryWithoutUpdate().contains("$isSmuggler")) {
                        campaignFleetAPI.getAI().addAssignmentAtStart(FleetAssignment.DEFEND_LOCATION, this.entity, 5.0f, "\u6b63\u5728\u4fdd\u536b " + this.eventTarget.getEntity().getName(), null);
                        continue;
                    }
                    if (campaignFleetAPI.getFaction() == this.faction) continue;
                    for (int bound = 100; bound > 0; --bound) {
                        if (campaignFleetAPI.getAI().getCurrentAssignment() == null || campaignFleetAPI.getAI().getCurrentAssignment().getTarget() == null || campaignFleetAPI.getAI().getCurrentAssignment().getTarget().getMarket() != this.eventTarget.getMarket()) break;
                        campaignFleetAPI.getAI().removeFirstAssignment();
                    }
                    if (campaignFleetAPI.getAI().getCurrentAssignment() != null && !campaignFleetAPI.getAI().getCurrentAssignment().isExipred()) continue;
                    List markets = Global.getSector().getEconomy().getMarketsCopy();
                    Collections.shuffle(markets);
                    SectorEntityToken token = null;
                    for (MarketAPI mkt : markets) {
                        if (!this.market.getFaction().isAtWorst(campaignFleetAPI.getFaction(), RepLevel.SUSPICIOUS)) continue;
                        token = mkt.getPrimaryEntity();
                        break;
                    }
                    if (token == null) continue;
                    campaignFleetAPI.getAI().addAssignmentAtStart(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, token, 5.0f, "\u64a4\u9000\u5230 " + token.getName(), null);
                }
            }
        }
        this.remainingDaysInStage -= days;
        if (this.stage == 1) {
            if (this.pillageFleet == null || this.pillageFleet.getAI() == null || !this.pillageFleet.isAlive() || this.pillageFleet.getFleetPoints() < 50) {
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    if (!campaignFleetAPI.isAlive()) continue;
                    campaignFleetAPI.clearAssignments();
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION, this.origin, 1000.0f, "\u56de\u5230 " + this.origin.getName());
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u6b63\u5728\u79bb\u5f00");
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.origin, 1000.0f);
                }
                if (this.playerContrib >= 100) {
                    this.creditsPaid = (float)this.playerContrib * 300.0f;
                    if (this.eventTarget.getFaction().isAtBest("player", RepLevel.HOSTILE)) {
                        this.creditsPaid *= 0.0f;
                    } else if (this.eventTarget.getFaction().isAtBest("player", RepLevel.INHOSPITABLE)) {
                        this.creditsPaid *= 0.3f;
                    } else if (this.eventTarget.getFaction().isAtBest("player", RepLevel.SUSPICIOUS)) {
                        this.creditsPaid *= 0.8f;
                    } else if (this.eventTarget.getFaction().isAtWorst("player", RepLevel.COOPERATIVE)) {
                        this.creditsPaid *= 1.5f;
                    } else if (this.eventTarget.getFaction().isAtWorst("player", RepLevel.FRIENDLY)) {
                        this.creditsPaid *= 1.35f;
                    } else if (this.eventTarget.getFaction().isAtWorst("player", RepLevel.WELCOMING)) {
                        this.creditsPaid *= 1.2f;
                    }
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_intercepted_by_player", this.entity, MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                        public void beforeDelivery(CommMessageAPI message) {
                            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                            playerFleet.getCargo().getCredits().add(UW_PillageEvent.this.creditsPaid);
                            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                            impact.delta = 0.1f;
                            impact.limit = RepLevel.COOPERATIVE;
                            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, message, false), UW_PillageEvent.this.eventTarget.getFaction().getId());
                        }
                    });
                } else {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_intercepted", this.entity, MessagePriority.ENSURE_DELIVERY);
                }
                this.endEvent();
            } else if (!this.origin.getFaction().isHostileTo(this.eventTarget.getFaction())) {
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    if (!campaignFleetAPI.isAlive()) continue;
                    campaignFleetAPI.clearAssignments();
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION, this.origin, 1000.0f, "\u56de\u5230 " + this.origin.getName());
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u6b63\u5728\u79bb\u5f00");
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.origin, 1000.0f);
                }
                this.endEvent();
            } else if (this.pillageFleet.getAI().getCurrentAssignment() == null) {
                this.remainingDaysInStage = (float)Math.random() * 5.0f + 10.0f;
                this.stage = 2;
                this.market.getMemoryWithoutUpdate().set("$pillaged", (Object)true);
                this.market.addCondition("uw_pillaged", true);
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    campaignFleetAPI.clearAssignments();
                    if (campaignFleetAPI == this.pillageFleet) {
                        campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.entity, 1000.0f, "\u6b63\u5728\u62a2\u52ab " + this.entity.getName());
                        continue;
                    }
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.entity, 1000.0f, "\u6b63\u5728\u5c01\u9501 " + this.entity.getName());
                }
                if (this.market.getSize() >= 6) {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "\u51c6\u5907\u4e2d", this.entity, MessagePriority.SECTOR);
                } else {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "\u51c6\u5907\u4e2d", this.entity, MessagePriority.CLUSTER);
                }
                this.market.getDemand("hand_weapons").getDemand().modifyMult(this.getStatModId(), 1.5f);
                this.market.getDemand("food").getDemand().modifyMult(this.getStatModId(), 1.5f);
                this.market.getDemand("fuel").getDemand().modifyMult(this.getStatModId(), 1.25f);
                this.market.getDemand("crew").getDemand().modifyMult(this.getStatModId(), 1.25f);
                this.market.getDemand("supplies").getDemand().modifyMult(this.getStatModId(), 1.5f);
            } else {
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    if (campaignFleetAPI == this.pillageFleet) continue;
                    if ((Misc.getDistance((Vector2f)this.pillageFleet.getLocation(), (Vector2f)campaignFleetAPI.getLocation()) > 1500.0f || this.pillageFleet.getContainingLocation() != campaignFleetAPI.getContainingLocation()) && campaignFleetAPI.getAI().getCurrentAssignmentType() != FleetAssignment.DELIVER_CREW) {
                        campaignFleetAPI.clearAssignments();
                        campaignFleetAPI.addAssignment(FleetAssignment.DELIVER_CREW, (SectorEntityToken)this.pillageFleet, 1000.0f, "\u6b63\u5728\u4fdd\u62a4 " + this.pillageFleet.getName());
                        continue;
                    }
                    if (!(Misc.getDistance((Vector2f)this.pillageFleet.getLocation(), (Vector2f)campaignFleetAPI.getLocation()) < 750.0f) || this.pillageFleet.getContainingLocation() != campaignFleetAPI.getContainingLocation() || campaignFleetAPI.getAI().getCurrentAssignmentType() == FleetAssignment.ORBIT_AGGRESSIVE) continue;
                    campaignFleetAPI.clearAssignments();
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, (SectorEntityToken)this.pillageFleet, 1000.0f, "\u6b63\u5728\u4fdd\u62a4 " + this.pillageFleet.getName());
                }
            }
        } else if (this.stage == 2 || this.stage == 3) {
            if (this.pillageFleet == null || this.pillageFleet.getAI() == null || !this.pillageFleet.isAlive() || this.pillageFleet.getFleetPoints() < 50) {
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    if (!campaignFleetAPI.isAlive()) continue;
                    campaignFleetAPI.clearAssignments();
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION, this.origin, 1000.0f, "\u56de\u5230 " + this.origin.getName());
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u6b63\u5728\u79bb\u5f00");
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.origin, 1000.0f);
                }
                if (this.pillageFleet != null) {
                    UW_PillageEvent.setCRBuff(this.pillageFleet, 0.0f);
                }
                if (this.playerContrib >= 100) {
                    this.creditsPaid = (float)this.playerContrib * 1000.0f;
                    if (this.eventTarget.getFaction().isAtBest("player", RepLevel.HOSTILE)) {
                        this.creditsPaid *= 0.0f;
                    } else if (this.eventTarget.getFaction().isAtBest("player", RepLevel.INHOSPITABLE)) {
                        this.creditsPaid *= 0.3f;
                    } else if (this.eventTarget.getFaction().isAtBest("player", RepLevel.SUSPICIOUS)) {
                        this.creditsPaid *= 0.8f;
                    } else if (this.eventTarget.getFaction().isAtWorst("player", RepLevel.COOPERATIVE)) {
                        this.creditsPaid *= 1.5f;
                    } else if (this.eventTarget.getFaction().isAtWorst("player", RepLevel.FRIENDLY)) {
                        this.creditsPaid *= 1.35f;
                    } else if (this.eventTarget.getFaction().isAtWorst("player", RepLevel.WELCOMING)) {
                        this.creditsPaid *= 1.2f;
                    }
                    if (this.stage == 2) {
                        Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_by_player", this.entity, MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                            public void beforeDelivery(CommMessageAPI message) {
                                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                                playerFleet.getCargo().getCredits().add(UW_PillageEvent.this.creditsPaid);
                                CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                                impact.delta = 0.15f;
                                impact.limit = RepLevel.COOPERATIVE;
                                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, message, false), UW_PillageEvent.this.eventTarget.getFaction().getId());
                            }
                        });
                    } else {
                        this.creditsPaid *= 0.5f;
                        Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_late_by_player", this.entity, MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                            public void beforeDelivery(CommMessageAPI message) {
                                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                                playerFleet.getCargo().getCredits().add(UW_PillageEvent.this.creditsPaid);
                                CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                                impact.delta = 0.07f;
                                impact.limit = RepLevel.COOPERATIVE;
                                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, message, false), UW_PillageEvent.this.eventTarget.getFaction().getId());
                            }
                        });
                    }
                } else if (this.stage == 2) {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "end", this.entity, MessagePriority.ENSURE_DELIVERY);
                } else {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_late", this.entity, MessagePriority.ENSURE_DELIVERY);
                }
                if (this.stage == 2) {
                    if (this.market.getSize() >= 6) {
                        this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(15.0f + (float)this.market.getSize() * 2.0f), (float)(20.0f + (float)this.market.getSize() * 2.0f)), 1, this.market));
                    } else {
                        this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(20.0f + (float)this.market.getSize() * 3.0f), (float)(30.0f + (float)this.market.getSize() * 3.0f)), 1, this.market));
                    }
                } else if (this.market.getSize() >= 6) {
                    this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(20.0f + (float)this.market.getSize() * 3.0f), (float)(30.0f + (float)this.market.getSize() * 3.0f)), 1, this.market));
                } else {
                    this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(30.0f + (float)this.market.getSize() * 4.0f), (float)(45.0f + (float)this.market.getSize() * 4.0f)), 1, this.market));
                }
                this.endEvent();
            } else if (!this.origin.getFaction().isHostileTo(this.eventTarget.getFaction())) {
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    if (!campaignFleetAPI.isAlive()) continue;
                    campaignFleetAPI.clearAssignments();
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION, this.origin, 1000.0f, "\u56de\u5230 " + this.origin.getName());
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u6b63\u5728\u79bb\u5f00");
                    campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.origin, 1000.0f);
                }
                if (this.pillageFleet != null) {
                    UW_PillageEvent.setCRBuff(this.pillageFleet, 0.0f);
                }
                if (this.stage == 2) {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_peace", this.entity, MessagePriority.ENSURE_DELIVERY);
                } else {
                    Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_late_peace", this.entity, MessagePriority.ENSURE_DELIVERY);
                }
                if (this.stage == 2) {
                    if (this.market.getSize() >= 6) {
                        this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(15.0f + (float)this.market.getSize() * 2.0f), (float)(20.0f + (float)this.market.getSize() * 2.0f)), 1, this.market));
                    } else {
                        this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(20.0f + (float)this.market.getSize() * 3.0f), (float)(30.0f + (float)this.market.getSize() * 3.0f)), 1, this.market));
                    }
                } else if (this.market.getSize() >= 6) {
                    this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(20.0f + (float)this.market.getSize() * 3.0f), (float)(30.0f + (float)this.market.getSize() * 3.0f)), 1, this.market));
                } else {
                    this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(30.0f + (float)this.market.getSize() * 4.0f), (float)(45.0f + (float)this.market.getSize() * 4.0f)), 1, this.market));
                }
                this.endEvent();
            } else {
                if (this.pillageFleet != null) {
                    float buffAmount = 0.0f;
                    for (CampaignFleetAPI fleet : this.activeFleets) {
                        if (fleet == this.pillageFleet) continue;
                        buffAmount += 30.0f * Math.min(1.0f, (float)fleet.getFleetPoints() / (50.0f + (float)this.pillageFleet.getFleetPoints()));
                    }
                    UW_PillageEvent.setCRBuff(this.pillageFleet, buffAmount);
                }
                for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                    AbilityPlugin burn;
                    if (campaignFleetAPI == this.pillageFleet) continue;
                    if (Misc.getDistance((Vector2f)this.entity.getLocation(), (Vector2f)campaignFleetAPI.getLocation()) > 5000.0f && (burn = campaignFleetAPI.getAbility("emergency_burn")) != null && burn.isUsable()) {
                        burn.activate();
                    }
                    if ((Misc.getDistance((Vector2f)this.entity.getLocation(), (Vector2f)campaignFleetAPI.getLocation()) > 3000.0f || this.pillageFleet.getContainingLocation() != campaignFleetAPI.getContainingLocation()) && campaignFleetAPI.getAI().getCurrentAssignmentType() == FleetAssignment.ORBIT_AGGRESSIVE) {
                        campaignFleetAPI.clearAssignments();
                        campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.entity, 1000.0f, "\u6b63\u5728\u5c01\u9501 " + this.entity.getName());
                        continue;
                    }
                    if (!(Misc.getDistance((Vector2f)this.entity.getLocation(), (Vector2f)campaignFleetAPI.getLocation()) < 1000.0f) || this.pillageFleet.getContainingLocation() != campaignFleetAPI.getContainingLocation() || campaignFleetAPI.getAI().getCurrentAssignmentType() != FleetAssignment.ORBIT_PASSIVE) continue;
                    campaignFleetAPI.clearAssignments();
                    campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.entity, 1000.0f, "\u6b63\u5728\u5c01\u9501 " + this.entity.getName());
                }
            }
        }
        if (this.stage == -1) {
            this.stage = 0;
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "planning", this.origin, MessagePriority.CLUSTER);
        } else if (this.remainingDaysInStage <= 0.0f && this.stage == 0) {
            this.stage = 1;
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "coming", this.origin, MessagePriority.CLUSTER);
            float qf = this.origin.getMarket().getShipQualityFactor();
            float f = (float)this.entity.getMarket().getSize() + this.entity.getMarket().getStabilityValue();
            int maxPts = 24 + Math.round(qf * 12.0f) + MathUtils.getRandomNumberInRange((int)0, (int)12) + (int)f;
            final FleetParams params = new FleetParams(null, this.market, "pirates", null, "patrolLarge", (float)maxPts, (float)maxPts / 15.0f, (float)maxPts / 15.0f, (float)maxPts / 10.0f, 0.0f, 0.0f, (float)maxPts / 15.0f, 0.0f, -1.0f, 0.5f, 0);
            this.pillageFleet = UW_FleetFactory.enhancedCreateFleet(Global.getSector().getFaction("pirates"), maxPts, new UW_FleetFactory.FleetFactoryDelegate(){

                @Override
                public CampaignFleetAPI createFleet() {
                    return FleetFactoryV2.createFleet((FleetParams)params);
                }
            });
            if (this.pillageFleet == null) {
                this.endEvent();
                return;
            }
            Misc.makeImportant((SectorEntityToken)this.pillageFleet, (String)"iw_pe", (float)1000.0f);
            this.pillageFleet.setName("\u63a0\u593a\u8005\u8230\u961f");
            this.pillageFleet.getMemoryWithoutUpdate().set("$fleetType", (Object)"uw_piratePillageFleet");
            this.pillageFleet.getStats().getDynamic().getMod("ds_debris_chance_battle").modifyMult("uw_spawner", 0.25f);
            this.pillageFleet.getStats().getDynamic().getMod("ds_derelicts_chance_battle").modifyMult("uw_spawner", 0.25f);
            this.pillageFleet.getStats().getDynamic().getMod("ds_derelicts_scale_fleet").modifyMult("uw_spawner", 0.5f);
            this.origin.getContainingLocation().addEntity((SectorEntityToken)this.pillageFleet);
            this.pillageFleet.setLocation(this.origin.getLocation().x + MathUtils.getRandomNumberInRange((float)-100.0f, (float)100.0f), this.origin.getLocation().y + MathUtils.getRandomNumberInRange((float)-100.0f, (float)100.0f));
            this.activeFleets.add(this.pillageFleet);
            Vector2f dest = Misc.getPointAtRadius((Vector2f)this.entity.getLocationInHyperspace(), (float)500.0f);
            SectorEntityToken token = Global.getSector().getHyperspace().createToken(dest.x, dest.y);
            this.pillageFleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u51c6\u5907\u5165\u4fb5");
            if (this.origin.getContainingLocation() != this.entity.getContainingLocation()) {
                this.pillageFleet.addAssignment(FleetAssignment.DELIVER_CREW, token, 1000.0f, "\u6b63\u5728\u524d\u5f80 " + this.entity.getContainingLocation().getName());
            }
            this.pillageFleet.addAssignment(FleetAssignment.DELIVER_CREW, this.entity, 1000.0f, "\u6b63\u5728\u524d\u5f80 " + this.entity.getName());
            for (int i = 0; i < 2; ++i) {
                maxPts = 12 + Math.round(qf * 6.0f) + MathUtils.getRandomNumberInRange((int)0, (int)6) + (int)(f * 0.5f);
                final FleetParams escortParams = new FleetParams(null, this.market, "pirates", null, "patrolMedium", (float)maxPts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f, -1.0f, 1.0f, 5);
                CampaignFleetAPI escort = UW_FleetFactory.enhancedCreateFleet(Global.getSector().getFaction("pirates"), maxPts, new UW_FleetFactory.FleetFactoryDelegate(){

                    @Override
                    public CampaignFleetAPI createFleet() {
                        return FleetFactoryV2.createFleet((FleetParams)escortParams);
                    }
                });
                if (escort == null) continue;
                escort.setName("\u7a81\u88ad\u8230\u961f");
                escort.getMemoryWithoutUpdate().set("$fleetType", (Object)"uw_piratePillageEscort");
                escort.getStats().getDynamic().getMod("ds_debris_chance_battle").modifyMult("uw_spawner", 0.25f);
                escort.getStats().getDynamic().getMod("ds_derelicts_chance_battle").modifyMult("uw_spawner", 0.25f);
                escort.getStats().getDynamic().getMod("ds_derelicts_scale_fleet").modifyMult("uw_spawner", 0.5f);
                this.origin.getContainingLocation().addEntity((SectorEntityToken)escort);
                escort.setLocation(this.origin.getLocation().x + MathUtils.getRandomNumberInRange((float)-250.0f, (float)250.0f), this.origin.getLocation().y + MathUtils.getRandomNumberInRange((float)-250.0f, (float)250.0f));
                this.activeFleets.add(escort);
                escort.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u51c6\u5907\u5165\u4fb5");
                escort.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, (SectorEntityToken)this.pillageFleet, 1000.0f, "\u6b63\u5728\u4fdd\u62a4 " + this.pillageFleet.getName());
            }
        } else if (this.remainingDaysInStage <= 0.0f && this.stage == 2) {
            this.remainingDaysInStage = (float)Math.random() * 5.0f + 10.0f;
            this.stage = 3;
        } else if (this.remainingDaysInStage <= 0.0f && this.stage == 3) {
            this.stage = 4;
            for (CampaignFleetAPI campaignFleetAPI : this.activeFleets) {
                if (!campaignFleetAPI.isAlive()) continue;
                campaignFleetAPI.clearAssignments();
                campaignFleetAPI.addAssignment(FleetAssignment.DELIVER_CREW, this.origin, 1000.0f, "\u56de\u5230 " + this.origin.getName());
                campaignFleetAPI.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.origin, 4.0f, "\u6b63\u5728\u79bb\u5f00");
                campaignFleetAPI.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.origin, 1000.0f);
            }
            if (this.pillageFleet != null) {
                UW_PillageEvent.setCRBuff(this.pillageFleet, 0.0f);
            }
            if (this.market.getSize() >= 6) {
                Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_victory", this.entity, MessagePriority.SECTOR);
            } else {
                Global.getSector().reportEventStage((CampaignEventPlugin)this, "end_victory", this.entity, MessagePriority.CLUSTER);
            }
            if (this.market.getSize() >= 6) {
                this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(30.0f + (float)this.market.getSize() * 4.0f), (float)(45.0f + (float)this.market.getSize() * 4.0f)), 2, this.market));
            } else {
                this.market.getPrimaryEntity().addScript((EveryFrameScript)new MarketDamage(MathUtils.getRandomNumberInRange((float)(45.0f + (float)this.market.getSize() * 6.0f), (float)(60.0f + (float)this.market.getSize() * 6.0f)), 2, this.market));
            }
            this.endEvent();
        }
    }

    public String getEventName() {
        return "\u6b63\u5728\u63a0\u593a " + this.entity.getName();
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList(1);
        this.addTokensToList(result, new String[]{"$credits"});
        return result.toArray(new String[result.size()]);
    }

    public void setParam(Object param) {
        Map params = (Map)param;
        this.origin = (SectorEntityToken)params.get("origin");
    }

    public CampaignFleetAPI getPillageFleet() {
        return this.pillageFleet;
    }

    public SectorEntityToken getPillageTarget() {
        return this.market.getPrimaryEntity();
    }

    public int getStage() {
        return this.stage;
    }

    public Map<String, String> getTokenReplacements() {
        Map tokens = super.getTokenReplacements();
        tokens.put("$origin", this.origin.getName());
        tokens.put("$planet", this.eventTarget.getEntity().getName());
        tokens.put("$system", ((StarSystemAPI)this.eventTarget.getLocation()).getBaseName());
        tokens.put("$sender", this.origin.getFaction().getDisplayName());
        tokens.put("$market", this.eventTarget.getMarket().getName());
        tokens.put("$targetFaction", this.eventTarget.getFaction().getDisplayName());
        tokens.put("$TargetFaction", Misc.ucFirst((String)this.eventTarget.getFaction().getDisplayName()));
        tokens.put("$theTargetFaction", this.eventTarget.getFaction().getDisplayNameWithArticle());
        tokens.put("$TheTargetFaction", Misc.ucFirst((String)this.eventTarget.getFaction().getDisplayNameWithArticle()));
        tokens.put("$faction", this.faction.getDisplayName());
        tokens.put("$Faction", Misc.ucFirst((String)this.faction.getDisplayName()));
        tokens.put("$theFaction", this.faction.getDisplayNameWithArticle());
        tokens.put("$TheFaction", Misc.ucFirst((String)this.faction.getDisplayNameWithArticle()));
        tokens.put("$factionLong", this.faction.getDisplayNameLong());
        tokens.put("$FactionLong", Misc.ucFirst((String)this.faction.getDisplayNameLong()));
        tokens.put("$theFactionLong", this.faction.getDisplayNameLongWithArticle());
        tokens.put("$TheFactionLong", Misc.ucFirst((String)this.faction.getDisplayNameLongWithArticle()));
        if (this.creditsPaid <= 1.0f) {
            tokens.put("$payment", "\u9274\u4e8e\u4f60\u4eec\u4e4b\u95f4\u7cdf\u7cd5\u7684\u5173\u7cfb " + this.eventTarget.getFaction().getDisplayNameWithArticle() + ", \u4ed6\u4eec\u4e0d\u613f\u610f\u62a5\u7b54\u4f60.");
            tokens.put("$credits", "");
        } else {
            tokens.put("$payment", Misc.ucFirst((String)this.eventTarget.getFaction().getDisplayNameWithArticle()) + " \u4ee5\u5956\u52b1\u4f60\u6700\u8fd1\u7684\u82f1\u52c7\u884c\u4e3a");
            tokens.put("$credits", Misc.getDGSCredits((float)this.creditsPaid));
        }
        return tokens;
    }

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
        this.faction = Global.getSector().getFaction("pirates");
        this.remainingDaysInStage = (float)Math.random() * 10.0f + 10.0f;
        this.stage = -1;
        this.playerContrib = 0;
        Global.getSector().getPersistentData().put("uw_currentPillageEvent", this);
    }

    public boolean isDone() {
        return this.done;
    }

    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        super.reportBattleOccurred(primaryWinner, battle);
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (!battle.onPlayerSide(primaryWinner)) {
            return;
        }
        if (!Global.getSector().getPlayerFleet().isTransponderOn()) {
            return;
        }
        for (CampaignFleetAPI loser : battle.getOtherSideFor(primaryWinner)) {
            if (!this.activeFleets.contains(loser)) continue;
            this.playerContrib = (int)((float)this.playerContrib + Misc.getSnapshotFPLost((CampaignFleetAPI)loser) / (float)(this.pillageFleet == loser ? 1 : 2) * battle.getPlayerInvolvementFraction());
        }
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        this.activeFleets.remove(fleet);
    }

    public void startEvent() {
        super.startEvent(true);
    }

    private void endEvent() {
        this.done = true;
        if (this.pillageFleet != null) {
            Misc.makeUnimportant((SectorEntityToken)this.pillageFleet, (String)"uw_pe");
        }
        this.activeFleets.clear();
        this.market.getMemoryWithoutUpdate().unset("$pillaged");
        for (MarketConnectionAPI connection : Global.getSector().getEconomy().getConnectionsCopy()) {
            if (!connection.getMarketIdOne().contentEquals(this.market.getId()) && !connection.getMarketIdTwo().contentEquals(this.market.getId())) continue;
            connection.getPriceMod().unmodify(this.getStatModId());
        }
        Global.getSector().getPersistentData().remove("uw_currentPillageEvent");
        this.market.getDemand("hand_weapons").getDemand().unmodify(this.getStatModId());
        this.market.getDemand("food").getDemand().unmodify(this.getStatModId());
        this.market.getDemand("fuel").getDemand().unmodify(this.getStatModId());
        this.market.getDemand("metals").getDemand().unmodify(this.getStatModId());
        this.market.getDemand("crew").getDemand().unmodify(this.getStatModId());
        this.market.getDemand("supplies").getDemand().unmodify(this.getStatModId());
    }

    private static class MarketDamage
    implements EveryFrameScript {
        private boolean done = false;
        private final float duration;
        private boolean halved = false;
        private final IntervalUtil interval = new IntervalUtil(5.0f, 10.0f);
        private final MarketAPI market;
        private final int severity;
        private float timer;

        MarketDamage(float duration, int severity, MarketAPI market) {
            this.duration = duration;
            this.timer = duration;
            this.severity = severity;
            this.market = market;
            for (CommodityOnMarketAPI commodity : market.getAllCommodities()) {
                float stockpile = commodity.getStockpile();
                if (commodity.isNonEcon() || stockpile <= 1.0f) continue;
                if (severity == 1) {
                    commodity.removeFromStockpile(stockpile * 0.2f);
                    continue;
                }
                commodity.removeFromStockpile(stockpile * 0.3f);
            }
            for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
                if (curr == market) continue;
                MarketConnectionAPI conn = Global.getSector().getEconomy().getConnection(market, curr);
                conn.getPriceMod().modifyMult("uw_pillage", MathUtils.getRandomNumberInRange((float)2.0f, (float)3.0f));
                conn.getSmugglingMod().modifyMult("uw_pillage", MathUtils.getRandomNumberInRange((float)1.0f, (float)2.0f));
            }
            for (MarketConditionAPI condition : market.getConditions()) {
                MarketConditionPlugin plugin = condition.getPlugin();
                if (!(plugin instanceof UW_Pillaged)) continue;
                plugin.setParam((Object)new UW_Pillaged.ConditionInfo(severity, ((UW_Pillaged)plugin).getInfo().stabilityImpact));
            }
        }

        public void advance(float amount) {
            if (this.timer <= 0.0f) {
                this.done = true;
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.interval.advance(days);
            if (this.interval.intervalElapsed()) {
                for (Object commodity : this.market.getAllCommodities()) {
                    float stockpile = commodity.getStockpile();
                    if (commodity.isNonEcon() || stockpile <= 1.0f) continue;
                    if (this.severity == 1) {
                        commodity.removeFromStockpile(stockpile * 0.1f);
                        continue;
                    }
                    commodity.removeFromStockpile(stockpile * 0.15f);
                }
            }
            this.timer -= days;
            if (this.timer <= 0.0f) {
                this.done = true;
                if (this.halved) {
                    // empty if block
                }
                int unrest = 0;
                for (MarketConditionAPI condition : this.market.getConditions()) {
                    MarketConditionPlugin plugin = condition.getPlugin();
                    if (!(plugin instanceof UW_Pillaged)) continue;
                    unrest = (int)((UW_Pillaged)plugin).getInfo().stabilityImpact;
                }
                for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (curr == this.market) continue;
                    MarketConnectionAPI conn = Global.getSector().getEconomy().getConnection(this.market, curr);
                    conn.getPriceMod().unmodify("uw_pillage");
                    conn.getSmugglingMod().unmodify("uw_pillage");
                }
                UW_PillageEvent.causeRecentUnrest(this.market, unrest);
                this.market.removeCondition("uw_pillaged");
            }
            if (this.timer <= this.duration / 2.0f && !this.halved && this.severity > 1) {
                this.halved = true;
                for (MarketConditionAPI condition : this.market.getConditions()) {
                    MarketConditionPlugin plugin = condition.getPlugin();
                    if (!(plugin instanceof UW_Pillaged)) continue;
                    plugin.setParam((Object)new UW_Pillaged.ConditionInfo(this.severity / 2, ((UW_Pillaged)plugin).getInfo().stabilityImpact));
                }
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return false;
        }
    }

    private static class CRBuff
    implements BuffManagerAPI.Buff {
        private float buffAmount;
        private boolean expired = false;
        private final IntervalUtil interval = new IntervalUtil(1.0f, 1.0f);
        private transient FleetMemberAPI lastMember = null;

        CRBuff(float buffAmount) {
            this.buffAmount = buffAmount;
        }

        public void advance(float days) {
            this.interval.advance(days);
            if (this.interval.intervalElapsed() && this.lastMember != null && (this.lastMember.getFleetData() == null || this.lastMember.getFleetData().getFleet() == null || !this.lastMember.getFleetData().getFleet().isAlive())) {
                this.expired = true;
            }
        }

        public void apply(FleetMemberAPI member) {
            this.lastMember = member;
            member.getStats().getBaseCRRecoveryRatePercentPerDay().modifyPercent("uw_pillagebuff", this.buffAmount);
            member.getStats().getCRLossPerSecondPercent().modifyMult("uw_pillagebuff", 100.0f / (100.0f + this.buffAmount));
            member.getStats().getCRPerDeploymentPercent().modifyPercent("uw_pillagebuff", 100.0f / (100.0f + this.buffAmount));
            member.getStats().getPeakCRDuration().modifyPercent("uw_pillagebuff", this.buffAmount);
            member.getStats().getRepairRatePercentPerDay().modifyPercent("uw_pillagebuff", this.buffAmount);
        }

        public String getId() {
            return "uw_pillagebuff";
        }

        public boolean isExpired() {
            return this.expired;
        }

        void setBuffAmount(float buffAmount, FleetMemberAPI member) {
            if (buffAmount != this.buffAmount) {
                this.apply(member);
            }
            this.buffAmount = buffAmount;
        }
    }
}

