/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import data.scripts.campaign.events.UW_PillageEvent;
import java.util.Map;

public class UW_RepTrackerEvent
extends BaseEventPlugin {
    private String otherFleetName = null;
    private CampaignEventTarget tempTarget = null;

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public CampaignEventTarget getEventTarget() {
        if (this.tempTarget != null) {
            return this.tempTarget;
        }
        return super.getEventTarget();
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        if (this.otherFleetName != null) {
            map.put("$otherFleetName", this.otherFleetName);
        }
        if (Global.getSector().getPersistentData().get("uw_currentPillageEvent") != null) {
            UW_PillageEvent event = (UW_PillageEvent)((Object)Global.getSector().getPersistentData().get("uw_currentPillageEvent"));
            map.put("$planet", event.getEventTarget().getEntity().getName());
            map.put("$pillageFleet", event.getPillageFleet().getFullName());
            map.put("$sender", event.getPillageFleet().getFaction().getDisplayName());
        }
        return map;
    }

    public boolean isDone() {
        return false;
    }

    public void reportBattleFinished(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (Global.getSector().getPersistentData().get("uw_currentPillageEvent") == null) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!battle.knowsWhoPlayerIs(battle.getSideFor(playerFleet)) || battle.getPlayerSide().size() <= 1) {
            return;
        }
        final CampaignFleetAPI pillageFleet = ((UW_PillageEvent)((Object)Global.getSector().getPersistentData().get("uw_currentPillageEvent"))).getPillageFleet();
        if (!(pillageFleet != null && pillageFleet.isAlive() && battle.isInvolved(pillageFleet) && battle.isOnPlayerSide(pillageFleet))) {
            return;
        }
        String[] names = new String[battle.getOtherSideFor(playerFleet).size()];
        int i = 0;
        for (Object other : battle.getOtherSideFor(playerFleet)) {
            names[i] = other.getNameWithFaction();
            ++i;
        }
        this.otherFleetName = Misc.getAndJoined((String[])names);
        float fpDestroyed = 0.0f;
        for (CampaignFleetAPI fleet : battle.getOtherSideFor(playerFleet)) {
            fpDestroyed += Misc.getSnapshotFPLost((CampaignFleetAPI)fleet) * battle.getPlayerInvolvementFraction();
        }
        this.tempTarget = new CampaignEventTarget((SectorEntityToken)pillageFleet);
        RepLevel level = playerFleet.getFaction().getRelationshipLevel(pillageFleet.getFaction());
        final float fp = fpDestroyed;
        if (fp > 0.0f && level.isAtWorst(RepLevel.HOSTILE)) {
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "battle_rep_positive", (SectorEntityToken)pillageFleet, MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){
                boolean deliver = true;

                public void beforeDelivery(CommMessageAPI message) {
                    ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.COMBAT_WITH_ENEMY, (Object)new Float(fp), message, true), pillageFleet.getFaction().getId());
                    this.deliver = Math.abs(result.delta) >= 0.01f;
                }

                public boolean shouldDeliver() {
                    return this.deliver;
                }
            });
        }
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

