/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickContributionMethod;
import com.fs.starfarer.api.loading.FleetCompositionDoctrineAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.UnderworldModPlugin;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class UW_CabalFleetManager
extends BaseLimitedFleetManager {
    public static int MAX_CABAL_FLEETS = 12;
    private static final String SETTINGS_FILE = "UNDERWORLD_OPTIONS.ini";

    public static void reloadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        MAX_CABAL_FLEETS = settings.getInt("maxCabalFleets");
    }

    private static int getMinPreferredMarketSize(float combat) {
        float fp = combat;
        if (fp <= 20.0f) {
            return 1;
        }
        if (fp <= 50.0f) {
            return 3;
        }
        if (fp <= 100.0f) {
            return 5;
        }
        if (fp <= 150.0f) {
            return 7;
        }
        return 8;
    }

    protected int getMaxFleets() {
        if (!UnderworldModPlugin.Module_StarlightCabal) {
            return 0;
        }
        return MAX_CABAL_FLEETS;
    }

    protected MarketAPI pickSourceMarket(Vector2f location, float combat) {
        List allMarkets = Global.getSector().getEconomy().getMarketsCopy();
        int size = UW_CabalFleetManager.getMinPreferredMarketSize(combat);
        WeightedRandomPicker closestPicker = new WeightedRandomPicker();
        WeightedRandomPicker closestMatchingSizePicker = new WeightedRandomPicker();
        for (MarketAPI market : allMarkets) {
            if (market.getPrimaryEntity() == null) continue;
            float weight = 0.0f;
            switch (market.getFactionId()) {
                case "tritachyon": {
                    weight += 10.0f;
                    break;
                }
                case "cabal": {
                    weight += 20.0f;
                    break;
                }
                case "blackrock_driveyards": {
                    weight += 5.0f;
                    break;
                }
                case "exigency": {
                    weight += 2.0f;
                }
            }
            if (market.hasCondition("cabal_influence")) {
                weight += 20.0f;
            }
            if (weight <= 0.0f) continue;
            float currDist = Misc.getDistance((Vector2f)market.getPrimaryEntity().getLocationInHyperspace(), (Vector2f)location);
            closestPicker.add((Object)market, weight * 5000.0f / Math.max(currDist, 2500.0f));
            if (market.getSize() < size) continue;
            closestMatchingSizePicker.add((Object)market, weight * 5000.0f / Math.max(currDist, 2500.0f));
        }
        if (!closestMatchingSizePicker.isEmpty()) {
            return (MarketAPI)closestMatchingSizePicker.pick();
        }
        if (!closestPicker.isEmpty()) {
            return (MarketAPI)closestPicker.pick();
        }
        return null;
    }

    protected StarSystemAPI pickTargetSystem() {
        WeightedRandomPicker picker = new WeightedRandomPicker();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float mult = Misc.getSpawnChanceMult((Vector2f)system.getLocation());
            float weight = 0.0f;
            for (MarketAPI market : Misc.getMarketsInLocation((LocationAPI)system)) {
                float w;
                if (market.getFactionId().equals("tritachyon") || market.getFactionId().equals("cabal") || market.getFactionId().equals("blackrock_driveyards") || market.getFactionId().equals("exigency") || !((w = 1.0f + market.getStabilityValue() + (float)market.getSize()) > weight)) continue;
                weight = w;
            }
            picker.add((Object)system, weight *= mult);
        }
        return (StarSystemAPI)picker.pick();
    }

    protected CampaignFleetAPI spawnFleet() {
        CabalFleetType cabalFleetType;
        if (!UnderworldModPlugin.Module_StarlightCabal) {
            return null;
        }
        StarSystemAPI target = this.pickTargetSystem();
        if (target == null) {
            return null;
        }
        float combat = MathUtils.getRandomNumberInRange((int)1, (int)MathUtils.getRandomNumberInRange((int)10, (int)MathUtils.getRandomNumberInRange((int)20, (int)30)));
        float freighter = Math.round(combat * MathUtils.getRandomNumberInRange((float)0.05f, (float)0.25f));
        float tanker = Math.round(combat * MathUtils.getRandomNumberInRange((float)0.0f, (float)0.2f));
        float utility = Math.round((freighter + tanker) * MathUtils.getRandomNumberInRange((float)0.0f, (float)0.5f));
        String fleetType = combat < 10.0f ? "patrolSmall" : (combat < 20.0f ? "patrolMedium" : "patrolLarge");
        FleetCompositionDoctrineAPI doctrine = Global.getSector().getFaction("cabal").getCompositionDoctrine();
        float preSmall = doctrine.getSmall();
        float preFast = doctrine.getFast();
        float preMedium = doctrine.getMedium();
        float preLarge = doctrine.getLarge();
        float preCapital = doctrine.getCapital();
        float preEscortSmallFraction = doctrine.getEscortSmallFraction();
        float preEscortMediumFraction = doctrine.getEscortMediumFraction();
        float preCombatFreighterProbability = doctrine.getCombatFreighterProbability();
        float preMinPointsForCombatCapital = doctrine.getMinPointsForCombatCapital();
        float preMinPointsForLargeCarrier = doctrine.getMinPointsForLargeCarrier();
        float preSmallCarrierProbability = doctrine.getSmallCarrierProbability();
        float preMediumCarrierProbability = doctrine.getMediumCarrierProbability();
        float preLargeCarrierProbability = doctrine.getLargeCarrierProbability();
        float preOfficersPerPoint = doctrine.getOfficersPerPoint();
        float preOfficerLevelPerPoint = doctrine.getOfficerLevelPerPoint();
        float preOfficerLevelBase = doctrine.getOfficerLevelBase();
        float preOfficerLevelVariance = doctrine.getOfficerLevelVariance();
        if (combat < 15.0f && Math.random() < 0.3) {
            cabalFleetType = CabalFleetType.FRIGATES;
            doctrine.setSmall(8.0f);
            doctrine.setFast(6.0f);
            doctrine.setMedium(4.0f);
            doctrine.setLarge(0.1f);
            doctrine.setCapital(0.1f);
            doctrine.setCombatFreighterProbability(0.25f);
            doctrine.setEscortSmallFraction(0.25f);
            doctrine.setEscortMediumFraction(0.25f);
            doctrine.setOfficersPerPoint(0.55f);
            doctrine.setOfficerLevelPerPoint(0.25f);
            doctrine.setSmallCarrierProbability(0.0f);
        } else if (combat >= 8.0f && combat < 25.0f && Math.random() < 0.3) {
            cabalFleetType = CabalFleetType.DESTROYERS;
            doctrine.setSmall(3.0f);
            doctrine.setFast(2.0f);
            doctrine.setMedium(15.0f);
            doctrine.setLarge(2.0f);
            doctrine.setCapital(0.1f);
            doctrine.setCombatFreighterProbability(0.25f);
            doctrine.setEscortSmallFraction(0.25f);
            doctrine.setEscortMediumFraction(0.25f);
            doctrine.setOfficersPerPoint(0.45f);
            doctrine.setOfficerLevelPerPoint(0.35f);
        } else if (combat >= 16.0f && Math.random() < 0.3) {
            cabalFleetType = CabalFleetType.CRUISERS;
            doctrine.setSmall(0.1f);
            doctrine.setFast(0.1f);
            doctrine.setMedium(4.0f);
            doctrine.setLarge(12.0f);
            doctrine.setCapital(1.0f);
            doctrine.setCombatFreighterProbability(0.25f);
            doctrine.setEscortSmallFraction(0.25f);
            doctrine.setEscortMediumFraction(0.25f);
            doctrine.setOfficersPerPoint(0.35f);
            doctrine.setOfficerLevelPerPoint(0.45f);
        } else if (combat >= 24.0f && Math.random() < 0.3) {
            cabalFleetType = CabalFleetType.CAPITALS;
            doctrine.setSmall(0.1f);
            doctrine.setFast(0.1f);
            doctrine.setMedium(0.1f);
            doctrine.setLarge(2.0f);
            doctrine.setCapital(8.0f);
            doctrine.setCombatFreighterProbability(0.25f);
            doctrine.setEscortSmallFraction(0.25f);
            doctrine.setEscortMediumFraction(0.25f);
            doctrine.setOfficersPerPoint(0.25f);
            doctrine.setOfficerLevelPerPoint(0.55f);
        } else if (combat >= 10.0f && Math.random() < 0.4) {
            cabalFleetType = CabalFleetType.CARRIERS;
            doctrine.setCombatFreighterProbability(0.5f);
            doctrine.setEscortSmallFraction(0.75f);
            doctrine.setEscortMediumFraction(0.75f);
            doctrine.setSmallCarrierProbability(0.75f);
            doctrine.setMediumCarrierProbability(0.75f);
            doctrine.setLargeCarrierProbability(0.75f);
        } else {
            cabalFleetType = CabalFleetType.BALANCED;
        }
        MarketAPI sourceMarket = this.pickSourceMarket(target.getLocation(), combat);
        if (sourceMarket == null) {
            return null;
        }
        CampaignFleetAPI fleet = FleetFactoryV2.createFleet((FleetParams)new FleetParams(target.getLocation(), sourceMarket, "cabal", null, fleetType, combat, freighter, tanker, 0.0f, 0.0f, 0.0f, utility, 0.25f, -1.0f, 1.0f, 0));
        doctrine.setSmall(preSmall);
        doctrine.setFast(preFast);
        doctrine.setMedium(preMedium);
        doctrine.setLarge(preLarge);
        doctrine.setCapital(preCapital);
        doctrine.setEscortSmallFraction(preEscortSmallFraction);
        doctrine.setEscortMediumFraction(preEscortMediumFraction);
        doctrine.setCombatFreighterProbability(preCombatFreighterProbability);
        doctrine.setMinPointsForCombatCapital(preMinPointsForCombatCapital);
        doctrine.setMinPointsForLargeCarrier(preMinPointsForLargeCarrier);
        doctrine.setSmallCarrierProbability(preSmallCarrierProbability);
        doctrine.setMediumCarrierProbability(preMediumCarrierProbability);
        doctrine.setLargeCarrierProbability(preLargeCarrierProbability);
        doctrine.setOfficersPerPoint(preOfficersPerPoint);
        doctrine.setOfficerLevelPerPoint(preOfficerLevelPerPoint);
        doctrine.setOfficerLevelBase(preOfficerLevelBase);
        doctrine.setOfficerLevelVariance(preOfficerLevelVariance);
        if (fleet == null) {
            return null;
        }
        if (combat < 10.0f) {
            fleet.getCommander().setRankId(Ranks.SPACE_COMMANDER);
        } else if (combat < 20.0f) {
            fleet.getCommander().setRankId(Ranks.SPACE_CAPTAIN);
        } else {
            fleet.getCommander().setRankId(Ranks.SPACE_ADMIRAL);
        }
        switch (cabalFleetType) {
            case FRIGATES: {
                fleet.setName("\u62a4\u536b\u8230\u961f");
                break;
            }
            case DESTROYERS: {
                fleet.setName("\u9a71\u9010\u8230\u961f");
                break;
            }
            case CRUISERS: {
                fleet.setName("\u5de1\u6d0b\u8230\u961f");
                break;
            }
            case CAPITALS: {
                fleet.setName("\u4e3b\u529b\u8230\u961f");
                break;
            }
            case CARRIERS: {
                if (combat < 20.0f) {
                    fleet.setName("\u822a\u6bcd\u7f16\u961f");
                    break;
                }
                fleet.setName("\u6b7b\u4ea1\u8230\u961f");
                break;
            }
            default: {
                if (combat < 10.0f) {
                    fleet.setName("\u5f98\u5f8a\u8005");
                    break;
                }
                if (combat < 20.0f) {
                    fleet.setName("\u96c6\u56e2\u8230\u961f");
                    break;
                }
                fleet.setName("\u5bb6\u65cf\u8230\u961f");
            }
        }
        fleet.getMemoryWithoutUpdate().set("$fleetType", (Object)"cabalFleet");
        fleet.getMemoryWithoutUpdate().set("$isPirate", (Object)true);
        fleet.getStats().getDynamic().getMod("ds_debris_chance_battle").modifyMult("uw_spawner", 0.5f);
        fleet.getStats().getDynamic().getMod("ds_derelicts_chance_battle").modifyMult("uw_spawner", 0.5f);
        fleet.getStats().getDynamic().getMod("ds_debris_scale_fleet").modifyMult("uw_spawner", 0.75f);
        fleet.getStats().getDynamic().getMod("ds_derelicts_scale_fleet").modifyMult("uw_spawner", 0.5f);
        MarketAPI source = Misc.getSourceMarket((CampaignFleetAPI)fleet);
        if (source == null) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        boolean spawnAtSource = true;
        if (player != null) {
            float targetToPlayer;
            float sourceToPlayer = Misc.getDistance((Vector2f)player.getLocation(), (Vector2f)source.getLocationInHyperspace());
            boolean bl = spawnAtSource = sourceToPlayer < (targetToPlayer = Misc.getDistance((Vector2f)player.getLocation(), (Vector2f)target.getLocation())) && source.hasCondition("cabal_influence");
        }
        if (spawnAtSource) {
            source.getPrimaryEntity().getContainingLocation().addEntity((SectorEntityToken)fleet);
            fleet.setLocation(source.getPrimaryEntity().getLocation().x, source.getPrimaryEntity().getLocation().y);
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, source.getPrimaryEntity(), 2.0f + (float)Math.random() * 2.0f, "\u6b63\u5728\u73af\u7ed5 " + source.getName());
        } else {
            Vector2f loc = Misc.pickHyperLocationNotNearPlayer((Vector2f)target.getLocation(), (float)((float)Global.getSettings().getMaxSensorRange() + 500.0f));
            Global.getSector().getHyperspace().addEntity((SectorEntityToken)fleet);
            fleet.setLocation(loc.x, loc.y);
            log.info((Object)("UW_CabalFleetManager: Spawned at " + loc));
        }
        fleet.addScript((EveryFrameScript)new ScrewWithPlayer(fleet));
        Vector2f dest = Misc.getPointAtRadius((Vector2f)target.getLocation(), (float)1500.0f);
        LocationAPI hyper = Global.getSector().getHyperspace();
        SectorEntityToken token = hyper.createToken(dest.x, dest.y);
        fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, token, 1000.0f, "\u6b63\u5728\u524d\u5f80 " + target.getBaseName() + " \u661f\u7cfb");
        if ((float)Math.random() > 0.75f) {
            fleet.addAssignment(FleetAssignment.RAID_SYSTEM, target.getHyperspaceAnchor(), 20.0f, "\u6b63\u5728\u9644\u8fd1\u88ad " + target.getBaseName() + " \u661f\u7cfb");
        } else {
            fleet.addAssignment(FleetAssignment.RAID_SYSTEM, target.getCenter(), 20.0f, "\u6b63\u5728\u88ad\u51fb " + target.getBaseName() + " \u661f\u7cfb");
        }
        fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, source.getPrimaryEntity(), 1000.0f, "\u56de\u5230 " + source.getName());
        fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, source.getPrimaryEntity(), 2.0f + 2.0f * (float)Math.random(), "retiring");
        fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, source.getPrimaryEntity(), 1000.0f);
        return fleet;
    }

    private static enum CabalFleetType {
        FRIGATES,
        DESTROYERS,
        CRUISERS,
        CAPITALS,
        CARRIERS,
        BALANCED;

    }

    public static class ScrewWithPlayer
    implements EveryFrameScript {
        private static long signalExtortionPaidGlobal = 0L;
        private static float timer = 0.0f;
        private final CampaignFleetAPI fleet;
        private long signalExtortionPaid = 0L;
        private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.5f);

        ScrewWithPlayer(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }

        public void advance(float amount) {
            float chaseDuration;
            float tryAgainTimer;
            MemoryAPI mem;
            float days = Global.getSector().getClock().convertToDays(amount);
            this.tracker.advance(days);
            if (timer > 0.0f) {
                timer -= days;
            }
            if ((mem = this.fleet.getMemoryWithoutUpdate()).getBoolean("$Cabal_extortionAskedFor")) {
                Misc.setFlagWithReason((MemoryAPI)mem, (String)"$pursuePlayer", (String)"cabalScrewWithPlayer", (boolean)false, (float)0.0f);
            }
            switch (Global.getSector().getFaction("cabal").getRelToPlayer().getLevel()) {
                default: {
                    return;
                }
                case INHOSPITABLE: {
                    tryAgainTimer = 30.0f;
                    chaseDuration = 6.0f;
                    break;
                }
                case SUSPICIOUS: {
                    tryAgainTimer = 45.0f;
                    chaseDuration = 5.0f;
                    break;
                }
                case NEUTRAL: {
                    tryAgainTimer = 60.0f;
                    chaseDuration = 4.0f;
                    break;
                }
                case FAVORABLE: {
                    tryAgainTimer = 75.0f;
                    chaseDuration = 3.0f;
                    break;
                }
                case WELCOMING: {
                    tryAgainTimer = 90.0f;
                    chaseDuration = 2.0f;
                    break;
                }
                case FRIENDLY: 
                case COOPERATIVE: {
                    return;
                }
            }
            if (signalExtortionPaidGlobal != this.signalExtortionPaid) {
                mem.set("$Cabal_extortionPaid", (Object)Float.valueOf(tryAgainTimer));
                timer = tryAgainTimer;
                this.signalExtortionPaid = signalExtortionPaidGlobal;
            }
            if (this.tracker.intervalElapsed() && timer <= 0.0f) {
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                if (playerFleet == null) {
                    return;
                }
                if (mem.getBoolean("$Cabal_extortionPaid") && signalExtortionPaidGlobal == this.signalExtortionPaid) {
                    signalExtortionPaidGlobal = Global.getSector().getClock().getTimestamp();
                }
                if (playerFleet.getContainingLocation() != this.fleet.getContainingLocation()) {
                    return;
                }
                if (!CabalPickContributionMethod.playerHasAbilityToPayContribution(this.fleet)) {
                    return;
                }
                SectorEntityToken.VisibilityLevel level = playerFleet.getVisibilityLevelTo((SectorEntityToken)this.fleet);
                if (level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS) {
                    Misc.setFlagWithReason((MemoryAPI)mem, (String)"$pursuePlayer", (String)"cabalScrewWithPlayer", (boolean)true, (float)chaseDuration);
                    timer = tryAgainTimer;
                }
            }
        }

        public boolean isDone() {
            return !this.fleet.isAlive();
        }

        public boolean runWhilePaused() {
            return false;
        }
    }
}

