/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.impl.campaign.submarkets.BlackMarketPlugin;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;

public class UW_CabalMarketPlugin
extends BlackMarketPlugin {
    private static final RepLevel MIN_STANDING = RepLevel.INHOSPITABLE;
    private boolean playerPaidToUnlock = false;
    private float sinceLastUnlock = 0.0f;

    public UW_CabalMarketPlugin() {
        this.minCargoUpdateInterval = 14.0f;
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.sinceLastUnlock += days;
        if (this.sinceLastUnlock > 7.0f) {
            this.playerPaidToUnlock = false;
        }
    }

    public SubmarketPlugin.DialogOption[] getDialogOptions(CoreUIAPI ui) {
        if (this.canPlayerAffordUnlock()) {
            return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("\u652f\u4ed8", new Script(){

                public void run() {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    playerFleet.getCargo().getCredits().subtract((float)UW_CabalMarketPlugin.this.getUnlockCost());
                    UW_CabalMarketPlugin.this.playerPaidToUnlock = true;
                    UW_CabalMarketPlugin.this.sinceLastUnlock = 0.0f;
                }
            }), new SubmarketPlugin.DialogOption("\u6ca1\u5173\u7cfb", null)};
        }
        return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("\u6ca1\u5173\u7cfb", null)};
    }

    public String getDialogText(CoreUIAPI ui) {
        if (this.canPlayerAffordUnlock()) {
            return "\"\u5982\u679c\u4f60\u60f3\u73b0\u5728\u8fdb\u5165, \u53ea\u9700\u652f\u4ed8 " + Misc.getWithDGS((float)this.getUnlockCost()) + "- \u661f\u5e01\u7684\u8d39\u7528.\"";
        }
        return "\"\u4f60\u5c45\u7136\u65e0\u6cd5\u652f\u4ed8 " + Misc.getWithDGS((float)this.getUnlockCost()) + "- \u661f\u5e01\u7684\u8d39\u7528? \u6eda\u5427.\"";
    }

    public Highlights getDialogTextHighlights(CoreUIAPI ui) {
        Highlights h = new Highlights();
        h.setText(new String[]{"" + this.getUnlockCost()});
        if (this.canPlayerAffordUnlock()) {
            h.setColors(new Color[]{Misc.getHighlightColor()});
        } else {
            h.setColors(new Color[]{Misc.getNegativeHighlightColor()});
        }
        return h;
    }

    public SubmarketPlugin.OnClickAction getOnClickAction(CoreUIAPI ui) {
        if (this.playerPaidToUnlock || this.submarket.getFaction().getRelToPlayer().isAtWorst(RepLevel.FRIENDLY)) {
            return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
        }
        return SubmarketPlugin.OnClickAction.SHOW_TEXT_DIALOG;
    }

    public float getTariff() {
        return this.playerPaidToUnlock || this.submarket.getFaction().getRelToPlayer().isAtWorst(RepLevel.FRIENDLY) ? 0.0f : 10.0f;
    }

    public String getTooltipAppendix(CoreUIAPI ui) {
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        if (!level.isAtWorst(MIN_STANDING)) {
            return "\u9700\u8981: " + this.submarket.getFaction().getDisplayName() + " - " + MIN_STANDING.getDisplayName().toLowerCase();
        }
        if (Global.getSector().getPlayerFleet().isTransponderOn()) {
            return "\u9700\u8981: \u4e00\u4e2a\u66f4\u52a0\u79c1\u5bc6\u7684\u65b9\u5f0f, \u6bd4\u5982\u5173\u95ed\u4f60\u7684\u5e94\u7b54\u5668";
        }
        return super.getTooltipAppendix(ui);
    }

    public boolean isEnabled(CoreUIAPI ui) {
        if (Global.getSector().getPlayerFleet().isTransponderOn()) {
            return false;
        }
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        return level.isAtWorst(MIN_STANDING);
    }

    public void updateCargoPrePlayerInteraction() {
        if (!this.okToUpdateCargo()) {
            return;
        }
        this.sinceLastCargoUpdate = 0.0f;
        CargoAPI cargo = this.getCargo();
        this.updateEconomicCommoditiesInCargo(true);
        this.pruneWeapons(0.5f);
        this.addWeaponsBasedOnMarketSize(5, 3, 4, null);
        this.addRandomWeapons(Math.max(1, this.market.getSize() - 2), 4);
        this.addRandomWings(Math.max(1, this.market.getSize() - 4), 3);
        this.addShips();
        this.addHullMods(4, 2 + this.itemGenRandom.nextInt(3));
        cargo.sort();
    }

    private void addShips() {
        int marketSize = this.market.getSize();
        this.pruneShips(0.75f);
        WeightedRandomPicker rolePicker = new WeightedRandomPicker();
        rolePicker.add((Object)"freighterSmall", 3.0f);
        rolePicker.add((Object)"tankerSmall", 3.0f);
        rolePicker.add((Object)"personnelSmall", 1.0f);
        rolePicker.add((Object)"combatSmall", 15.0f);
        rolePicker.add((Object)"escortSmall", 10.0f);
        rolePicker.add((Object)"combatMedium", 15.0f);
        rolePicker.add((Object)"carrierSmall", 3.0f);
        if (marketSize >= 4) {
            rolePicker.add((Object)"utility", 5.0f);
            rolePicker.add((Object)"freighterMedium", 5.0f);
            rolePicker.add((Object)"tankerMedium", 5.0f);
            rolePicker.add((Object)"personnelMedium", 2.0f);
            rolePicker.add((Object)"combatMedium", 10.0f);
            rolePicker.add((Object)"escortMedium", 10.0f);
            rolePicker.add((Object)"carrierSmall", 10.0f);
            rolePicker.add((Object)"combatLarge", 10.0f);
            rolePicker.add((Object)"carrierMedium", 5.0f);
            rolePicker.add((Object)"combatCapital", 3.0f);
        }
        if (marketSize >= 5) {
            rolePicker.add((Object)"utility", 3.0f);
            rolePicker.add((Object)"freighterLarge", 3.0f);
            rolePicker.add((Object)"tankerLarge", 3.0f);
            rolePicker.add((Object)"personnelLarge", 1.0f);
            rolePicker.add((Object)"combatFreighterLarge", 5.0f);
            rolePicker.add((Object)"combatLarge", 5.0f);
            rolePicker.add((Object)"carrierMedium", 5.0f);
            rolePicker.add((Object)"combatCapital", 4.0f);
            rolePicker.add((Object)"carrierLarge", 2.0f);
        }
        this.addShipsForRoles(Math.round(1.5f + (float)marketSize * 1.5f), rolePicker, null);
    }

    private boolean canPlayerAffordUnlock() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int credits = (int)playerFleet.getCargo().getCredits().get();
        return credits >= this.getUnlockCost();
    }

    private int getUnlockCost() {
        float fudge;
        switch (this.submarket.getFaction().getRelToPlayer().getLevel()) {
            default: {
                fudge = 2.0f;
                break;
            }
            case SUSPICIOUS: {
                fudge = 1.5f;
                break;
            }
            case NEUTRAL: {
                fudge = 1.0f;
                break;
            }
            case FAVORABLE: {
                fudge = 0.75f;
                break;
            }
            case WELCOMING: {
                fudge = 0.5f;
                break;
            }
            case FRIENDLY: 
            case COOPERATIVE: {
                fudge = 0.0f;
            }
        }
        return Math.round((float)this.market.getSize() * this.market.getStabilityValue() * fudge) * 1000;
    }
}

