/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.submarkets.BlackMarketPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.util.UW_Defs;
import java.util.List;
import java.util.Random;

public class UW_ScrapyardMarketPlugin
extends BlackMarketPlugin {
    public float getDesiredAboveDemandCommodityQuantity(CommodityOnMarketAPI com) {
        switch (com.getId()) {
            case "fuel": 
            case "supplies": 
            case "hand_weapons": 
            case "heavy_machinery": 
            case "metals": 
            case "rare_metals": 
            case "volatiles": {
                break;
            }
            default: {
                return 0.0f;
            }
        }
        boolean illegal = this.market.isIllegal(com.getId());
        if (illegal) {
            return com.getAboveDemandStockpile();
        }
        float blackMarketLegalFraction = 1.0f - 0.09f * this.market.getStabilityValue();
        return com.getAboveDemandStockpile() * blackMarketLegalFraction;
    }

    public float getDesiredBelowDemandCommodityQuantity(CommodityOnMarketAPI com) {
        switch (com.getId()) {
            case "fuel": 
            case "supplies": {
                break;
            }
            default: {
                return 0.0f;
            }
        }
        boolean illegal = this.market.isIllegal(com.getId());
        float blackMarketLegalFraction = 0.5f - 0.02f * this.market.getStabilityValue();
        float blackMarketIllegalFraction = 0.5f - 0.025f * this.market.getStabilityValue();
        float fraction = blackMarketLegalFraction;
        if (illegal) {
            fraction = blackMarketIllegalFraction;
        }
        return Math.max(0.0f, com.getStockpile() - com.getAboveDemandStockpile()) * fraction;
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL) {
            return "\u6982\u4e0d\u9000\u6b3e";
        }
        return "\u975e\u6cd5\u4ea4\u6613 " + this.submarket.getNameOneLine().toLowerCase() + " here";
    }

    public String getIllegalTransferText(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL) {
            return "\u6982\u4e0d\u9000\u6b3e";
        }
        return "\u975e\u6cd5\u8d2d\u4e70";
    }

    public float getTariff() {
        return -0.3f;
    }

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL) {
            return true;
        }
        if (this.market.hasCondition("free_market")) {
            return false;
        }
        return this.submarket.getFaction().isIllegal(commodityId);
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL) {
            return true;
        }
        if (!stack.isCommodityStack()) {
            return false;
        }
        return this.isIllegalOnSubmarket((String)stack.getData(), action);
    }

    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public void updateCargoPrePlayerInteraction() {
        for (FleetMemberAPI member : this.getCargo().getMothballedShips().getMembersListCopy()) {
            int dmods = Math.round(5.0f * (1.0f - member.getStatus().getHullFraction()));
            ShipVariantAPI variant = member.getVariant();
            int dModsAlready = DModManager.getNumDMods((ShipVariantAPI)variant);
            if ((dmods = Math.max(0, dmods - dModsAlready)) > 0) {
                DModManager.setDHull((ShipVariantAPI)variant);
            }
            member.setVariant(variant, false, true);
            if (dmods <= 0) continue;
            DModManager.addDMods((FleetMemberAPI)member, (boolean)true, (int)dmods, (Random)new Random());
        }
        if (!this.okToUpdateCargo()) {
            return;
        }
        this.sinceLastCargoUpdate = 0.0f;
        CargoAPI cargo = this.getCargo();
        this.updateEconomicCommoditiesInCargo(false);
        this.pruneWeapons(0.5f);
        WeightedRandomPicker factionPicker = new WeightedRandomPicker();
        int index = 0;
        for (String item : UW_Defs.SCRAPYARD_FACTIONS.getItems()) {
            FactionAPI f;
            try {
                f = Global.getSector().getFaction(item);
            }
            catch (Exception e) {
                f = null;
            }
            if (f != null) {
                factionPicker.add((Object)f, UW_Defs.SCRAPYARD_FACTIONS.getWeight(index));
            }
            ++index;
        }
        this.addWeaponsBasedOnMarketSize(6, 3, 1, factionPicker);
        this.addRandomWeapons(Math.max(1, this.market.getSize()), 1);
        this.addRandomWings(Math.max(1, this.market.getSize() - 2), 1);
        this.addShips();
        this.addHullMods(1, 1 + this.itemGenRandom.nextInt(3));
        cargo.sort();
    }

    private void addShips() {
        int marketSize = this.market.getSize();
        this.pruneShips(0.75f);
        WeightedRandomPicker rolePicker = new WeightedRandomPicker();
        rolePicker.add((Object)"civilianRandom", 5.0f);
        rolePicker.add((Object)"freighterSmall", 3.0f);
        rolePicker.add((Object)"tankerSmall", 20.0f);
        rolePicker.add((Object)"combatFreighterSmall", 15.0f);
        rolePicker.add((Object)"escortSmall", 15.0f);
        rolePicker.add((Object)"combatSmall", 15.0f);
        rolePicker.add((Object)"linerSmall", 1.0f);
        rolePicker.add((Object)"freighterMedium", 5.0f);
        rolePicker.add((Object)"tankerMedium", 10.0f);
        rolePicker.add((Object)"combatFreighterMedium", 10.0f);
        rolePicker.add((Object)"combatMedium", 10.0f);
        rolePicker.add((Object)"escortMedium", 10.0f);
        rolePicker.add((Object)"carrierSmall", 10.0f);
        rolePicker.add((Object)"linerMedium", 1.0f);
        rolePicker.add((Object)"freighterLarge", 3.0f);
        rolePicker.add((Object)"tankerLarge", 5.0f);
        rolePicker.add((Object)"combatFreighterLarge", 5.0f);
        rolePicker.add((Object)"combatLarge", 5.0f);
        rolePicker.add((Object)"carrierMedium", 3.0f);
        rolePicker.add((Object)"linerLarge", 1.0f);
        rolePicker.add((Object)"combatCapital", 3.0f);
        rolePicker.add((Object)"carrierLarge", 2.0f);
        WeightedRandomPicker factionPicker = new WeightedRandomPicker();
        int index = 0;
        for (String item : UW_Defs.SCRAPYARD_FACTIONS.getItems()) {
            FactionAPI f;
            try {
                f = Global.getSector().getFaction(item);
            }
            catch (Exception e) {
                f = null;
            }
            if (f != null) {
                factionPicker.add((Object)f, UW_Defs.SCRAPYARD_FACTIONS.getWeight(index));
            }
            ++index;
        }
        this.addShipsForRoles(2 + marketSize * 6, (WeightedRandomPicker<String>)rolePicker, (WeightedRandomPicker<FactionAPI>)factionPicker);
    }

    protected void addShipsForRole(String role, Random random, WeightedRandomPicker<FactionAPI> factionPicker) {
        float qf = -1.0f;
        FactionAPI faction = this.submarket.getFaction();
        if (factionPicker != null && !factionPicker.isEmpty()) {
            faction = (FactionAPI)factionPicker.pick();
        }
        List picks = faction.pickShip(role, qf, random);
        for (ShipRolePick pick : picks) {
            FleetMemberAPI member;
            FleetMemberType type = FleetMemberType.SHIP;
            String variantId = pick.variantId;
            if (pick.isFighterWing()) {
                type = FleetMemberType.FIGHTER_WING;
            } else {
                member = Global.getFactory().createFleetMember(type, pick.variantId);
                variantId = member.getHullId() + "_Hull";
            }
            member = Global.getFactory().createFleetMember(type, variantId);
            member.getRepairTracker().setMothballed(true);
            int dmods = Math.round(random.nextFloat() * random.nextFloat() * 4.0f);
            ShipVariantAPI variant = member.getVariant();
            int dModsAlready = DModManager.getNumDMods((ShipVariantAPI)variant);
            int newDmods = Math.max(0, dmods - dModsAlready);
            if (newDmods > 0) {
                DModManager.setDHull((ShipVariantAPI)variant);
            }
            member.setVariant(variant, false, true);
            if (newDmods > 0) {
                DModManager.addDMods((FleetMemberAPI)member, (boolean)true, (int)newDmods, (Random)random);
            }
            member.getStatus().setHullFraction(1.0f - (float)dmods * 0.1f);
            this.getCargo().getMothballedShips().addFleetMember(member);
        }
    }

    protected void addShipsForRoles(int maxTotal, WeightedRandomPicker<String> rolePicker, WeightedRandomPicker<FactionAPI> factionPicker) {
        if (rolePicker.isEmpty()) {
            return;
        }
        rolePicker.setRandom(this.itemGenRandom);
        if (factionPicker != null) {
            factionPicker.setRandom(this.itemGenRandom);
        }
        int curr = this.getCargo().getMothballedShips().getMembersListCopy().size();
        int toAdd = maxTotal - curr;
        for (int added = 0; added < toAdd; ++added) {
            String role = (String)rolePicker.pick();
            this.addShipsForRole(role, rolePicker.getRandom(), factionPicker);
        }
    }
}

