/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.util.UW_Util;
import java.awt.Color;
import org.lazywizard.lazylib.CollisionUtils;
import org.lwjgl.util.vector.Vector2f;

public class UW_CabalUpgrades
extends BaseHullMod {
    private static final float ARMOR_MULT = 1.05f;
    private static final float FLUX_MULT = 1.05f;
    private static final float HANDLING_MULT = 1.05f;
    private static final float LOGISTICS_PENALTY = 15.0f;
    private static final float MAX_SPARKLE_CHANCE_PER_SECOND_PER_CELL = 1.0f;
    private static final float SHIELD_MULT = 1.05f;
    private static final Color SPARK_COLOR = new Color(175, 50, 230, 100);
    private static final float SPARK_DURATION = 0.5f;
    private static final float SPARK_RADIUS = 4.0f;

    public static Vector2f getCellLocation(ShipAPI ship, float x, float y) {
        float xx = x - (float)ship.getArmorGrid().getGrid().length / 2.0f;
        float yy = y - (float)ship.getArmorGrid().getGrid()[0].length / 2.0f;
        float cellSize = ship.getArmorGrid().getCellSize();
        Vector2f cellLoc = new Vector2f();
        float theta = (float)((double)((ship.getFacing() - 90.0f) / 360.0f) * (Math.PI * 2));
        cellLoc.x = (float)((double)xx * Math.cos(theta) - (double)yy * Math.sin(theta)) * cellSize + ship.getLocation().x;
        cellLoc.y = (float)((double)xx * Math.sin(theta) + (double)yy * Math.cos(theta)) * cellSize + ship.getLocation().y;
        return cellLoc;
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        CombatEngineAPI engine = Global.getCombatEngine();
        float fluxLevel = ship.getFluxTracker().getFluxLevel();
        ArmorGridAPI armorGrid = ship.getArmorGrid();
        Color color = new Color(SPARK_COLOR.getRed(), SPARK_COLOR.getGreen(), SPARK_COLOR.getBlue(), (int)((float)SPARK_COLOR.getAlpha() * (1.0f - fluxLevel)));
        for (int x = 0; x < armorGrid.getGrid().length; ++x) {
            for (int y = 0; y < armorGrid.getGrid()[0].length; ++y) {
                float armorLevel = armorGrid.getArmorValue(x, y);
                if (armorLevel <= 0.0f) continue;
                float chance = amount * (1.0f - fluxLevel) * 1.0f * armorLevel / armorGrid.getMaxArmorInCell();
                if (Math.random() >= (double)chance) continue;
                float cellSize = armorGrid.getCellSize();
                Vector2f cellLoc = UW_CabalUpgrades.getCellLocation(ship, x, y);
                cellLoc.x += cellSize * 0.1f - cellSize * (float)Math.random();
                cellLoc.y += cellSize * 0.1f - cellSize * (float)Math.random();
                if (!CollisionUtils.isPointWithinBounds((Vector2f)cellLoc, (CombatEntityAPI)ship)) continue;
                engine.addHitParticle(cellLoc, ship.getVelocity(), 2.0f * (float)Math.random() + 4.0f, 1.0f, 0.5f, UW_Util.colorJitter(color, 50.0f));
            }
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getArmorBonus().modifyMult(id, 1.05f);
        stats.getHullBonus().modifyMult(id, 1.05f);
        stats.getFluxCapacity().modifyMult(id, 1.05f);
        stats.getFluxDissipation().modifyMult(id, 1.05f);
        stats.getShieldUpkeepMult().modifyMult(id, 0.952381f);
        stats.getShieldUnfoldRateMult().modifyMult(id, 1.05f);
        stats.getShieldTurnRateMult().modifyMult(id, 1.05f);
        stats.getShieldArcBonus().modifyMult(id, 1.05f);
        stats.getShieldDamageTakenMult().modifyMult(id, 0.952381f);
        stats.getPhaseCloakActivationCostBonus().modifyMult(id, 0.952381f);
        stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 0.952381f);
        stats.getMaxSpeed().modifyMult(id, 1.05f);
        stats.getAcceleration().modifyMult(id, 1.05f);
        stats.getDeceleration().modifyMult(id, 1.05f);
        stats.getMaxTurnRate().modifyMult(id, 1.05f);
        stats.getTurnAcceleration().modifyMult(id, 1.05f);
        stats.getSuppliesPerMonth().modifyPercent(id, 15.0f);
        stats.getSuppliesToRecover().modifyPercent(id, 15.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + Math.round(4.999995f);
        }
        if (index == 1) {
            return "" + Math.round(4.999995f);
        }
        if (index == 2) {
            return "" + Math.round(4.999995f);
        }
        if (index == 3) {
            return "" + Math.round(4.999995f);
        }
        if (index == 4) {
            return "" + Math.round(15.0f);
        }
        return null;
    }
}

