/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.PhaseCloakStats;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class UW_PirateCloakStats
extends PhaseCloakStats {
    private static final float MAX_TIME_MULT = 2.5f;

    public static float getMaxTimeMult(MutableShipStatsAPI stats) {
        return 1.0f + 1.5f * stats.getDynamic().getValue("phase_time_mult");
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float level;
        String actualId = id;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        actualId = actualId + "_" + ship.getId();
        if (player) {
            this.maintainStatus(ship, effectLevel);
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, actualId);
            return;
        }
        float levelForAlpha = level = effectLevel;
        ship.setPhased(true);
        ship.setExtraAlphaMult(1.0f - 0.75f * levelForAlpha);
        ship.setApplyExtraAlphaToEngines(true);
        float shipTimeMult = 1.0f + (UW_PirateCloakStats.getMaxTimeMult(stats) - 1.0f) * levelForAlpha;
        stats.getTimeMult().modifyMult(actualId, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(actualId, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(actualId);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);
        ship.setPhased(false);
        ship.setExtraAlphaMult(1.0f);
    }

    private void maintainStatus(ShipAPI playerShip, float effectLevel) {
        float level = effectLevel;
        float f = 0.0f;
        ShipSystemAPI cloak = playerShip.getPhaseCloak();
        if (cloak == null) {
            cloak = playerShip.getSystem();
        }
        if (cloak == null) {
            return;
        }
        if (level > f) {
            Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY2, cloak.getSpecAPI().getIconSpriteName(), cloak.getDisplayName(), "\u65f6\u95f4\u6d41\u901f\u6539\u53d8", false);
        }
    }
}

