/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class UW_Util {
    public static Color colorBlend(Color a, Color b, float amount) {
        float conjAmount = 1.0f - amount;
        return new Color((int)Math.max(0.0f, Math.min(255.0f, (float)a.getRed() * conjAmount + (float)b.getRed() * amount)), (int)Math.max(0.0f, Math.min(255.0f, (float)a.getGreen() * conjAmount + (float)b.getGreen() * amount)), (int)Math.max(0.0f, Math.min(255.0f, (float)a.getBlue() * conjAmount + (float)b.getBlue() * amount)), (int)Math.max(0.0f, Math.min(255.0f, (float)a.getAlpha() * conjAmount + (float)b.getAlpha() * amount)));
    }

    public static Color colorJitter(Color color, float amount) {
        return new Color(Math.max(0, Math.min(255, color.getRed() + (int)(((float)Math.random() - 0.5f) * amount))), Math.max(0, Math.min(255, color.getGreen() + (int)(((float)Math.random() - 0.5f) * amount))), Math.max(0, Math.min(255, color.getBlue() + (int)(((float)Math.random() - 0.5f) * amount))), color.getAlpha());
    }

    public static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    public static float lerp(float x, float y, float alpha) {
        return (1.0f - alpha) * x + alpha * y;
    }

    public static void removeMarketInfluence(MarketAPI market, String faction) {
        List influences = (List)market.getMemoryWithoutUpdate().get("$ds_market_influences");
        if (influences != null) {
            influences.remove(faction);
        }
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static long roundToSignificantFiguresLong(double num, int n) {
        return Math.round(UW_Util.roundToSignificantFigures(num, n));
    }

    public static void setMarketInfluence(MarketAPI market, String faction) {
        ArrayList<String> influences = (ArrayList<String>)market.getMemoryWithoutUpdate().get("$ds_market_influences");
        if (influences == null) {
            influences = new ArrayList<String>(3);
            market.getMemoryWithoutUpdate().set("$ds_market_influences", influences);
        }
        if (!influences.contains(faction)) {
            influences.add(faction);
        }
    }
}

