/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class UW_HellfireEveryFrameEffect
implements EveryFrameWeaponEffectPlugin {
    private static final Vector2f OFFSET_1 = new Vector2f(-58.5f, 20.0f);
    private static final Vector2f OFFSET_2 = new Vector2f(-64.5f, 0.0f);
    private static final Vector2f OFFSET_3 = new Vector2f(-58.5f, -20.0f);
    private static final Color SMOKE_COLOR_1 = new Color(100, 75, 70, 200);
    private static final Color SMOKE_COLOR_2 = new Color(40, 40, 40, 100);
    private static final float SMOKE_DURATION = 2.5f;
    private static final float SMOKE_SIZE = 50.0f;
    private float lastChargeLevel = 0.0f;
    private float lastCooldownRemaining = 0.0f;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (engine.isPaused()) {
            return;
        }
        float chargeLevel = weapon.getChargeLevel();
        float cooldownRemaining = weapon.getCooldownRemaining();
        if (chargeLevel > this.lastChargeLevel || this.lastCooldownRemaining < cooldownRemaining) {
            Vector2f muzzleLocation;
            Vector2f weaponLocation = weapon.getLocation();
            ShipAPI ship = weapon.getShip();
            float weaponFacing = weapon.getCurrAngle();
            Vector2f shipVelocity = ship.getVelocity();
            switch (MathUtils.getRandomNumberInRange((int)1, (int)3)) {
                case 1: {
                    muzzleLocation = new Vector2f((ReadableVector2f)OFFSET_1);
                    break;
                }
                case 2: {
                    muzzleLocation = new Vector2f((ReadableVector2f)OFFSET_2);
                    break;
                }
                case 3: {
                    muzzleLocation = new Vector2f((ReadableVector2f)OFFSET_3);
                    break;
                }
                default: {
                    return;
                }
            }
            VectorUtils.rotate((Vector2f)muzzleLocation, (float)weaponFacing, (Vector2f)muzzleLocation);
            Vector2f.add((Vector2f)muzzleLocation, (Vector2f)weaponLocation, (Vector2f)muzzleLocation);
            Vector2f smokeVelocity = MathUtils.getPointOnCircumference((Vector2f)shipVelocity, (float)(-20.0f * ((float)Math.random() * 0.5f + 0.75f)), (float)weaponFacing);
            if (this.lastCooldownRemaining < cooldownRemaining) {
                engine.addSmokeParticle(muzzleLocation, smokeVelocity, 50.0f * ((float)Math.random() * 0.5f + 1.25f), 0.3f, 2.5f * ((float)Math.random() * 0.5f + 1.25f), SMOKE_COLOR_2);
                engine.addSmokeParticle(muzzleLocation, smokeVelocity, 50.0f * ((float)Math.random() * 1.0f + 0.5f), 0.5f, 2.5f * ((float)Math.random() * 0.5f + 0.75f), SMOKE_COLOR_1);
            }
        }
        this.lastChargeLevel = chargeLevel;
        this.lastCooldownRemaining = cooldownRemaining;
    }
}

