/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.underworld;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import data.scripts.world.underworld.UW_DickersonFleetManager;

public class UW_DickersonAssignmentAI
implements EveryFrameScript {
    private final UW_DickersonFleetManager.DickersonFleetData data;
    private float daysTotal = 0.0f;
    private final CampaignFleetAPI fleet;
    private boolean orderedReturn = false;

    public UW_DickersonAssignmentAI(CampaignFleetAPI fleet, UW_DickersonFleetManager.DickersonFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 120.0f) {
            this.giveReturnToSourceOrders();
            return;
        }
        if (this.fleet.getAI().getCurrentAssignment() != null) {
            float fp = this.fleet.getFleetPoints();
            if (fp < this.data.startingFleetPoints / 3.0f) {
                this.giveReturnToSourceOrders();
            }
        } else {
            this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.data.source, 1000.0f, "\u6b63\u5728\u4fdd\u536b " + this.data.sourceMarket.getName());
        }
    }

    public boolean isDone() {
        return !this.fleet.isAlive();
    }

    public boolean runWhilePaused() {
        return false;
    }

    private float getDaysToOrbit() {
        return 1.0f;
    }

    private void giveInitialAssignment() {
        float daysToOrbit = this.getDaysToOrbit();
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.source, daysToOrbit, "\u51c6\u5907\u5de5\u4f5c " + this.data.source.getName());
    }

    private void giveReturnToSourceOrders() {
        if (!this.orderedReturn) {
            this.orderedReturn = true;
            this.fleet.clearAssignments();
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.data.source, 1000.0f);
        }
    }
}

