/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.underworld;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.campaign.UW_FleetFactory;
import data.scripts.world.underworld.UW_DickersonAssignmentAI;

public class UW_DickersonFleetManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    private static final WeightedRandomPicker<String> DICKERSON_VARIANTS = new WeightedRandomPicker();
    private DickersonFleetData activeDickerson = null;
    private int battlesLost;
    private boolean dickersonHostile;
    private final MarketAPI market;
    private float respawnTimer;
    private final IntervalUtil tracker;

    public UW_DickersonFleetManager(MarketAPI market) {
        super(true);
        this.market = market;
        this.tracker = new IntervalUtil(0.75f, 1.25f);
        this.battlesLost = 0;
        this.respawnTimer = 0.0f;
        this.dickersonHostile = false;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        Integer level = (Integer)Global.getSector().getPersistentData().get("uw_dickerson_level");
        if (level == null) {
            Global.getSector().getPersistentData().put("uw_dickerson_level", this.battlesLost);
        } else {
            this.battlesLost = level;
        }
        this.tracker.advance(days);
        this.respawnTimer -= days;
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (this.market.hasCondition("decivilized")) {
            return;
        }
        if (!(this.activeDickerson == null || this.activeDickerson.fleet.getContainingLocation() != null && this.activeDickerson.fleet.getContainingLocation().getFleets().contains(this.activeDickerson.fleet) && this.activeDickerson.fleet.isAlive())) {
            this.activeDickerson = null;
        }
        if (this.market.getFactionId().contentEquals("pirates") && this.activeDickerson == null && this.respawnTimer <= 0.0f) {
            int pts = 30 + this.battlesLost * 10 + Math.min(this.battlesLost, 9) * Math.min(this.battlesLost, 9) * 5;
            final FleetParams params = new FleetParams(null, this.market, this.market.getFactionId(), null, "patrolLarge", (float)pts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 1.0f, 1.0f, 1.0f, 5);
            CampaignFleetAPI fleet = UW_FleetFactory.enhancedCreateFleet(this.market.getFaction(), pts, new UW_FleetFactory.FleetFactoryDelegate(){

                @Override
                public CampaignFleetAPI createFleet() {
                    return FleetFactoryV2.createFleet((FleetParams)params);
                }
            });
            if (fleet == null) {
                return;
            }
            FleetMemberAPI oldFlagship = fleet.getFlagship();
            FleetMemberAPI shadowclaw = Global.getFactory().createFleetMember(FleetMemberType.SHIP, (String)DICKERSON_VARIANTS.pick());
            fleet.getFleetData().addFleetMember(shadowclaw);
            oldFlagship.setFlagship(false);
            oldFlagship.setCaptain(shadowclaw.getCaptain());
            fleet.getFleetData().setFlagship(shadowclaw);
            switch (this.battlesLost) {
                case 0: {
                    fleet.setName("Dickerson \u7684\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)0);
                    break;
                }
                case 1: {
                    fleet.setName("Dickerson \u7684\u7ffb\u65b0\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)1);
                    break;
                }
                case 2: {
                    fleet.setName("Dickerson \u7684\u5f3a\u5316\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)2);
                    break;
                }
                case 3: {
                    fleet.setName("Dickerson \u7684\u5927\u578b\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)3);
                    break;
                }
                case 4: {
                    fleet.setName("Dickerson \u7684\u6d77\u76d7\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)4);
                    break;
                }
                case 5: {
                    fleet.setName("Dickerson \u7684\u5927\u89c4\u6a21\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)5);
                    break;
                }
                case 6: {
                    fleet.setName("Dickerson \u7684\u4e0d\u673d\u519b\u56e2");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)6);
                    break;
                }
                case 7: {
                    fleet.setName("Dickerson \u7684\u795e\u5723\u65e0\u654c\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)7);
                    break;
                }
                case 8: {
                    fleet.setName("Dickerson \u7684\u6c38\u6052\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)8);
                    break;
                }
                default: {
                    fleet.setName("Dicker \u7684\u65e0\u9650\u8230\u961f");
                    fleet.getMemoryWithoutUpdate().set("$uwDickersonLevel", (Object)9);
                }
            }
            fleet.getMemoryWithoutUpdate().set("$uwIsDickerson", (Object)true);
            fleet.getMemoryWithoutUpdate().set("$stillAlive", (Object)true);
            fleet.setNoFactionInName(true);
            fleet.getMemoryWithoutUpdate().set("$fleetType", (Object)"uw_dickerson");
            fleet.getMemoryWithoutUpdate().set("$qualityFactor", (Object)Float.valueOf(1.0f));
            if (this.battlesLost > 0) {
                fleet.getMemoryWithoutUpdate().set("$sawPlayerTransponderOn", (Object)true);
                fleet.getMemoryWithoutUpdate().set("$missionImportant", (Object)true);
            }
            if (!this.dickersonHostile) {
                fleet.getMemoryWithoutUpdate().set("$cfai_makeNonHostile", (Object)true);
            }
            if (this.battlesLost <= 1) {
                fleet.getMemoryWithoutUpdate().set("$cfai_makeNonAggressive", (Object)true);
            }
            if (this.battlesLost > 2) {
                fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", (Object)true);
            }
            fleet.getMemoryWithoutUpdate().set("$cfai_noJump", (Object)true);
            fleet.getMemoryWithoutUpdate().set("$patrolAllowTOff", (Object)true);
            fleet.getMemoryWithoutUpdate().set("$isPatrol", (Object)true);
            fleet.getMemoryWithoutUpdate().set("$isPirate", (Object)true);
            fleet.getMemoryWithoutUpdate().set("$fidConifgGen", (Object)new DickersonInteractionConfigGen());
            Misc.makeLowRepImpact((CampaignFleetAPI)fleet, (String)"uw_dickerson");
            fleet.getCommander().setPostId(Ranks.POST_GANGSTER);
            fleet.getCommander().setRankId(Ranks.SPACE_CAPTAIN);
            fleet.getCommander().setPortraitSprite("graphics/uw/portraits/uw_dickerson_extended_family.png");
            if (this.battlesLost < 1) {
                fleet.getCommander().getName().setLast("Dickerson");
            } else {
                fleet.getCommander().getName().setLast("Dickerson " + Global.getSettings().getRoman(this.battlesLost + 1));
            }
            shadowclaw.setCaptain(fleet.getCommander());
            fleet.getFleetData().sort();
            SectorEntityToken entity = this.market.getPrimaryEntity();
            entity.getContainingLocation().addEntity((SectorEntityToken)fleet);
            fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
            fleet.updateCounts();
            fleet.forceSync();
            DickersonFleetData data = new DickersonFleetData(fleet);
            data.startingFleetPoints = fleet.getFleetPoints();
            data.sourceMarket = this.market;
            data.source = this.market.getPrimaryEntity();
            this.activeDickerson = data;
            UW_DickersonAssignmentAI ai = new UW_DickersonAssignmentAI(fleet, data);
            fleet.addScript((EveryFrameScript)ai);
        }
    }

    public boolean isDone() {
        return false;
    }

    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        super.reportBattleOccurred(primaryWinner, battle);
        if (this.activeDickerson == null) {
            return;
        }
        if (!battle.isPlayerInvolved() || !battle.isInvolved(this.activeDickerson.fleet) || battle.onPlayerSide(this.activeDickerson.fleet)) {
            return;
        }
        if (!this.dickersonHostile) {
            this.activeDickerson.fleet.getMemoryWithoutUpdate().unset("$cfai_makeNonHostile");
            this.dickersonHostile = true;
        }
        if (this.activeDickerson.fleet.getFlagship() != null && this.activeDickerson.fleet.getFlagship().getCaptain() == this.activeDickerson.dickerson) {
            return;
        }
        ++this.battlesLost;
        Global.getSector().getPersistentData().put("uw_dickerson_level", this.battlesLost);
        this.activeDickerson.fleet.getMemoryWithoutUpdate().set("$stillAlive", (Object)false);
        this.respawnTimer = 20.0f;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        super.reportFleetDespawned(fleet, reason, param);
        if (this.activeDickerson == null) {
            return;
        }
        if (this.activeDickerson.fleet == fleet) {
            this.activeDickerson = null;
            this.respawnTimer += 20.0f;
        }
    }

    public boolean runWhilePaused() {
        return false;
    }

    static {
        DICKERSON_VARIANTS.add((Object)"uw_shadowclaw_pro", 10.0f);
        DICKERSON_VARIANTS.add((Object)"uw_shadowclaw_ber", 7.5f);
        DICKERSON_VARIANTS.add((Object)"uw_shadowclaw_sni", 5.0f);
    }

    public static class DickersonInteractionConfigGen
    implements FleetInteractionDialogPluginImpl.FIDConfigGen {
        public FleetInteractionDialogPluginImpl.FIDConfig createConfig() {
            FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
            config.impactsEnemyReputation = false;
            config.delegate = new FleetInteractionDialogPluginImpl.FIDDelegate(){

                public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                    bcc.enemyDeployAll = true;
                }

                public void notifyLeave(InteractionDialogAPI dialog) {
                }

                public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                }
            };
            return config;
        }
    }

    public static class DickersonFleetData {
        public PersonAPI dickerson;
        public CampaignFleetAPI fleet;
        public SectorEntityToken source;
        public MarketAPI sourceMarket;
        public float startingFleetPoints = 0.0f;

        public DickersonFleetData(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }
    }
}

