/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.underworld;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import data.scripts.world.underworld.UW_DickersonFleetManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class UW_Styx {
    private static final Random random = new Random();

    public static MarketAPI addMarketplace(String factionID, SectorEntityToken primaryEntity, ArrayList<SectorEntityToken> connectedEntities, String name, int size, ArrayList<String> marketConditions, ArrayList<String> submarkets, float tarrif) {
        String planetID;
        EconomyAPI globalEconomy = Global.getSector().getEconomy();
        String marketID = planetID = primaryEntity.getId();
        MarketAPI newMarket = Global.getFactory().createMarket(marketID, name, size);
        newMarket.setFactionId(factionID);
        newMarket.setPrimaryEntity(primaryEntity);
        newMarket.setBaseSmugglingStabilityValue(0);
        newMarket.getTariff().modifyFlat("generator", tarrif);
        newMarket.getLocationInHyperspace().set((ReadableVector2f)primaryEntity.getLocationInHyperspace());
        if (null != submarkets) {
            for (String market : submarkets) {
                newMarket.addSubmarket(market);
            }
        }
        for (String condition : marketConditions) {
            newMarket.addCondition(condition);
        }
        if (null != connectedEntities) {
            for (SectorEntityToken entity : connectedEntities) {
                newMarket.getConnectedEntities().add(entity);
            }
        }
        globalEconomy.addMarket(newMarket);
        primaryEntity.setMarket(newMarket);
        primaryEntity.setFaction(factionID);
        if (null != connectedEntities) {
            for (SectorEntityToken entity : connectedEntities) {
                entity.setMarket(newMarket);
                entity.setFaction(factionID);
            }
        }
        return newMarket;
    }

    public static void dickersonifyBaseStaff() {
        SectorEntityToken arigato = UW_Styx.getArigato();
        if (arigato == null) {
            return;
        }
        for (PersonAPI person : arigato.getMarket().getPeopleCopy()) {
            if (!person.getFaction().getId().equals("pirates") || person.getPost().equals(Ranks.POST_MERCENARY)) continue;
            person.setPortraitSprite("graphics/uw/portraits/uw_dickerson_extended_family.png");
            person.getName().setLast("Dickerson");
        }
    }

    public static void generatePt2(SectorAPI sector) {
        StarSystemAPI system = sector.getStarSystem("Styx");
        MarketAPI scrapyardMarket = sector.getEconomy().getMarket("uw_arigato");
        UW_Styx.pickLocation(sector, system);
        scrapyardMarket.getLocationInHyperspace().set((ReadableVector2f)system.getLocation());
        system.autogenerateHyperspaceJumpPoints(true, true);
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor((BaseTiledTerrain)plugin);
        float minRadius = plugin.getTileSize() * 2.0f;
        float radius = system.getMaxRadiusInHyperspace();
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius * 0.5f, 0.0f, 360.0f);
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius, 0.0f, 360.0f, 0.25f);
    }

    public static SectorEntityToken getArigato() {
        if (Global.getSector().getStarSystem("Styx") == null) {
            return null;
        }
        return Global.getSector().getStarSystem("Styx").getEntityById("uw_arigato");
    }

    public static SectorEntityToken getRoboto() {
        if (Global.getSector().getStarSystem("Styx") == null) {
            return null;
        }
        return Global.getSector().getStarSystem("Styx").getEntityById("uw_roboto");
    }

    public static SectorEntityToken getStyx() {
        if (Global.getSector().getStarSystem("Styx") == null) {
            return null;
        }
        return Global.getSector().getStarSystem("Styx").getEntityById("uw_styx");
    }

    private static float getRandom(float min, float max) {
        float radius = min + (max - min) * random.nextFloat();
        return radius;
    }

    private static void pickLocation(SectorAPI sector, StarSystemAPI system) {
        float radius = system.getMaxRadiusInHyperspace() + 200.0f;
        block0: for (int i = 0; i < 100; ++i) {
            Vector2f loc = new Vector2f(UW_Styx.getRandom(20000.0f, 30000.0f), 0.0f);
            VectorUtils.rotate((Vector2f)loc, (float)UW_Styx.getRandom(0.0f, 360.0f), (Vector2f)loc);
            for (LocationAPI location : sector.getAllLocations()) {
                if (!(location instanceof StarSystemAPI)) continue;
                float otherRadius = ((StarSystemAPI)location).getMaxRadiusInHyperspace();
                if (!(MathUtils.getDistance((Vector2f)location.getLocation(), (Vector2f)loc) < radius + otherRadius)) continue;
                continue block0;
            }
            system.getLocation().set(loc.x, loc.y);
            break;
        }
    }

    public void generate(SectorAPI sector) {
        random.setSeed(sector.getSeedString().hashCode());
        ProcgenUsedNames.notifyUsed((String)"Styx");
        ProcgenUsedNames.notifyUsed((String)"Arigato");
        ProcgenUsedNames.notifyUsed((String)"Roboto");
        StarSystemAPI system = sector.createStarSystem("Styx");
        system.setBackgroundTextureFilename("graphics/uw/backgrounds/uw_styx.png");
        PlanetAPI star = system.initStar("uw_styx", "star_red_dwarf", 500.0f, 300.0f);
        star.setCustomDescriptionId("uw_star_styx");
        PlanetAPI roboto = system.addPlanet("uw_roboto", (SectorEntityToken)star, "Roboto", "toxic_cold", 120.0f, 120.0f, 5500.0f, 770.0f);
        roboto.getSpec().setTilt(10.0f);
        roboto.getSpec().setCloudColor(new Color(230, 210, 200, 170));
        roboto.applySpecChanges();
        roboto.setCustomDescriptionId("uw_planet_roboto");
        MarketAPI robotoMarket = Global.getFactory().createMarket("uw_roboto_conditions", roboto.getName(), 0);
        robotoMarket.setPrimaryEntity((SectorEntityToken)roboto);
        robotoMarket.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        robotoMarket.setFactionId("neutral");
        robotoMarket.addCondition("ruins_vast");
        robotoMarket.addCondition("toxic_atmosphere");
        robotoMarket.addCondition("pollution");
        robotoMarket.addCondition("ore_abundant");
        robotoMarket.addCondition("rare_ore_sparse");
        robotoMarket.addCondition("organics_trace");
        robotoMarket.setPlanetConditionMarketOnly(true);
        for (MarketConditionAPI cond : robotoMarket.getConditions()) {
            cond.setSurveyed(true);
        }
        roboto.setMarket(robotoMarket);
        CustomCampaignEntityAPI arigato = system.addCustomEntity("uw_arigato", "Arigato", "station_sporeship_derelict", "pirates");
        arigato.setCircularOrbitPointingDown((SectorEntityToken)roboto, 90.0f, 300.0f, 13.0f);
        arigato.setInteractionImage("illustrations", "orbital_construction");
        arigato.setCustomDescriptionId("uw_station_arigato");
        system.addAsteroidBelt((SectorEntityToken)star, 150, 4000.0f, 350.0f, 450.0f, 500.0f, "asteroid_belt", "Modron Belt");
        system.addAsteroidBelt((SectorEntityToken)star, 200, 13000.0f, 2500.0f, 2650.0f, 2950.0f, "asteroid_belt", "Domo Belt");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("uw_styxgate", "Styx \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)star, 35.0f, 4000.0f, 475.0f);
        jumpPoint.setRelatedPlanet((SectorEntityToken)roboto);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI relay = system.addCustomEntity("uw_styx_relay", "Radio Styx", "comm_relay", "pirates");
        relay.setCircularOrbit((SectorEntityToken)star, 0.0f, 5500.0f, 770.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)star, (StarAge)StarAge.OLD, (int)5, (int)10, (float)6500.0f, (int)1, (boolean)false);
        MarketAPI scrapyardMarket = UW_Styx.addMarketplace("pirates", (SectorEntityToken)arigato, null, "Arigato", 4, new ArrayList<String>(Arrays.asList("orbital_station", "population_4", "uw_scrapyard_condition", "military_base", "free_market", "frontier", "organized_crime")), new ArrayList<String>(Arrays.asList("open_market", "uw_scrapyard_submarket", "storage")), 0.3f);
        scrapyardMarket.getMemoryWithoutUpdate().set("$nex_uninvadable", (Object)true);
        system.addScript((EveryFrameScript)new UW_DickersonFleetManager(scrapyardMarket));
        system.addScript((EveryFrameScript)new Demilitarize(scrapyardMarket));
        arigato.addScript((EveryFrameScript)new PatrolFleetManager(scrapyardMarket));
        if (system.hasTag("theme_core_unpopulated")) {
            system.removeTag("theme_core_unpopulated");
            system.addTag("theme_core_populated");
        }
    }

    public static class Demilitarize
    implements EveryFrameScript {
        private final MarketAPI market;

        Demilitarize(MarketAPI market) {
            this.market = market;
        }

        public void advance(float amount) {
            if (this.market.hasSubmarket("generic_military")) {
                this.market.removeSubmarket("generic_military");
            }
        }

        public boolean isDone() {
            return false;
        }

        public boolean runWhilePaused() {
            return false;
        }
    }
}

