package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemKeys;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Misc.Token;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.util.UW_Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

import static com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod.extortionAmount;

/**
 * CabalPickContributionMethod
 */
public class CabalPickContributionMethod extends BaseCommandPlugin {

    public static Logger log = Global.getLogger(CabalPickContributionMethod.class);

    public static boolean playerHasAbilityToPayContribution(CampaignFleetAPI fleet) {
        List<String> extortionMethods = new ArrayList<>(2);

        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        float lowerThreshold = Math.min(100000f, fleet.getFleetPoints() * 1000f);
        if (credits > lowerThreshold) {
            extortionMethods.add("tithe");
        }

        lowerThreshold = Math.min(12500f, fleet.getFleetPoints() * 1000f);
        float cargoValue = CabalCargoCalc.valueOfBiggestCommodityStack(Global.getSector().getPlayerFleet().getCargo());
        if (cargoValue > lowerThreshold) {
            extortionMethods.add("cargo");
        }

        return !extortionMethods.isEmpty();
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Token> params,
                           Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }

        CampaignFleetAPI fleet;
        if (dialog.getInteractionTarget() instanceof CampaignFleetAPI) {
            fleet = (CampaignFleetAPI) dialog.getInteractionTarget();
        } else {
            return false;
        }

        WeightedRandomPicker<String> extortionMethods = new WeightedRandomPicker<>();
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        float totalCargoValue = CabalCargoCalc.totalCargoValue(Global.getSector().getPlayerFleet().getCargo());
        float totalWeaponsValue = CabalWeaponCalc.totalWeaponsValue(Global.getSector().getPlayerFleet());
        float totalFightersValue = CabalFighterCalc.totalFightersValue(Global.getSector().getPlayerFleet());
        float totalShipsValue = CabalShipCalc.totalShipsValue(Global.getSector().getPlayerFleet());
        float netWorth = credits + totalCargoValue + totalWeaponsValue + totalFightersValue + totalShipsValue;
        float targetExtortion = (float) extortionAmount(netWorth);
        log.info("Seen credit value of " + credits);
        log.info("Calculated cargo value of " + totalCargoValue);
        log.info("Calculated weapons value of " + totalWeaponsValue);
        log.info("Calculated fighters value of " + totalFightersValue);
        log.info("Calculated ships value of " + totalShipsValue);
        log.info("Evaluated net worth at " + netWorth);
        log.info("Targeting extortion value at " + targetExtortion);

        float lowerThreshold = Math.min(100000f, fleet.getFleetPoints() * 1000f);
        float upperThreshold = fleet.getFleetPoints() * 5000f;
        if (credits > lowerThreshold) {
            float weight = (float) Math.sqrt(Math.min(credits, upperThreshold) / targetExtortion) * 1.5f;
            extortionMethods.add("tithe", weight);
            log.info("Tithe extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(12500f, fleet.getFleetPoints() * 1000f);
        upperThreshold = fleet.getFleetPoints() * 5000f;
        float cargoValue = CabalCargoCalc.valueOfBiggestCommodityStack(Global.getSector().getPlayerFleet().getCargo());
        if (cargoValue > lowerThreshold) {
            float weight = (float) Math.sqrt(Math.min(cargoValue, upperThreshold) / targetExtortion);
            extortionMethods.add("cargo", weight);
            log.info("Cargo extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(25f, fleet.getFleetPoints() * 2.5f);
        float weaponFanciness = CabalWeaponCalc.bestWeaponFanciness(Global.getSector().getPlayerFleet());
        if (weaponFanciness > lowerThreshold) {
            float weight = (float) Math.sqrt(weaponFanciness / (targetExtortion / 500f));
            extortionMethods.add("weapon", weight);
            log.info("Weapon extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(20f, fleet.getFleetPoints() * 2f);
        float fighterFanciness = CabalFighterCalc.bestFighterFanciness(Global.getSector().getPlayerFleet());
        if (fighterFanciness > lowerThreshold) {
            float weight = (float) Math.sqrt(fighterFanciness / (targetExtortion / 500f));
            extortionMethods.add("fighter", weight);
            log.info("Fighter extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(12500f, fleet.getFleetPoints() * 1000f);
        upperThreshold = fleet.getFleetPoints() * 5000f;
        float shipValue = CabalShipCalc.bestShipValue(Global.getSector().getPlayerFleet(), upperThreshold);
        if (shipValue > lowerThreshold && CabalShipCalc.usableShips(Global.getSector().getPlayerFleet()) > 1) {
            float weight = (float) Math.sqrt(Math.min(shipValue, upperThreshold) / targetExtortion) * 0.25f;
            extortionMethods.add("ship", weight);
            log.info("Ship extortion method at weight " + weight);
        }

        if (extortionMethods.isEmpty()) {
            memoryMap.get(MemKeys.LOCAL).set("$Cabal_extortionMethod", "none", 0);
            return false;
        }

        memoryMap.get(MemKeys.LOCAL).set("$Cabal_extortionMethod", extortionMethods.pick(), 7);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_netWorthString", Misc.getDGSCredits(
                                         UW_Util.roundToSignificantFiguresLong(netWorth, 4)), 0);
        return true;
    }
}
