package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemKeys;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Misc.Token;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.util.UW_Util;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/**
 * CabalPickExtortionMethod
 */
public class CabalPickExtortionMethod extends BaseCommandPlugin {

    public static Logger log = Global.getLogger(CabalPickExtortionMethod.class);

    public static double extortionAmount(float credits) {
        double tithe;
        if (credits < 200000f) {
            tithe = credits / 2.0;
        } else if (credits < 500000.0) {
            tithe = 100000.0 + (credits - 200000.0) / 3.0;
        } else if (credits < 900000.0) {
            tithe = 200000.0 + (credits - 500000.0) / 4.0;
        } else if (credits < 1400000.0) {
            tithe = 300000.0 + (credits - 900000.0) / 5.0;
        } else if (credits < 2000000.0) {
            tithe = 400000.0 + (credits - 1400000.0) / 6.0;
        } else if (credits < 2700000.0) {
            tithe = 500000.0 + (credits - 2000000.0) / 7.0;
        } else if (credits < 3500000.0) {
            tithe = 600000.0 + (credits - 2700000.0) / 8.0;
        } else if (credits < 4400000.0) {
            tithe = 700000.0 + (credits - 3500000.0) / 9.0;
        } else if (credits < 5400000.0) {
            tithe = 800000.0 + (credits - 4400000.0) / 10.0;
        } else if (credits < 6500000.0) {
            tithe = 900000.0 + (credits - 5400000.0) / 11.0;
        } else if (credits < 7700000.0) {
            tithe = 1000000.0 + (credits - 6500000.0) / 12.0;
        } else if (credits < 9000000.0) {
            tithe = 1100000.0 + (credits - 7700000.0) / 13.0;
        } else if (credits < 10400000.0) {
            tithe = 1200000.0 + (credits - 9000000.0) / 14.0;
        } else {
            tithe = 1300000.0 + (credits - 10400000.0) / 15.0;
        }
        return tithe;
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Token> params,
                           Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }

        CampaignFleetAPI fleet;
        if (dialog.getInteractionTarget() instanceof CampaignFleetAPI) {
            fleet = (CampaignFleetAPI) dialog.getInteractionTarget();
        } else {
            return false;
        }

        WeightedRandomPicker<String> extortionMethods = new WeightedRandomPicker<>();
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        float totalCargoValue = CabalCargoCalc.totalCargoValue(Global.getSector().getPlayerFleet().getCargo());
        float totalWeaponsValue = CabalWeaponCalc.totalWeaponsValue(Global.getSector().getPlayerFleet());
        float totalFightersValue = CabalFighterCalc.totalFightersValue(Global.getSector().getPlayerFleet());
        float totalShipsValue = CabalShipCalc.totalShipsValue(Global.getSector().getPlayerFleet());
        float netWorth = credits + totalCargoValue + totalWeaponsValue + totalFightersValue + totalShipsValue;
        float targetExtortion = (float) extortionAmount(netWorth);
        log.info("Seen credit value of " + credits);
        log.info("Calculated cargo value of " + totalCargoValue);
        log.info("Calculated weapons value of " + totalWeaponsValue);
        log.info("Calculated fighters value of " + totalFightersValue);
        log.info("Calculated ships value of " + totalShipsValue);
        log.info("Evaluated net worth at " + netWorth);
        log.info("Targeting extortion value at " + targetExtortion);

        float lowerThreshold = Math.min(200000f, fleet.getFleetPoints() * 2500f);
        float upperThreshold = fleet.getFleetPoints() * 5000f;
        if (credits > lowerThreshold) {
            float weight = (float) Math.sqrt(Math.min(credits, upperThreshold) / targetExtortion);
            extortionMethods.add("tithe", weight);
            log.info("Tithe extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(25000f, fleet.getFleetPoints() * 2500f);
        upperThreshold = fleet.getFleetPoints() * 5000f;
        float cargoValue = CabalCargoCalc.valueOfBiggestCommodityStack(Global.getSector().getPlayerFleet().getCargo());
        if (cargoValue > lowerThreshold) {
            float weight = (float) Math.sqrt(Math.min(cargoValue, upperThreshold) / targetExtortion);
            extortionMethods.add("cargo", weight);
            log.info("Cargo extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(50f, fleet.getFleetPoints() * 5f);
        float weaponFanciness = CabalWeaponCalc.bestWeaponFanciness(Global.getSector().getPlayerFleet());
        if (weaponFanciness > lowerThreshold) {
            float weight = (float) Math.sqrt(weaponFanciness / (targetExtortion / 500f)) * 1.5f;
            extortionMethods.add("weapon", weight);
            log.info("Weapon extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(40f, fleet.getFleetPoints() * 4f);
        float fighterFanciness = CabalFighterCalc.bestFighterFanciness(Global.getSector().getPlayerFleet());
        if (fighterFanciness > lowerThreshold) {
            float weight = (float) Math.sqrt(fighterFanciness / (targetExtortion / 500f)) * 1.5f;
            extortionMethods.add("fighter", weight);
            log.info("Fighter extortion method at weight " + weight);
        }

        lowerThreshold = Math.min(25000f, fleet.getFleetPoints() * 2500f);
        upperThreshold = fleet.getFleetPoints() * 5000f;
        float shipValue = CabalShipCalc.bestShipValue(Global.getSector().getPlayerFleet(), upperThreshold);
        if (shipValue > lowerThreshold && CabalShipCalc.usableShips(Global.getSector().getPlayerFleet()) > 1) {
            float weight = (float) Math.sqrt(Math.min(shipValue, upperThreshold) / targetExtortion) * 0.5f;
            extortionMethods.add("ship", weight);
            log.info("Ship extortion method at weight " + weight);
        }

        if (extortionMethods.isEmpty()) {
            memoryMap.get(MemKeys.LOCAL).set("$Cabal_extortionMethod", "none", 0);
            return false;
        }

        memoryMap.get(MemKeys.LOCAL).set("$Cabal_extortionMethod", extortionMethods.pick(), 7);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_netWorthString", Misc.getDGSCredits(
                                         UW_Util.roundToSignificantFiguresLong(netWorth, 4)), 0);
        return true;
    }
}
