package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemKeys;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;

import static com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod.extortionAmount;

/**
 * CabalShipCalc
 */
public class CabalShipCalc extends BaseCommandPlugin {

    public static float bestShipValue(CampaignFleetAPI fleet, float maxValue) {
        float bestShipValue = 0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float value = member.getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");

            if (value > bestShipValue && value <= maxValue) {
                bestShipValue = value;
            }
        }
        return bestShipValue;
    }

    public static float totalShipsValue(CampaignFleetAPI fleet) {
        float totalShipValue = 0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float value = member.getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            totalShipValue += value;
        }
        return totalShipValue;
    }

    public static int usableShips(CampaignFleetAPI fleet) {
        int usableShips = 0;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isFighterWing()) {
                continue;
            }
            usableShips++;
        }
        return usableShips;
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }

        CampaignFleetAPI fleet;
        if (dialog.getInteractionTarget() instanceof CampaignFleetAPI) {
            fleet = (CampaignFleetAPI) dialog.getInteractionTarget();
        } else {
            return false;
        }

        float totalCreditsValue = totalShipsValue(Global.getSector().getPlayerFleet());
        double valueToTake = extortionAmount(totalCreditsValue);
        valueToTake = Math.min(valueToTake, fleet.getFleetPoints() * 5000.0);
        double minimumToTake = Math.min(valueToTake, fleet.getFleetPoints() * 1000.0);

        float thresholdForMultipleChoice = Math.max((float) minimumToTake, totalCreditsValue / 2f);
        FleetMemberAPI bestShip = null;
        float bestShipValue = 0f;
        List<FleetMemberAPI> multipleChoice = new ArrayList<>(Global.getSector().getPlayerFleet().getFleetData().getNumMembers());
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            float value = member.getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            if (value > valueToTake) {
                continue;
            }

            if (value > bestShipValue) {
                bestShip = member;
                bestShipValue = value;
            }
            if (value > thresholdForMultipleChoice) {
                multipleChoice.add(member);
            }
        }

        if (!multipleChoice.isEmpty()) {
            int index = MathUtils.getRandomNumberInRange(0, multipleChoice.size() - 1);

            bestShipValue = multipleChoice.get(index).getBaseSellValue() / Global.getSettings().getFloat("shipSellPriceMult");
            bestShip = multipleChoice.get(index);
        }
        if (bestShip == null) {
            return false;
        }

        for (String slot : bestShip.getVariant().getFittedWeaponSlots()) {
            WeaponSpecAPI weapon = bestShip.getVariant().getWeaponSpec(slot);
            bestShipValue += weapon.getBaseValue() * Global.getSettings().getFloat("nonEconItemSellPriceMult");
        }

        float repImpact;
        if (bestShipValue <= 25000f) {
            repImpact = 0.01f;
        } else if (bestShipValue <= 50000f) {
            repImpact = 0.02f;
        } else if (bestShipValue <= 100000f) {
            repImpact = 0.03f;
        } else if (bestShipValue <= 200000f) {
            repImpact = 0.04f;
        } else if (bestShipValue <= 400000f) {
            repImpact = 0.05f;
        } else if (bestShipValue <= 800000f) {
            repImpact = 0.06f;
        } else if (bestShipValue <= 1600000f) {
            repImpact = 0.07f;
        } else if (bestShipValue <= 3200000f) {
            repImpact = 0.08f;
        } else if (bestShipValue <= 6400000f) {
            repImpact = 0.09f;
        } else {
            repImpact = 0.10f;
        }

        memoryMap.get(MemKeys.LOCAL).set("$Cabal_ship_name", bestShip.getShipName(), 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_ship_hull", bestShip.getHullSpec().getHullName(), 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_ship_hull_full", bestShip.getVariant().getFullDesignationWithHullName(), 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_ship_uuid", bestShip.getId(), 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_ship_is_fighter", bestShip.isFighterWing(), 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_repImpact", repImpact, 0);
        return true;
    }
}
