package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemKeys;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Misc.Token;
import data.scripts.util.UW_Util;
import java.util.List;
import java.util.Map;

import static com.fs.starfarer.api.impl.campaign.rulecmd.CabalPickExtortionMethod.extortionAmount;

/**
 * CabalTitheCalc
 */
public class CabalTitheCalc extends BaseCommandPlugin {

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }

        CampaignFleetAPI fleet;
        if (dialog.getInteractionTarget() instanceof CampaignFleetAPI) {
            fleet = (CampaignFleetAPI) dialog.getInteractionTarget();
        } else {
            return false;
        }

        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();

        double tithe = extortionAmount(credits);

        tithe = Math.min(tithe, fleet.getFleetPoints() * 5000.0);
        long realTithe = UW_Util.roundToSignificantFiguresLong(tithe, 3);

        float repImpact;
        if (realTithe <= 12500f) {
            repImpact = 0.01f;
        } else if (realTithe <= 25000f) {
            repImpact = 0.02f;
        } else if (realTithe <= 50000f) {
            repImpact = 0.03f;
        } else if (realTithe <= 100000f) {
            repImpact = 0.04f;
        } else {
            repImpact = 0.05f;
        }

        memoryMap.get(MemKeys.LOCAL).set("$Cabal_tithe_string", Misc.getWithDGS(realTithe), 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_tithe", realTithe, 0);
        memoryMap.get(MemKeys.LOCAL).set("$Cabal_repImpact", repImpact, 0);
        return true;
    }
}
