package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoAPI.CargoItemType;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.Misc.Token;
import java.util.List;
import java.util.Map;

/**
 * CabalTransferCargo
 */
public class CabalTransferCargo extends BaseCommandPlugin {

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Token> params,
                           Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }

        CampaignFleetAPI fleet;
        if (dialog.getInteractionTarget() instanceof CampaignFleetAPI) {
            fleet = (CampaignFleetAPI) dialog.getInteractionTarget();
        } else {
            return false;
        }

        String id = params.get(0).getString(memoryMap);
        float qty = params.get(1).getFloat(memoryMap);

        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        boolean modSpec = false;
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            if (stack.getHullModSpecIfHullMod() != null && stack.getHullModSpecIfHullMod().getId().contentEquals(id)) {
                modSpec = true;
                break;
            }
        }
        if (modSpec) {
            cargo.removeItems(CargoItemType.MOD_SPEC, id, qty);
        } else {
            cargo.removeItems(CargoItemType.RESOURCES, id, qty);
        }
        cargo.removeEmptyStacks();
        fleet.getCargo().addCommodity(id, qty);
        return true;
    }
}
