package data.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import data.scripts.UnderworldModPlugin;
import data.scripts.campaign.events.UW_EventManager;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommonStrings;
import org.lazywizard.console.Console;

public class UW_TriggerPillage implements BaseCommand {

    @Override
    public CommandResult runCommand(String args, CommandContext context) {
        if (context != CommandContext.CAMPAIGN_MAP) {
            Console.showMessage(CommonStrings.ERROR_CAMPAIGN_ONLY);
            return CommandResult.WRONG_CONTEXT;
        }

        if (!args.isEmpty()) {
            return CommandResult.BAD_SYNTAX;
        }

        if (!UnderworldModPlugin.Module_PillageFleets) {
            Console.showMessage("Error: Pillage event is disabled!");
            return CommandResult.ERROR;
        }

        if (Global.getSector().getEventManager().getNumOngoing("uw_pillage") > 0) {
            Console.showMessage("Error: Pillage event is already ongoing!");
            return CommandResult.ERROR;
        }

        for (CampaignEventListener listener : Global.getSector().getAllListeners()) {
            if (listener instanceof UW_EventManager) {
                ((UW_EventManager) listener).timeToPillageEvent = 0.1f;
            }
        }

        return CommandResult.SUCCESS;
    }
}
