package data.missions.blunder;

import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.UnderworldModPlugin;

public class MissionDefinition implements MissionDefinitionPlugin {

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "ISS", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "CGR", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "The Infernal Machine Horde");
        api.setFleetTagline(FleetSide.ENEMY, "Church of Galactic Redemption Purification Fleet");

        if (!UnderworldModPlugin.hasSWP) {
            api.addBriefingItem("SHIP/WEAPON PACK REQUIRED");
            api.addBriefingItem("Download Ship/Weapon Pack to play this mission!");
        }

        if (!UnderworldModPlugin.hasSWP) {
            return;
        }

        api.addBriefingItem("Defeat all enemy forces");
        api.addBriefingItem("The Infernal Machine must survive");

        api.addToFleet(FleetSide.PLAYER, "ssp_infernalmachine_sta", FleetMemberType.SHIP, "The Infernal Machine", true);
        api.addToFleet(FleetSide.PLAYER, "ssp_barbarian_sta", FleetMemberType.SHIP, "ISS Forge", false);
        api.addToFleet(FleetSide.PLAYER, "ssp_stalker_sta", FleetMemberType.SHIP, "ISS Insurgent", false);
        api.addToFleet(FleetSide.PLAYER, "ssp_boar_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_shark_rai", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "buffalo2_FS", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "condor_Strike", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "condor_Strike", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_tiger_rai", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_tiger_rai", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_torch_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_torch_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_venom_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_venom_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "ssp_sidecar_ass", FleetMemberType.SHIP, false);

        api.defeatOnShipLoss("The Infernal Machine");

        api.addToFleet(FleetSide.ENEMY, "ssp_cathedral_gra", FleetMemberType.SHIP, "CGR Inquisition", true);
        api.addToFleet(FleetSide.ENEMY, "dominator_d_Assault", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "dominator_d_Assault", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "eagle_d_Assault", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "falcon_d_CS", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "enforcer_d_Strike", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "enforcer_d_Strike", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "ssp_vanguard_sta", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "ssp_archer_stai", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "sunder_d_Assault", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "lasher_d_CS", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "lasher_d_CS", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "brawler_Assault", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "brawler_Assault", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "aggressive");
        api.addToFleet(FleetSide.ENEMY, "vigilance_Strike", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.ENEMY, "vigilance_FS", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.ENEMY, "hound_luddic_church_Standard", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.ENEMY, "hound_luddic_church_Standard", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.ENEMY, "hound_luddic_church_Standard", FleetMemberType.SHIP, false).getCaptain().setPersonality(
                "cautious");

        float width = 14000f;
        float height = 18000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        float minX = -width / 2;
        float minY = -height / 2;

        for (int i = 0; i < 5; i++) {
            float x = (float) Math.random() * width - width / 2;
            float y = (float) Math.random() * height - height / 2;
            float radius = 100f + (float) Math.random() * 400f;
            api.addNebula(x, y, radius);
        }

        api.addObjective(minX + width * 0.50f, minY + height * 0.50f, "nav_buoy");
    }
}
