package data.missions.surveyor;

import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.UnderworldModPlugin;

public class MissionDefinition implements MissionDefinitionPlugin {

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "TTS", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "ISS", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "Tri-Tachyon Survey Fleet");
        api.setFleetTagline(FleetSide.ENEMY, "Pirate ambush");

        if (!UnderworldModPlugin.hasSWP) {
            api.addBriefingItem("SHIP/WEAPON PACK REQUIRED");
            api.addBriefingItem("Download Ship/Weapon Pack to play this mission!");
        }

        if (!UnderworldModPlugin.hasSWP) {
            return;
        }

        api.addBriefingItem("Destroy The Infernal Machine if possible");
        api.addBriefingItem("The TTS Parse must survive");

        api.addToFleet(FleetSide.PLAYER, "swp_chronos_sta", FleetMemberType.SHIP, "TTS Parse", true);
        api.addToFleet(FleetSide.PLAYER, "ssp_beholder_sta", FleetMemberType.SHIP, "TTS Vanguard", false);
        api.addToFleet(FleetSide.PLAYER, "ssp_hecate_sta", FleetMemberType.SHIP, "TTS Strafe", false);
        api.addToFleet(FleetSide.PLAYER, "ssp_hecate_sta", FleetMemberType.SHIP, "TTS Striker", false);

        api.defeatOnShipLoss("TTS Parse");

        api.addToFleet(FleetSide.ENEMY, "ssp_infernalmachine_sta", FleetMemberType.SHIP, "The Infernal Machine", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_barbarian_sta", FleetMemberType.SHIP, "ISS Hammer", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_barbarian_sta", FleetMemberType.SHIP, "ISS Anvil", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_stalker_sta", FleetMemberType.SHIP, "ISS Reaper", false);
        api.addToFleet(FleetSide.ENEMY, "condor_Attack", FleetMemberType.SHIP, "ISS Haven", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_boar_sta", FleetMemberType.SHIP, "ISS Blast", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_boar_sta", FleetMemberType.SHIP, "ISS Boots", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_scythe_sta", FleetMemberType.SHIP, "ISS Deep", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_scythe_sta", FleetMemberType.SHIP, "ISS Thought", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_venom_sta", FleetMemberType.SHIP, "ISS Viking", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_venom_sta", FleetMemberType.SHIP, "ISS Marauder", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_sidecar_sta", FleetMemberType.SHIP, "ISS Vega", false);
        api.addToFleet(FleetSide.ENEMY, "ssp_sidecar_sta", FleetMemberType.SHIP, "ISS Megaton", false);

        float width = 14000f;
        float height = 14000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        for (int i = 0; i < 5; i++) {
            float x = (float) Math.random() * width - width / 2;
            float y = (float) Math.random() * height - height / 2;
            float radius = 100f + (float) Math.random() * 400f;
            api.addNebula(x, y, radius);
        }

        api.addAsteroidField(0f, 0f, (float) Math.random() * 360f, width, 20f, 70f, 250);
    }
}
