package data.missions.uw_purplehaze;

import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.UnderworldModPlugin;

public class MissionDefinition implements MissionDefinitionPlugin {

    private static boolean swp = false;

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "STAR", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "HSS", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "Starlight Cabal raiders");
        api.setFleetTagline(FleetSide.ENEMY, "Hegemony task force");

        api.addBriefingItem("Defeat all enemy forces");
        api.addBriefingItem("The STAR Corset must survive");
        api.addBriefingItem("NOTE: Different enemy ships available with Ship/Weapon Pack (click mission to toggle)");

        if (UnderworldModPlugin.hasSWP) {
            swp = !swp;
        }

        api.addToFleet(FleetSide.PLAYER, "aurora_cabal_cus", FleetMemberType.SHIP, "STAR Corset", true);
        api.addToFleet(FleetSide.PLAYER, "harbinger_cabal_cus", FleetMemberType.SHIP, "STAR Leggings", false);
        api.addToFleet(FleetSide.PLAYER, "medusa_cabal_cus", FleetMemberType.SHIP, "STAR Chemise", false);
        api.addToFleet(FleetSide.PLAYER, "afflictor_cabal_cus", FleetMemberType.SHIP, "STAR Chopine", false);
        api.addToFleet(FleetSide.PLAYER, "scarab_cabal_cus", FleetMemberType.SHIP, "STAR Nightgown", false);
        api.addToFleet(FleetSide.PLAYER, "tempest_cabal_cus", FleetMemberType.SHIP, "STAR Thigh Highs", false);
        api.addToFleet(FleetSide.PLAYER, "wolf_cabal_cus", FleetMemberType.SHIP, "STAR Heels", false);

        api.defeatOnShipLoss("STAR Corset");

        api.addToFleet(FleetSide.ENEMY, swp ? "ssp_vindicator_o_sta" : "dominator_Assault", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, swp ? "ssp_punisher_ass" : "falcon_CS", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, swp ? "gryphon_xiv_eli" : "gryphon_FS", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, swp ? "ssp_vanguard_sta" : "enforcer_Balanced", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, swp ? "ssp_albatross_sta" : "mule_Standard", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, swp ? "hammerhead_xiv_eli" : "hammerhead_Elite", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "condor_Support", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "centurion_Assault", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "lasher_Standard", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "kite_Interceptor", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "kite_Interceptor", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "broadsword_wing", FleetMemberType.FIGHTER_WING, false);
        api.addToFleet(FleetSide.ENEMY, "talon_wing", FleetMemberType.FIGHTER_WING, false);

        float width = 14000f;
        float height = 16000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        /*
         for (int i = 0; i < 5; i++) {
         float x = (float) Math.random() * width - width / 2;
         float y = (float) Math.random() * height - height / 2;
         float radius = 100f + (float) Math.random() * 400f;
         api.addNebula(x, y, radius);
         }
         */
        float minX = -width / 2;
        float minY = -height / 2;
        api.addObjective(minX + width * 0.29f, minY + height * 0.33f, "nav_buoy");
        //api.addObjective(minX + width * 0.5f, minY + height * 0.5f, "comm_relay");
        api.addObjective(minX + width * 0.71f, minY + height * 0.67f, "sensor_array");

        api.setHyperspaceMode(true);
    }
}
